/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracapture.shootphoto;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.camera.CameraShootPhotoMode;
import dji.sdk.keyvalue.value.camera.CameraStorageInfo;
import dji.sdk.keyvalue.value.camera.CameraStorageInfos;
import dji.sdk.keyvalue.value.camera.CameraStorageLocation;
import dji.sdk.keyvalue.value.camera.CameraType;
import dji.sdk.keyvalue.value.camera.PhotoAEBPhotoCount;
import dji.sdk.keyvalue.value.camera.PhotoAEBSettings;
import dji.sdk.keyvalue.value.camera.PhotoBurstCount;
import dji.sdk.keyvalue.value.camera.PhotoIntervalShootSettings;
import dji.sdk.keyvalue.value.camera.PhotoPanoramaMode;
import dji.sdk.keyvalue.value.camera.SDCardLoadState;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.manager.KeyManager;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraAEBPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraBurstPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraIntervalPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraPanoramaPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraPhotoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraSDPhotoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraSSDPhotoStorageState;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.module.FlatCameraModule;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;

public class ShootPhotoWidgetModel
extends WidgetModel
implements ICameraIndex {
    private static final int INVALID_AVAILABLE_CAPTURE_COUNT = -1;
    private final DataProcessor<CameraPhotoState> cameraPhotoState;
    private final DataProcessor<CameraPhotoStorageState> cameraStorageState;
    private final DataProcessor<Boolean> isShootingPhoto;
    private final DataProcessor<Boolean> isStoringPhoto;
    private final DataProcessor<Boolean> canStartShootingPhoto;
    private final DataProcessor<Boolean> shootPhotoNotAllowed;
    private final DataProcessor<Boolean> canStopShootingPhoto;
    private final DataProcessor<String> cameraDisplayName;
    private final DataProcessor<Boolean> isShootingInterval;
    private final DataProcessor<CameraType> cameraType;
    private final DataProcessor<Boolean> isShootingPanorama;
    private final DataProcessor<PhotoAEBSettings> aebSettings;
    private final DataProcessor<PhotoAEBPhotoCount> aebCount;
    private final DataProcessor<PhotoBurstCount> burstCount;
    private final DataProcessor<PhotoBurstCount> rawBurstCount;
    private final DataProcessor<PhotoIntervalShootSettings> timeIntervalSettings;
    private final DataProcessor<PhotoPanoramaMode> panoramaMode;
    private final DataProcessor<CameraStorageInfos> storageInfosProcessor;
    private final DataProcessor<CameraStorageLocation> storageLocation;
    private final DataProcessor<SDCardLoadState> sdCardState;
    private final DataProcessor<SDCardLoadState> innerStorageState;
    private final DataProcessor<SSDOperationState> ssdState;
    private final DataProcessor<Integer> sdAvailableCaptureCount;
    private final DataProcessor<Integer> innerStorageAvailableCaptureCount;
    private final DataProcessor<Integer> rawPhotoBurstCaptureCount;
    private final DataProcessor<Boolean> isProductConnected;
    private final PhotoIntervalShootSettings defaultIntervalSettings;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.UNKNOWN;
    private FlatCameraModule flatCameraModule;

    public ShootPhotoWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.defaultIntervalSettings = new PhotoIntervalShootSettings();
        CameraPhotoState photoState = new CameraPhotoState(CameraShootPhotoMode.UNKNOWN);
        this.cameraPhotoState = DataProcessor.create(photoState);
        CameraSDPhotoStorageState cameraSDStorageState = new CameraSDPhotoStorageState(CameraStorageLocation.SDCARD, 0L, SDCardLoadState.NOT_INSERTED);
        this.cameraStorageState = DataProcessor.create(cameraSDStorageState);
        this.canStartShootingPhoto = DataProcessor.create(false);
        this.shootPhotoNotAllowed = DataProcessor.create(true);
        this.canStopShootingPhoto = DataProcessor.create(false);
        this.cameraDisplayName = DataProcessor.create("");
        this.aebSettings = DataProcessor.create(new PhotoAEBSettings());
        this.aebCount = DataProcessor.create(PhotoAEBPhotoCount.UNKNOWN);
        this.burstCount = DataProcessor.create(PhotoBurstCount.UNKNOWN);
        this.rawBurstCount = DataProcessor.create(PhotoBurstCount.UNKNOWN);
        this.timeIntervalSettings = DataProcessor.create(this.defaultIntervalSettings);
        this.panoramaMode = DataProcessor.create(PhotoPanoramaMode.UNKNOWN);
        this.isShootingPhoto = DataProcessor.create(false);
        this.isShootingInterval = DataProcessor.create(false);
        this.cameraType = DataProcessor.create(CameraType.NOT_SUPPORTED);
        this.isShootingPanorama = DataProcessor.create(false);
        this.isStoringPhoto = DataProcessor.create(false);
        this.storageLocation = DataProcessor.create(CameraStorageLocation.SDCARD);
        this.sdCardState = DataProcessor.create(SDCardLoadState.UNKNOWN);
        this.innerStorageState = DataProcessor.create(SDCardLoadState.UNKNOWN);
        this.ssdState = DataProcessor.create(SSDOperationState.UNKNOWN);
        this.sdAvailableCaptureCount = DataProcessor.create(-1);
        this.innerStorageAvailableCaptureCount = DataProcessor.create(-1);
        this.rawPhotoBurstCaptureCount = DataProcessor.create(-1);
        this.isProductConnected = DataProcessor.create(false);
        this.storageInfosProcessor = DataProcessor.create(new CameraStorageInfos(CameraStorageLocation.UNKNOWN, new ArrayList()));
        this.flatCameraModule = new FlatCameraModule();
        this.addModule(this.flatCameraModule);
    }

    public Flowable<CameraPhotoState> getCameraPhotoState() {
        return this.cameraPhotoState.toFlowable();
    }

    public Flowable<CameraPhotoStorageState> getCameraStorageState() {
        return this.cameraStorageState.toFlowable();
    }

    public Flowable<Boolean> isShootingPhoto() {
        return this.isShootingPhoto.toFlowable();
    }

    public Flowable<Boolean> isStoringPhoto() {
        return this.isStoringPhoto.toFlowable();
    }

    public Flowable<Boolean> canStartShootingPhoto() {
        return this.canStartShootingPhoto.toFlowable();
    }

    public Flowable<Boolean> canStopShootingPhoto() {
        return this.canStopShootingPhoto.toFlowable();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.flatCameraModule.updateCameraSource(cameraIndex, lensType);
        this.restart();
    }

    public Flowable<String> getCameraDisplayName() {
        return this.cameraDisplayName.toFlowable();
    }

    public Completable startShootPhoto() {
        if (!this.canStartShootingPhoto.getValue().booleanValue()) {
            return Completable.complete();
        }
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)CameraKey.KeyStartShootPhoto, (ComponentIndexType)this.cameraIndex));
    }

    public Completable stopShootPhoto() {
        if (!this.canStopShootingPhoto.getValue().booleanValue()) {
            return Completable.complete();
        }
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)CameraKey.KeyStopShootPhoto, (ComponentIndexType)this.cameraIndex));
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyConnection, (ComponentIndexType)this.cameraIndex), this.isProductConnected, newValue -> this.onCameraConnected((boolean)newValue));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyAEBSettings, (ComponentIndexType)this.cameraIndex), this.aebSettings, photoAEBSettings -> this.aebCount.onNext(photoAEBSettings.getCount()));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyPhotoBurstCount, (ComponentIndexType)this.cameraIndex), this.burstCount);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyRawBurstCount, (ComponentIndexType)this.cameraIndex), this.rawBurstCount);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyPhotoIntervalShootSettings, (ComponentIndexType)this.cameraIndex), this.timeIntervalSettings);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyPhotoPanoramaMode, (ComponentIndexType)this.cameraIndex), this.panoramaMode);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsShootingPhoto, (ComponentIndexType)this.cameraIndex), this.isShootingPhoto);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraStoringFile, (ComponentIndexType)this.cameraIndex), this.isStoringPhoto);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyShootPhotoNotAllowed, (ComponentIndexType)this.cameraIndex), this.shootPhotoNotAllowed, aBoolean -> this.canStartShootingPhoto.onNext(aBoolean == false));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraShootingContinuousPhotos, (ComponentIndexType)this.cameraIndex), this.isShootingInterval, this::onCanStopShootingPhoto);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsShootingPhotoPanorama, (ComponentIndexType)this.cameraIndex), this.isShootingPanorama, newValue -> this.onCanStopShootingPhoto((boolean)newValue));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraType, (ComponentIndexType)this.cameraIndex), this.cameraType, type -> this.cameraDisplayName.onNext(type.name()));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraStorageInfos, (ComponentIndexType)this.cameraIndex), this.storageInfosProcessor, cameraStorageInfos -> {
            CameraStorageInfo sdcardInfo;
            this.storageLocation.onNext(cameraStorageInfos.getCurrentStorageType());
            CameraStorageInfo internalInfo = cameraStorageInfos.getCameraStorageInfoByLocation(CameraStorageLocation.INTERNAL);
            if (internalInfo != null) {
                this.innerStorageState.onNext(internalInfo.getStorageState());
                this.sdAvailableCaptureCount.onNext(internalInfo.getAvailablePhotoCount());
            }
            if ((sdcardInfo = cameraStorageInfos.getCameraStorageInfoByLocation(CameraStorageLocation.SDCARD)) != null) {
                this.sdCardState.onNext(sdcardInfo.getStorageState());
                this.innerStorageAvailableCaptureCount.onNext(sdcardInfo.getAvailablePhotoCount());
            }
        });
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDOperationState, (ComponentIndexType)this.cameraIndex), this.ssdState);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySDCardAvailablePhotoCount, (ComponentIndexType)this.cameraIndex), this.sdAvailableCaptureCount);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyInternalStorageAvailablePhotoCount, (ComponentIndexType)this.cameraIndex), this.innerStorageAvailableCaptureCount);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyH1PhotoBurstCount, (ComponentIndexType)this.cameraIndex), this.rawPhotoBurstCaptureCount);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        this.updateCameraPhotoState();
        this.updateCameraStorageState();
    }

    public boolean isPhotoMode() {
        return this.flatCameraModule.getCameraModeDataProcessor().getValue().isPhotoMode() || this.flatCameraModule.getCameraModeDataProcessor().getValue() == CameraMode.VIDEO_NORMAL && this.isSupportShootPhoto();
    }

    private boolean isSupportShootPhoto() {
        CameraType cameraType = (CameraType)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraType, (ComponentIndexType)this.cameraIndex), (Object)CameraType.NOT_SUPPORTED);
        return cameraType == CameraType.M3T || cameraType == CameraType.M3E || cameraType == CameraType.M3M || cameraType == CameraType.ZENMUSE_H20T;
    }

    private void updateCameraPhotoState() {
        CameraPhotoState state = null;
        CameraShootPhotoMode shootPhotoMode = this.flatCameraModule.getShootPhotoModeProcessor().getValue();
        switch (shootPhotoMode) {
            case NORMAL: 
            case HDR: 
            case HYPER_LIGHT: 
            case EHDR: {
                state = new CameraPhotoState(shootPhotoMode);
                break;
            }
            case BURST: {
                if (PhotoBurstCount.UNKNOWN.equals((Object)this.burstCount.getValue())) break;
                state = new CameraBurstPhotoState(shootPhotoMode, this.burstCount.getValue());
                break;
            }
            case RAW_BURST: {
                if (PhotoBurstCount.UNKNOWN.equals((Object)this.rawBurstCount.getValue())) break;
                state = new CameraBurstPhotoState(shootPhotoMode, this.rawBurstCount.getValue());
                break;
            }
            case AEB: {
                if (PhotoAEBPhotoCount.UNKNOWN.equals((Object)this.aebCount.getValue())) break;
                state = new CameraAEBPhotoState(shootPhotoMode, this.aebCount.getValue());
                break;
            }
            case INTERVAL: {
                PhotoIntervalShootSettings intervalSettings = this.timeIntervalSettings.getValue();
                if (this.defaultIntervalSettings.equals(this.timeIntervalSettings.getValue())) break;
                state = new CameraIntervalPhotoState(shootPhotoMode, intervalSettings.getCount(), intervalSettings.getInterval().intValue());
                break;
            }
            case PANO_APP: {
                if (PhotoPanoramaMode.UNKNOWN.equals((Object)this.panoramaMode.getValue())) break;
                state = new CameraPanoramaPhotoState(shootPhotoMode, this.panoramaMode.getValue());
                break;
            }
        }
        if (state != null) {
            this.cameraPhotoState.onNext(state);
        }
    }

    private void updateCameraStorageState() {
        CameraStorageLocation currentStorageLocation = this.storageLocation.getValue();
        if (CameraStorageLocation.UNKNOWN.equals((Object)currentStorageLocation)) {
            return;
        }
        CameraShootPhotoMode currentShootPhotoMode = this.flatCameraModule.getShootPhotoModeProcessor().getValue();
        long availableCaptureCount = this.getAvailableCaptureCount(currentStorageLocation, currentShootPhotoMode);
        CameraPhotoStorageState newCameraPhotoStorageState = null;
        if (currentShootPhotoMode == CameraShootPhotoMode.RAW_BURST) {
            newCameraPhotoStorageState = new CameraSSDPhotoStorageState(CameraStorageLocation.UNKNOWN, availableCaptureCount, this.ssdState.getValue());
        } else if (CameraStorageLocation.SDCARD.equals((Object)currentStorageLocation)) {
            if (!SDCardLoadState.UNKNOWN.equals((Object)this.sdCardState.getValue())) {
                newCameraPhotoStorageState = new CameraSDPhotoStorageState(currentStorageLocation, availableCaptureCount, this.sdCardState.getValue());
            }
        } else if (CameraStorageLocation.INTERNAL.equals((Object)currentStorageLocation)) {
            newCameraPhotoStorageState = new CameraSDPhotoStorageState(currentStorageLocation, availableCaptureCount, this.innerStorageState.getValue());
        }
        if (newCameraPhotoStorageState != null) {
            this.cameraStorageState.onNext(newCameraPhotoStorageState);
        }
    }

    private long getAvailableCaptureCount(CameraStorageLocation storageLocation, CameraShootPhotoMode shootPhotoMode) {
        if (shootPhotoMode == CameraShootPhotoMode.RAW_BURST) {
            return this.rawPhotoBurstCaptureCount.getValue().intValue();
        }
        switch (storageLocation) {
            case SDCARD: {
                return this.sdAvailableCaptureCount.getValue().intValue();
            }
            case INTERNAL: {
                return this.innerStorageAvailableCaptureCount.getValue().intValue();
            }
        }
        return -1L;
    }

    private void onCanStopShootingPhoto(boolean canStopShootingPhoto) {
        this.canStopShootingPhoto.onNext(canStopShootingPhoto);
    }

    private void onCameraConnected(boolean isCameraConnected) {
        if (!isCameraConnected) {
            this.sdCardState.onNext(SDCardLoadState.UNKNOWN);
            this.innerStorageState.onNext(SDCardLoadState.UNKNOWN);
            this.ssdState.onNext(SSDOperationState.UNKNOWN);
        }
    }
}

