/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.warning;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.v5.et.DJIKeyInfoEtKt;
import dji.v5.manager.diagnostic.DJIDeviceHealthInfo;
import dji.v5.manager.diagnostic.DJIDeviceHealthInfoChangeListener;
import dji.v5.manager.diagnostic.DJIDeviceStatus;
import dji.v5.manager.diagnostic.DJIDeviceStatusChangeListener;
import dji.v5.manager.diagnostic.DeviceHealthManager;
import dji.v5.manager.diagnostic.DeviceStatusManager;
import dji.v5.manager.diagnostic.WarningLevel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aR'\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldji/v5/ux/warning/DeviceHealthAndStatusWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;)V", "deviceMessageProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ljava/util/ArrayList;", "Ldji/v5/ux/warning/DeviceHealthAndStatusWidgetModel$DeviceMessage;", "Lkotlin/collections/ArrayList;", "getDeviceMessageProcessor", "()Ldji/v5/ux/core/util/DataProcessor;", "isConnectedProcessor", "", "healthInfoChangeListener", "Ldji/v5/manager/diagnostic/DJIDeviceHealthInfoChangeListener;", "deviceStatusChangeListener", "Ldji/v5/manager/diagnostic/DJIDeviceStatusChangeListener;", "inSetup", "", "inCleanup", "updateDeviceMessage", "level3Count", "", "level2Count", "DeviceMessage", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nDeviceHealthAndStatusWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceHealthAndStatusWidgetModel.kt\ndji/v5/ux/warning/DeviceHealthAndStatusWidgetModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1011#2,2:82\n1774#2,4:84\n1774#2,4:88\n*S KotlinDebug\n*F\n+ 1 DeviceHealthAndStatusWidgetModel.kt\ndji/v5/ux/warning/DeviceHealthAndStatusWidgetModel\n*L\n49#1:82,2\n54#1:84,4\n56#1:88,4\n*E\n"})
public final class DeviceHealthAndStatusWidgetModel
extends WidgetModel {
    @NotNull
    private final DataProcessor<ArrayList<DeviceMessage>> deviceMessageProcessor;
    @NotNull
    private final DataProcessor<Boolean> isConnectedProcessor;
    @NotNull
    private final DJIDeviceHealthInfoChangeListener healthInfoChangeListener;
    @NotNull
    private final DJIDeviceStatusChangeListener deviceStatusChangeListener;

    public DeviceHealthAndStatusWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        DataProcessor dataProcessor = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.deviceMessageProcessor = dataProcessor;
        DataProcessor<Boolean> dataProcessor2 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.isConnectedProcessor = dataProcessor2;
        this.healthInfoChangeListener = arg_0 -> DeviceHealthAndStatusWidgetModel.healthInfoChangeListener$lambda$0(this, arg_0);
        this.deviceStatusChangeListener = (arg_0, arg_1) -> DeviceHealthAndStatusWidgetModel.deviceStatusChangeListener$lambda$1(this, arg_0, arg_1);
    }

    @NotNull
    public final DataProcessor<ArrayList<DeviceMessage>> getDeviceMessageProcessor() {
        return this.deviceMessageProcessor;
    }

    @NotNull
    public final DataProcessor<Boolean> isConnectedProcessor() {
        return this.isConnectedProcessor;
    }

    @Override
    protected void inSetup() {
        DeviceHealthManager.getInstance().addDJIDeviceHealthInfoChangeListener(this.healthInfoChangeListener);
        DeviceStatusManager.getInstance().addDJIDeviceStatusChangeListener(this.deviceStatusChangeListener);
        DJIKeyInfo dJIKeyInfo = FlightControllerKey.KeyConnection;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo, (String)"KeyConnection");
        this.bindDataProcessor(DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo), this.isConnectedProcessor);
    }

    @Override
    protected void inCleanup() {
        DeviceHealthManager.getInstance().removeDJIDeviceHealthInfoChangeListener(this.healthInfoChangeListener);
        DeviceStatusManager.getInstance().removeDJIDeviceStatusChangeListener(this.deviceStatusChangeListener);
    }

    private final void updateDeviceMessage() {
        ArrayList<DeviceMessage> messages = new ArrayList<DeviceMessage>();
        for (Object e : DeviceHealthManager.getInstance().getCurrentDJIDeviceHealthInfos()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            DJIDeviceHealthInfo health = (DJIDeviceHealthInfo)e;
            String string2 = health.title();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"title(...)");
            String string3 = health.description();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"description(...)");
            WarningLevel warningLevel = health.warningLevel();
            Intrinsics.checkNotNullExpressionValue((Object)warningLevel, (String)"warningLevel(...)");
            String string4 = health.informationCode();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"informationCode(...)");
            messages.add(new DeviceMessage(string2, string3, warningLevel, string4));
        }
        if (Intrinsics.areEqual(messages, this.deviceMessageProcessor.getValue())) {
            return;
        }
        List $this$sortByDescending$iv = messages;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DeviceMessage msg = (DeviceMessage)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)msg.getWarningLevel();
                    msg = (DeviceMessage)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)msg.getWarningLevel()));
                }
            });
        }
        this.deviceMessageProcessor.onNext(messages);
    }

    /*
     * WARNING - void declaration
     */
    public final int level3Count() {
        int n;
        ArrayList<DeviceMessage> arrayList = this.deviceMessageProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"getValue(...)");
        Iterable $this$count$iv = arrayList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                DeviceMessage it = (DeviceMessage)element$iv;
                boolean bl = false;
                if (!(it.getWarningLevel() == WarningLevel.WARNING || it.getWarningLevel() == WarningLevel.SERIOUS_WARNING) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int level2Count() {
        int n;
        ArrayList<DeviceMessage> arrayList = this.deviceMessageProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"getValue(...)");
        Iterable $this$count$iv = arrayList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                DeviceMessage it = (DeviceMessage)element$iv;
                boolean bl = false;
                if (!(it.getWarningLevel() == WarningLevel.NOTICE || it.getWarningLevel() == WarningLevel.CAUTION) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    private static final void healthInfoChangeListener$lambda$0(DeviceHealthAndStatusWidgetModel this$0, List it) {
        this$0.updateDeviceMessage();
    }

    private static final void deviceStatusChangeListener$lambda$1(DeviceHealthAndStatusWidgetModel this$0, DJIDeviceStatus dJIDeviceStatus, DJIDeviceStatus dJIDeviceStatus2) {
        this$0.updateDeviceMessage();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Ldji/v5/ux/warning/DeviceHealthAndStatusWidgetModel$DeviceMessage;", "", "title", "", "description", "warningLevel", "Ldji/v5/manager/diagnostic/WarningLevel;", "code", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ldji/v5/manager/diagnostic/WarningLevel;Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "getDescription", "getWarningLevel", "()Ldji/v5/manager/diagnostic/WarningLevel;", "getCode", "equals", "", "other", "hashCode", "", "validDescription", "component1", "component2", "component3", "component4", "copy", "toString", "android-sdk-v5-uxsdk_release"})
    public static final class DeviceMessage {
        @NotNull
        private final String title;
        @NotNull
        private final String description;
        @NotNull
        private final WarningLevel warningLevel;
        @NotNull
        private final String code;

        public DeviceMessage(@NotNull String title, @NotNull String description, @NotNull WarningLevel warningLevel, @NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)warningLevel, (String)"warningLevel");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.title = title;
            this.description = description;
            this.warningLevel = warningLevel;
            this.code = code;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final WarningLevel getWarningLevel() {
            return this.warningLevel;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DeviceMessage ? Intrinsics.areEqual((Object)((DeviceMessage)other).code, (Object)this.code) : false;
        }

        public int hashCode() {
            int result = this.title.hashCode();
            result = 31 * result + this.description.hashCode();
            result = 31 * result + this.warningLevel.hashCode();
            result = 31 * result + this.code.hashCode();
            return result;
        }

        @NotNull
        public final String validDescription() {
            CharSequence charSequence = this.description;
            if (charSequence.length() == 0) {
                boolean bl = false;
                return this.code;
            }
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final WarningLevel component3() {
            return this.warningLevel;
        }

        @NotNull
        public final String component4() {
            return this.code;
        }

        @NotNull
        public final DeviceMessage copy(@NotNull String title, @NotNull String description, @NotNull WarningLevel warningLevel, @NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)warningLevel, (String)"warningLevel");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new DeviceMessage(title, description, warningLevel, code);
        }

        public static /* synthetic */ DeviceMessage copy$default(DeviceMessage deviceMessage, String string2, String string3, WarningLevel warningLevel, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = deviceMessage.title;
            }
            if ((n & 2) != 0) {
                string3 = deviceMessage.description;
            }
            if ((n & 4) != 0) {
                warningLevel = deviceMessage.warningLevel;
            }
            if ((n & 8) != 0) {
                string4 = deviceMessage.code;
            }
            return deviceMessage.copy(string2, string3, warningLevel, string4);
        }

        @NotNull
        public String toString() {
            return "DeviceMessage(title=" + this.title + ", description=" + this.description + ", warningLevel=" + this.warningLevel + ", code=" + this.code + ")";
        }
    }
}

