/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightAssistantKey;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.value.flightassistant.AuxiliaryLightMode;
import dji.sdk.keyvalue.value.flightcontroller.LEDsSettings;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.LogUtils;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.SwitcherCell;
import dji.v5.ux.core.base.TabSelectCell;
import dji.v5.ux.core.ui.setting.ui.MenuFragment;
import dji.v5.ux.core.util.ViewUtil;

public class LedMenuFragment
extends MenuFragment
implements SwitcherCell.OnCheckedChangedListener,
TabSelectCell.OnTabChangeListener {
    private SwitcherCell mLEDBeaconCell;
    private SwitcherCell mLEDArmCell;
    private SwitcherCell mLEDStatusCell;
    private SwitcherCell m430LEDsHideModeCell;
    private LinearLayout m430LedSettingLayout;
    private SwitcherCell m430BeaconLedCell;
    private TabSelectCell m430TopAuxiliaryTabSelectCell;
    private TabSelectCell m430BottomAuxiliaryTabSelectCell;

    private void initView(View view) {
        this.mLEDBeaconCell = (SwitcherCell)view.findViewById(R.id.setting_menu_common_led_beacon);
        this.mLEDArmCell = (SwitcherCell)view.findViewById(R.id.setting_menu_common_led_arm);
        this.mLEDStatusCell = (SwitcherCell)view.findViewById(R.id.setting_menu_common_led_status);
        this.m430LEDsHideModeCell = (SwitcherCell)view.findViewById(R.id.setting_menu_common_leds_hide_mode);
        this.m430LedSettingLayout = (LinearLayout)view.findViewById(R.id.setting_menu_common_led);
        this.m430BeaconLedCell = (SwitcherCell)view.findViewById(R.id.setting_menu_common_beacon_led);
        this.m430TopAuxiliaryTabSelectCell = (TabSelectCell)view.findViewById(R.id.setting_menu_common_top_auxiliary_light);
        this.m430BottomAuxiliaryTabSelectCell = (TabSelectCell)view.findViewById(R.id.setting_menu_common_bottom_auxiliary_light);
    }

    @Override
    protected String getPreferencesTitle() {
        return StringUtils.getResStr((int)R.string.uxsdk_setting_menu_title_led, (Object[])new Object[0]);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.uxsdk_setting_menu_led_layout;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        return this.mFragmentRoot;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
        this.init430LEDsHideModeView();
        this.initKey();
    }

    private void initKey() {
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHasInternalBeaconLeds), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<Boolean>(){

            public void onSuccess(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    LedMenuFragment.this.updateViewsByState();
                }
            }

            public void onFailure(@NonNull IDJIError error) {
            }
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightAssistantKey.KeyBottomAuxiliaryLightMode), (Object)this, (oldValue, mode) -> {
            if (mode != null) {
                this.setCellTab(this.m430BottomAuxiliaryTabSelectCell, mode.value());
            }
        });
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<ProductType>(){

            public void onSuccess(ProductType productType) {
                if (productType == ProductType.M30_SERIES || productType == ProductType.DJI_MAVIC_3_ENTERPRISE_SERIES) {
                    LedMenuFragment.this.m430TopAuxiliaryTabSelectCell.setVisibility(8);
                    LedMenuFragment.this.m430BeaconLedCell.setVisibility(0);
                } else {
                    LedMenuFragment.this.updateTopAuxiliaryTabSelectCell();
                }
            }

            public void onFailure(@NonNull IDJIError error) {
            }
        });
    }

    private void updateTopAuxiliaryTabSelectCell() {
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightAssistantKey.KeyTopAuxiliaryLightMode), (Object)this, (oldValue, mode) -> {
            if (mode != null) {
                this.setCellTab(this.m430TopAuxiliaryTabSelectCell, mode.value());
            }
        });
    }

    private void updateViewsByState() {
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLEDsSettings), (Object)this, (oldValue, leDsSettings) -> {
            if (leDsSettings != null) {
                this.setCellCheck(this.m430BeaconLedCell, leDsSettings.getNavigationLEDsOn());
                this.setCellCheck(this.mLEDStatusCell, leDsSettings.getStatusIndicatorLEDsOn());
                this.setCellCheck(this.mLEDArmCell, leDsSettings.getFrontLEDsOn());
            }
        });
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        KeyManager.getInstance().cancelListen((Object)this);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void init430LEDsHideModeView() {
        this.mLEDBeaconCell.setVisibility(8);
        this.mLEDArmCell.setVisibility(8);
        this.mLEDStatusCell.setVisibility(8);
        this.m430LEDsHideModeCell.setVisibility(8);
        this.m430LEDsHideModeCell.setOnCheckedChangedListener(this);
        this.m430BeaconLedCell.setOnCheckedChangedListener(this);
        this.m430TopAuxiliaryTabSelectCell.setOnTabChangeListener(this);
        this.m430BottomAuxiliaryTabSelectCell.setOnTabChangeListener(this);
        this.m430LedSettingLayout.setVisibility(0);
    }

    @Override
    public void onCheckedChanged(SwitcherCell cell, final boolean isChecked) {
        int id2 = cell.getId();
        if (id2 == R.id.setting_menu_common_leds_hide_mode) {
            if (isChecked) {
                this.openLEDsHide(true);
            } else {
                this.openLEDsHide(false);
            }
        } else if (id2 == R.id.setting_menu_common_beacon_led || id2 == R.id.setting_menu_common_led_beacon) {
            LEDsSettings leDsSettings = this.createLedsBuilder();
            leDsSettings.setNavigationLEDsOn(Boolean.valueOf(isChecked));
            KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLEDsSettings), (Object)leDsSettings, new CommonCallbacks.CompletionCallback(){

                public void onSuccess() {
                }

                public void onFailure(@NonNull IDJIError error) {
                }
            });
        } else if (id2 == R.id.setting_menu_common_led_arm) {
            LEDsSettings leDsSettings = this.createLedsBuilder();
            leDsSettings.setFrontLEDsOn(Boolean.valueOf(isChecked));
            leDsSettings.setRearLEDsOn(Boolean.valueOf(isChecked));
            leDsSettings.setStatusIndicatorLEDsOn(Boolean.valueOf(isChecked));
            KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLEDsSettings), (Object)leDsSettings, new CommonCallbacks.CompletionCallback(){

                public void onSuccess() {
                    if (!isChecked) {
                        ViewUtil.showToast(LedMenuFragment.this.getContext(), R.string.uxsdk_app_operator_fail, 0);
                    }
                }

                public void onFailure(@NonNull IDJIError error) {
                }
            });
        } else if (id2 == R.id.setting_menu_common_led_status) {
            LEDsSettings leDsSettings = this.createLedsBuilder();
            leDsSettings.setStatusIndicatorLEDsOn(Boolean.valueOf(isChecked));
            KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLEDsSettings), (Object)leDsSettings, new CommonCallbacks.CompletionCallback(){

                public void onSuccess() {
                    if (!isChecked) {
                        ViewUtil.showToast(LedMenuFragment.this.getContext(), R.string.uxsdk_app_operator_fail, 0);
                    }
                }

                public void onFailure(@NonNull IDJIError error) {
                }
            });
        }
    }

    private LEDsSettings createLedsBuilder() {
        LEDsSettings defaultSettings = new LEDsSettings();
        LEDsSettings leDsSettings = (LEDsSettings)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLEDsSettings), (Object)defaultSettings);
        return new LEDsSettings(leDsSettings.getFrontLEDsOn(), leDsSettings.getStatusIndicatorLEDsOn(), leDsSettings.getRearLEDsOn(), leDsSettings.getNavigationLEDsOn());
    }

    private void openLEDsHide(boolean isHide) {
        LogUtils.i((String)this.TAG, (Object[])new Object[]{"leds hide mode " + isHide});
    }

    @Override
    public void onTabChanged(TabSelectCell cell, int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        int id2 = cell.getId();
        if (id2 == R.id.setting_menu_common_top_auxiliary_light) {
            KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightAssistantKey.KeyTopAuxiliaryLightMode), (Object)AuxiliaryLightMode.find((int)newIndex), new CommonCallbacks.CompletionCallback(){

                public void onSuccess() {
                }

                public void onFailure(@NonNull IDJIError error) {
                    ViewUtil.showToast(LedMenuFragment.this.getContext(), R.string.uxsdk_app_operator_fail, 0);
                }
            });
        } else if (id2 == R.id.setting_menu_common_bottom_auxiliary_light) {
            AuxiliaryLightMode mode = AuxiliaryLightMode.find((int)newIndex);
            if (mode == AuxiliaryLightMode.OFF) {
                ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_menu_close_bottom_aux_tips, 1);
            }
            KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightAssistantKey.KeyBottomAuxiliaryLightMode), (Object)AuxiliaryLightMode.find((int)newIndex), new CommonCallbacks.CompletionCallback(){

                public void onSuccess() {
                }

                public void onFailure(@NonNull IDJIError error) {
                    ViewUtil.showToast(LedMenuFragment.this.getContext(), R.string.uxsdk_app_operator_fail, 0);
                }
            });
        }
    }

    private void setCellCheck(SwitcherCell cell, boolean isCheck) {
        if (null != cell) {
            cell.setOnCheckedChangedListener(null);
            cell.setChecked(isCheck);
            cell.setOnCheckedChangedListener(this);
        }
    }

    private void setCellTab(TabSelectCell cell, int tab) {
        if (null != cell) {
            cell.setOnTabChangeListener(null);
            cell.setCurrentTab(tab);
            cell.setOnTabChangeListener(this);
        }
    }
}

