/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import androidx.appcompat.widget.AppCompatSeekBar;
import dji.v5.ux.R;
import dji.v5.ux.core.extension.ViewExtensions;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0015\u00a8\u0006%"}, d2={"Ldji/v5/ux/core/ui/SlideAndFillSeekBar;", "Landroidx/appcompat/widget/AppCompatSeekBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "reachedPaint", "Landroid/graphics/Paint;", "thumbPaint", "startPaint", "outerListener", "Landroid/widget/SeekBar$OnSeekBarChangeListener;", "currentProgress", "thumbSelectedColor", "getThumbSelectedColor", "()I", "setThumbSelectedColor", "(I)V", "thumbNormalColor", "getThumbNormalColor", "setThumbNormalColor", "value", "progressColor", "getProgressColor", "setProgressColor", "initListener", "", "setOnSeekBarChangeListener", "l", "initPaints", "onDraw", "canvas", "Landroid/graphics/Canvas;", "android-sdk-v5-uxsdk_debug"})
public final class SlideAndFillSeekBar
extends AppCompatSeekBar {
    @NotNull
    private Paint reachedPaint;
    @NotNull
    private Paint thumbPaint;
    @NotNull
    private Paint startPaint;
    @Nullable
    private SeekBar.OnSeekBarChangeListener outerListener;
    private int currentProgress;
    private int thumbSelectedColor;
    private int thumbNormalColor;
    private int progressColor;

    @JvmOverloads
    public SlideAndFillSeekBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.reachedPaint = new Paint(1);
        this.thumbPaint = new Paint(1);
        this.startPaint = new Paint(1);
        this.thumbSelectedColor = ViewExtensions.getColor((View)this, R.color.uxsdk_slider_thumb_selected);
        this.thumbNormalColor = ViewExtensions.getColor((View)this, R.color.uxsdk_white);
        this.progressColor = ViewExtensions.getColor((View)this, R.color.uxsdk_slider_filled);
        this.initListener();
        this.initPaints();
    }

    public /* synthetic */ SlideAndFillSeekBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getThumbSelectedColor() {
        return this.thumbSelectedColor;
    }

    public final void setThumbSelectedColor(int n) {
        this.thumbSelectedColor = n;
    }

    public final int getThumbNormalColor() {
        return this.thumbNormalColor;
    }

    public final void setThumbNormalColor(int n) {
        this.thumbNormalColor = n;
    }

    public final int getProgressColor() {
        return this.progressColor;
    }

    public final void setProgressColor(int value) {
        this.progressColor = value;
        this.initPaints();
    }

    private final void initListener() {
        SeekBar.OnSeekBarChangeListener innerListener2 = new SeekBar.OnSeekBarChangeListener(this){
            final /* synthetic */ SlideAndFillSeekBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
                    SlideAndFillSeekBar.access$setCurrentProgress$p(this.this$0, progress);
                    SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = SlideAndFillSeekBar.access$getOuterListener$p(this.this$0);
                    if (onSeekBarChangeListener == null) break block0;
                    onSeekBarChangeListener.onProgressChanged((SeekBar)this.this$0, progress, fromUser);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
                    SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = SlideAndFillSeekBar.access$getOuterListener$p(this.this$0);
                    if (onSeekBarChangeListener == null) break block0;
                    onSeekBarChangeListener.onStartTrackingTouch((SeekBar)this.this$0);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
                    SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = SlideAndFillSeekBar.access$getOuterListener$p(this.this$0);
                    if (onSeekBarChangeListener == null) break block0;
                    onSeekBarChangeListener.onStopTrackingTouch((SeekBar)this.this$0);
                }
            }
        };
        super.setOnSeekBarChangeListener(innerListener2);
    }

    public void setOnSeekBarChangeListener(@NotNull SeekBar.OnSeekBarChangeListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.outerListener = l;
    }

    private final void initPaints() {
        this.reachedPaint.setColor(this.progressColor);
        this.reachedPaint.setStyle(Paint.Style.STROKE);
        this.reachedPaint.setStrokeWidth((float)this.getMeasuredHeight());
        this.reachedPaint.setStrokeCap(Paint.Cap.ROUND);
        this.startPaint.setColor(this.progressColor);
        this.startPaint.setStyle(Paint.Style.STROKE);
        this.startPaint.setStrokeWidth((float)this.getMeasuredHeight());
        this.startPaint.setStrokeCap(Paint.Cap.ROUND);
        this.thumbPaint.setColor(this.thumbNormalColor);
        this.thumbPaint.setStyle(Paint.Style.STROKE);
        this.thumbPaint.setStrokeWidth((float)this.getMeasuredHeight());
        this.thumbPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected synchronized void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Drawable thumb = this.getThumb();
        Rect rect = thumb.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect thumbRect = rect;
        this.reachedPaint.setStrokeWidth((float)thumb.getIntrinsicHeight());
        this.startPaint.setStrokeWidth((float)thumb.getIntrinsicHeight());
        this.thumbPaint.setStrokeWidth((float)thumb.getIntrinsicHeight());
        if (this.currentProgress > 0) {
            canvas.drawLine((float)thumb.getIntrinsicWidth() / 2.0f, (float)thumbRect.centerY(), (float)thumbRect.centerX(), (float)thumbRect.centerY(), this.reachedPaint);
            canvas.drawPoint((float)thumb.getIntrinsicWidth() / 2.0f, (float)thumbRect.centerY(), this.startPaint);
        }
        if (this.currentProgress == 0 || this.currentProgress == 100) {
            this.thumbPaint.setColor(this.thumbNormalColor);
        } else {
            this.thumbPaint.setColor(this.thumbSelectedColor);
        }
        canvas.drawPoint((float)thumbRect.centerX(), (float)thumbRect.centerY(), this.thumbPaint);
    }

    @JvmOverloads
    public SlideAndFillSeekBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SlideAndFillSeekBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$setCurrentProgress$p(SlideAndFillSeekBar $this, int n) {
        $this.currentProgress = n;
    }

    public static final /* synthetic */ SeekBar.OnSeekBarChangeListener access$getOuterListener$p(SlideAndFillSeekBar $this) {
        return $this.outerListener;
    }
}

