/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.renderer;

import android.content.Context;
import android.graphics.Canvas;
import dji.v5.ux.core.base.charts.model.Viewport;
import dji.v5.ux.core.base.charts.renderer.AbstractChartRenderer;
import dji.v5.ux.core.base.charts.renderer.ChartRenderer;
import dji.v5.ux.core.base.charts.view.Chart;
import java.util.ArrayList;
import java.util.List;

public class ComboChartRenderer
extends AbstractChartRenderer {
    protected List<ChartRenderer> renderers = new ArrayList<ChartRenderer>();
    protected Viewport unionViewport = new Viewport();

    public ComboChartRenderer(Context context, Chart chart) {
        super(context, chart);
    }

    @Override
    public void onChartSizeChanged() {
        for (ChartRenderer renderer : this.renderers) {
            renderer.onChartSizeChanged();
        }
    }

    @Override
    public void onChartDataChanged() {
        super.onChartDataChanged();
        for (ChartRenderer renderer : this.renderers) {
            renderer.onChartDataChanged();
        }
        this.onChartViewportChanged();
    }

    @Override
    public void onChartViewportChanged() {
        if (this.isViewportCalculationEnabled) {
            int rendererIndex = 0;
            for (ChartRenderer renderer : this.renderers) {
                renderer.onChartViewportChanged();
                if (rendererIndex == 0) {
                    this.unionViewport.set(renderer.getMaximumViewport());
                } else {
                    this.unionViewport.union(renderer.getMaximumViewport());
                }
                ++rendererIndex;
            }
            this.computator.setMaxViewport(this.unionViewport);
            this.computator.setCurrentViewport(this.unionViewport);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        for (ChartRenderer renderer : this.renderers) {
            renderer.draw(canvas);
        }
    }

    @Override
    public void drawUnclipped(Canvas canvas) {
        for (ChartRenderer renderer : this.renderers) {
            renderer.drawUnclipped(canvas);
        }
    }

    @Override
    public boolean checkTouch(float touchX, float touchY) {
        ChartRenderer renderer;
        int rendererIndex;
        this.selectedValue.clear();
        for (rendererIndex = this.renderers.size() - 1; rendererIndex >= 0; --rendererIndex) {
            renderer = this.renderers.get(rendererIndex);
            if (!renderer.checkTouch(touchX, touchY)) continue;
            this.selectedValue.set(renderer.getSelectedValue());
            break;
        }
        --rendererIndex;
        while (rendererIndex >= 0) {
            renderer = this.renderers.get(rendererIndex);
            renderer.clearTouch();
            --rendererIndex;
        }
        return this.isTouched();
    }

    @Override
    public void clearTouch() {
        for (ChartRenderer renderer : this.renderers) {
            renderer.clearTouch();
        }
        this.selectedValue.clear();
    }
}

