/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.ssd;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraShootPhotoMode;
import dji.sdk.keyvalue.value.camera.CameraWorkMode;
import dji.sdk.keyvalue.value.camera.SSDClipFileNameMsg;
import dji.sdk.keyvalue.value.camera.SSDColor;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.sdk.keyvalue.value.camera.SSDVideoLicense;
import dji.sdk.keyvalue.value.camera.VideoResolutionFrameRate;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;

public class CameraConfigSSDWidgetModel
extends WidgetModel
implements ICameraIndex {
    protected static final int INVALID_AVAILABLE_CAPTURE_COUNT = -1;
    protected static final int INVALID_AVAILABLE_RECORDING_TIME = -1;
    private final DataProcessor<Boolean> isSSDSupportedProcessor;
    private final DataProcessor<VideoResolutionFrameRate> ssdVideoResolutionAndFrameRateProcessor;
    private final DataProcessor<Integer> ssdRemainingSpaceInMBProcessor;
    private final DataProcessor<SSDClipFileNameMsg> ssdClipFileNameProcessor;
    private final DataProcessor<CameraWorkMode> cameraModeProcessor;
    private final DataProcessor<CameraShootPhotoMode> shootPhotoModeProcessor;
    private final DataProcessor<SSDOperationState> ssdOperationStateProcessor;
    private final DataProcessor<Integer> ssdAvailableRecordingTimeInSecProcessor;
    private final DataProcessor<List<SSDVideoLicense>> activateSSDVideoLicenseProcessor;
    private final DataProcessor<SSDColor> ssdColorProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraConfigSSDWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
        this.isSSDSupportedProcessor = DataProcessor.create(false);
        this.ssdVideoResolutionAndFrameRateProcessor = DataProcessor.create(new VideoResolutionFrameRate());
        this.ssdRemainingSpaceInMBProcessor = DataProcessor.create(-1);
        this.ssdClipFileNameProcessor = DataProcessor.create(new SSDClipFileNameMsg());
        this.cameraModeProcessor = DataProcessor.create(CameraWorkMode.UNKNOWN);
        this.shootPhotoModeProcessor = DataProcessor.create(CameraShootPhotoMode.UNKNOWN);
        this.ssdOperationStateProcessor = DataProcessor.create(SSDOperationState.UNKNOWN);
        this.ssdAvailableRecordingTimeInSecProcessor = DataProcessor.create(-1);
        this.activateSSDVideoLicenseProcessor = DataProcessor.create(new ArrayList());
        this.ssdColorProcessor = DataProcessor.create(SSDColor.UNKNOWN);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<Boolean> isSSDSupported() {
        return this.isSSDSupportedProcessor.toFlowable();
    }

    public Flowable<List<SSDVideoLicense>> getSSDLicense() {
        return this.activateSSDVideoLicenseProcessor.toFlowable();
    }

    public Flowable<Integer> getSSDRemainingSpace() {
        return this.ssdRemainingSpaceInMBProcessor.toFlowable();
    }

    public Flowable<SSDClipFileNameMsg> getSSDClipName() {
        return this.ssdClipFileNameProcessor.toFlowable();
    }

    public Flowable<VideoResolutionFrameRate> getSSDResolutionAndFrameRate() {
        return this.ssdVideoResolutionAndFrameRateProcessor.toFlowable();
    }

    public Flowable<SSDOperationState> getSSDOperationState() {
        return this.ssdOperationStateProcessor.toFlowable();
    }

    public Flowable<SSDColor> getSSDColor() {
        return this.ssdColorProcessor.toFlowable();
    }

    public Flowable<CameraShootPhotoMode> getShootPhotoMode() {
        return this.shootPhotoModeProcessor.toFlowable();
    }

    public Flowable<CameraWorkMode> getCameraMode() {
        return this.cameraModeProcessor.toFlowable();
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsInternalSSDSupported, (ComponentIndexType)this.cameraIndex), this.isSSDSupportedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDVideoResolutionFrameRate, (ComponentIndexType)this.cameraIndex), this.ssdVideoResolutionAndFrameRateProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDRemainingSpaceInMB, (ComponentIndexType)this.cameraIndex), this.ssdRemainingSpaceInMBProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDClipFileName, (ComponentIndexType)this.cameraIndex), this.ssdClipFileNameProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraWorkMode, (ComponentIndexType)this.cameraIndex), this.cameraModeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyShootPhotoMode, (ComponentIndexType)this.cameraIndex), this.shootPhotoModeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDOperationState, (ComponentIndexType)this.cameraIndex), this.ssdOperationStateProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeySSDAvailableRecordingTimeInSeconds, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.ssdAvailableRecordingTimeInSecProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDVideoLicenses, (ComponentIndexType)this.cameraIndex), this.activateSSDVideoLicenseProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDColor, (ComponentIndexType)this.cameraIndex), this.ssdColorProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
    }
}

