/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.aperture;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraAperture;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.visualcamera.aperture.CameraConfigApertureWidgetModel;

public class CameraConfigApertureWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private CameraConfigApertureWidgetModel widgetModel;
    private TextView apertureTitleTextView;
    private TextView apertureValueTextView;

    public CameraConfigApertureWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigApertureWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigApertureWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigApertureWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_base_camera_info, (ViewGroup)this);
        this.apertureTitleTextView = (TextView)this.findViewById(R.id.textview_title);
        this.apertureValueTextView = (TextView)this.findViewById(R.id.textview_value);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigApertureWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.apertureTitleTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_aperture_title));
        }
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getAperture().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
    }

    private void updateUI(@NonNull CameraAperture aperture) {
        this.apertureValueTextView.setText((CharSequence)CameraUtil.apertureDisplayName(this.getResources(), aperture));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_base_camera_info_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setApertureTitleTextAppearance(@StyleRes int textAppearance) {
        this.apertureTitleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getApertureTitleTextColors() {
        return this.apertureTitleTextView.getTextColors();
    }

    @ColorInt
    public int getApertureTitleTextColor() {
        return this.apertureTitleTextView.getCurrentTextColor();
    }

    public void setApertureTitleTextColor(@NonNull ColorStateList colorStateList) {
        this.apertureTitleTextView.setTextColor(colorStateList);
    }

    public void setApertureTitleTextColor(@ColorInt int color2) {
        this.apertureTitleTextView.setTextColor(color2);
    }

    @Dimension
    public float getApertureTitleTextSize() {
        return this.apertureTitleTextView.getTextSize();
    }

    public void setApertureTitleTextSize(@Dimension float textSize) {
        this.apertureTitleTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getApertureTitleTextBackground() {
        return this.apertureTitleTextView.getBackground();
    }

    public void setApertureTitleTextBackground(@DrawableRes int resourceId) {
        this.apertureTitleTextView.setBackgroundResource(resourceId);
    }

    public void setApertureTitleTextBackground(@Nullable Drawable drawable2) {
        this.apertureTitleTextView.setBackground(drawable2);
    }

    public void setApertureValueTextAppearance(@StyleRes int textAppearance) {
        this.apertureValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getApertureValueTextColors() {
        return this.apertureValueTextView.getTextColors();
    }

    @ColorInt
    public int getApertureValueTextColor() {
        return this.apertureValueTextView.getCurrentTextColor();
    }

    public void setApertureValueTextColor(@NonNull ColorStateList colorStateList) {
        this.apertureValueTextView.setTextColor(colorStateList);
    }

    public void setApertureValueTextColor(@ColorInt int color2) {
        this.apertureValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getApertureValueTextSize() {
        return this.apertureValueTextView.getTextSize();
    }

    public void setApertureValueTextSize(@Dimension float textSize) {
        this.apertureValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getApertureValueTextBackground() {
        return this.apertureValueTextView.getBackground();
    }

    public void setApertureValueTextBackground(@DrawableRes int resourceId) {
        this.apertureValueTextView.setBackgroundResource(resourceId);
    }

    public void setApertureValueTextBackground(@Nullable Drawable drawable2) {
        this.apertureValueTextView.setBackground(drawable2);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable apertureValueTextBackgroundDrawable;
        int apertureValueTextColor;
        float apertureValueTextSize;
        int apertureValueTextAppearanceId;
        Drawable apertureTitleTextBackgroundDrawable;
        int apertureTitleTextColor;
        float apertureTitleTextSize;
        int apertureTitleTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigApertureWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigApertureWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.CameraConfigApertureWidget_uxsdk_lensType, 0)));
        }
        if ((apertureTitleTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigApertureWidget_uxsdk_apertureTitleTextAppearance, -1)) != -1) {
            this.setApertureTitleTextAppearance(apertureTitleTextAppearanceId);
        }
        if ((apertureTitleTextSize = typedArray.getDimension(R.styleable.CameraConfigApertureWidget_uxsdk_apertureTitleTextSize, -1.0f)) != -1.0f) {
            this.setApertureTitleTextSize(DisplayUtil.pxToSp((Context)context, (float)apertureTitleTextSize));
        }
        if ((apertureTitleTextColor = typedArray.getColor(R.styleable.CameraConfigApertureWidget_uxsdk_apertureTitleTextColor, 0)) != 0) {
            this.setApertureTitleTextColor(apertureTitleTextColor);
        }
        if ((apertureTitleTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigApertureWidget_uxsdk_apertureTitleBackgroundDrawable)) != null) {
            this.setApertureTitleTextBackground(apertureTitleTextBackgroundDrawable);
        }
        if ((apertureValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigApertureWidget_uxsdk_apertureValueTextAppearance, -1)) != -1) {
            this.setApertureValueTextAppearance(apertureValueTextAppearanceId);
        }
        if ((apertureValueTextSize = typedArray.getDimension(R.styleable.CameraConfigApertureWidget_uxsdk_apertureValueTextSize, -1.0f)) != -1.0f) {
            this.setApertureValueTextSize(DisplayUtil.pxToSp((Context)context, (float)apertureValueTextSize));
        }
        if ((apertureValueTextColor = typedArray.getColor(R.styleable.CameraConfigApertureWidget_uxsdk_apertureValueTextColor, 0)) != 0) {
            this.setApertureValueTextColor(apertureValueTextColor);
        }
        if ((apertureValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigApertureWidget_uxsdk_apertureValueBackgroundDrawable)) != null) {
            this.setApertureValueTextBackground(apertureValueTextBackgroundDrawable);
        }
        typedArray.recycle();
    }
}

