/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircle;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircleOptions;
import dji.v5.ux.mapkit.maplibre.map.MaplibreMapDelegate;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;
import java.util.ArrayList;
import java.util.List;

public class MGroupCircle
implements DJIGroupCircle {
    private MapboxMap mapboxMap;
    private FillLayer groupCircleLayer;
    private GeoJsonSource source;
    private MaplibreMapDelegate maplibreMapDelegate;
    private float zindex;
    private DJIGroupCircleOptions options;
    private String sourceId;
    private String layerId;
    private int size;

    private MGroupCircle() {
    }

    public MGroupCircle(MaplibreMapDelegate maplibreMapDelegate, MapboxMap mapboxMap, FillLayer groupCircleLayer, GeoJsonSource source, DJIGroupCircleOptions options) {
        this.maplibreMapDelegate = maplibreMapDelegate;
        this.mapboxMap = mapboxMap;
        this.groupCircleLayer = groupCircleLayer;
        this.source = source;
        this.sourceId = source.getId();
        this.layerId = groupCircleLayer.getId();
        this.options = options;
    }

    public void updateSourceLayer() {
        this.source = new GeoJsonSource(this.sourceId);
        this.setCircles(this.options.getCenters(), this.options.getRadius());
        this.mapboxMap.getStyle().addSource((Source)this.source);
        this.groupCircleLayer = new FillLayer(this.layerId, this.sourceId);
        this.maplibreMapDelegate.updateLayerByZIndex((int)this.options.getZIndex(), (Layer)this.groupCircleLayer);
    }

    @Override
    public void remove() {
        this.maplibreMapDelegate.onGroupCircleRemove(this);
    }

    @Override
    public void setCircles(List<DJILatLng> centers, List<Double> radius) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        if (centers.size() != radius.size()) {
            return;
        }
        this.size = centers.size();
        this.options.radius(radius);
        this.options.centers(centers);
        ArrayList<Feature> features = new ArrayList<Feature>(this.size);
        for (int i = 0; i < this.size; ++i) {
            Point point = Point.fromLngLat((double)centers.get(i).getLongitude(), (double)centers.get(i).getLatitude());
            Polygon center = MaplibreUtils.getCircle(point, radius.get(i));
            features.add(Feature.fromGeometry((Geometry)center));
        }
        FeatureCollection featureCollection = FeatureCollection.fromFeatures(features);
        this.source.setGeoJson(featureCollection);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        if (visible) {
            this.groupCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"visible")});
        } else {
            this.groupCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"none")});
        }
    }

    @Override
    public boolean isVisible() {
        boolean visible = ((String)this.groupCircleLayer.getVisibility().value).equals("visible");
        return visible;
    }

    @Override
    public void setZIndex(float zIndex) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.zIndex(this.zindex);
        this.maplibreMapDelegate.updateLayerByZIndex((int)zIndex, (Layer)this.groupCircleLayer);
    }

    @Override
    public float getZIndex() {
        return this.options.getZIndex();
    }

    @Override
    public void setFillColor(int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.fillColor(color2);
        this.groupCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.fillColor((int)color2)});
    }

    @Override
    public void setStrokeColor(int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.strokeColor(color2);
        this.groupCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.fillOutlineColor((int)color2)});
    }

    @Override
    public DJIGroupCircleOptions getOptions() {
        return null;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getLayerId() {
        return this.layerId;
    }
}

