/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.maps;

import dji.v5.ux.mapkit.core.callback.OnCameraChangeListener;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import java.util.LinkedList;
import java.util.List;

public abstract class DJIBaseMap
implements DJIMap {
    protected List<OnCameraChangeListener> onCameraChangeListeners = new LinkedList<OnCameraChangeListener>();
    protected List<DJIMap.OnMarkerClickListener> onMarkerClickListeners = new LinkedList<DJIMap.OnMarkerClickListener>();
    protected List<DJIMap.OnMapLongClickListener> onMapLongClickListeners = new LinkedList<DJIMap.OnMapLongClickListener>();
    protected List<DJIMap.OnInfoWindowClickListener> onInfoWindowClickListeners = new LinkedList<DJIMap.OnInfoWindowClickListener>();
    protected List<DJIMap.OnMarkerDragListener> onMarkerDragListeners = new LinkedList<DJIMap.OnMarkerDragListener>();
    protected List<DJIMap.OnMapClickListener> onMapClickListeners = new LinkedList<DJIMap.OnMapClickListener>();

    protected boolean onMarkerClick(DJIMarker marker) {
        for (DJIMap.OnMarkerClickListener listener2 : this.onMarkerClickListeners) {
            listener2.onMarkerClick(marker);
        }
        return true;
    }

    protected void onMapClick(DJILatLng latLng) {
        for (DJIMap.OnMapClickListener listener2 : this.onMapClickListeners) {
            listener2.onMapClick(latLng);
        }
    }

    protected void onMapLongClick(DJILatLng latLng) {
        for (DJIMap.OnMapLongClickListener listener2 : this.onMapLongClickListeners) {
            listener2.onMapLongClick(latLng);
        }
    }

    protected void onInfoWindowClick(DJIMarker marker) {
        for (DJIMap.OnInfoWindowClickListener listener2 : this.onInfoWindowClickListeners) {
            listener2.onInfoWindowClick(marker);
        }
    }

    protected void onMarkerDragStart(DJIMarker marker) {
        for (DJIMap.OnMarkerDragListener listener2 : this.onMarkerDragListeners) {
            listener2.onMarkerDragStart(marker);
        }
    }

    protected void onMarkerDrag(DJIMarker marker) {
        for (DJIMap.OnMarkerDragListener listener2 : this.onMarkerDragListeners) {
            listener2.onMarkerDrag(marker);
        }
    }

    protected void onMarkerDragEnd(DJIMarker marker) {
        for (DJIMap.OnMarkerDragListener listener2 : this.onMarkerDragListeners) {
            listener2.onMarkerDragEnd(marker);
        }
    }

    protected void onCameraChange(DJICameraPosition cameraPosition) {
        for (OnCameraChangeListener listener2 : this.onCameraChangeListeners) {
            listener2.onCameraChange(cameraPosition);
        }
    }

    protected void onCameraChangeFinish(DJICameraPosition cameraPosition) {
        for (OnCameraChangeListener listener2 : this.onCameraChangeListeners) {
            listener2.onCameraChange(cameraPosition);
        }
    }

    @Override
    public void setOnMarkerClickListener(DJIMap.OnMarkerClickListener listener2) {
        if (listener2 != null && !this.onMarkerClickListeners.contains(listener2)) {
            this.onMarkerClickListeners.add(listener2);
        }
    }

    @Override
    public void removeOnMarkerClickListener(DJIMap.OnMarkerClickListener listener2) {
        this.onMarkerClickListeners.remove(listener2);
    }

    @Override
    public void setOnMapClickListener(DJIMap.OnMapClickListener listener2) {
        if (listener2 != null && !this.onMapClickListeners.contains(listener2)) {
            this.onMapClickListeners.add(listener2);
        }
    }

    @Override
    public void removeOnMapClickListener(DJIMap.OnMapClickListener listener2) {
        this.onMapClickListeners.clear();
    }

    @Override
    public void setOnInfoWindowClickListener(DJIMap.OnInfoWindowClickListener listener2) {
        if (listener2 != null && !this.onInfoWindowClickListeners.contains(listener2)) {
            this.onInfoWindowClickListeners.add(listener2);
        }
    }

    @Override
    public void setOnMarkerDragListener(DJIMap.OnMarkerDragListener listener2) {
        if (listener2 != null && !this.onMarkerDragListeners.contains(listener2)) {
            this.onMarkerDragListeners.add(listener2);
        }
    }

    @Override
    public void removeOnMarkerDragListener(DJIMap.OnMarkerDragListener listener2) {
        this.onMarkerDragListeners.remove(listener2);
    }

    @Override
    public void removeAllOnMarkerDragListener() {
        this.onMarkerDragListeners.clear();
    }

    @Override
    public void setOnMapLongClickListener(DJIMap.OnMapLongClickListener listener2) {
        if (listener2 != null && !this.onMapLongClickListeners.contains(listener2)) {
            this.onMapLongClickListeners.add(listener2);
        }
    }

    @Override
    public void removeOnMapLongClickListener(DJIMap.OnMapLongClickListener listener2) {
        this.onMapLongClickListeners.remove(listener2);
    }

    @Override
    public void removeAllOnMapLongClickListener() {
        this.onMapLongClickListeners.clear();
    }

    @Override
    public void setOnCameraChangeListener(OnCameraChangeListener listener2) {
        if (listener2 != null && !this.onCameraChangeListeners.contains(listener2)) {
            this.onCameraChangeListeners.add(listener2);
        }
    }

    @Override
    public void removeOnCameraChangeListener(OnCameraChangeListener listener2) {
        this.onCameraChangeListeners.remove(listener2);
    }

    @Override
    public void removeAllOnCameraChangeListeners() {
        this.onCameraChangeListeners.clear();
    }

    @Override
    public void removeAllOnMarkerClickListener() {
        this.onMarkerDragListeners.clear();
    }

    @Override
    public void removeAllOnMapClickListener() {
        this.onMapClickListeners.clear();
    }
}

