/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.core.model.WarningMessageError;
import java.util.Objects;

public class WarningMessage {
    private static final int DEFAULT_DISPLAY_DURATION = 5;
    private WarningType warningType;
    private int code;
    private int subCode;
    private int componentIndex;
    private String reason;
    private String solution;
    private Level level = Level.WARNING;
    private Type type = Type.AUTO_DISAPPEAR;
    private Action action = Action.INSERT;
    private int showDuration = 5;
    private int iconRes;

    private WarningMessage(@Nullable WarningType type, @Nullable String reason, @Nullable String solution) {
        this.reason = reason;
        this.solution = solution;
        this.code = WarningType.OTHER.getValue();
        this.subCode = WarningMessageError.CUSTOMER_USE_ERROR.value();
        this.warningType = type;
        if (this.reason != null) {
            this.code = this.reason.hashCode();
        }
        if (this.solution != null) {
            this.code += this.solution.hashCode();
        }
    }

    public WarningMessage(@Nullable WarningType warningType, int code, int subCode, @Nullable String reason, @Nullable String solution) {
        this(warningType, code, subCode, 0, reason, solution);
    }

    public WarningMessage(@Nullable WarningType warningType, int code, int subCode, int componentIndex, @Nullable String reason, @Nullable String solution) {
        this.warningType = warningType;
        this.code = code;
        this.subCode = subCode;
        this.componentIndex = componentIndex;
        this.reason = reason;
        this.solution = solution;
    }

    @Nullable
    public WarningType getWarningType() {
        return this.warningType;
    }

    public void setWarningType(@Nullable WarningType type) {
        this.warningType = type;
    }

    public int getCode() {
        return this.code;
    }

    public void setSubCode(int subCode) {
        this.subCode = subCode;
    }

    public int getSubCode() {
        return this.subCode;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public void setComponentIndex(int componentIndex) {
        this.componentIndex = componentIndex;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public void setReason(@Nullable String reason) {
        this.reason = reason;
    }

    @Nullable
    public String getSolution() {
        return this.solution;
    }

    public void setSolution(@Nullable String solution) {
        this.solution = solution;
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable Level level) {
        this.level = level;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    public void setType(@Nullable Type type) {
        this.type = type;
    }

    public int getShowDuration() {
        return this.showDuration;
    }

    public void setShowDuration(int showDuration) {
        this.showDuration = showDuration;
    }

    @Nullable
    public Action getAction() {
        return this.action;
    }

    public void setAction(@Nullable Action action) {
        this.action = action;
    }

    public int getIconRes() {
        return this.iconRes;
    }

    public void setIconRes(int iconRes) {
        this.iconRes = iconRes;
    }

    @NonNull
    public String toString() {
        return "WarningMessage{WarningType=" + (this.warningType == null ? "is null" : this.warningType.name()) + ", code=" + this.code + ", subCode=" + this.subCode + ", componentIndex=" + this.componentIndex + ", reason='" + this.reason + '\'' + ", solution='" + this.solution + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarningMessage that = (WarningMessage)o;
        if (this.warningType != that.warningType) {
            return false;
        }
        if (this.code != that.code) {
            return false;
        }
        if (this.subCode != that.subCode) {
            return false;
        }
        if (this.componentIndex != that.componentIndex) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        return Objects.equals(this.solution, that.solution);
    }

    public int hashCode() {
        int result = this.code;
        result = 31 * result + this.subCode;
        result = 31 * result + (this.warningType == null ? 0 : this.warningType.getValue());
        result = 31 * result + this.componentIndex;
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        result = 31 * result + (this.solution != null ? this.solution.hashCode() : 0);
        return result;
    }

    public static enum Level {
        NOTIFY(0),
        WARNING(1),
        DANGEROUS(2);

        private int value;
        private static Level[] values;

        private Level(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Level[] getValues() {
            if (values == null) {
                values = Level.values();
            }
            return values;
        }

        public static Level find(int value) {
            for (Level item : Level.getValues()) {
                if (item.getValue() != value) continue;
                return item;
            }
            return NOTIFY;
        }
    }

    public static enum Type {
        AUTO_DISAPPEAR(0),
        PUSH(1),
        PINNED(2),
        PINNED_NOT_CLOSE(3);

        private int value;
        private static Type[] values;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type[] getValues() {
            if (values == null) {
                values = Type.values();
            }
            return values;
        }

        public static Type find(int value) {
            for (Type item : Type.getValues()) {
                if (item.getValue() != value) continue;
                return item;
            }
            return AUTO_DISAPPEAR;
        }
    }

    public static enum Action {
        INSERT,
        REMOVE;

    }

    public static enum WarningType {
        AIR1860(0),
        BATTERY(1),
        CAMERA(2),
        CENTER_BOARD(3),
        OSD(4),
        FLIGHT_CONTROLLER(5),
        GIMBAL(6),
        LIGHT_BRIDGE(7),
        REMOTE_CONTROLLER(8),
        VISION(9),
        FLIGHT_RECORD(10),
        FLY_SAFE(11),
        RTK(12),
        LTE(13),
        OTHER(100);

        private int value;
        private static WarningType[] values;

        private WarningType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static WarningType[] getValues() {
            if (values == null) {
                values = WarningType.values();
            }
            return values;
        }

        public static WarningType find(int value) {
            for (WarningType item : WarningType.getValues()) {
                if (item.getValue() != value) continue;
                return item;
            }
            return OTHER;
        }
    }

    public static class Builder {
        private WarningType warningType;
        private int code;
        private int subCode;
        private int componentIndex;
        private String reason;
        private String solution;
        private Level level = Level.WARNING;
        private Type type = Type.AUTO_DISAPPEAR;
        private Action action = Action.INSERT;
        private int showDuration = 5;
        private int iconRes;

        public Builder(@Nullable WarningType warningType) {
            this.warningType = warningType;
        }

        @NonNull
        public Builder code(int code) {
            this.code = code;
            return this;
        }

        @NonNull
        public Builder warningType(@Nullable WarningType warningType) {
            this.warningType = warningType;
            return this;
        }

        @NonNull
        public Builder subCode(int subCode) {
            this.subCode = subCode;
            return this;
        }

        @NonNull
        public Builder componentIndex(int componentIndex) {
            this.componentIndex = componentIndex;
            return this;
        }

        @NonNull
        public Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @NonNull
        public Builder solution(@Nullable String solution) {
            this.solution = solution;
            return this;
        }

        @NonNull
        public Builder level(@Nullable Level level) {
            this.level = level;
            return this;
        }

        @NonNull
        public Builder type(@Nullable Type type) {
            this.type = type;
            return this;
        }

        @NonNull
        public Builder showDuration(int showDuration) {
            this.showDuration = showDuration;
            return this;
        }

        @NonNull
        public Builder action(@Nullable Action action) {
            this.action = action;
            return this;
        }

        @NonNull
        public Builder iconRes(int iconRes) {
            this.iconRes = iconRes;
            return this;
        }

        @NonNull
        public WarningMessage build() {
            WarningMessage warningMessage = new WarningMessage(this.warningType, this.reason, this.solution);
            if (this.code != -1) {
                warningMessage.setCode(this.code);
            }
            warningMessage.setSubCode(this.subCode);
            warningMessage.setLevel(this.level);
            warningMessage.setType(this.type);
            warningMessage.setComponentIndex(this.componentIndex);
            warningMessage.setShowDuration(this.showDuration);
            warningMessage.setAction(this.action);
            warningMessage.setIconRes(this.iconRes);
            return warningMessage;
        }
    }
}

