/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.model;

import dji.v5.ux.core.base.charts.model.AbstractChartData;
import dji.v5.ux.core.base.charts.model.Line;
import dji.v5.ux.core.base.charts.model.PointValue;
import java.util.ArrayList;
import java.util.List;

public class LineChartData
extends AbstractChartData {
    private List<Line> lines = new ArrayList<Line>();
    private float baseValue = 0.0f;

    public LineChartData() {
    }

    public LineChartData(List<Line> lines) {
        this.setLines(lines);
    }

    public LineChartData(LineChartData data) {
        super(data);
        this.baseValue = data.baseValue;
        for (Line line : data.lines) {
            this.lines.add(new Line(line));
        }
    }

    public static LineChartData generateDummyData() {
        LineChartData data = new LineChartData();
        ArrayList<PointValue> values = new ArrayList<PointValue>(4);
        values.add(new PointValue(0.0f, 2.0f));
        values.add(new PointValue(1.0f, 4.0f));
        values.add(new PointValue(2.0f, 3.0f));
        values.add(new PointValue(3.0f, 4.0f));
        Line line = new Line(values);
        ArrayList<Line> lines = new ArrayList<Line>(1);
        lines.add(line);
        data.setLines(lines);
        return data;
    }

    @Override
    public void update(float scale) {
        for (Line line : this.lines) {
            line.update(scale);
        }
    }

    @Override
    public void finish() {
        for (Line line : this.lines) {
            line.finish();
        }
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public LineChartData setLines(List<Line> lines) {
        this.lines = null == lines ? new ArrayList<Line>() : lines;
        return this;
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    public LineChartData setBaseValue(float baseValue) {
        this.baseValue = baseValue;
        return this;
    }
}

