/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import androidx.annotation.NonNull;
import dji.v5.ux.core.base.SchedulerProvider;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.processors.BehaviorProcessor;

public final class DataProcessor<T> {
    private final BehaviorProcessor<T> processor;
    private final T defaultValue;

    @NonNull
    public static <T> DataProcessor<T> create(@NonNull T defaultValue) {
        return new DataProcessor<T>(defaultValue);
    }

    private DataProcessor(@NonNull T defaultValue) {
        this.processor = BehaviorProcessor.createDefault(defaultValue);
        this.defaultValue = defaultValue;
    }

    public void onNext(@NonNull T data) {
        this.processor.onNext(data);
    }

    public void onComplete() {
        this.processor.onComplete();
    }

    public void onError(@NonNull Throwable error) {
        this.processor.onError(error);
    }

    @NonNull
    public T getValue() {
        Object t = this.processor.getValue();
        if (t == null) {
            t = this.defaultValue;
        }
        return (T)t;
    }

    @NonNull
    public Flowable<T> toFlowable() {
        return this.processor.observeOn(SchedulerProvider.computation()).onBackpressureLatest();
    }

    @NonNull
    public Flowable<T> toFlowableOnUI() {
        return this.processor.observeOn(SchedulerProvider.ui()).onBackpressureLatest();
    }

    public Observable<T> toObservableOnUI() {
        return this.toFlowableOnUI().toObservable();
    }
}

