/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.wb;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraWhiteBalanceInfo;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;

public class CameraConfigWBWidgetModel
extends WidgetModel
implements ICameraIndex {
    private DataProcessor<CameraWhiteBalanceInfo> whiteBalanceProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraConfigWBWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.whiteBalanceProcessor = DataProcessor.create(new CameraWhiteBalanceInfo());
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<CameraWhiteBalanceInfo> getWhiteBalance() {
        return this.whiteBalanceProcessor.toFlowable();
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyWhiteBalance, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.whiteBalanceProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
    }
}

