/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.common.EmptyMsg;
import dji.sdk.keyvalue.value.flightcontroller.CompassCalibrationState;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.dialog.BaseDialog;
import dji.v5.ux.core.util.ViewUtil;

public class CompassCalibrationDialog
extends BaseDialog
implements View.OnClickListener {
    private View rootView;
    private boolean isCalibrating = true;
    private CompassCalibrationState mLastState = CompassCalibrationState.UNKNOWN;
    private boolean mFinish;
    private TextView mTitleTv;
    private TextView mStepTv;
    private ImageView mIllustationIv;
    private View mBottomDivider;
    private TextView mRightBtn;
    private TextView mLeftBtn;
    private static int[] aircraftCompassIconM30 = new int[]{R.drawable.uxsdk_fpv_compass_horizontal_m30, R.drawable.uxsdk_fpv_compass_vertical_m30};
    private static int[] aircraftCompassIconM300 = new int[]{R.drawable.uxsdk_fpv_compass_horizontal_m300, R.drawable.uxsdk_fpv_compass_vertical_m300};
    private static int[] aircraftCompassIconM3 = new int[]{R.drawable.uxsdk_fpv_compass_horizontal_m3e, R.drawable.uxsdk_fpv_compass_vertical_m3e};

    private void initView(View view) {
        this.mTitleTv = (TextView)view.findViewById(R.id.compass_calibration_title);
        this.mStepTv = (TextView)view.findViewById(R.id.compass_calibration_step);
        this.mIllustationIv = (ImageView)view.findViewById(R.id.compass_calibration_illustration);
        this.mBottomDivider = view.findViewById(R.id.compass_calibration_bottom_divider);
        this.mRightBtn = (TextView)view.findViewById(R.id.compass_calibration_right_btn);
        this.mRightBtn.setOnClickListener((View.OnClickListener)this);
        this.mLeftBtn = (TextView)view.findViewById(R.id.compass_calibration_left_btn);
        this.mLeftBtn.setOnClickListener((View.OnClickListener)this);
    }

    public CompassCalibrationDialog(@NonNull Context context) {
        this(context, R.style.NoTitleDialog);
    }

    public CompassCalibrationDialog(@NonNull Context context, @StyleRes int themeResId) {
        super(context, themeResId);
        this.initialize(context);
    }

    protected CompassCalibrationDialog(@NonNull Context context, boolean cancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_dialog_compass_calibration, null);
        this.initView(this.rootView);
        this.updateNoticeImage(this.getIllustrationResIdByAircraft(CompassCalibrationState.HORIZONTAL));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.rootView);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsCompassCalibrating), (Object)this, (oldValue, newValue) -> {
            this.isCalibrating = newValue != null;
            this.checkCompassCalibrationState();
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyCompassCalibrationStatus), (Object)this, (oldValue, state) -> {
            this.mFinish = state == CompassCalibrationState.SUCCEEDED || state == CompassCalibrationState.FAILED;
            this.mLastState = state;
            if (state != CompassCalibrationState.UNKNOWN && state != CompassCalibrationState.IDLE) {
                this.updateViews((CompassCalibrationState)state);
            } else {
                this.checkCompassCalibrationState();
            }
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), (Object)this, (oldValue, connection) -> {
            if (connection != null && !connection.booleanValue()) {
                this.dismiss();
            }
        });
    }

    private void checkCompassCalibrationState() {
        if (!this.mFinish && !this.isCalibrating && this.mLastState == CompassCalibrationState.IDLE) {
            this.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        KeyManager.getInstance().cancelListen((Object)this);
    }

    @Override
    public int getDialogWidth() {
        return (int)this.getContext().getResources().getDimension(R.dimen.uxsdk_dialog_update_width);
    }

    @Override
    public int getDialogMaxHeight() {
        return AndUtil.getLandScreenHeight((Context)this.getContext());
    }

    public void onClick(View view) {
        if (view.getId() == R.id.compass_calibration_left_btn) {
            if (this.isCalibrating) {
                KeyManager.getInstance().performAction(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStopCompassCalibration), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<EmptyMsg>(){

                    public void onSuccess(EmptyMsg emptyMsg) {
                    }

                    public void onFailure(@NonNull IDJIError error) {
                    }
                });
            }
            this.dismiss();
        } else {
            KeyManager.getInstance().performAction(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStopCompassCalibration), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<EmptyMsg>(){

                public void onSuccess(EmptyMsg emptyMsg) {
                    CompassCalibrationDialog.this.startCali();
                }

                public void onFailure(@NonNull IDJIError error) {
                }
            });
        }
    }

    private void startCali() {
        KeyManager.getInstance().performAction(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartCompassCalibration), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<EmptyMsg>(){

            public void onSuccess(EmptyMsg emptyMsg) {
            }

            public void onFailure(@NonNull IDJIError error) {
                ViewUtil.showToast(CompassCalibrationDialog.this.getContext(), R.string.uxsdk_app_check_aircraft_connection, 0);
            }
        });
    }

    private void updateViews(CompassCalibrationState status) {
        if (status == CompassCalibrationState.HORIZONTAL) {
            String title = this.getContext().getString(R.string.uxsdk_fpv_checklist_compass_tip_1);
            this.mTitleTv.setText((CharSequence)title);
            this.mStepTv.setVisibility(0);
            this.mStepTv.setText(this.getStepResIdByAircraft(status));
            this.updateNoticeImage(this.getIllustrationResIdByAircraft(status));
            this.mLeftBtn.setText(R.string.uxsdk_fpv_checklist_cancel_cele);
            this.mRightBtn.setVisibility(8);
            this.mBottomDivider.setVisibility(8);
        } else if (status == CompassCalibrationState.VERTICAL) {
            String title = this.getContext().getString(R.string.uxsdk_fpv_checklist_compass_tip_2);
            this.mTitleTv.setText((CharSequence)title);
            this.mStepTv.setVisibility(0);
            this.mStepTv.setText(this.getStepResIdByAircraft(status));
            this.updateNoticeImage(this.getIllustrationResIdByAircraft(status));
            this.mLeftBtn.setText(R.string.uxsdk_fpv_checklist_cancel_cele);
            this.mRightBtn.setVisibility(8);
            this.mBottomDivider.setVisibility(8);
        } else if (status == CompassCalibrationState.SUCCEEDED) {
            this.mTitleTv.setText(R.string.uxsdk_fpv_compass_adjust_complete);
            this.mStepTv.setVisibility(8);
            this.updateNoticeImage(R.drawable.uxsdk_setting_ui_success);
            this.mLeftBtn.setText(R.string.uxsdk_app_ok);
            this.mRightBtn.setVisibility(8);
            this.mBottomDivider.setVisibility(8);
        } else if (status == CompassCalibrationState.FAILED) {
            this.mTitleTv.setText(R.string.uxsdk_fpv_compass_adjust_fail);
            this.mStepTv.setVisibility(8);
            this.updateNoticeImage(R.drawable.uxsdk_setting_ui_fail);
            this.mLeftBtn.setText(R.string.uxsdk_app_cancel);
            this.mRightBtn.setVisibility(0);
            this.mBottomDivider.setVisibility(0);
        }
    }

    private void updateNoticeImage(@DrawableRes int resId) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mIllustationIv.getLayoutParams();
        params.topMargin = 0;
        params.bottomMargin = 0;
        if (resId == R.drawable.uxsdk_setting_ui_success || resId == R.drawable.uxsdk_setting_ui_fail) {
            params.topMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.uxsdk_dialog_content_margin_top);
            params.bottomMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.uxsdk_dialog_content_margin_top);
        }
        this.mIllustationIv.setImageResource(resId);
    }

    private int getStepResIdByAircraft(CompassCalibrationState status) {
        if (status == CompassCalibrationState.HORIZONTAL) {
            return R.string.uxsdk_fpv_checklist_compass_tip_1_desc;
        }
        return R.string.uxsdk_fpv_checklist_compass_tip_2_desc;
    }

    private int getIllustrationResIdByAircraft(CompassCalibrationState status) {
        int[] resIds = ProductUtil.isM30Product() ? aircraftCompassIconM30 : (ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct() ? aircraftCompassIconM3 : aircraftCompassIconM300);
        if (status == CompassCalibrationState.HORIZONTAL) {
            return resIds[0];
        }
        return resIds[1];
    }
}

