/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.model;

import dji.v5.ux.core.base.charts.formatter.ColumnChartValueFormatter;
import dji.v5.ux.core.base.charts.formatter.SimpleColumnChartValueFormatter;
import dji.v5.ux.core.base.charts.model.SubcolumnValue;
import java.util.ArrayList;
import java.util.List;

public class Column {
    private boolean hasLabels = false;
    private boolean hasLabelsOnlyForSelected = false;
    private ColumnChartValueFormatter formatter = new SimpleColumnChartValueFormatter();
    private List<SubcolumnValue> values = new ArrayList<SubcolumnValue>();

    public Column() {
    }

    public Column(List<SubcolumnValue> values) {
        this.setValues(values);
    }

    public Column(Column column) {
        this.hasLabels = column.hasLabels;
        this.hasLabelsOnlyForSelected = column.hasLabelsOnlyForSelected;
        this.formatter = column.formatter;
        for (SubcolumnValue columnValue : column.values) {
            this.values.add(new SubcolumnValue(columnValue));
        }
    }

    public void update(float scale) {
        for (SubcolumnValue value : this.values) {
            value.update(scale);
        }
    }

    public void finish() {
        for (SubcolumnValue value : this.values) {
            value.finish();
        }
    }

    public List<SubcolumnValue> getValues() {
        return this.values;
    }

    public Column setValues(List<SubcolumnValue> values) {
        this.values = null == values ? new ArrayList<SubcolumnValue>() : values;
        return this;
    }

    public boolean hasLabels() {
        return this.hasLabels;
    }

    public Column setHasLabels(boolean hasLabels) {
        this.hasLabels = hasLabels;
        if (hasLabels) {
            this.hasLabelsOnlyForSelected = false;
        }
        return this;
    }

    public boolean hasLabelsOnlyForSelected() {
        return this.hasLabelsOnlyForSelected;
    }

    public Column setHasLabelsOnlyForSelected(boolean hasLabelsOnlyForSelected) {
        this.hasLabelsOnlyForSelected = hasLabelsOnlyForSelected;
        if (hasLabelsOnlyForSelected) {
            this.hasLabels = false;
        }
        return this;
    }

    public ColumnChartValueFormatter getFormatter() {
        return this.formatter;
    }

    public Column setFormatter(ColumnChartValueFormatter formatter) {
        if (null != formatter) {
            this.formatter = formatter;
        }
        return this;
    }
}

