/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.useraccount;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.fragment.app.FragmentActivity;
import dji.v5.manager.account.LoginInfo;
import dji.v5.manager.account.LoginState;
import dji.v5.manager.account.UserAccountManager;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.UXSDKError;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.useraccount.UserAccountLoginWidgetModel;
import java.util.HashMap;
import java.util.Map;

public class UserAccountLoginWidget
extends ConstraintLayoutWidget<Boolean>
implements View.OnClickListener {
    private static final String TAG = "LoginWidget";
    private TextView widgetStateTextView;
    private ImageView widgetActionImageView;
    private ImageView widgetUserImageView;
    private TextView widgetMessageTextView;
    private View widgetDivider;
    private UserAccountLoginWidgetModel widgetModel;
    private Map<LoginState, Integer> widgetStateTextColorMap;
    private Map<LoginState, Integer> widgetMessageTextColorMap;
    private Map<LoginState, Drawable> widgetActionIconMap;
    private Map<LoginState, Drawable> widgetUserIconMap;
    private LoginInfo currentLoginInfo = new LoginInfo();

    public UserAccountLoginWidget(Context context) {
        super(context);
    }

    public UserAccountLoginWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UserAccountLoginWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        UserAccountLoginWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_user_account_login, (ViewGroup)this);
        this.setBackgroundResource(R.drawable.uxsdk_background_black_rectangle);
        this.widgetDivider = this.findViewById(R.id.widget_divider);
        this.widgetStateTextView = (TextView)this.findViewById(R.id.textview_widget_status);
        this.widgetActionImageView = (ImageView)this.findViewById(R.id.imageview_widget_status);
        this.widgetUserImageView = (ImageView)this.findViewById(R.id.imageview_widget_user);
        this.widgetMessageTextView = (TextView)this.findViewById(R.id.textview_widget_message);
        this.widgetStateTextColorMap = new HashMap<LoginState, Integer>();
        this.widgetMessageTextColorMap = new HashMap<LoginState, Integer>();
        this.widgetActionIconMap = new HashMap<LoginState, Drawable>();
        this.widgetUserIconMap = new HashMap<LoginState, Drawable>();
        if (!this.isInEditMode()) {
            this.widgetModel = new UserAccountLoginWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance(), UserAccountManager.getInstance());
        }
        this.setOnClickListener(this);
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getUserAccountInformation().observeOn(SchedulerProvider.ui()).subscribe(loginInfo -> {
            if (loginInfo != null) {
                this.currentLoginInfo = loginInfo;
                this.updateUI();
            }
        }));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    public void onClick(View v) {
        if (this.currentLoginInfo.getLoginState() == LoginState.LOGGED_IN) {
            this.logoutUser();
        } else {
            this.loginUser();
        }
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_user_account_login_ratio);
    }

    private void loginUser() {
        Context ctx = this.getContext();
        if (!(ctx instanceof FragmentActivity) || ((FragmentActivity)ctx).isFinishing()) {
            LogUtils.e((String)TAG, (Object[])new Object[]{"Context is not activity or had finish: " + ctx});
        } else {
            this.addDisposable(this.widgetModel.loginUser((FragmentActivity)ctx).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, error -> LogUtils.e((String)TAG, (Object[])new Object[]{"login error:" + error})));
        }
    }

    private void logoutUser() {
        this.addDisposable(this.widgetModel.logoutUser().observeOn(SchedulerProvider.ui()).subscribe(() -> {}, error -> {
            if (error instanceof UXSDKError) {
                LogUtils.e((String)TAG, (Object[])new Object[]{error.toString()});
            }
        }));
    }

    private void updateUI() {
        if (this.currentLoginInfo == null) {
            LogUtils.e((String)TAG, (Object[])new Object[]{"currentLoginInfo == null"});
            return;
        }
        switch (this.currentLoginInfo.getLoginState()) {
            case LOGGED_IN: {
                this.widgetStateTextView.setText((CharSequence)this.currentLoginInfo.getAccount());
                this.widgetMessageTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_user_login_widget_logged_in));
                break;
            }
            case NOT_LOGGED_IN: {
                this.widgetStateTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_user_login_widget_login));
                this.widgetMessageTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_user_login_widget_not_logged_in));
                break;
            }
            case TOKEN_OUT_OF_DATE: {
                this.widgetStateTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_user_login_widget_refresh));
                this.widgetMessageTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_user_login_widget_token));
                break;
            }
            default: {
                return;
            }
        }
        this.widgetMessageTextView.setTextColor(this.getWidgetMessageTextColor(this.currentLoginInfo.getLoginState()));
        this.widgetActionImageView.setImageDrawable(this.getActionIcon(this.currentLoginInfo.getLoginState()));
        this.widgetUserImageView.setImageDrawable(this.getUserIcon(this.currentLoginInfo.getLoginState()));
        this.widgetStateTextView.setTextColor(this.getWidgetStateTextColor(this.currentLoginInfo.getLoginState()));
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.UserAccountLoginWidget);
        this.initActionIcon(typedArray);
        this.initStateText(typedArray);
        this.initMessageTest(typedArray);
        typedArray.recycle();
    }

    private void initStateText(TypedArray typedArray) {
        int color2;
        int textAppearance = typedArray.getResourceId(R.styleable.UserAccountLoginWidget_uxsdk_stateTextAppearance, -1);
        if (textAppearance != -1) {
            this.setWidgetStateTextAppearance(textAppearance);
        }
        if ((color2 = typedArray.getColor(R.styleable.UserAccountLoginWidget_uxsdk_stateTextColorLoggedIn, 0)) != 0) {
            this.setWidgetStateTextColor(LoginState.LOGGED_IN, color2);
        }
        if ((color2 = typedArray.getColor(R.styleable.UserAccountLoginWidget_uxsdk_stateTextColorNotLoggedIn, 0)) != 0) {
            this.setWidgetStateTextColor(LoginState.NOT_LOGGED_IN, color2);
        }
        if ((color2 = typedArray.getColor(R.styleable.UserAccountLoginWidget_uxsdk_stateTextColorTokenOutOfDate, 0)) != 0) {
            this.setWidgetStateTextColor(LoginState.TOKEN_OUT_OF_DATE, color2);
        }
        this.setWidgetStateTextEnabled(typedArray.getBoolean(R.styleable.UserAccountLoginWidget_uxsdk_stateTextEnabled, true));
    }

    private void initMessageTest(TypedArray typedArray) {
        int color2;
        int textAppearance = typedArray.getResourceId(R.styleable.UserAccountLoginWidget_uxsdk_messageTextAppearance, -1);
        if (textAppearance != -1) {
            this.setWidgetMessageTextAppearance(textAppearance);
        }
        if ((color2 = typedArray.getColor(R.styleable.UserAccountLoginWidget_uxsdk_messageTextColorLoggedIN, 0)) != 0) {
            this.setWidgetMessageTextColor(LoginState.LOGGED_IN, color2);
        }
        if ((color2 = typedArray.getColor(R.styleable.UserAccountLoginWidget_uxsdk_messageTextColorNotLoggedIn, 0)) != 0) {
            this.setWidgetMessageTextColor(LoginState.NOT_LOGGED_IN, color2);
        }
        if ((color2 = typedArray.getColor(R.styleable.UserAccountLoginWidget_uxsdk_messageTextColorTokenOutOfDate, 0)) != 0) {
            this.setWidgetMessageTextColor(LoginState.TOKEN_OUT_OF_DATE, color2);
        }
        this.setWidgetMessageTextSize(typedArray.getDimension(R.styleable.UserAccountLoginWidget_uxsdk_messageTextSize, this.getResources().getDimension(R.dimen.uxsdk_user_account_message_text_size)));
        this.setWidgetMessageBackground(typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_messageTextBackground));
        this.setWidgetStateTextSize(typedArray.getDimension(R.styleable.UserAccountLoginWidget_uxsdk_messageTextSize, this.getResources().getDimension(R.dimen.uxsdk_user_account_state_text_size)));
        if (typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_messageTextBackground) != null) {
            this.setWidgetStateBackground(typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_messageTextBackground));
        }
        this.initActionIcon(typedArray);
        this.setMessageTextEnabled(typedArray.getBoolean(R.styleable.UserAccountLoginWidget_uxsdk_messageTextEnabled, true));
    }

    private void initActionIcon(TypedArray typedArray) {
        Drawable drawable2 = typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_actionIconLoggedIn);
        if (drawable2 != null) {
            this.setActionIcon(LoginState.LOGGED_IN, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_actionIconNotLoggedIn)) != null) {
            this.setActionIcon(LoginState.NOT_LOGGED_IN, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_actionIconTokenOutOfDate)) != null) {
            this.setActionIcon(LoginState.TOKEN_OUT_OF_DATE, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_userIconLoggedIn)) != null) {
            this.setUserIcon(LoginState.LOGGED_IN, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_userIconNotLoggedIn)) != null) {
            this.setUserIcon(LoginState.NOT_LOGGED_IN, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_userIconTokenOutOfDate)) != null) {
            this.setUserIcon(LoginState.TOKEN_OUT_OF_DATE, drawable2);
        }
        if (typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_userIconBackground) != null) {
            this.setUserIconBackground(typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_userIconBackground));
        }
        if (typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_actionIconBackground) != null) {
            this.setActionIconBackground(typedArray.getDrawable(R.styleable.UserAccountLoginWidget_uxsdk_actionIconBackground));
        }
        this.setUserIconEnabled(typedArray.getBoolean(R.styleable.UserAccountLoginWidget_uxsdk_userIconEnabled, true));
        this.setActionIconEnabled(typedArray.getBoolean(R.styleable.UserAccountLoginWidget_uxsdk_actionIconEnabled, true));
    }

    private void initDefaults() {
        if (this.isInEditMode()) {
            return;
        }
        this.setWidgetStateTextColor(LoginState.NOT_LOGGED_IN, this.getResources().getColor(R.color.uxsdk_white_80_percent));
        this.setWidgetStateTextColor(LoginState.LOGGED_IN, this.getResources().getColor(R.color.uxsdk_white_80_percent));
        this.setWidgetStateTextColor(LoginState.TOKEN_OUT_OF_DATE, this.getResources().getColor(R.color.uxsdk_white_80_percent));
        this.setWidgetStateTextColor(LoginState.UNKNOWN, this.getResources().getColor(R.color.uxsdk_white_80_percent));
        this.setWidgetMessageTextColor(LoginState.NOT_LOGGED_IN, this.getResources().getColor(R.color.uxsdk_red_material_800));
        this.setWidgetMessageTextColor(LoginState.LOGGED_IN, this.getResources().getColor(R.color.uxsdk_green_material_400));
        this.setWidgetMessageTextColor(LoginState.TOKEN_OUT_OF_DATE, this.getResources().getColor(R.color.uxsdk_yellow_500));
        this.setWidgetMessageTextColor(LoginState.UNKNOWN, this.getResources().getColor(R.color.uxsdk_red_material_800));
        this.setUserIcon(LoginState.NOT_LOGGED_IN, this.getResources().getDrawable(R.drawable.uxsdk_ic_person));
        this.setUserIcon(LoginState.LOGGED_IN, this.getResources().getDrawable(R.drawable.uxsdk_ic_person));
        this.setUserIcon(LoginState.TOKEN_OUT_OF_DATE, this.getResources().getDrawable(R.drawable.uxsdk_ic_person));
        this.setUserIcon(LoginState.UNKNOWN, this.getResources().getDrawable(R.drawable.uxsdk_ic_person));
        this.setActionIcon(LoginState.NOT_LOGGED_IN, this.getResources().getDrawable(R.drawable.uxsdk_ic_person_log_in));
        this.setActionIcon(LoginState.LOGGED_IN, this.getResources().getDrawable(R.drawable.uxsdk_ic_person_log_out));
        this.setActionIcon(LoginState.TOKEN_OUT_OF_DATE, this.getResources().getDrawable(R.drawable.uxsdk_ic_person_log_out));
        this.setActionIcon(LoginState.UNKNOWN, this.getResources().getDrawable(R.drawable.uxsdk_ic_person_log_in));
        this.setWidgetStateTextSize(this.getResources().getDimension(R.dimen.uxsdk_user_account_state_text_size));
        this.setWidgetMessageTextSize(this.getResources().getDimension(R.dimen.uxsdk_user_account_message_text_size));
    }

    public void setWidgetStateTextColor(@NonNull LoginState userAccountState, @ColorInt int color2) {
        this.widgetStateTextColorMap.put(userAccountState, color2);
        this.updateUI();
    }

    @ColorInt
    public int getWidgetStateTextColor(@NonNull LoginState userAccountState) {
        return this.widgetStateTextColorMap.get(userAccountState);
    }

    public void setWidgetStateTextAppearance(@StyleRes int textAppearance) {
        this.widgetStateTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public Drawable getWidgetStateBackground() {
        return this.widgetStateTextView.getBackground();
    }

    public void setWidgetStateBackground(@DrawableRes int resourceId) {
        this.setWidgetStateBackground(this.getResources().getDrawable(resourceId));
    }

    public void setWidgetStateBackground(@Nullable Drawable drawable2) {
        this.widgetStateTextView.setBackground(drawable2);
    }

    @Dimension
    public float getWidgetStateTextSize() {
        return this.widgetStateTextView.getTextSize();
    }

    public void setWidgetStateTextSize(@Dimension float textSize) {
        this.widgetStateTextView.setTextSize(textSize);
    }

    public void setWidgetMessageTextColor(@NonNull LoginState userAccountState, @ColorInt int color2) {
        this.widgetMessageTextColorMap.put(userAccountState, color2);
        this.updateUI();
    }

    @ColorInt
    public int getWidgetMessageTextColor(@NonNull LoginState userAccountState) {
        return this.widgetMessageTextColorMap.get(userAccountState);
    }

    public void setWidgetMessageTextAppearance(@StyleRes int textAppearance) {
        this.widgetMessageTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public Drawable getWidgetMessageBackground() {
        return this.widgetMessageTextView.getBackground();
    }

    public void setWidgetMessageBackground(@DrawableRes int resourceId) {
        this.setWidgetMessageBackground(this.getResources().getDrawable(resourceId));
    }

    public void setWidgetMessageBackground(@Nullable Drawable drawable2) {
        this.widgetMessageTextView.setBackground(drawable2);
    }

    @Dimension
    public float getWidgetMessageTextSize() {
        return this.widgetMessageTextView.getTextSize();
    }

    public void setWidgetMessageTextSize(@Dimension float textSize) {
        this.widgetMessageTextView.setTextSize(textSize);
    }

    public void setActionIcon(@NonNull LoginState userAccountState, @DrawableRes int resourceId) {
        this.setActionIcon(userAccountState, this.getResources().getDrawable(resourceId));
    }

    public void setActionIcon(@NonNull LoginState userAccountState, @Nullable Drawable drawable2) {
        this.widgetActionIconMap.put(userAccountState, drawable2);
        this.updateUI();
    }

    public Drawable getActionIcon(@NonNull LoginState userAccountState) {
        return this.widgetActionIconMap.get(userAccountState);
    }

    public Drawable getActionIconBackground() {
        return this.widgetActionImageView.getBackground();
    }

    public void setActionIconBackground(@DrawableRes int resourceId) {
        this.setActionIconBackground(this.getResources().getDrawable(resourceId));
    }

    public void setActionIconBackground(@Nullable Drawable drawable2) {
        this.widgetActionImageView.setBackground(drawable2);
    }

    public void setUserIcon(@NonNull LoginState userAccountState, @DrawableRes int resourceId) {
        this.setUserIcon(userAccountState, this.getResources().getDrawable(resourceId));
    }

    public void setUserIcon(@NonNull LoginState userAccountState, @Nullable Drawable drawable2) {
        this.widgetUserIconMap.put(userAccountState, drawable2);
        this.updateUI();
    }

    public Drawable getUserIcon(@NonNull LoginState userAccountState) {
        return this.widgetUserIconMap.get(userAccountState);
    }

    public Drawable getUserIconBackground() {
        return this.widgetUserImageView.getBackground();
    }

    public void setUserIconBackground(@DrawableRes int resourceId) {
        this.setUserIconBackground(this.getResources().getDrawable(resourceId));
    }

    public void setUserIconBackground(@Nullable Drawable drawable2) {
        this.widgetUserImageView.setBackground(drawable2);
    }

    public boolean isActionIconEnabled() {
        return this.widgetActionImageView.getVisibility() == 0;
    }

    public void setActionIconEnabled(boolean isEnabled) {
        this.widgetActionImageView.setVisibility(isEnabled ? 0 : 8);
        this.widgetDivider.setVisibility(isEnabled ? 0 : 8);
    }

    public boolean isUserIconEnabled() {
        return this.widgetUserImageView.getVisibility() == 0;
    }

    public void setUserIconEnabled(boolean isEnabled) {
        this.widgetUserImageView.setVisibility(isEnabled ? 0 : 8);
        this.widgetDivider.setVisibility(isEnabled ? 0 : 8);
    }

    public boolean isMessageTextEnabled() {
        return this.widgetMessageTextView.getVisibility() == 0;
    }

    public void setMessageTextEnabled(boolean isEnabled) {
        this.widgetMessageTextView.setVisibility(isEnabled ? 0 : 8);
    }

    public boolean isWidgetStateTextEnabled() {
        return this.widgetStateTextView.getVisibility() == 0;
    }

    public void setWidgetStateTextEnabled(boolean isEnabled) {
        this.widgetStateTextView.setVisibility(isEnabled ? 0 : 8);
    }
}

