/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.model;

import android.graphics.Typeface;
import dji.v5.ux.core.base.charts.formatter.AxisValueFormatter;
import dji.v5.ux.core.base.charts.formatter.SimpleAxisValueFormatter;
import dji.v5.ux.core.base.charts.model.AxisValue;
import dji.v5.ux.core.base.charts.util.ChartUtils;
import java.util.ArrayList;
import java.util.List;

public class Axis {
    private int textSize = 12;
    private int maxLabelChars = 3;
    private List<AxisValue> values = new ArrayList<AxisValue>();
    private String name;
    private boolean isAutoGenerated = true;
    private boolean hasLines = false;
    private boolean isInside = false;
    private int textColor = -3355444;
    private int lineColor = ChartUtils.DEFAULT_DARKEN_COLOR;
    private Typeface typeface;
    private AxisValueFormatter formatter = new SimpleAxisValueFormatter();
    private boolean hasSeparationLine = true;
    private boolean hasTiltedLabels = false;

    public Axis() {
    }

    public Axis(List<AxisValue> values) {
        this.setValues(values);
    }

    public Axis(Axis axis) {
        this.name = axis.name;
        this.isAutoGenerated = axis.isAutoGenerated;
        this.hasLines = axis.hasLines;
        this.isInside = axis.isInside;
        this.textColor = axis.textColor;
        this.lineColor = axis.lineColor;
        this.textSize = axis.textSize;
        this.maxLabelChars = axis.maxLabelChars;
        this.typeface = axis.typeface;
        this.formatter = axis.formatter;
        this.hasSeparationLine = axis.hasSeparationLine;
        for (AxisValue axisValue : axis.values) {
            this.values.add(new AxisValue(axisValue));
        }
    }

    public static Axis generateAxisFromRange(float start, float stop, float step) {
        ArrayList<AxisValue> values = new ArrayList<AxisValue>();
        for (float value = start; value <= stop; value += step) {
            AxisValue axisValue = new AxisValue(value);
            values.add(axisValue);
        }
        return new Axis(values);
    }

    public static Axis generateAxisFromCollection(List<Float> axisValues) {
        ArrayList<AxisValue> values = new ArrayList<AxisValue>();
        int index = 0;
        for (float value : axisValues) {
            AxisValue axisValue = new AxisValue(value);
            values.add(axisValue);
            ++index;
        }
        return new Axis(values);
    }

    public static Axis generateAxisFromCollection(List<Float> axisValues, List<String> axisValuesLabels) {
        if (axisValues.size() != axisValuesLabels.size()) {
            throw new IllegalArgumentException("Values and labels lists must have the same size!");
        }
        ArrayList<AxisValue> values = new ArrayList<AxisValue>();
        int index = 0;
        for (float value : axisValues) {
            AxisValue axisValue = new AxisValue(value).setLabel(axisValuesLabels.get(index));
            values.add(axisValue);
            ++index;
        }
        return new Axis(values);
    }

    public List<AxisValue> getValues() {
        return this.values;
    }

    public Axis setValues(List<AxisValue> values) {
        this.values = null == values ? new ArrayList<AxisValue>() : values;
        this.isAutoGenerated = false;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Axis setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isAutoGenerated() {
        return this.isAutoGenerated;
    }

    public Axis setAutoGenerated(boolean isAutoGenerated) {
        this.isAutoGenerated = isAutoGenerated;
        return this;
    }

    public boolean hasLines() {
        return this.hasLines;
    }

    public Axis setHasLines(boolean hasLines) {
        this.hasLines = hasLines;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public Axis setTextColor(int color2) {
        this.textColor = color2;
        return this;
    }

    public boolean isInside() {
        return this.isInside;
    }

    public Axis setInside(boolean isInside) {
        this.isInside = isInside;
        return this;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public Axis setLineColor(int lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public Axis setTextSize(int textSize) {
        this.textSize = textSize;
        return this;
    }

    public int getMaxLabelChars() {
        return this.maxLabelChars;
    }

    public Axis setMaxLabelChars(int maxLabelChars) {
        if (maxLabelChars < 0) {
            maxLabelChars = 0;
        } else if (maxLabelChars > 32) {
            maxLabelChars = 32;
        }
        this.maxLabelChars = maxLabelChars;
        return this;
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public Axis setTypeface(Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public AxisValueFormatter getFormatter() {
        return this.formatter;
    }

    public Axis setFormatter(AxisValueFormatter formatter) {
        this.formatter = null == formatter ? new SimpleAxisValueFormatter() : formatter;
        return this;
    }

    public Axis setHasSeparationLine(boolean hasSeparationLine) {
        this.hasSeparationLine = hasSeparationLine;
        return this;
    }

    public boolean hasSeparationLine() {
        return this.hasSeparationLine;
    }

    public boolean hasTiltedLabels() {
        return this.hasTiltedLabels;
    }

    public Axis setHasTiltedLabels(boolean hasTiltedLabels) {
        this.hasTiltedLabels = hasTiltedLabels;
        return this;
    }
}

