/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.battery.BatteryOverviewValue;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.battery.BatteryGroupInfoWidgetModel;
import dji.v5.ux.core.widget.battery.BatteryInfoWidget;
import java.util.ArrayList;
import java.util.List;

public class BatteryGroupWidget
extends FrameLayoutWidget<Object> {
    protected BatteryGroupInfoWidgetModel widgetModel = new BatteryGroupInfoWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    protected ViewGroup container;
    protected boolean isConnected = false;
    protected boolean isEnableBatteryCells = true;
    protected boolean isEnableSerialNumber = true;

    public BatteryGroupWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BatteryGroupWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BatteryGroupWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        BatteryGroupWidget.inflate((Context)context, (int)R.layout.uxsdk_view_group_battery, (ViewGroup)this);
        this.container = (ViewGroup)this.findViewById(R.id.setting_menu_battery_info_view_layout);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getBatteryOverview().subscribe(this::updateBatteryWidget));
        this.addReaction(this.widgetModel.getConnection().subscribe(connection -> {
            if (Boolean.compare(this.isConnected, connection) == 0) {
                return;
            }
            this.isConnected = connection;
            if (!this.isConnected) {
                this.widgetModel.reset();
            }
        }));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private void updateBatteryWidget(List<BatteryOverviewValue> batteryOverviewList) {
        BatteryInfoWidget view;
        int i;
        int newCount;
        ArrayList<BatteryOverviewValue> availableList = new ArrayList<BatteryOverviewValue>();
        for (BatteryOverviewValue value : batteryOverviewList) {
            if (!value.getIsConnected().equals(true)) continue;
            availableList.add(value);
        }
        int childCount = this.container.getChildCount();
        if (childCount < (newCount = availableList.size())) {
            for (i = childCount; i < newCount; ++i) {
                view = new BatteryInfoWidget(this.getContext());
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                params.topMargin = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_15_dp);
                this.container.addView((View)view, (ViewGroup.LayoutParams)params);
                view.setEnableSerialNumber(this.isEnableSerialNumber);
                view.setEnableBatteryCells(this.isEnableBatteryCells);
            }
        } else if (childCount > newCount) {
            for (i = childCount - 1; i >= newCount; --i) {
                this.container.removeViewAt(i);
            }
        }
        for (i = 0; i < this.container.getChildCount(); ++i) {
            view = (BatteryInfoWidget)this.container.getChildAt(i);
            view.setBatteryIndex(((BatteryOverviewValue)availableList.get(i)).getIndex());
        }
    }

    public void setEnableBatteryCells(boolean isEnable) {
        this.isEnableBatteryCells = isEnable;
        this.updateBatteryInfoWidget();
    }

    public void setEnableSerialNumber(boolean isEnable) {
        this.isEnableSerialNumber = isEnable;
        this.updateBatteryInfoWidget();
    }

    private void updateBatteryInfoWidget() {
        for (int i = 0; i < this.container.getChildCount(); ++i) {
            View childView = this.container.getChildAt(i);
            if (!(childView instanceof BatteryInfoWidget)) continue;
            BatteryInfoWidget widget = (BatteryInfoWidget)childView;
            widget.setEnableBatteryCells(this.isEnableBatteryCells);
            widget.setEnableSerialNumber(this.isEnableSerialNumber);
        }
    }
}

