/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import androidx.annotation.DrawableRes;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TabGroupWidget
extends RadioGroup
implements RadioGroup.OnCheckedChangeListener {
    private int mPadding;
    private int mTextSize;
    private int mTextColor;
    private CoverStyle mCoverStyle;
    private int mCheckedIndex;
    private boolean mFixedSize;
    private boolean mTextBold;
    private List<String> mTabs;
    private OnTabChangeListener mOnTabChangeListener;

    public TabGroupWidget(Context context) {
        this(context, null);
    }

    public TabGroupWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        CharSequence[] entries;
        this.setOrientation(0);
        super.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TabGroupWidget, 0, 0);
        this.mFixedSize = ta.getBoolean(R.styleable.TabGroupWidget_uxsdk_fixedSize, true);
        this.mTextSize = ta.getDimensionPixelSize(R.styleable.TabGroupWidget_uxsdk_textSize, AndUtil.dip2px((Context)this.getContext(), (float)9.0f));
        this.mTextColor = ta.getColor(R.styleable.TabGroupWidget_uxsdk_textColor, AndUtil.getResColor((int)R.color.uxsdk_dic_color_c9_blue));
        this.mTextBold = ta.getBoolean(R.styleable.TabGroupWidget_uxsdk_textBold, false);
        this.mCoverStyle = CoverStyle.index(ta.getInt(R.styleable.TabGroupWidget_uxsdk_coverStyle, CoverStyle.BLUE.ordinal()));
        this.mPadding = ta.getDimensionPixelSize(R.styleable.TabGroupWidget_uxsdk_tabsPadding, (int)context.getResources().getDimension(R.dimen.uxsdk_3_dp));
        this.mTabs = new ArrayList<String>();
        if (ta.hasValue(R.styleable.TabGroupWidget_uxsdk_tabs) && (entries = ta.getTextArray(R.styleable.TabGroupWidget_uxsdk_tabs)) != null && entries.length > 0) {
            for (CharSequence s : entries) {
                this.mTabs.add(s.toString());
            }
            this.setTabs();
        }
        ta.recycle();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && this.mFixedSize && this.mTabs.size() > 0) {
            int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int eachWidth = width / this.mTabs.size();
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)child.getLayoutParams();
                layoutParams.width = eachWidth;
                child.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.setEnabled(enabled);
        }
    }

    public void setOnCheckedChangeListener(RadioGroup.OnCheckedChangeListener listener2) {
        LogUtils.e((String)"TabGroupWidget", (Object[])new Object[]{"Please use setOnTabChangeListener instead."});
    }

    private void setTabs() {
        this.removeAllViews();
        int size = this.mTabs.size();
        for (int i = 0; i < size; ++i) {
            RadioButton tab = new RadioButton(this.getContext());
            tab.setId(i);
            tab.setButtonDrawable(null);
            tab.setGravity(17);
            tab.setText((CharSequence)this.mTabs.get(i));
            tab.setTextSize(0, (float)this.mTextSize);
            tab.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
            tab.setSingleLine(true);
            tab.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            if (this.mTextBold) {
                tab.setTypeface(Typeface.DEFAULT, 1);
            }
            this.initTabBackground(tab, i, size);
            if (i == this.mCheckedIndex) {
                tab.setChecked(true);
            }
            this.setTextColorByType(tab, i == this.mCheckedIndex);
            this.addView((View)tab);
        }
    }

    private void initTabBackground(RadioButton tab, int i, int size) {
        if (i == 0) {
            tab.setBackgroundResource(this.mCoverStyle.mResStart);
        } else if (i == size - 1) {
            tab.setBackgroundResource(this.mCoverStyle.mResEnd);
        } else {
            tab.setBackgroundResource(this.mCoverStyle.mResMid);
        }
    }

    private void setTextColorByType(RadioButton tab, boolean checked) {
        if (checked) {
            tab.setTextColor(AndUtil.getResColor((int)this.mCoverStyle.mResTextColorChecked));
        } else {
            tab.setTextColor(this.mTextColor);
        }
    }

    public void setItems(List<String> items) {
        this.mTabs.clear();
        if (items != null && !items.isEmpty()) {
            this.mTabs.addAll(items);
        }
        this.setTabs();
    }

    public void setItems(String[] items) {
        this.mTabs.clear();
        if (items != null && items.length > 0) {
            this.mTabs.addAll(Arrays.asList(items));
        }
        this.setTabs();
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            RadioButton curChild = (RadioButton)this.getChildAt(i);
            if (curChild.getId() != checkedId) continue;
            this.setTextColorByType(curChild, true);
            if (i == this.mCheckedIndex) break;
            RadioButton oldChild = (RadioButton)this.getChildAt(this.mCheckedIndex);
            this.setTextColorByType(oldChild, false);
            if (this.mOnTabChangeListener != null) {
                this.mOnTabChangeListener.onTabChanged(this.mCheckedIndex, i);
            }
            this.mCheckedIndex = i;
            break;
        }
    }

    public void setOnTabChangeListener(OnTabChangeListener onTabChangeListener) {
        this.mOnTabChangeListener = onTabChangeListener;
    }

    public int getCheckedIndex() {
        return this.mCheckedIndex;
    }

    public void setCheckedIndex(int checkedIndex) {
        if (checkedIndex < this.getChildCount()) {
            RadioButton tab = (RadioButton)this.getChildAt(checkedIndex);
            tab.setChecked(true);
        }
    }

    public void updateTabDefaultNames(int size) {
        for (int i = size; i < this.getChildCount(); ++i) {
            RadioButton tab = (RadioButton)this.getChildAt(i);
            tab.setVisibility(8);
        }
    }

    public void updateTabNames(List<String> names) {
        if (names == null) {
            return;
        }
        int index = 0;
        for (String name : names) {
            if (index < this.getChildCount()) {
                RadioButton tab = (RadioButton)this.getChildAt(index);
                tab.setText((CharSequence)name);
                tab.setVisibility(0);
            }
            ++index;
        }
        for (int i = index; i < this.getChildCount(); ++i) {
            RadioButton tab = (RadioButton)this.getChildAt(i);
            tab.setVisibility(8);
        }
    }

    public static enum CoverStyle {
        BLUE(R.color.uxsdk_dic_color_c8_white, R.drawable.uxsdk_tab_item_start_blue_style, R.drawable.uxsdk_tab_item_mid_blue_style, R.drawable.uxsdk_tab_item_end_blue_style),
        WHITE(R.color.uxsdk_dic_color_c4_black, R.drawable.uxsdk_tab_item_start_white_style, R.drawable.uxsdk_tab_item_mid_white_style, R.drawable.uxsdk_tab_item_end_white_style),
        WHITE_V2(R.color.uxsdk_black_95_percent, R.drawable.uxsdk_tab_item_start_white_v2_style, R.drawable.uxsdk_tab_item_mid_white_v2_style, R.drawable.uxsdk_tab_item_end_white_v2_style),
        BLACK(R.color.uxsdk_white, R.drawable.uxsdk_tab_item_start_black_style, R.drawable.uxsdk_tab_item_mid_black_style, R.drawable.uxsdk_tab_item_end_black_style);

        private final int mResTextColorChecked;
        private final int mResStart;
        private final int mResMid;
        private final int mResEnd;

        private CoverStyle(@DrawableRes int resTextColorChecked, @DrawableRes int resStart, int resMid, int redEnd) {
            this.mResTextColorChecked = resTextColorChecked;
            this.mResStart = resStart;
            this.mResMid = resMid;
            this.mResEnd = redEnd;
        }

        private static CoverStyle index(int index) {
            CoverStyle[] values = CoverStyle.values();
            if (index < 0 || index >= values.length) {
                return BLUE;
            }
            return values[index];
        }
    }

    public static interface OnTabChangeListener {
        public void onTabChanged(int var1, int var2);
    }
}

