/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

public final class SettingDefinitions {
    private SettingDefinitions() {
    }

    public static enum GimbalIndex {
        UNKONWN(-1),
        PORT(0),
        STARBOARD(1),
        TOP(2);

        private int value;
        private static GimbalIndex[] values;

        private GimbalIndex(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static GimbalIndex[] getValues() {
            if (values == null) {
                values = GimbalIndex.values();
            }
            return values;
        }

        public static GimbalIndex find(int value) {
            for (GimbalIndex index : GimbalIndex.getValues()) {
                if (index.value() != value) continue;
                return index;
            }
            return UNKONWN;
        }
    }

    public static enum MapProvider {
        UNKNOWN(-1),
        GOOGLE(0),
        HERE(1),
        AMAP(2),
        MAPLIBRE(3);

        private int index;
        private static MapProvider[] values;

        private MapProvider(int index) {
            this.index = index;
        }

        public static MapProvider[] getValues() {
            if (values == null) {
                values = MapProvider.values();
            }
            return values;
        }

        @NonNull
        public static MapProvider find(@IntRange(from=-1L, to=3L) int index) {
            for (MapProvider mapProvider : MapProvider.getValues()) {
                if (mapProvider.getIndex() != index) continue;
                return mapProvider;
            }
            return UNKNOWN;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum ControlMode {
        SPOT_METER(0),
        CENTER_METER(1),
        AUTO_FOCUS(2),
        MANUAL_FOCUS(3),
        AUTO_FOCUS_CONTINUE(4);

        private int value;
        private static ControlMode[] values;

        private ControlMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        private boolean _equals(int b) {
            return this.value == b;
        }

        public static ControlMode[] getValues() {
            if (values == null) {
                values = ControlMode.values();
            }
            return values;
        }

        public static ControlMode find(int value) {
            ControlMode result = SPOT_METER;
            for (int i = 0; i < ControlMode.getValues().length; ++i) {
                if (!ControlMode.getValues()[i]._equals(value)) continue;
                result = ControlMode.getValues()[i];
                break;
            }
            return result;
        }
    }
}

