/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.common.EmptyMsg;
import dji.sdk.keyvalue.value.flightcontroller.IMUCalibrationInfo;
import dji.sdk.keyvalue.value.flightcontroller.IMUCalibrationOrientation;
import dji.sdk.keyvalue.value.flightcontroller.IMUCalibrationState;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.IImuResources;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ImuCalView
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = ImuCalView.class.getSimpleName();
    ImageView mCloseImg = null;
    LinearLayout mProcessLy = null;
    ImageView mProcessAirImg = null;
    LinearLayout mProcessPageLy = null;
    TextView mPrepareStartTv = null;
    ProgressBar mProecessPgb = null;
    TextView mProcessTv = null;
    TextView mProcessPageTv = null;
    LinearLayout mStatusLy = null;
    ImageView mStatusImg = null;
    TextView mStatusDescTv = null;
    TextView mStatusOptTv = null;
    TextView mStatusRestartTv = null;
    private final LinearLayout[] mProcessDescLys = new LinearLayout[3];
    private final TextView[] mProcessDescTvs = new TextView[3];
    private int[] mPrepareDesc = IImuResources.RESIDS_PREPARE_DESC;
    private List<Integer> mNeedCalIndex;
    private OnImuCalListener mOnImuCalListener = null;
    private IMUCalibrationInfo mIMUCalibrationHint;
    int[] sideSequence;

    private void initView() {
        this.mCloseImg = (ImageView)this.findViewById(R.id.imu_cal_close_img);
        this.mCloseImg.setOnClickListener((View.OnClickListener)this);
        this.mProcessLy = (LinearLayout)this.findViewById(R.id.imu_cal_process_ly);
        this.mProcessAirImg = (ImageView)this.findViewById(R.id.imu_cal_left_content_img);
        this.mProcessPageLy = (LinearLayout)this.findViewById(R.id.imu_cal_left_botom_ly);
        this.mPrepareStartTv = (TextView)this.findViewById(R.id.imu_cal_start_tv);
        this.mPrepareStartTv.setOnClickListener((View.OnClickListener)this);
        this.mProecessPgb = (ProgressBar)this.findViewById(R.id.imu_cal_pgb);
        this.mProcessTv = (TextView)this.findViewById(R.id.imu_cal_pgb_tv);
        this.mProcessPageTv = (TextView)this.findViewById(R.id.imu_cal_page_tv);
        this.mStatusLy = (LinearLayout)this.findViewById(R.id.imu_cal_status_ly);
        this.mStatusImg = (ImageView)this.findViewById(R.id.imu_cal_status_img);
        this.mStatusDescTv = (TextView)this.findViewById(R.id.imu_cal_status_tv);
        this.mStatusOptTv = (TextView)this.findViewById(R.id.imu_cal_status_opt_tv);
        this.mStatusOptTv.setOnClickListener((View.OnClickListener)this);
        this.mStatusRestartTv = (TextView)this.findViewById(R.id.imu_cal_status_restart_tv);
        this.mStatusRestartTv.setOnClickListener((View.OnClickListener)this);
    }

    public ImuCalView(Context context) {
        this(context, null);
    }

    public ImuCalView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImuCalView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_setting_ui_imu_cal_view, (ViewGroup)this, true);
        this.initView();
    }

    public void setOnImuCalListener(OnImuCalListener listener2) {
        this.mOnImuCalListener = listener2;
    }

    private void initViews() {
        this.mPrepareDesc = IImuResources.RESIDS_PREPARE_DESC_REMOVE_DESC1;
        this.sideSequence = ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct() ? IImuResources.SIDE_SEQUENCE_M2E : IImuResources.SIDE_SEQUENCE;
        int[] descResIds = new int[]{R.id.imu_cal_right_desc_ly1, R.id.imu_cal_right_desc_ly2, R.id.imu_cal_right_desc_ly3};
        for (int i = 0; i < 3; ++i) {
            this.mProcessDescLys[i] = (LinearLayout)this.findViewById(descResIds[i]);
            this.mProcessDescTvs[i] = (TextView)this.mProcessDescLys[i].findViewById(R.id.setting_ui_imucal_desc_tv);
        }
        this.showPrepare();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.setKeepScreenOn(true);
        this.initViews();
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIMUCalibrationInfo), (Object)this, (oldValue, newValue) -> {
            if (newValue != null) {
                this.updateViews((IMUCalibrationInfo)newValue);
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.imu_cal_start_tv) {
            this.startCalibrate();
        } else if (id2 == R.id.imu_cal_status_opt_tv) {
            if (this.mIMUCalibrationHint != null && this.mIMUCalibrationHint.getCalibrationState() == IMUCalibrationState.FAILED) {
                this.startCalibrate();
            } else {
                this.closeSelf(0);
            }
        } else if (id2 == R.id.imu_cal_close_img) {
            this.closeSelf(0);
        } else if (id2 == R.id.imu_cal_status_restart_tv) {
            KeyManager.getInstance().performAction(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyRebootDevice), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<EmptyMsg>(){

                public void onSuccess(EmptyMsg emptyMsg) {
                    LogUtils.d((String)TAG, (Object[])new Object[]{"rebootDevice success"});
                }

                public void onFailure(@NonNull IDJIError error) {
                    LogUtils.d((String)TAG, (Object[])new Object[]{"rebootDevice failed!"});
                }
            });
            this.closeSelf(0);
        }
    }

    private void startCalibrate() {
        this.showProcess();
        KeyManager.getInstance().performAction(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartIMUCalibration), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<EmptyMsg>(){

            public void onSuccess(EmptyMsg emptyMsg) {
                LogUtils.d((String)TAG, (Object[])new Object[]{"startCalibrate success!"});
            }

            public void onFailure(@NonNull IDJIError error) {
                LogUtils.e((String)TAG, (Object[])new Object[]{"startCalibrate failed!"});
            }
        });
    }

    private void updateDesc(int[] descResIds) {
        int i;
        int offset = descResIds.length;
        for (i = 0; i < offset; ++i) {
            if (this.mProcessDescLys[i] != null) {
                this.mProcessDescLys[i].setVisibility(0);
            }
            if (this.mProcessDescTvs[i] == null) continue;
            this.mProcessDescTvs[i].setText(descResIds[i]);
        }
        for (i = offset; i < 3; ++i) {
            if (this.mProcessDescLys[i] == null) continue;
            this.mProcessDescLys[i].setVisibility(8);
        }
    }

    private void updateViews(IMUCalibrationInfo imuCalibrationHint) {
        if (this.mIMUCalibrationHint == null || this.mIMUCalibrationHint.getCalibrationState() != imuCalibrationHint.getCalibrationState()) {
            this.updateStatus(imuCalibrationHint);
        }
        if (imuCalibrationHint.getCalibrationState() == IMUCalibrationState.CALIBRATING) {
            this.updatePageIndex(imuCalibrationHint);
            int totalProgress = imuCalibrationHint.getOrientationsToCalibrate().size() + imuCalibrationHint.getOrientationsCalibrated().size();
            this.updateProgress(100 * imuCalibrationHint.getOrientationsCalibrated().size() / totalProgress);
        } else if (imuCalibrationHint.getCalibrationState() == IMUCalibrationState.FAILED) {
            this.mStatusDescTv.setText((CharSequence)this.getContext().getString(R.string.uxsdk_setting_ui_imu_fail));
        } else if (imuCalibrationHint.getCalibrationState() == IMUCalibrationState.SUCCESSFUL) {
            // empty if block
        }
        this.mIMUCalibrationHint = imuCalibrationHint;
    }

    private void updatePageIndex(IMUCalibrationInfo imuCalibrationHint) {
        int total;
        if (this.mNeedCalIndex == null) {
            this.mNeedCalIndex = new ArrayList<Integer>();
            for (int i = 0; i < imuCalibrationHint.getOrientationsToCalibrate().size(); ++i) {
                this.mNeedCalIndex.add(((IMUCalibrationOrientation)imuCalibrationHint.getOrientationsToCalibrate().get(i)).value());
            }
        }
        if ((total = this.mNeedCalIndex.size()) == 0) {
            return;
        }
        int childCount = this.mProcessPageLy.getChildCount();
        if (childCount != total) {
            if (childCount > total) {
                while (childCount-- > total) {
                    this.mProcessPageLy.removeViewAt(childCount);
                }
            } else {
                int radius = AndUtil.dip2px((Context)this.getContext(), (float)9.0f);
                int margin = AndUtil.dip2px((Context)this.getContext(), (float)5.0f);
                while (childCount++ < total) {
                    LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(radius, radius);
                    param.setMargins(margin, margin, margin, margin);
                    View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uxsdk_setting_circle_view, null);
                    this.mProcessPageLy.addView(v, (ViewGroup.LayoutParams)param);
                }
            }
        }
        this.updatePageIndexEx(total, imuCalibrationHint);
    }

    private void updatePageIndexEx(int total, IMUCalibrationInfo imuCalibrationHint) {
        int[] mCalibrationOrder = new int[]{0, 1, 2, 3, 4, 5};
        int current = -1;
        for (int i = 0; i < total; ++i) {
            View v = this.mProcessPageLy.getChildAt(i);
            int index = this.getSDKIndex(mCalibrationOrder[i]);
            boolean calibrated = false;
            for (IMUCalibrationOrientation orientation : imuCalibrationHint.getOrientationsCalibrated()) {
                if (orientation.value() != index) continue;
                v.setHovered(false);
                v.setSelected(true);
                calibrated = true;
                break;
            }
            if (calibrated) continue;
            if (current == -1) {
                current = mCalibrationOrder[i];
                this.mProcessPageTv.setText((CharSequence)String.format(Locale.US, "%d/%d", i + 1, total));
                v.setHovered(true);
            } else {
                v.setHovered(false);
            }
            v.setSelected(false);
        }
        this.updateCurrentSide(this.getSDKIndex(current));
    }

    private int getSDKIndex(int current) {
        if (current >= 0 && current < this.sideSequence.length) {
            return this.sideSequence[current];
        }
        return 4;
    }

    private void updateCurrentSide(int currentSide) {
        int resId = this.getAircraft(currentSide);
        if (0 != resId) {
            this.mProcessAirImg.setImageResource(resId);
        }
    }

    private void updateProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        } else if (progress > 100) {
            progress = 100;
        }
        this.mProecessPgb.setProgress(progress);
    }

    private void updateStatus(IMUCalibrationInfo imuCalibrationHint) {
        if (IMUCalibrationState.NONE == imuCalibrationHint.getCalibrationState()) {
            this.showPrepare();
        } else if (IMUCalibrationState.CALIBRATING == imuCalibrationHint.getCalibrationState()) {
            this.showProcess();
        } else if (IMUCalibrationState.SUCCESSFUL == imuCalibrationHint.getCalibrationState()) {
            this.showSuccess();
        } else if (IMUCalibrationState.FAILED == imuCalibrationHint.getCalibrationState()) {
            this.showFail();
        }
    }

    private void showPrepare() {
        this.mCloseImg.setVisibility(0);
        this.mPrepareStartTv.setVisibility(0);
        this.mProcessLy.setVisibility(0);
        this.mProcessPageLy.setVisibility(4);
        this.mProcessAirImg.setImageResource(this.getReadyResId());
        this.updateDesc(this.mPrepareDesc);
        this.mProecessPgb.setVisibility(8);
        this.mProcessTv.setVisibility(8);
        this.mProcessPageTv.setVisibility(4);
        this.mStatusLy.setVisibility(8);
    }

    private void showProcess() {
        this.mCloseImg.setVisibility(8);
        this.mPrepareStartTv.setVisibility(8);
        this.mProcessLy.setVisibility(0);
        this.mProcessPageLy.setVisibility(0);
        this.mProcessAirImg.setImageResource(this.getAircraft(IMUCalibrationOrientation.BOTTOM_DOWN.value()));
        this.updateDesc(IImuResources.RESIDS_PROCESS_DESC);
        this.mProecessPgb.setVisibility(0);
        this.mProecessPgb.setProgress(0);
        this.mProcessTv.setVisibility(0);
        this.mProcessPageTv.setVisibility(0);
        this.mStatusLy.setVisibility(8);
    }

    private void showSuccess() {
        this.mCloseImg.setVisibility(0);
        this.mProcessLy.setVisibility(8);
        this.mStatusLy.setVisibility(0);
        this.mStatusDescTv.setText(R.string.uxsdk_setting_ui_imu_success);
        this.mStatusImg.setBackgroundResource(R.drawable.uxsdk_setting_ui_success);
        this.mStatusOptTv.setText(R.string.uxsdk_setting_ui_imu_back);
        this.mStatusRestartTv.setVisibility(0);
    }

    private void showFail() {
        this.mCloseImg.setVisibility(0);
        this.mProcessLy.setVisibility(8);
        this.mStatusLy.setVisibility(0);
        this.mStatusDescTv.setText(R.string.uxsdk_setting_ui_imu_fail);
        this.mStatusImg.setBackgroundResource(R.drawable.uxsdk_setting_ui_fail);
        this.mStatusOptTv.setText(R.string.uxsdk_setting_ui_imu_retry);
        this.mStatusRestartTv.setVisibility(8);
    }

    private int getReadyResId() {
        if (ProductUtil.isM30Product()) {
            return R.drawable.uxsdk_setting_ui_imu_ready_m320;
        }
        if (ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct()) {
            return R.drawable.uxsdk_img_device_home_m3e;
        }
        return R.drawable.uxsdk_setting_ui_imu_ready_m300;
    }

    private int getAircraft(int index) {
        int[] resIds = ProductUtil.isM30Product() ? IImuResources.RESIDS_AIRCRAFT_M320 : (ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct() ? IImuResources.RESIDS_AIRCRAFT_M3E : IImuResources.RESIDS_AIRCRAFT_M300);
        if (0 <= index && index < resIds.length) {
            return resIds[index];
        }
        return 0;
    }

    private void closeSelf(int arg) {
        if (null != this.mOnImuCalListener) {
            this.mOnImuCalListener.onClose(arg);
        }
    }

    public static interface OnImuCalListener {
        public void onClose(int var1);
    }
}

