/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.zoom;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ViewWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.visualcamera.zoom.FocalZoomWidgetViewModel;
import java.math.BigDecimal;

public class FocalZoomWidgetView
extends ViewWidget
implements ICameraIndex {
    private static final int FOCAL_CHECK_MESSAGE_TYPE = 0;
    private static final int FOCAL_CHANGE_TIMEOUT = 1000;
    private static final int FOCAL_TOUCH_TIMEOUT = 7000;
    private static final int FOCAL_CLICK_INTERVAL = 200;
    private static final int MIN_VELOCITY = 100;
    private static final float THRESHOLD = 1.0E-6f;
    private int[] mFocalLengthGears = new int[]{2, 5, 10, 20, 40, 80, 160, 200};
    private final int[] mStepGears = new int[]{10, 16, 25, 250};
    private final float[] mStepValues = new float[]{0.1f, 0.2f, 0.3f, 0.5f};
    private int mCurrentLevel = -1;
    private Handler myHandler;
    private float mCurrentScreenFocalMultiTimes = this.mFocalLengthGears[2];
    private float mCurrentDroneFocalMultiTimes;
    private float mHighLevelValue;
    private float mLowLevelValue;
    private float mMiddleLevelValue;
    private int mViewWidth;
    private int mViewHeight;
    private Paint mBackgroundPaint;
    private Paint mMarkTextPaint;
    private Paint mDotPaint;
    private Paint mSliderPaint;
    private Paint mSliderTextPaint;
    private Paint mSliderMarkTextPaint;
    private Paint mDividerPaint;
    private Paint mSymbolBitmapPaint;
    private int mBackgroudColor;
    private int mBackgroudShadowColor;
    private int mBackgroudShadowSizeDP = 2;
    private int mBackgroudRadiusDP = 2;
    private int mBackgroundPaddingDP = 2;
    private int mMarkTextColor;
    private int mMarkTextFontSizeDP = 12;
    private int mDotColor;
    private int mDotRadiusDP = 2;
    private int mDotGap_dp = 4;
    private int mSliderColor;
    private int mSliderRadiusDP = 2;
    private int mSliderShadowSizeDP = 2;
    private int mSliderTextColor;
    private int mSliderNumTextFontSizDP = 12;
    private int mSliderMarkTextFontSizDP = 6;
    private int mSliderHeightDP = this.mSliderNumTextFontSizDP + this.mSliderMarkTextFontSizDP + 12;
    private int mDividerColor;
    private int mDividerPaddingDP = 2 + this.mBackgroundPaddingDP;
    private int mDividerHeightDP = 1;
    private Bitmap mPlusBitmap;
    private Bitmap mMinusBitmap;
    private Bitmap mPlusBitmapUnclick;
    private Bitmap mMinusBitmapUnclick;
    private int mSymbolImageSize;
    private float mUpMartTextY;
    private float mDownMarkTextY;
    private float mUpDividerY;
    private float mDownDividerY;
    private float mDensity;
    private float mSliderTopY;
    private float mSliderBottomY;
    private float mMoveStartY;
    private float step = 0.1f;
    private boolean mIsStartSlowMove = false;
    private boolean mIsStartQuickMove = false;
    private VelocityTracker mVelocityTracker;
    private float mTouchDownY = 0.0f;
    private float mTouchDownTime = 0.0f;
    private long mFinalTouchTime;
    private boolean mIsInited = false;
    private FocalZoomWidgetViewModel widgetModel;

    public FocalZoomWidgetView(Context context) {
        this(context, null, 0);
    }

    public FocalZoomWidgetView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FocalZoomWidgetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
        this.initHandler();
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        if (!this.isInEditMode()) {
            this.widgetModel = new FocalZoomWidgetViewModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
    }

    @Override
    protected void reactToModelChanges() {
        this.addDisposable(this.widgetModel.focalZoomRatios.toFlowable().observeOn(SchedulerProvider.ui()).subscribe(ratios -> this.pushFocalLength(ratios.floatValue())));
        this.addDisposable(this.widgetModel.focalZoomRatiosRange.toFlowable().observeOn(SchedulerProvider.ui()).subscribe(range -> this.pushFocalLengthRange(range.getGears())));
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    private void initPaint() {
        this.mBackgroudColor = this.getContext().getResources().getColor(R.color.uxsdk_black_60_percent);
        this.mBackgroudShadowColor = this.getContext().getResources().getColor(R.color.uxsdk_zoom_slider_background_shadow);
        this.mMarkTextColor = this.getContext().getResources().getColor(R.color.uxsdk_zoom_slider_color);
        this.mDotColor = this.getContext().getResources().getColor(R.color.uxsdk_zoom_slider_dot_color);
        this.mSliderColor = this.getContext().getResources().getColor(R.color.uxsdk_zoom_slider_color);
        this.mSliderTextColor = this.getContext().getResources().getColor(R.color.uxsdk_white);
        this.mDividerColor = this.getContext().getResources().getColor(R.color.uxsdk_zoom_slider_dot_color);
        this.mPlusBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.uxsdk_focal_zoom_slider_plus);
        this.mMinusBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.uxsdk_focal_zoom_slider_minus);
        this.mPlusBitmapUnclick = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.uxsdk_focal_zoom_slider_plus_unclick);
        this.mMinusBitmapUnclick = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.uxsdk_focal_zoom_slider_minus_unclick);
        this.mDensity = this.getContext().getResources().getDisplayMetrics().density;
        this.resetDimen();
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setColor(this.mBackgroudColor);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setShadowLayer((float)this.mBackgroudShadowSizeDP * this.mDensity, 0.0f, 0.0f, this.mBackgroudShadowColor);
        this.mMarkTextPaint = new Paint();
        this.mMarkTextPaint.setColor(this.mMarkTextColor);
        this.mMarkTextPaint.setStrokeWidth(3.0f);
        this.mMarkTextPaint.setStyle(Paint.Style.FILL);
        this.mMarkTextPaint.setTextSize((float)this.mMarkTextFontSizeDP * this.mDensity);
        this.mMarkTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mMarkTextPaint.setAntiAlias(true);
        this.mDotPaint = new Paint();
        this.mDotPaint.setColor(this.mDotColor);
        this.mDotPaint.setStyle(Paint.Style.FILL);
        this.mDotPaint.setAntiAlias(true);
        this.mSliderPaint = new Paint();
        this.mSliderPaint.setColor(this.mSliderColor);
        this.mSliderPaint.setStyle(Paint.Style.FILL);
        this.mSliderPaint.setAntiAlias(true);
        this.mSliderPaint.setShadowLayer((float)this.mSliderShadowSizeDP * this.mDensity, 0.0f, 0.0f, this.mBackgroudShadowColor);
        this.mSliderTextPaint = new Paint();
        this.mSliderTextPaint.setColor(this.mSliderTextColor);
        this.mSliderTextPaint.setAntiAlias(true);
        this.mSliderTextPaint.setStrokeWidth(3.0f);
        this.mSliderTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mSliderTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSliderTextPaint.setTextSize((float)this.mSliderNumTextFontSizDP * this.mDensity);
        this.mSliderMarkTextPaint = new Paint();
        this.mSliderMarkTextPaint.setColor(this.mSliderTextColor);
        this.mSliderMarkTextPaint.setAntiAlias(true);
        this.mSliderMarkTextPaint.setStrokeWidth(1.0f);
        this.mSliderMarkTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mSliderMarkTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSliderMarkTextPaint.setTextSize((float)this.mSliderMarkTextFontSizDP * this.mDensity);
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setColor(this.mDividerColor);
        this.mDividerPaint.setStyle(Paint.Style.FILL);
        this.mDividerPaint.setAntiAlias(true);
        this.mSymbolBitmapPaint = new Paint();
        this.mSymbolBitmapPaint.setFilterBitmap(true);
        this.mSymbolBitmapPaint.setDither(true);
        this.mSymbolBitmapPaint.setAntiAlias(true);
        this.setBackgroundResource(17170445);
    }

    private void resetDimen() {
        float pixel_benchmark = this.getContext().getResources().getDimension(R.dimen.uxsdk_pixel_benchmark) / this.mDensity;
        this.mBackgroudShadowSizeDP = (int)((float)this.mBackgroudShadowSizeDP * pixel_benchmark);
        this.mBackgroudRadiusDP = (int)((float)this.mBackgroudRadiusDP * pixel_benchmark);
        this.mBackgroundPaddingDP = (int)((float)this.mBackgroundPaddingDP * pixel_benchmark);
        this.mMarkTextFontSizeDP = (int)((float)this.mMarkTextFontSizeDP * pixel_benchmark);
        this.mDotRadiusDP = (int)((float)this.mDotRadiusDP * pixel_benchmark);
        this.mDotGap_dp = (int)((float)this.mDotGap_dp * pixel_benchmark);
        this.mSliderRadiusDP = (int)((float)this.mSliderRadiusDP * pixel_benchmark);
        this.mSliderShadowSizeDP = (int)((float)this.mSliderShadowSizeDP * pixel_benchmark);
        this.mSliderNumTextFontSizDP = (int)((float)this.mSliderNumTextFontSizDP * pixel_benchmark);
        this.mSliderMarkTextFontSizDP = (int)((float)this.mSliderMarkTextFontSizDP * pixel_benchmark);
        this.mSliderHeightDP = (int)((float)this.mSliderHeightDP * pixel_benchmark);
        this.mDividerPaddingDP = (int)((float)this.mDividerPaddingDP * pixel_benchmark);
        this.mDividerHeightDP = (int)((float)this.mDividerHeightDP * pixel_benchmark);
    }

    private void initHandler() {
        this.myHandler = new Handler(msg -> {
            if (msg.what == 0) {
                this.checkValue();
            }
            return false;
        });
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initSize();
    }

    private void initSize() {
        this.mViewHeight = this.getHeight();
        this.mViewWidth = this.getWidth();
        this.mSymbolImageSize = (int)(((float)this.mViewWidth - (float)this.mBackgroundPaddingDP * this.mDensity * 2.0f) / 3.0f);
        this.mUpMartTextY = (float)this.mViewWidth + (float)this.mMarkTextFontSizeDP * this.mDensity + (float)this.mMarkTextFontSizeDP * this.mDensity / 2.0f + (float)this.mBackgroundPaddingDP * this.mDensity;
        this.mDownMarkTextY = (float)(this.mViewHeight - this.mViewWidth) - (float)this.mMarkTextFontSizeDP * this.mDensity - (float)this.mMarkTextFontSizeDP * this.mDensity / 2.0f - (float)this.mBackgroundPaddingDP * this.mDensity;
        this.mUpDividerY = this.mViewWidth;
        this.mDownDividerY = (float)this.mViewHeight - (float)this.mViewWidth;
        this.mSliderTopY = this.mUpMartTextY - (float)this.mMarkTextFontSizeDP * this.mDensity - (float)this.mDividerHeightDP * this.mDensity;
        this.mSliderBottomY = this.mDownMarkTextY - (float)this.mSliderHeightDP * this.mDensity / 2.0f - (float)this.mDividerHeightDP * this.mDensity;
        LogUtils.i((String)this.getLogTag(), (Object[])new Object[]{"mViewHeight", this.mViewHeight, "mViewWidth", this.mViewWidth, "mSymbolImageSize", this.mSymbolImageSize, "mUpMartTextY", Float.valueOf(this.mUpMartTextY), "mDownMarkTextY", Float.valueOf(this.mDownMarkTextY), "mUpDividerY", Float.valueOf(this.mUpDividerY), "mDownDividerY", Float.valueOf(this.mDownDividerY), "mSliderTopY", Float.valueOf(this.mSliderTopY), "mSliderBottomY", Float.valueOf(this.mSliderBottomY)});
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas);
        this.drawMarkText(canvas);
        this.drawDot(canvas);
        this.drawSlider(canvas);
        this.drawSymbol(canvas);
    }

    private void drawBackground(Canvas canvas) {
        RectF rectF = new RectF((float)this.mBackgroundPaddingDP * this.mDensity, (float)this.mBackgroundPaddingDP * this.mDensity, (float)this.mViewWidth - (float)this.mBackgroundPaddingDP * this.mDensity, (float)this.mViewHeight - (float)this.mBackgroundPaddingDP * this.mDensity);
        canvas.drawRoundRect(rectF, (float)this.mBackgroudRadiusDP * this.mDensity, (float)this.mBackgroudRadiusDP * this.mDensity, this.mBackgroundPaint);
    }

    private void drawMarkText(Canvas canvas) {
        float x = (float)this.mViewWidth / 2.0f;
        RectF upDividerRectF = new RectF((float)this.mDividerPaddingDP * this.mDensity, this.mUpDividerY, (float)this.mViewWidth - (float)this.mDividerPaddingDP * this.mDensity, this.mUpDividerY + (float)this.mDividerHeightDP * this.mDensity);
        canvas.drawRect(upDividerRectF, this.mDividerPaint);
        RectF bottomDividerRectF = new RectF((float)this.mDividerPaddingDP * this.mDensity, this.mDownDividerY, (float)this.mViewWidth - (float)this.mDividerPaddingDP * this.mDensity, this.mDownDividerY - (float)this.mDividerHeightDP * this.mDensity);
        canvas.drawRect(bottomDividerRectF, this.mDividerPaint);
        Paint.FontMetrics fontMetrics = this.mMarkTextPaint.getFontMetrics();
        canvas.drawText((int)this.mHighLevelValue + "X", x, this.mUpMartTextY - fontMetrics.bottom, this.mMarkTextPaint);
        canvas.drawText((int)this.mLowLevelValue + "X", x, this.mDownMarkTextY - fontMetrics.top, this.mMarkTextPaint);
    }

    private void drawDot(Canvas canvas) {
        int startLineWidth = this.mViewWidth / 3;
        int endLineWidth = this.mViewWidth / 12;
        int gap = (int)((float)(this.mDotRadiusDP * 2 + this.mDotGap_dp) * this.mDensity);
        if (gap == 0) {
            return;
        }
        int lineCount = (int)((this.mDownMarkTextY - this.mUpMartTextY) / (float)gap);
        if (lineCount == 0) {
            return;
        }
        int minusNumber = (startLineWidth - endLineWidth) / lineCount;
        for (float lineY = this.mUpMartTextY + (float)gap; lineY < this.mDownMarkTextY - (float)gap; lineY += (float)gap) {
            RectF rectF = new RectF((float)(this.mViewWidth - startLineWidth) / 2.0f, lineY, (float)(this.mViewWidth + startLineWidth) / 2.0f, lineY + (float)this.mDotRadiusDP * this.mDensity);
            canvas.drawRect(rectF, this.mDotPaint);
            startLineWidth -= minusNumber;
        }
    }

    private void drawSlider(Canvas canvas) {
        if (this.mCurrentLevel == -1) {
            return;
        }
        float sliderY = this.getCurrentSliderY();
        RectF rectF = new RectF(0.0f, sliderY, (float)this.mViewWidth, sliderY + (float)this.mSliderHeightDP * this.mDensity);
        canvas.drawRoundRect(rectF, (float)this.mSliderRadiusDP * this.mDensity, (float)this.mSliderRadiusDP * this.mDensity, this.mSliderPaint);
        Paint.FontMetrics fontMetrics = this.mSliderTextPaint.getFontMetrics();
        float distance = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        float baseline = rectF.top + (float)(this.mSliderMarkTextFontSizDP + 8) / 2.0f * this.mDensity + distance;
        canvas.drawText("ZOOM", rectF.centerX(), baseline, this.mSliderMarkTextPaint);
        this.mSliderTextPaint.setTextSize((float)this.mSliderNumTextFontSizDP * this.mDensity);
        fontMetrics = this.mSliderTextPaint.getFontMetrics();
        distance = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        baseline = rectF.top + (float)(this.mSliderMarkTextFontSizDP + 4) * this.mDensity + (float)(this.mSliderNumTextFontSizDP + 8) * this.mDensity / 2.0f + distance;
        canvas.drawText(this.mCurrentScreenFocalMultiTimes + "X", rectF.centerX(), baseline, this.mSliderTextPaint);
    }

    private void drawSymbol(Canvas canvas) {
        Rect plusDestRect = new Rect(0, 0, this.mViewWidth, this.mViewWidth);
        if (this.mCurrentScreenFocalMultiTimes == (float)this.mFocalLengthGears[this.mFocalLengthGears.length - 1]) {
            canvas.drawBitmap(this.mPlusBitmapUnclick, null, plusDestRect, this.mSymbolBitmapPaint);
        } else {
            canvas.drawBitmap(this.mPlusBitmap, null, plusDestRect, this.mSymbolBitmapPaint);
        }
        int destMinusY = this.mViewHeight - this.mViewWidth;
        Rect minusDestRect = new Rect(0, destMinusY, this.mViewWidth, destMinusY + this.mViewWidth);
        if (this.mCurrentScreenFocalMultiTimes == (float)this.mFocalLengthGears[0]) {
            canvas.drawBitmap(this.mMinusBitmapUnclick, null, minusDestRect, this.mSymbolBitmapPaint);
        } else {
            canvas.drawBitmap(this.mMinusBitmap, null, minusDestRect, this.mSymbolBitmapPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        this.mFinalTouchTime = SystemClock.uptimeMillis();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.onTouchEventDown(event);
                break;
            }
            case 1: {
                this.onTouchEventUp(event);
                break;
            }
            case 2: {
                this.onTouchEventMove(event);
                break;
            }
        }
        return true;
    }

    private void onTouchEventDown(MotionEvent event) {
        this.mTouchDownY = event.getY();
        this.mMoveStartY = event.getY();
        this.mTouchDownTime = SystemClock.uptimeMillis();
    }

    private void onTouchEventUp(MotionEvent event) {
        this.mIsStartSlowMove = false;
        this.mIsStartQuickMove = false;
        if ((float)SystemClock.uptimeMillis() - this.mTouchDownTime < 200.0f) {
            if (event.getY() < this.mUpDividerY) {
                this.upLevel();
            } else if (event.getY() > this.mDownDividerY) {
                this.downLevel();
            } else {
                this.setCurrentValueByClick(event.getY());
            }
        }
    }

    private void onTouchEventMove(MotionEvent event) {
        float nowY = event.getRawY();
        if (this.mTouchDownY > this.mUpDividerY && this.mTouchDownY < this.mDownDividerY) {
            this.mVelocityTracker.computeCurrentVelocity(1000);
            float velocity = this.mVelocityTracker.getYVelocity();
            float stepDistance = (this.mSliderBottomY - this.mSliderTopY) / ((this.mHighLevelValue - this.mLowLevelValue) / this.step);
            if (velocity != 0.0f) {
                if (Math.abs(velocity) <= 100.0f) {
                    if (!this.mIsStartSlowMove) {
                        this.mIsStartQuickMove = false;
                        this.mIsStartSlowMove = true;
                    } else if (velocity > 0.0f) {
                        for (int i = 0; i < this.mStepGears.length; ++i) {
                            if (this.mCurrentScreenFocalMultiTimes != (float)this.mStepGears[i]) continue;
                            this.step = this.mStepValues[i];
                            break;
                        }
                        if (Math.abs(nowY - this.mMoveStartY) > 10.0f) {
                            float value = this.mCurrentScreenFocalMultiTimes - this.step;
                            this.mMoveStartY = nowY;
                            this.reviseValueAndShow(value);
                        }
                    } else {
                        for (int i = 0; i < this.mStepGears.length; ++i) {
                            if (this.mCurrentScreenFocalMultiTimes != (float)this.mStepGears[i]) continue;
                            int index = Math.min(i + 1, this.mStepValues.length - 1);
                            this.step = this.mStepValues[index];
                            break;
                        }
                        if (Math.abs(nowY - this.mMoveStartY) > 10.0f) {
                            float value = this.mCurrentScreenFocalMultiTimes + this.step;
                            this.mMoveStartY = nowY;
                            this.reviseValueAndShow(value);
                        }
                    }
                } else if (!this.mIsStartQuickMove) {
                    this.mIsStartSlowMove = false;
                    this.mIsStartQuickMove = true;
                } else if (Math.abs(nowY - this.mMoveStartY) > stepDistance) {
                    this.setCurrentValueByMove(nowY - this.mMoveStartY);
                    this.mMoveStartY = nowY;
                }
            }
        }
        this.invalidate();
    }

    private void setCurrentValue(float curValue) {
        if (this.mFocalLengthGears.length < 1) {
            return;
        }
        curValue = curValue < (float)this.mFocalLengthGears[0] ? (float)this.mFocalLengthGears[0] : curValue;
        curValue = curValue > (float)this.mFocalLengthGears[this.mFocalLengthGears.length - 1] ? (float)this.mFocalLengthGears[this.mFocalLengthGears.length - 1] : curValue;
        this.reviseValueAndShow(curValue);
    }

    private void upLevel() {
        int level = 1;
        if (this.mCurrentScreenFocalMultiTimes == this.mHighLevelValue) {
            ++level;
        }
        this.setLevel(this.mCurrentLevel + level, 0.0f);
    }

    private void downLevel() {
        int level = 1;
        if (this.mCurrentScreenFocalMultiTimes == this.mLowLevelValue) {
            ++level;
        }
        this.setLevel(this.mCurrentLevel - level, 0.0f);
    }

    private void setLevel(int level, float defaultValue) {
        float value;
        int newLevel;
        if (level < 0) {
            newLevel = 0;
        } else {
            while (level > this.mFocalLengthGears.length - 1) {
                --level;
            }
            newLevel = level;
        }
        this.mCurrentLevel = newLevel;
        if (this.mCurrentLevel == 0) {
            this.mLowLevelValue = this.mFocalLengthGears[this.mCurrentLevel];
            this.mMiddleLevelValue = -1.0f;
            this.mHighLevelValue = this.mFocalLengthGears[this.mCurrentLevel + 1];
            value = defaultValue == 0.0f ? this.mLowLevelValue : defaultValue;
        } else if (this.mCurrentLevel == this.mFocalLengthGears.length - 1) {
            this.mLowLevelValue = this.mFocalLengthGears[this.mCurrentLevel - 1];
            this.mMiddleLevelValue = -1.0f;
            this.mHighLevelValue = this.mFocalLengthGears[this.mCurrentLevel];
            value = defaultValue == 0.0f ? this.mHighLevelValue : defaultValue;
            value = Math.min(value, this.mHighLevelValue);
        } else {
            this.mLowLevelValue = this.mFocalLengthGears[this.mCurrentLevel - 1];
            this.mMiddleLevelValue = this.mFocalLengthGears[this.mCurrentLevel];
            this.mHighLevelValue = this.mFocalLengthGears[this.mCurrentLevel + 1];
            value = defaultValue == 0.0f ? this.mMiddleLevelValue : defaultValue;
        }
        this.sendFocusCmd(value);
        this.invalidate();
    }

    private float getCurrentSliderY() {
        float middle = (this.mSliderBottomY - this.mSliderTopY) / 2.0f;
        float y = this.mMiddleLevelValue == -1.0f ? this.mSliderBottomY - (this.mSliderBottomY - this.mSliderTopY) * ((this.mCurrentScreenFocalMultiTimes - this.mLowLevelValue) / (this.mHighLevelValue - this.mLowLevelValue)) : (this.mCurrentScreenFocalMultiTimes == this.mMiddleLevelValue ? this.mSliderTopY + middle : (this.mCurrentScreenFocalMultiTimes < this.mMiddleLevelValue ? this.mSliderTopY + middle + middle * ((this.mMiddleLevelValue - this.mCurrentScreenFocalMultiTimes) / (this.mMiddleLevelValue - this.mLowLevelValue)) : this.mSliderTopY + middle - middle * ((this.mCurrentScreenFocalMultiTimes - this.mMiddleLevelValue) / (this.mHighLevelValue - this.mMiddleLevelValue))));
        return y;
    }

    private void setCurrentValueByClick(float pointY) {
        pointY -= (float)this.mSliderHeightDP * this.mDensity / 2.0f;
        float middle = (this.mSliderBottomY - this.mSliderTopY) / 2.0f;
        float value = 0.0f;
        if (this.mMiddleLevelValue == -1.0f) {
            if (pointY <= this.mUpMartTextY) {
                value = this.mHighLevelValue;
            } else if (pointY >= this.mDownMarkTextY) {
                value = this.mLowLevelValue;
            } else {
                float scale = (pointY - this.mSliderTopY) / (this.mSliderBottomY - this.mSliderTopY);
                value = this.mHighLevelValue - scale * (this.mHighLevelValue - this.mLowLevelValue);
            }
        } else {
            float height;
            value = pointY <= this.mUpMartTextY ? this.mHighLevelValue : (pointY >= this.mDownMarkTextY ? this.mLowLevelValue : ((height = pointY - this.mSliderTopY) <= middle ? this.mHighLevelValue - height / middle * (this.mHighLevelValue - this.mMiddleLevelValue) : this.mMiddleLevelValue - (height - middle) / middle * (this.mMiddleLevelValue - this.mLowLevelValue)));
        }
        this.reviseValueAndShow(value);
    }

    private void setCurrentValueByMove(float offsetY) {
        if (Math.abs(offsetY) > 100.0f) {
            return;
        }
        float middle = (this.mSliderBottomY - this.mSliderTopY) / 2.0f;
        float value = 0.0f;
        value = this.mMiddleLevelValue == -1.0f ? (offsetY < 0.0f ? (value += Math.abs(offsetY) / (this.mSliderBottomY - this.mSliderTopY) * (this.mHighLevelValue - this.mLowLevelValue)) : (value -= Math.abs(offsetY) / (this.mSliderBottomY - this.mSliderTopY) * (this.mHighLevelValue - this.mLowLevelValue))) : (this.mCurrentScreenFocalMultiTimes > this.mMiddleLevelValue ? (offsetY < 0.0f ? (value += Math.abs(offsetY) / middle * (this.mHighLevelValue - this.mMiddleLevelValue)) : (value -= Math.abs(offsetY) / middle * (this.mHighLevelValue - this.mMiddleLevelValue))) : (offsetY < 0.0f ? (value += Math.abs(offsetY) / middle * (this.mMiddleLevelValue - this.mLowLevelValue)) : (value -= Math.abs(offsetY) / middle * (this.mMiddleLevelValue - this.mLowLevelValue))));
        float moveValue = value + this.mCurrentScreenFocalMultiTimes;
        moveValue = Math.min(moveValue, (float)this.mFocalLengthGears[this.mFocalLengthGears.length - 1]);
        moveValue = Math.max(moveValue, (float)this.mFocalLengthGears[0]);
        this.reviseValueAndShow(moveValue);
    }

    private void reviseValueAndShow(float value) {
        this.calculateStep(value);
        value = this.calculateValue(value);
        this.calculateLevel(value);
        if (value > this.mHighLevelValue) {
            value = this.mHighLevelValue;
        } else if (value < this.mLowLevelValue) {
            value = this.mLowLevelValue;
        }
        this.sendFocusCmd(value);
        this.invalidate();
    }

    private void calculateLevel(float value) {
        if (value >= this.mHighLevelValue || value <= this.mLowLevelValue) {
            int nowLevel = 0;
            for (int i = this.mFocalLengthGears.length - 1; i > 0; --i) {
                if (!(value > (float)this.mFocalLengthGears[i])) continue;
                nowLevel = i;
                break;
            }
            if (this.mCurrentLevel == -1 || this.mCurrentLevel != nowLevel) {
                this.mCurrentLevel = nowLevel;
                if (this.mCurrentLevel == 0) {
                    this.mLowLevelValue = this.mFocalLengthGears[this.mCurrentLevel];
                    this.mMiddleLevelValue = -1.0f;
                    this.mHighLevelValue = this.mFocalLengthGears[this.mCurrentLevel + 1];
                } else if (this.mCurrentLevel == this.mFocalLengthGears.length - 1) {
                    this.mLowLevelValue = this.mFocalLengthGears[this.mCurrentLevel - 1];
                    this.mMiddleLevelValue = -1.0f;
                    this.mHighLevelValue = this.mFocalLengthGears[this.mCurrentLevel];
                } else {
                    this.mLowLevelValue = this.mFocalLengthGears[this.mCurrentLevel - 1];
                    this.mMiddleLevelValue = this.mFocalLengthGears[this.mCurrentLevel];
                    this.mHighLevelValue = this.mFocalLengthGears[this.mCurrentLevel + 1];
                }
            }
        }
    }

    private float calculateValue(float value) {
        for (int i = 0; i < this.mFocalLengthGears.length - 1; ++i) {
            if (!((float)((int)Math.abs((float)(this.mFocalLengthGears[i] * 10) - value * 10.0f)) < this.step * 10.0f)) continue;
            value = this.mFocalLengthGears[i];
        }
        int surplus = (int)((value = new BigDecimal(Float.toString(value)).setScale(1, 4).floatValue()) * 10.0f) % (int)(this.step * 10.0f);
        if (surplus != 0) {
            value = (float)surplus < this.step * 5.0f ? (value -= (float)surplus / 10.0f) : (value += (this.step * 10.0f - (float)surplus) / 10.0f);
        }
        value = new BigDecimal(Float.toString(value)).setScale(1, 4).floatValue();
        for (int i = 0; i < this.mFocalLengthGears.length - 1; ++i) {
            if (!((float)((int)Math.abs((float)(this.mFocalLengthGears[i] * 10) - value * 10.0f)) < this.step * 10.0f)) continue;
            value = this.mFocalLengthGears[i];
        }
        return value;
    }

    private void calculateStep(float value) {
        for (int i = 0; i < this.mStepGears.length; ++i) {
            if (!(value < (float)this.mStepGears[i])) continue;
            this.step = this.mStepValues[i];
            break;
        }
    }

    private void sendFocusCmd(float curValue) {
        if (this.mCurrentScreenFocalMultiTimes != curValue || !this.mIsInited) {
            this.mIsInited = true;
            this.mCurrentScreenFocalMultiTimes = curValue;
        }
        if (SystemClock.uptimeMillis() - this.mFinalTouchTime < 7000L) {
            this.widgetModel.setFocusDistance(curValue);
            if (this.myHandler != null) {
                this.myHandler.removeMessages(0);
            }
        }
    }

    private void checkValue() {
        if (Math.abs(this.mCurrentDroneFocalMultiTimes - this.mCurrentScreenFocalMultiTimes) > 1.0E-6f) {
            this.setCurrentValue(this.mCurrentDroneFocalMultiTimes);
        }
    }

    public void pushFocalLength(float droneFocalMultiTimes) {
        this.mCurrentDroneFocalMultiTimes = droneFocalMultiTimes;
        if (SystemClock.uptimeMillis() - this.mFinalTouchTime < 7000L) {
            if (this.myHandler != null) {
                this.myHandler.removeMessages(0);
                this.myHandler.sendEmptyMessageDelayed(0, 1000L);
            }
        } else if (Math.abs(this.mCurrentDroneFocalMultiTimes - this.mCurrentScreenFocalMultiTimes) > 1.0E-6f) {
            this.post(() -> this.setCurrentValue(this.mCurrentDroneFocalMultiTimes));
        }
    }

    public void pushFocalLengthRange(int[] gears) {
        this.mFocalLengthGears = gears;
        if (this.myHandler != null) {
            this.myHandler.removeMessages(0);
            this.myHandler.sendEmptyMessageDelayed(0, 1000L);
        }
    }

    public void enterInternalSpotChecking() {
        this.setEnabled(false);
        this.setAlpha(0.5f);
    }

    public void exitInternalSpotChecking() {
        this.setEnabled(true);
        this.setAlpha(1.0f);
    }

    public void dispose() {
        if (this.myHandler != null) {
            this.myHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }
}

