/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.ev;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraExposureCompensation;
import dji.sdk.keyvalue.value.camera.ExposureSensitivityMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.visualcamera.ev.CameraConfigEVWidgetModel;

public class CameraConfigEVWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private CameraConfigEVWidgetModel widgetModel;
    private TextView evTitleTextView;
    private TextView evValueTextView;

    public CameraConfigEVWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigEVWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigEVWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigEVWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_base_camera_info, (ViewGroup)this);
        this.evTitleTextView = (TextView)this.findViewById(R.id.textview_title);
        this.evValueTextView = (TextView)this.findViewById(R.id.textview_value);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigEVWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.evTitleTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_ev_title));
        }
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getExposureCompensation().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
        this.addReaction(this.widgetModel.getExposureSensitivityMode().observeOn(SchedulerProvider.ui()).subscribe(this::updateVisibility));
    }

    private void updateUI(@NonNull CameraExposureCompensation exposureCompensation) {
        this.evValueTextView.setText((CharSequence)CameraUtil.exposureValueDisplayName(exposureCompensation));
    }

    private void updateVisibility(@NonNull ExposureSensitivityMode exposureSensitivityMode) {
        if (exposureSensitivityMode == ExposureSensitivityMode.EI) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_base_camera_info_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setEVTitleTextAppearance(@StyleRes int textAppearance) {
        this.evTitleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getEVTitleTextColors() {
        return this.evTitleTextView.getTextColors();
    }

    @ColorInt
    public int getEVTitleTextColor() {
        return this.evTitleTextView.getCurrentTextColor();
    }

    public void setEVTitleTextColor(@NonNull ColorStateList colorStateList) {
        this.evTitleTextView.setTextColor(colorStateList);
    }

    public void setEVTitleTextColor(@ColorInt int color2) {
        this.evTitleTextView.setTextColor(color2);
    }

    @Dimension
    public float getEVTitleTextSize() {
        return this.evTitleTextView.getTextSize();
    }

    public void setEVTitleTextSize(@Dimension float textSize) {
        this.evTitleTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getEVTitleTextBackground() {
        return this.evTitleTextView.getBackground();
    }

    public void setEVTitleTextBackground(@DrawableRes int resourceId) {
        this.evTitleTextView.setBackgroundResource(resourceId);
    }

    public void setEVTitleTextBackground(@Nullable Drawable drawable2) {
        this.evTitleTextView.setBackground(drawable2);
    }

    public void setEVValueTextAppearance(@StyleRes int textAppearance) {
        this.evValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getEVValueTextColors() {
        return this.evValueTextView.getTextColors();
    }

    @ColorInt
    public int getEVValueTextColor() {
        return this.evValueTextView.getCurrentTextColor();
    }

    public void setEVValueTextColor(@NonNull ColorStateList colorStateList) {
        this.evValueTextView.setTextColor(colorStateList);
    }

    public void setEVValueTextColor(@ColorInt int color2) {
        this.evValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getEVValueTextSize() {
        return this.evValueTextView.getTextSize();
    }

    public void setEVValueTextSize(@Dimension float textSize) {
        this.evValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getEVValueTextBackground() {
        return this.evValueTextView.getBackground();
    }

    public void setEVValueTextBackground(@DrawableRes int resourceId) {
        this.evValueTextView.setBackgroundResource(resourceId);
    }

    public void setEVValueTextBackground(@Nullable Drawable drawable2) {
        this.evValueTextView.setBackground(drawable2);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable evValueTextBackgroundDrawable;
        int evValueTextColor;
        float evValueTextSize;
        int evValueTextAppearanceId;
        Drawable evTitleTextBackgroundDrawable;
        int evTitleTextColor;
        float evTitleTextSize;
        int evTitleTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigEVWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigEVWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.CameraConfigEVWidget_uxsdk_lensType, 0)));
        }
        if ((evTitleTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigEVWidget_uxsdk_evTitleTextAppearance, -1)) != -1) {
            this.setEVTitleTextAppearance(evTitleTextAppearanceId);
        }
        if ((evTitleTextSize = typedArray.getDimension(R.styleable.CameraConfigEVWidget_uxsdk_evTitleTextSize, -1.0f)) != -1.0f) {
            this.setEVTitleTextSize(DisplayUtil.pxToSp((Context)context, (float)evTitleTextSize));
        }
        if ((evTitleTextColor = typedArray.getColor(R.styleable.CameraConfigEVWidget_uxsdk_evTitleTextColor, 0)) != 0) {
            this.setEVTitleTextColor(evTitleTextColor);
        }
        if ((evTitleTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigEVWidget_uxsdk_evTitleBackgroundDrawable)) != null) {
            this.setEVTitleTextBackground(evTitleTextBackgroundDrawable);
        }
        if ((evValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigEVWidget_uxsdk_evValueTextAppearance, -1)) != -1) {
            this.setEVValueTextAppearance(evValueTextAppearanceId);
        }
        if ((evValueTextSize = typedArray.getDimension(R.styleable.CameraConfigEVWidget_uxsdk_evValueTextSize, -1.0f)) != -1.0f) {
            this.setEVValueTextSize(DisplayUtil.pxToSp((Context)context, (float)evValueTextSize));
        }
        if ((evValueTextColor = typedArray.getColor(R.styleable.CameraConfigEVWidget_uxsdk_evValueTextColor, 0)) != 0) {
            this.setEVValueTextColor(evValueTextColor);
        }
        if ((evValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigEVWidget_uxsdk_evValueBackgroundDrawable)) != null) {
            this.setEVValueTextBackground(evValueTextBackgroundDrawable);
        }
        typedArray.recycle();
    }
}

