/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.sample.showcase.widgetlist;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.fpvinteraction.FPVInteractionWidget;
import dji.v5.ux.sample.showcase.widgetlist.WidgetViewHolder;

public class WidgetView
extends ConstraintLayout {
    protected LinearLayout containerView;
    protected TextView aspectRatioTextView;
    protected TextView currentSizeTextView;
    private WidgetViewHolder<?> widgetViewHolder;
    private ScaleGestureDetector scaleGestureDetector;
    private int originalHeight;
    private int originalWidth;
    private float scaleFactor = 1.0f;
    private ViewGroup widget;

    public WidgetView(Context context) {
        super(context);
    }

    public WidgetView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WidgetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ViewGroup init(WidgetViewHolder<?> widgetViewHolder) {
        this.widgetViewHolder = widgetViewHolder;
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        WidgetView.inflate((Context)this.getContext(), (int)R.layout.uxsdk_view_widget, (ViewGroup)this);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.containerView = (LinearLayout)this.findViewById(R.id.widget_container);
        this.aspectRatioTextView = (TextView)this.findViewById(R.id.textview_aspect_ratio);
        this.currentSizeTextView = (TextView)this.findViewById(R.id.textview_current_size);
        this.findViewById(R.id.widget_container).setOnTouchListener((v, event) -> {
            this.scaleGestureDetector.onTouchEvent(event);
            return true;
        });
        this.widget = widgetViewHolder.getWidget(this.getContext());
        if (this.widget != null) {
            this.containerView.addView((View)this.widget);
        }
        this.aspectRatioTextView.setText((CharSequence)widgetViewHolder.getIdealDimensionRatioString());
        return this.widget;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.post(() -> {
            if (this.originalHeight == 0 && this.originalWidth == 0) {
                this.originalHeight = this.widget.getHeight();
                this.originalWidth = this.widget.getWidth();
                this.invalidate();
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.widgetViewHolder == null) {
            return;
        }
        this.currentSizeTextView.setText((CharSequence)this.widgetViewHolder.getWidgetSize());
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            WidgetView.this.scaleFactor *= scaleGestureDetector.getScaleFactor();
            WidgetView.this.scaleFactor = Math.max(0.1f, Math.min(WidgetView.this.scaleFactor, 10.0f));
            if (WidgetView.this.widget != null) {
                ViewGroup.LayoutParams layoutParams = WidgetView.this.widget.getLayoutParams();
                layoutParams.height = WidgetView.this.originalHeight * (int)WidgetView.this.scaleFactor;
                layoutParams.width = WidgetView.this.originalWidth * (int)WidgetView.this.scaleFactor;
                WidgetView.this.widget.setLayoutParams(layoutParams);
                if (WidgetView.this.widget instanceof FPVInteractionWidget) {
                    ((FPVInteractionWidget)WidgetView.this.widget).adjustAspectRatio(layoutParams.width, layoutParams.height);
                }
                WidgetView.this.currentSizeTextView.setText((CharSequence)WidgetView.this.widgetViewHolder.getWidgetSize());
            }
            return true;
        }
    }
}

