/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.amap.annotations;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Polygon;
import dji.v5.ux.mapkit.amap.utils.AMapUtils;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import java.util.ArrayList;
import java.util.List;

public class APolygon
implements DJIPolygon {
    private Polygon mPolygon;

    public APolygon(@NonNull Polygon mPolygon) {
        this.mPolygon = mPolygon;
    }

    @Override
    public void remove() {
        this.mPolygon.remove();
    }

    @Override
    public boolean isVisible() {
        return this.mPolygon.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.mPolygon.setVisible(visible);
    }

    @Override
    public void setPoints(List<DJILatLng> points) {
        ArrayList<LatLng> aPoints = new ArrayList<LatLng>(points.size());
        for (DJILatLng latLng : points) {
            aPoints.add(AMapUtils.fromDJILatLng(latLng));
        }
        this.mPolygon.setPoints(aPoints);
    }

    @Override
    public List<DJILatLng> getPoints() {
        ArrayList<DJILatLng> djiPoints = new ArrayList<DJILatLng>(this.mPolygon.getPoints().size());
        for (LatLng latLng : this.mPolygon.getPoints()) {
            djiPoints.add(AMapUtils.fromLatLng(latLng));
        }
        return djiPoints;
    }

    @Override
    public void setFillColor(@ColorInt int color2) {
        this.mPolygon.setFillColor(color2);
    }

    @Override
    public int getFillColor() {
        return this.mPolygon.getFillColor();
    }

    @Override
    public void setStrokeColor(@ColorInt int color2) {
        this.mPolygon.setStrokeColor(color2);
    }

    @Override
    public int getStrokeColor() {
        return this.mPolygon.getStrokeColor();
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.mPolygon.setStrokeWidth(strokeWidth);
    }

    @Override
    public float getStrokeWidth() {
        return this.mPolygon.getStrokeWidth();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APolygon aPolygon = (APolygon)o;
        return this.mPolygon.equals((Object)aPolygon.mPolygon);
    }

    public int hashCode() {
        return this.mPolygon.hashCode();
    }
}

