/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.Scroller;
import androidx.annotation.ColorInt;
import dji.v5.ux.R;

public class RulerView
extends View {
    protected static final int DEFAULT_INTERVAL = 10;
    protected static final int DEFAULT_NUMBER = 13;
    protected int width = 0;
    protected int height = 0;
    protected Paint drawPaint = null;
    protected Drawable selectDrawable = null;
    protected int scaleColor = 0;
    protected int scalePadding = 0;
    protected float density = 0.0f;
    protected int minVelocity = 0;
    protected int maxVelocity = 0;
    protected Scroller scroller = null;
    protected VelocityTracker velocityTracker = null;
    protected int offsetY = 0;
    protected int lastTouchY = 0;
    protected final RectF tmpRect = new RectF();
    protected int maxSize = 2000;
    protected int curSize = 0;
    protected int interval = 10;
    protected OnRulerScrollListener onScrollListener = null;
    protected OnRulerChangeListener onChangeListener = null;
    protected boolean isRulerEnabled = true;

    public RulerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initDatas(context);
        if (this.isInEditMode()) {
            return;
        }
        this.initDefaultAttrs();
    }

    public void setOnScrollListener(OnRulerScrollListener listener2) {
        this.onScrollListener = listener2;
    }

    public void setOnChangeListener(OnRulerChangeListener listener2) {
        this.onChangeListener = listener2;
    }

    public void setMaxSize(int max) {
        if (max != this.maxSize) {
            this.maxSize = max;
            if (this.curSize > max) {
                int beforeSize = this.curSize;
                this.curSize = max;
                if (null != this.onChangeListener) {
                    this.onChangeListener.onChanged(this, max, beforeSize, false);
                }
                this.offsetY = (int)((float)(max + 1) * this.density);
            }
            this.postInvalidate();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isAtMin() {
        return this.curSize == 0;
    }

    public boolean isAtMax() {
        return this.curSize == this.maxSize;
    }

    public void setCurSizeNow(int size) {
        int beforeSize = this.curSize;
        this.curSize = size;
        if (null != this.onChangeListener) {
            this.onChangeListener.onChanged(this, size, beforeSize, false);
        }
        this.offsetY = (int)((float)size * this.density);
        this.postInvalidate();
    }

    public void setCurSize(int size) {
        if (size != this.curSize) {
            if (size > this.maxSize) {
                size = this.maxSize;
            } else if (size < 0) {
                size = 0;
            }
            int step = (int)((float)Math.abs(this.curSize - size) * 1.0f / 8.0f + 1.0f);
            this.post(new ScrollRunnable(this.curSize, size, step));
        }
    }

    public int getCurSize() {
        return this.curSize;
    }

    public int stepUp(int step) {
        int size = this.curSize;
        if (this.curSize < this.maxSize) {
            size = this.curSize + step;
            if (size > this.maxSize) {
                size = this.maxSize;
            }
            this.post(new ScrollRunnable(this.curSize, size));
        }
        return size;
    }

    public int stepDown(int step) {
        int size = this.curSize;
        if (this.curSize > 0) {
            size = this.curSize - step;
            if (size < 0) {
                size = 0;
            }
            this.post(new ScrollRunnable(this.curSize, size));
        }
        return size;
    }

    public void stepNext() {
        if (this.curSize < this.maxSize) {
            int size = this.curSize + this.interval;
            if (size > this.maxSize) {
                size = this.maxSize;
            }
            this.post(new ScrollRunnable(this.curSize, size));
        }
    }

    public void stepPrev() {
        if (this.curSize > 0) {
            int size = this.curSize - this.interval;
            if (size < 0) {
                size = 0;
            }
            this.post(new ScrollRunnable(this.curSize, size));
        }
    }

    protected void initDefaultAttrs() {
        Resources res = this.getResources();
        this.scaleColor = res.getColor(R.color.uxsdk_white);
        this.scalePadding = res.getDimensionPixelSize(R.dimen.uxsdk_gen_corner_radius);
        this.drawPaint.setColor(this.scaleColor);
    }

    protected void initDatas(Context context) {
        this.scroller = new Scroller(context);
        this.drawPaint = new Paint();
        this.drawPaint.setAntiAlias(true);
        this.drawPaint.setStyle(Paint.Style.FILL);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.minVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maxVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
        float targetDensity = this.getResources().getDisplayMetrics().density * 2.0f;
        if (targetDensity < 4.0f) {
            targetDensity = 4.0f;
        }
        int number = 12;
        float fHeight = (float)heightSize * 1.0f;
        this.density = fHeight / (float)(number * this.interval + 1);
        while (this.density > targetDensity) {
            this.density = fHeight / (float)((number += 2) * this.interval + 1);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.width = w;
        this.height = h;
        if (this.selectDrawable != null) {
            int selectHeight = this.selectDrawable.getIntrinsicHeight();
            int selectWidth = this.selectDrawable.getIntrinsicWidth();
            this.selectDrawable.setBounds((w - selectWidth) / 2, (h - selectHeight) / 2, (w + selectWidth) / 2, (h + selectHeight) / 2);
        }
    }

    private void obtainTracker() {
        if (null == this.velocityTracker) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleTracker() {
        if (null != this.velocityTracker) {
            this.velocityTracker.clear();
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    private void requestInterceptEvent() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private void onOffsetChanged(int offset) {
        int size = (int)((float)offset / this.density);
        if (size != this.curSize) {
            int beforeSize = this.curSize;
            this.curSize = size;
            if (null != this.onChangeListener) {
                this.onChangeListener.onChanged(this, size, beforeSize, true);
            }
        }
    }

    private void scrollOverY(int deltaY) {
        int maxOffset = (int)((float)(this.maxSize + 1) * this.density);
        this.offsetY += deltaY;
        if (this.offsetY < 0) {
            this.offsetY = 0;
        } else if (this.offsetY > maxOffset) {
            this.offsetY = maxOffset;
        }
        this.onOffsetChanged(this.offsetY);
        this.postInvalidate();
    }

    public void computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            this.offsetY = this.scroller.getCurrY();
            this.onOffsetChanged(this.offsetY);
            if (this.scroller.isFinished() && null != this.onScrollListener) {
                this.onScrollListener.onScrollingFinished(this);
            }
            this.postInvalidateOnAnimation();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isRulerEnabled) {
            this.obtainTracker();
            this.velocityTracker.addMovement(event);
            int action = event.getAction();
            switch (action) {
                case 0: {
                    this.requestInterceptEvent();
                    if (!this.scroller.isFinished()) {
                        this.scroller.abortAnimation();
                    }
                    this.lastTouchY = (int)event.getY();
                    if (null == this.onScrollListener) break;
                    this.onScrollListener.onScrollingStarted(this);
                    break;
                }
                case 2: {
                    int y = (int)event.getY();
                    int deltaY = this.lastTouchY - y;
                    this.lastTouchY = y;
                    this.scrollOverY(deltaY);
                    break;
                }
                case 1: 
                case 3: {
                    this.velocityTracker.computeCurrentVelocity(1000, (float)this.maxVelocity);
                    int initialVelocity = (int)this.velocityTracker.getYVelocity();
                    if (Math.abs(initialVelocity) > this.minVelocity) {
                        int maxOffset = (int)((float)(this.maxSize + 1) * this.density);
                        this.scroller.fling(0, this.offsetY, 0, -initialVelocity, 0, 0, 0, maxOffset);
                    } else if (null != this.onScrollListener) {
                        this.onScrollListener.onScrollingFinished(this);
                    }
                    this.recycleTracker();
                    break;
                }
            }
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        if (this.selectDrawable != null) {
            this.selectDrawable.draw(canvas);
        }
        float offset = this.offsetY;
        float maxOffset = (float)(this.maxSize + 1) * this.density;
        float halfH = (float)this.height * 1.0f / 2.0f;
        int offDensity = (int)(offset / this.density % (float)this.interval);
        if (offDensity != 0) {
            offDensity = this.interval - offDensity;
        }
        float left = this.scalePadding;
        float right = (float)this.width - (float)this.scalePadding;
        float radius = this.density / 2.0f;
        float halfDensity = this.density / 2.0f;
        for (float top = (float)offDensity * this.density; top < (float)this.height; top += (float)this.interval * this.density) {
            if (!(halfH <= top + offset + this.density) || !(top + offset + halfDensity <= maxOffset + halfH)) continue;
            this.tmpRect.set(left, top, right, top + this.density);
            this.drawPaint.setAlpha(this.recalAlpha(top, halfH));
            canvas.drawRoundRect(this.tmpRect, radius, radius, this.drawPaint);
        }
    }

    private int recalAlpha(float top, float halfH) {
        float pos = top + this.density * 1.0f / 2.0f;
        float factor = Math.abs(pos - halfH) * 1.0f / halfH;
        return (int)(((1.0f - factor) * (1.0f - factor) * 0.95f + 0.05f) * 255.0f);
    }

    public void setRulerEnabled(boolean isEnabled) {
        this.isRulerEnabled = isEnabled;
    }

    public boolean isRulerEnabled() {
        return this.isRulerEnabled;
    }

    public void setScaleColor(@ColorInt int scaleColor) {
        this.scaleColor = scaleColor;
        this.drawPaint.setColor(scaleColor);
        this.invalidate();
    }

    @ColorInt
    public int getScaleColor() {
        return this.scaleColor;
    }

    public static interface OnRulerScrollListener {
        public void onScrollingStarted(RulerView var1);

        public void onScrollingFinished(RulerView var1);
    }

    public static interface OnRulerChangeListener {
        public void onChanged(RulerView var1, int var2, int var3, boolean var4);
    }

    private final class ScrollRunnable
    implements Runnable {
        private int mStartSize;
        private int mEndSize;
        private int mStep;
        private boolean mbAdd = false;

        private ScrollRunnable(int start, int end) {
            this(start, end, 2);
        }

        private ScrollRunnable(int start, int end, int step) {
            this.mStartSize = start;
            this.mEndSize = end;
            this.mStep = step;
            if (start < end) {
                this.mbAdd = true;
            }
        }

        private void doAdd() {
            if (this.mEndSize <= this.mStartSize + this.mStep + 1) {
                int beforeSize = RulerView.this.curSize;
                RulerView.this.curSize = this.mEndSize;
                if (null != RulerView.this.onChangeListener) {
                    RulerView.this.onChangeListener.onChanged(RulerView.this, this.mEndSize, beforeSize, true);
                }
                RulerView.this.offsetY = (int)((float)this.mEndSize * RulerView.this.density);
                RulerView.this.postInvalidate();
            } else {
                RulerView.this.curSize += this.mStep;
                if (RulerView.this.curSize >= this.mEndSize) {
                    int beforeSize = RulerView.this.curSize;
                    RulerView.this.curSize = this.mEndSize;
                    if (null != RulerView.this.onChangeListener) {
                        RulerView.this.onChangeListener.onChanged(RulerView.this, this.mEndSize, beforeSize, true);
                    }
                    RulerView.this.offsetY = (int)((float)this.mEndSize * RulerView.this.density);
                    RulerView.this.postInvalidate();
                } else {
                    RulerView.this.offsetY = (int)((float)RulerView.this.curSize * RulerView.this.density);
                    RulerView.this.invalidate();
                    RulerView.this.postDelayed(this, 10L);
                }
            }
        }

        @Override
        public void run() {
            if (this.mbAdd) {
                this.doAdd();
            } else if (this.mEndSize + this.mStep + 1 >= this.mStartSize) {
                int beforeSize = RulerView.this.curSize;
                RulerView.this.curSize = this.mEndSize;
                if (null != RulerView.this.onChangeListener) {
                    RulerView.this.onChangeListener.onChanged(RulerView.this, this.mEndSize, beforeSize, true);
                }
                RulerView.this.offsetY = (int)((float)this.mEndSize * RulerView.this.density);
                RulerView.this.postInvalidate();
            } else {
                this.performListenerChange();
            }
        }

        private void performListenerChange() {
            RulerView.this.curSize -= this.mStep;
            if (RulerView.this.curSize <= this.mEndSize) {
                int beforeSize = RulerView.this.curSize;
                RulerView.this.curSize = this.mEndSize;
                if (null != RulerView.this.onChangeListener) {
                    RulerView.this.onChangeListener.onChanged(RulerView.this, this.mEndSize, beforeSize, true);
                }
                RulerView.this.offsetY = (int)((float)this.mEndSize * RulerView.this.density);
                RulerView.this.postInvalidate();
            } else {
                RulerView.this.offsetY = (int)((float)RulerView.this.curSize * RulerView.this.density);
                RulerView.this.invalidate();
                RulerView.this.postDelayed(this, 10L);
            }
        }
    }
}

