/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.flightcontroller.ControlChannelMapping;
import dji.sdk.keyvalue.value.remotecontroller.RemoteControllerType;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.SwitcherCell;
import dji.v5.ux.core.base.TabSelectCell;
import dji.v5.ux.core.util.ViewUtil;
import java.util.Arrays;

public class FpaView
extends LinearLayout
implements SwitcherCell.OnCheckedChangedListener,
TabSelectCell.OnTabChangeListener {
    private static final String TAG = "FpaView";
    private TextView mDescView;
    private SwitcherCell mSwitcherCell;
    private TabSelectCell mFlycModeTabCell;
    private View mDividerTv;
    private int[] modeDrawable = new int[]{R.drawable.uxsdk_setting_ui_flyc_smart_controller_rc_mode_aps, R.drawable.uxsdk_setting_ui_flyc_smart_controller_rc_mode};

    public FpaView(Context context) {
        this(context, null);
    }

    public FpaView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FpaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_setting_menu_flyc_mode, (ViewGroup)this, true);
        this.setOrientation(1);
        this.modeDrawable[0] = FpaView.getRes(R.drawable.uxsdk_setting_ui_flyc_m3e_rc_mode_ans, R.drawable.uxsdk_setting_ui_flyc_c_plus_rc_mode_aps, R.drawable.uxsdk_setting_ui_flyc_smart_controller_rc_mode_aps);
        this.modeDrawable[1] = FpaView.getRes(R.drawable.uxsdk_setting_ui_flyc_m3e_rc_mode_tns, R.drawable.uxsdk_setting_ui_flyc_rc_plus_rc_mode, R.drawable.uxsdk_setting_ui_flyc_smart_controller_rc_mode);
        this.mDescView = (TextView)this.findViewById(R.id.setting_ui_flyc_mode);
        this.mSwitcherCell = (SwitcherCell)this.findViewById(R.id.setting_ui_flyc_mode_switch);
        this.mFlycModeTabCell = (TabSelectCell)this.findViewById(R.id.setting_ui_flyc_mode_tab);
        this.mDividerTv = this.findViewById(R.id.setting_ui_flyc_mode_divider);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mFlycModeTabCell.addTabs(0, Arrays.asList(this.getResources().getStringArray(FpaView.getRes(R.array.uxsdk_flight_mode_rc510, R.array.uxsdk_flight_mode_smart_controller, R.array.uxsdk_flight_mode).intValue())));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyMultipleFlightModeEnabled), (Object)this, (oldValue, open) -> {
            LogUtils.d((String)TAG, (Object[])new Object[]{"MultipleFlightModeEnabled = " + open});
            this.mSwitcherCell.setOnCheckedChangedListener(null);
            this.mSwitcherCell.setChecked(Boolean.TRUE.equals(open));
            this.mSwitcherCell.setOnCheckedChangedListener(this);
            this.updateView(Boolean.TRUE.equals(open));
        });
    }

    protected void onDetachedFromWindow() {
        KeyManager.getInstance().cancelListen((Object)this);
        super.onDetachedFromWindow();
    }

    @Override
    public void onCheckedChanged(SwitcherCell cell, final boolean isChecked) {
        KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyMultipleFlightModeEnabled), (Object)isChecked, new CommonCallbacks.CompletionCallback(){

            public void onSuccess() {
                if (!isChecked && FpaView.this.mFlycModeTabCell.getCurrentTab() == 1) {
                    FpaView.this.setTripodFlycMode();
                }
            }

            public void onFailure(@NonNull IDJIError error) {
                FpaView.this.mSwitcherCell.setOnCheckedChangedListener(null);
                FpaView.this.mSwitcherCell.setChecked(!isChecked);
                FpaView.this.mSwitcherCell.setOnCheckedChangedListener(FpaView.this);
            }
        });
    }

    @Override
    public void onTabChanged(TabSelectCell cell, int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        if (newIndex == 1) {
            this.showAttiFlycModeDialog(oldIndex);
        } else {
            this.setTripodFlycMode();
        }
    }

    private void setTripodFlycMode() {
        KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyCustomFunctionMode), (Object)ControlChannelMapping.TRIPOD, new CommonCallbacks.CompletionCallback(){

            public void onSuccess() {
                FpaView.this.updateFlycModeDescView(0);
            }

            public void onFailure(@NonNull IDJIError error) {
                FpaView.this.setTabCellCurrentTab(1);
                ViewUtil.showToast(FpaView.this.getContext(), AndUtil.getResString((int)R.string.uxsdk_setting_menu_setting_fail));
            }
        });
    }

    private void updateView(boolean open) {
        this.setVisibility(0);
        int visible = open ? 0 : 8;
        this.mSwitcherCell.setBottomDividerEnable(!open);
        this.mDescView.setVisibility(visible);
        this.mDividerTv.setVisibility(visible);
        this.mFlycModeTabCell.setVisibility(8);
        this.updateFlycModeValue();
    }

    private void updateFlycModeValue() {
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyCustomFunctionMode), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<ControlChannelMapping>(){

            public void onSuccess(ControlChannelMapping config) {
                FpaView.this.updateFlycModeView(config);
            }

            public void onFailure(@NonNull IDJIError error) {
            }
        });
    }

    private void updateFlycModeView(ControlChannelMapping channelMapping) {
        int currentTab = channelMapping == ControlChannelMapping.ATTITUDE_NORMAL ? 1 : 0;
        this.setTabCellCurrentTab(currentTab);
        this.mFlycModeTabCell.setVisibility(this.mSwitcherCell.isChecked() ? 0 : 8);
        this.updateFlycModeDescView(currentTab);
    }

    private void showAttiFlycModeDialog(int oldIndex) {
        LogUtils.d((String)TAG, (Object[])new Object[]{"curIndex " + oldIndex});
        KeyManager.getInstance().setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyCustomFunctionMode), (Object)ControlChannelMapping.ATTITUDE_NORMAL, new CommonCallbacks.CompletionCallback(){

            public void onSuccess() {
                ViewUtil.showToast(FpaView.this.getContext(), R.string.uxsdk_setting_menu_desc_omni_perception_downwards, 0);
                FpaView.this.updateFlycModeDescView(1);
            }

            public void onFailure(@NonNull IDJIError error) {
                FpaView.this.setTabCellCurrentTab(0);
                ViewUtil.showToast(FpaView.this.getContext(), AndUtil.getResString((int)R.string.uxsdk_setting_menu_setting_fail));
            }
        });
    }

    private void setTabCellCurrentTab(int index) {
        this.mFlycModeTabCell.setOnTabChangeListener(null);
        this.mFlycModeTabCell.setCurrentTab(index);
        this.mFlycModeTabCell.setOnTabChangeListener(this);
    }

    private void updateFlycModeDescView(int index) {
        if (index == 1) {
            this.mDescView.setCompoundDrawablesWithIntrinsicBounds(this.modeDrawable[0], 0, 0, 0);
            this.mDescView.setText(FpaView.getRes(R.string.uxsdk_setting_menu_flyc_mode_atti_n_mode_rc511, R.string.uxsdk_setting_menu_flyc_mode_atti_n_mode, R.string.uxsdk_setting_menu_flyc_mode_atti).intValue());
        } else {
            this.mDescView.setCompoundDrawablesWithIntrinsicBounds(this.modeDrawable[1], 0, 0, 0);
            this.mDescView.setText(FpaView.getRes(R.string.uxsdk_setting_menu_flyc_mode_n_rc511, R.string.uxsdk_setting_menu_flyc_mode_n, R.string.uxsdk_setting_menu_flyc_mode_m300).intValue());
        }
    }

    public static <T> T getRes(@NonNull T rcPlusRes, @NonNull T smartControllerRes) {
        RemoteControllerType curType = (RemoteControllerType)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRemoteControllerType), (Object)RemoteControllerType.UNKNOWN);
        switch (curType) {
            case DJI_RC_PRO: 
            case DJI_RC_PLUS: {
                return rcPlusRes;
            }
        }
        return smartControllerRes;
    }

    public static <T> T getRes(@NonNull T m3eRes, @NonNull T rcPlusRes, @NonNull T smartControllerRes) {
        RemoteControllerType curType = (RemoteControllerType)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRemoteControllerType), (Object)RemoteControllerType.UNKNOWN);
        switch (curType) {
            case DJI_RC_PRO: {
                return m3eRes;
            }
            case DJI_RC_PLUS: {
                return rcPlusRes;
            }
        }
        return smartControllerRes;
    }
}

