/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.AirLinkKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;

public class FrequencyTabSelectWidgetModel
extends WidgetModel {
    private DataProcessor<FrequencyBand> airlinkFrequencyBandMsgDataProcessor = DataProcessor.create(FrequencyBand.UNKNOWN);
    private DataProcessor<List<FrequencyBand>> airlinkFrequencyBandRangeMsgDataProcessor = DataProcessor.create(new ArrayList());
    private DataProcessor<ChannelSelectionMode> channelSelectionModeDataProcessor = DataProcessor.create(ChannelSelectionMode.UNKNOWN);
    private DataProcessor<Boolean> connectionProcessor = DataProcessor.create(false);

    protected FrequencyTabSelectWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyBand), this.airlinkFrequencyBandMsgDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyBandRange), this.airlinkFrequencyBandRangeMsgDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyChannelSelectionMode), this.channelSelectionModeDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyConnection), this.connectionProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Completable setFrequencyBand(FrequencyBand value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyBand), value);
    }

    public Completable setChannelSelectionMode(ChannelSelectionMode value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyChannelSelectionMode), value);
    }

    public Flowable<FrequencyBand> getFrequencyBand() {
        return this.airlinkFrequencyBandMsgDataProcessor.toFlowableOnUI();
    }

    public Flowable<ChannelSelectionMode> getChannelSelectionMode() {
        return this.channelSelectionModeDataProcessor.toFlowableOnUI();
    }

    public Flowable<List<FrequencyBand>> getFrequencyBandRange() {
        return this.airlinkFrequencyBandRangeMsgDataProcessor.toFlowableOnUI();
    }

    public Flowable<Boolean> getConnection() {
        return this.connectionProcessor.toFlowableOnUI();
    }
}

