/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.warning;

import android.content.Context;
import android.graphics.Outline;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.v5.manager.diagnostic.WarningLevel;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.JsonUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.WidgetSizeDescription;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.popover.Popover;
import dji.v5.ux.core.popover.PopoverHelper;
import dji.v5.ux.databinding.UxsdkFpvTopBarWidgetWarningMessageBinding;
import dji.v5.ux.warning.DeviceHealthAndStatusWidgetModel;
import dji.v5.ux.warning.FpvWarningMessagePopoverView;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 D2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001DB'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u00109\u001a\u00020:2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010;\u001a\u00020:H\u0014J\b\u0010@\u001a\u00020:H\u0002J\b\u0010A\u001a\u00020:H\u0014J\b\u0010B\u001a\u00020:H\u0014J\b\u0010C\u001a\u00020:H\u0002R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u00104\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010+\u001a\u0004\b6\u00107R\u0014\u0010<\u001a\u00020=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006E"}, d2={"Ldji/v5/ux/warning/DeviceHealthAndStatusWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "warningMessageCountWrapper", "Landroid/view/ViewGroup;", "getWarningMessageCountWrapper", "()Landroid/view/ViewGroup;", "setWarningMessageCountWrapper", "(Landroid/view/ViewGroup;)V", "cardViewWarningWrapper", "Landroid/widget/FrameLayout;", "getCardViewWarningWrapper", "()Landroid/widget/FrameLayout;", "setCardViewWarningWrapper", "(Landroid/widget/FrameLayout;)V", "tvWarningMessage", "Landroid/widget/TextView;", "getTvWarningMessage", "()Landroid/widget/TextView;", "setTvWarningMessage", "(Landroid/widget/TextView;)V", "tvLevel3Count", "getTvLevel3Count", "setTvLevel3Count", "tvLevel2Count", "getTvLevel2Count", "setTvLevel2Count", "tvNoMessage", "getTvNoMessage", "setTvNoMessage", "popupView", "Landroid/view/View;", "getPopupView", "()Landroid/view/View;", "popupView$delegate", "Lkotlin/Lazy;", "popover", "Ldji/v5/ux/core/popover/Popover;", "getPopover", "()Ldji/v5/ux/core/popover/Popover;", "setPopover", "(Ldji/v5/ux/core/popover/Popover;)V", "binding", "Ldji/v5/ux/databinding/UxsdkFpvTopBarWidgetWarningMessageBinding;", "widgetModel", "Ldji/v5/ux/warning/DeviceHealthAndStatusWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/warning/DeviceHealthAndStatusWidgetModel;", "widgetModel$delegate", "initView", "", "reactToModelChanges", "widgetSizeDescription", "Ldji/v5/ux/core/base/WidgetSizeDescription;", "getWidgetSizeDescription", "()Ldji/v5/ux/core/base/WidgetSizeDescription;", "updateDisplayMessage", "onAttachedToWindow", "onDetachedFromWindow", "updateLevelCount", "Companion", "android-sdk-v5-uxsdk_release"})
public class DeviceHealthAndStatusWidget
extends ConstraintLayoutWidget<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public ViewGroup warningMessageCountWrapper;
    public FrameLayout cardViewWarningWrapper;
    public TextView tvWarningMessage;
    public TextView tvLevel3Count;
    public TextView tvLevel2Count;
    public TextView tvNoMessage;
    @NotNull
    private final Lazy popupView$delegate;
    @Nullable
    private Popover popover;
    private UxsdkFpvTopBarWidgetWarningMessageBinding binding;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private final WidgetSizeDescription widgetSizeDescription;

    @JvmOverloads
    public DeviceHealthAndStatusWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.popupView$delegate = LazyKt.lazy(() -> DeviceHealthAndStatusWidget.popupView_delegate$lambda$0(context));
        this.widgetModel$delegate = LazyKt.lazy(DeviceHealthAndStatusWidget::widgetModel_delegate$lambda$1);
        this.widgetSizeDescription = new WidgetSizeDescription(WidgetSizeDescription.SizeType.OTHER, WidgetSizeDescription.Dimension.WRAP, WidgetSizeDescription.Dimension.EXPAND);
    }

    public /* synthetic */ DeviceHealthAndStatusWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final ViewGroup getWarningMessageCountWrapper() {
        ViewGroup viewGroup = this.warningMessageCountWrapper;
        if (viewGroup != null) {
            return viewGroup;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"warningMessageCountWrapper");
        return null;
    }

    public final void setWarningMessageCountWrapper(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"<set-?>");
        this.warningMessageCountWrapper = viewGroup;
    }

    @NotNull
    public final FrameLayout getCardViewWarningWrapper() {
        FrameLayout frameLayout = this.cardViewWarningWrapper;
        if (frameLayout != null) {
            return frameLayout;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cardViewWarningWrapper");
        return null;
    }

    public final void setCardViewWarningWrapper(@NotNull FrameLayout frameLayout) {
        Intrinsics.checkNotNullParameter((Object)frameLayout, (String)"<set-?>");
        this.cardViewWarningWrapper = frameLayout;
    }

    @NotNull
    public final TextView getTvWarningMessage() {
        TextView textView = this.tvWarningMessage;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tvWarningMessage");
        return null;
    }

    public final void setTvWarningMessage(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.tvWarningMessage = textView;
    }

    @NotNull
    public final TextView getTvLevel3Count() {
        TextView textView = this.tvLevel3Count;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tvLevel3Count");
        return null;
    }

    public final void setTvLevel3Count(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.tvLevel3Count = textView;
    }

    @NotNull
    public final TextView getTvLevel2Count() {
        TextView textView = this.tvLevel2Count;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tvLevel2Count");
        return null;
    }

    public final void setTvLevel2Count(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.tvLevel2Count = textView;
    }

    @NotNull
    public final TextView getTvNoMessage() {
        TextView textView = this.tvNoMessage;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tvNoMessage");
        return null;
    }

    public final void setTvNoMessage(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.tvNoMessage = textView;
    }

    private final View getPopupView() {
        Lazy lazy = this.popupView$delegate;
        return (View)lazy.getValue();
    }

    @Nullable
    public final Popover getPopover() {
        return this.popover;
    }

    public final void setPopover(@Nullable Popover popover) {
        this.popover = popover;
    }

    private final DeviceHealthAndStatusWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (DeviceHealthAndStatusWidgetModel)lazy.getValue();
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.binding = UxsdkFpvTopBarWidgetWarningMessageBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        this.setWarningMessageCountWrapper((ViewGroup)this.findViewById(R.id.warning_message_count_wrapper));
        this.getWarningMessageCountWrapper().setClipToOutline(true);
        this.getWarningMessageCountWrapper().setOutlineProvider(new ViewOutlineProvider(this){
            final /* synthetic */ DeviceHealthAndStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void getOutline(View view, Outline outline) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                float radius = this.this$0.getResources().getDimension(R.dimen.uxsdk_2_dp);
                outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), radius);
            }
        });
        this.setTvWarningMessage((TextView)this.findViewById(R.id.tv_warning_message));
        this.setTvLevel3Count((TextView)this.findViewById(R.id.tv_level3_count));
        this.setTvLevel2Count((TextView)this.findViewById(R.id.tv_level2_count));
        this.setTvNoMessage((TextView)this.findViewById(R.id.tv_warning_no_message));
        this.setCardViewWarningWrapper((FrameLayout)this.findViewById(R.id.cardview_warning_message));
        this.getCardViewWarningWrapper().setClipToOutline(true);
        this.getCardViewWarningWrapper().setOutlineProvider(new ViewOutlineProvider(this){
            final /* synthetic */ DeviceHealthAndStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void getOutline(View view, Outline outline) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                float radius = this.this$0.getResources().getDimension(R.dimen.uxsdk_2_dp);
                outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), radius);
            }
        });
        this.setOnClickListener(arg_0 -> DeviceHealthAndStatusWidget.initView$lambda$3(this, arg_0));
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getDeviceMessageProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ DeviceHealthAndStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ArrayList<DeviceHealthAndStatusWidgetModel.DeviceMessage> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object[] objectArray = new Object[]{JsonUtil.toJson((List)it)};
                LogUtils.d((String)DeviceHealthAndStatusWidget.access$getLogTag(this.this$0), (Object[])objectArray);
                DeviceHealthAndStatusWidget.access$updateDisplayMessage(this.this$0);
                DeviceHealthAndStatusWidget.access$updateLevelCount(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
    }

    @Override
    @NotNull
    public WidgetSizeDescription getWidgetSizeDescription() {
        return this.widgetSizeDescription;
    }

    private final void updateDisplayMessage() {
        block4: {
            block3: {
                ArrayList<DeviceHealthAndStatusWidgetModel.DeviceMessage> it = this.getWidgetModel().getDeviceMessageProcessor().getValue();
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!(!((Collection)it).isEmpty())) break block3;
                this.getTvWarningMessage().setText((CharSequence)it.get(0).validDescription());
                this.getCardViewWarningWrapper().setBackgroundColor(AndUtil.getResColor((int)Companion.colorResId(it.get(0).getWarningLevel())));
                this.getTvNoMessage().setVisibility(8);
                this.getTvWarningMessage().setVisibility(0);
                Object object = this.popover;
                if (object != null && (object = ((Popover)object).getBuilder()) != null) {
                    ((Popover.Builder)object).setAnchor((View)this);
                }
                Popover popover = this.popover;
                if (popover == null) break block4;
                Popover p = popover;
                boolean bl2 = false;
                p.getBuilder().setAnchor((View)this);
                p.getBuilder().setYOffset((int)AndUtil.getDimension((int)R.dimen.uxsdk_2_dp));
                p.requestLayout();
                break block4;
            }
            this.getCardViewWarningWrapper().setBackgroundColor(AndUtil.getResColor((int)R.color.uxsdk_fpv_popover_content_background_color));
            this.getTvNoMessage().setVisibility(0);
            this.getTvWarningMessage().setVisibility(8);
            if (!this.getWidgetModel().isConnectedProcessor().getValue().booleanValue()) {
                this.getTvNoMessage().setText((CharSequence)"N/A");
            } else {
                this.getTvNoMessage().setText((CharSequence)AndUtil.getResString((int)R.string.uxsdk_fpv_message_box_empty_content_v2));
            }
            Popover popover = this.popover;
            if (popover == null) break block4;
            Popover p = popover;
            boolean bl = false;
            p.getBuilder().setAnchor((View)this.getTvNoMessage());
            p.getBuilder().setYOffset((int)AndUtil.getDimension((int)R.dimen.uxsdk_10_dp));
            p.requestLayout();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    private final void updateLevelCount() {
        block4: {
            int level3Count = this.getWidgetModel().level3Count();
            int level2Count = this.getWidgetModel().level2Count();
            if (level2Count == 0) {
                this.getTvLevel2Count().setVisibility(8);
            } else {
                this.getTvLevel2Count().setVisibility(0);
                this.getTvLevel2Count().setText((CharSequence)String.valueOf(level2Count));
            }
            if (level3Count == 0) {
                this.getTvLevel3Count().setVisibility(8);
            } else {
                this.getTvLevel3Count().setVisibility(0);
                this.getTvLevel3Count().setText((CharSequence)String.valueOf(level3Count));
            }
            this.getWarningMessageCountWrapper().setVisibility(level2Count == 0 && level3Count == 0 ? 4 : 0);
            Popover popover = this.popover;
            if (popover == null) break block4;
            popover.requestLayout();
        }
    }

    @JvmOverloads
    public DeviceHealthAndStatusWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DeviceHealthAndStatusWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final FpvWarningMessagePopoverView popupView_delegate$lambda$0(Context $context) {
        return new FpvWarningMessagePopoverView($context, null, 0, 6, null);
    }

    private static final DeviceHealthAndStatusWidgetModel widgetModel_delegate$lambda$1() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new DeviceHealthAndStatusWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final void initView$lambda$3$lambda$2() {
    }

    private static final void initView$lambda$3(DeviceHealthAndStatusWidget this$0, View it) {
        block5: {
            Popover popover = this$0.popover;
            boolean bl = popover != null ? popover.isShowing() : false;
            if (bl) {
                return;
            }
            if (this$0.popover == null) {
                View view;
                boolean isEmpty = this$0.getWidgetModel().getDeviceMessageProcessor().getValue().isEmpty();
                if (isEmpty) {
                    view = (View)this$0.getTvNoMessage();
                } else {
                    UxsdkFpvTopBarWidgetWarningMessageBinding uxsdkFpvTopBarWidgetWarningMessageBinding = this$0.binding;
                    if (uxsdkFpvTopBarWidgetWarningMessageBinding == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                        uxsdkFpvTopBarWidgetWarningMessageBinding = null;
                    }
                    ConstraintLayout constraintLayout = uxsdkFpvTopBarWidgetWarningMessageBinding.warningMessageRootView;
                    Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"warningMessageRootView");
                    view = (View)constraintLayout;
                }
                this$0.popover = PopoverHelper.INSTANCE.baseBuilder(view).yOffset(isEmpty ? MathKt.roundToInt((float)AndUtil.getDimension((int)R.dimen.uxsdk_10_dp)) : MathKt.roundToInt((float)AndUtil.getDimension((int)R.dimen.uxsdk_2_dp))).customView(this$0.getPopupView()).bottomScreenMargin((int)AndUtil.getDimension((int)R.dimen.uxsdk_96_dp)).leftScreenMargin(MathKt.roundToInt((float)AndUtil.getDimension((int)R.dimen.uxsdk_40_dp))).align(Popover.Align.CENTER).arrowColor(AndUtil.getResColor((int)R.color.uxsdk_fpv_popover_content_background_color)).onDismiss(DeviceHealthAndStatusWidget::initView$lambda$3$lambda$2).build();
            }
            Popover popover2 = this$0.popover;
            if (popover2 == null) break block5;
            popover2.show();
        }
    }

    public static final /* synthetic */ String access$getLogTag(DeviceHealthAndStatusWidget $this) {
        return $this.getLogTag();
    }

    public static final /* synthetic */ void access$updateDisplayMessage(DeviceHealthAndStatusWidget $this) {
        $this.updateDisplayMessage();
    }

    public static final /* synthetic */ void access$updateLevelCount(DeviceHealthAndStatusWidget $this) {
        $this.updateLevelCount();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Ldji/v5/ux/warning/DeviceHealthAndStatusWidget$Companion;", "", "<init>", "()V", "colorResId", "", "warningLevel", "Ldji/v5/manager/diagnostic/WarningLevel;", "popColorResId", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int colorResId(@NotNull WarningLevel warningLevel) {
            Intrinsics.checkNotNullParameter((Object)warningLevel, (String)"warningLevel");
            return switch (WhenMappings.$EnumSwitchMapping$0[warningLevel.ordinal()]) {
                case 1 -> R.color.uxsdk_green_material_400;
                case 2 -> R.color.uxsdk_orange_in_dark;
                case 3 -> R.color.uxsdk_orange_in_dark;
                case 4 -> R.color.uxsdk_red_in_dark;
                case 5 -> R.color.uxsdk_red_in_dark;
                default -> R.color.uxsdk_orange_in_dark;
            };
        }

        public final int popColorResId(@NotNull WarningLevel warningLevel) {
            Intrinsics.checkNotNullParameter((Object)warningLevel, (String)"warningLevel");
            return switch (WhenMappings.$EnumSwitchMapping$0[warningLevel.ordinal()]) {
                case 1 -> R.color.uxsdk_green_material_800_67_percent;
                case 2 -> R.color.uxsdk_orange_in_dark_050;
                case 3 -> R.color.uxsdk_orange_in_dark_050;
                case 4 -> R.color.uxsdk_red_in_dark_050;
                case 5 -> R.color.uxsdk_red_in_dark_050;
                default -> R.color.uxsdk_orange_in_dark;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[WarningLevel.values().length];
                try {
                    nArray[WarningLevel.NORMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WarningLevel.NOTICE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WarningLevel.CAUTION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WarningLevel.WARNING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WarningLevel.SERIOUS_WARNING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

