/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraColor;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.camera.CameraStorageInfo;
import dji.sdk.keyvalue.value.camera.CameraStorageInfos;
import dji.sdk.keyvalue.value.camera.CameraStorageLocation;
import dji.sdk.keyvalue.value.camera.PhotoFileFormat;
import dji.sdk.keyvalue.value.camera.SDCardLoadState;
import dji.sdk.keyvalue.value.camera.VideoFrameRate;
import dji.sdk.keyvalue.value.camera.VideoResolution;
import dji.sdk.keyvalue.value.camera.VideoResolutionFrameRate;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.module.FlatCameraModule;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;

public class CameraConfigStorageWidgetModel
extends WidgetModel
implements ICameraIndex {
    protected static final int INVALID_AVAILABLE_CAPACITY = -1;
    private final DataProcessor<CameraStorageLocation> storageLocationProcessor;
    private final DataProcessor<CameraStorageInfos> storageInfosProcessor;
    private final DataProcessor<VideoResolutionFrameRate> resolutionAndFrameRateProcessor;
    private final DataProcessor<PhotoFileFormat> photoFileFormatProcessor;
    private final DataProcessor<SDCardLoadState> sdCardState;
    private final DataProcessor<SDCardLoadState> innerStorageState;
    private final DataProcessor<Integer> sdAvailableCaptureCount;
    private final DataProcessor<Integer> innerStorageAvailableCaptureCount;
    private final DataProcessor<Integer> sdCardRecordingTime;
    private final DataProcessor<Integer> innerStorageRecordingTime;
    private final DataProcessor<Integer> availableCapacity;
    private final DataProcessor<CameraColor> cameraColorProcessor;
    private final DataProcessor<ImageFormat> imageFormatProcessor;
    private final DataProcessor<CameraStorageState> cameraStorageState;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;
    private final FlatCameraModule flatCameraModule;

    public CameraConfigStorageWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.storageLocationProcessor = DataProcessor.create(CameraStorageLocation.UNKNOWN);
        this.resolutionAndFrameRateProcessor = DataProcessor.create(new VideoResolutionFrameRate());
        this.photoFileFormatProcessor = DataProcessor.create(PhotoFileFormat.UNKNOWN);
        this.sdCardState = DataProcessor.create(SDCardLoadState.UNKNOWN);
        this.innerStorageState = DataProcessor.create(SDCardLoadState.UNKNOWN);
        this.cameraColorProcessor = DataProcessor.create(CameraColor.UNKNOWN);
        this.availableCapacity = DataProcessor.create(-1);
        this.sdAvailableCaptureCount = DataProcessor.create(-1);
        this.innerStorageAvailableCaptureCount = DataProcessor.create(-1);
        this.sdCardRecordingTime = DataProcessor.create(-1);
        this.innerStorageRecordingTime = DataProcessor.create(-1);
        this.imageFormatProcessor = DataProcessor.create(new ImageFormat(CameraMode.UNKNOWN, PhotoFileFormat.UNKNOWN, VideoResolution.UNKNOWN, VideoFrameRate.UNKNOWN));
        CameraStorageState cameraSSDStorageState = new CameraStorageState(CameraMode.UNKNOWN, CameraStorageLocation.UNKNOWN, SDCardLoadState.UNKNOWN, -1, -1L, -1);
        this.storageInfosProcessor = DataProcessor.create(new CameraStorageInfos(CameraStorageLocation.UNKNOWN, new ArrayList()));
        this.cameraStorageState = DataProcessor.create(cameraSSDStorageState);
        this.flatCameraModule = new FlatCameraModule();
        this.addModule(this.flatCameraModule);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<ImageFormat> getImageFormat() {
        return this.imageFormatProcessor.toFlowable();
    }

    public Flowable<CameraStorageState> getCameraStorageState() {
        return this.cameraStorageState.toFlowable();
    }

    public Flowable<CameraColor> getCameraColor() {
        return this.cameraColorProcessor.toFlowable();
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraStorageInfos, (ComponentIndexType)this.cameraIndex), this.storageInfosProcessor, cameraStorageInfos -> {
            CameraStorageInfo sdcardInfo;
            this.storageLocationProcessor.onNext(cameraStorageInfos.getCurrentStorageType());
            CameraStorageInfo internalInfo = cameraStorageInfos.getCameraStorageInfoByLocation(CameraStorageLocation.INTERNAL);
            if (internalInfo != null) {
                this.innerStorageState.onNext(internalInfo.getStorageState());
                this.availableCapacity.onNext(internalInfo.getStorageLeftCapacity());
                this.innerStorageAvailableCaptureCount.onNext(internalInfo.getAvailablePhotoCount());
                this.innerStorageRecordingTime.onNext(internalInfo.getAvailableVideoDuration());
            }
            if ((sdcardInfo = cameraStorageInfos.getCameraStorageInfoByLocation(CameraStorageLocation.SDCARD)) != null) {
                this.sdCardState.onNext(sdcardInfo.getStorageState());
                this.availableCapacity.onNext(sdcardInfo.getStorageLeftCapacity());
                this.sdAvailableCaptureCount.onNext(sdcardInfo.getAvailablePhotoCount());
                this.sdCardRecordingTime.onNext(sdcardInfo.getAvailableVideoDuration());
            }
        });
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyVideoResolutionFrameRate, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.resolutionAndFrameRateProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyPhotoFileFormat, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.photoFileFormatProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraColor, (ComponentIndexType)this.cameraIndex), this.cameraColorProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        this.imageFormatProcessor.onNext(new ImageFormat(this.flatCameraModule.getCameraModeDataProcessor().getValue(), this.photoFileFormatProcessor.getValue(), this.resolutionAndFrameRateProcessor.getValue().getResolution(), this.resolutionAndFrameRateProcessor.getValue().getFrameRate()));
        this.updateCameraStorageState();
    }

    private void updateCameraStorageState() {
        CameraStorageLocation currentStorageLocation = this.storageLocationProcessor.getValue();
        if (CameraStorageLocation.UNKNOWN.equals((Object)currentStorageLocation)) {
            return;
        }
        SDCardLoadState sdCardOperationState = null;
        switch (currentStorageLocation) {
            case SDCARD: {
                if (SDCardLoadState.UNKNOWN.equals((Object)this.sdCardState.getValue())) break;
                sdCardOperationState = this.sdCardState.getValue();
                break;
            }
            case INTERNAL: {
                if (SDCardLoadState.UNKNOWN.equals((Object)this.innerStorageState.getValue())) break;
                sdCardOperationState = this.innerStorageState.getValue();
                break;
            }
        }
        if (sdCardOperationState != null) {
            this.cameraStorageState.onNext(new CameraStorageState(this.flatCameraModule.getCameraModeDataProcessor().getValue(), currentStorageLocation, sdCardOperationState, this.availableCapacity.getValue(), this.getAvailableCaptureCount(currentStorageLocation), this.getAvailableRecordingTime(currentStorageLocation)));
        }
    }

    private long getAvailableCaptureCount(CameraStorageLocation storageLocation) {
        switch (storageLocation) {
            case SDCARD: {
                return this.sdAvailableCaptureCount.getValue().intValue();
            }
            case INTERNAL: {
                return this.innerStorageAvailableCaptureCount.getValue().intValue();
            }
        }
        return -1L;
    }

    private int getAvailableRecordingTime(CameraStorageLocation storageLocation) {
        switch (storageLocation) {
            case SDCARD: {
                return this.sdCardRecordingTime.getValue();
            }
            case INTERNAL: {
                return this.innerStorageRecordingTime.getValue();
            }
        }
        return -1;
    }

    public static class ImageFormat {
        private final CameraMode cameraMode;
        private final PhotoFileFormat photoFileFormat;
        private final VideoResolution resolution;
        private final VideoFrameRate frameRate;

        protected ImageFormat(@Nullable CameraMode cameraMode, @Nullable PhotoFileFormat photoFileFormat, @Nullable VideoResolution resolution, @Nullable VideoFrameRate frameRate) {
            this.cameraMode = cameraMode;
            this.photoFileFormat = photoFileFormat;
            this.resolution = resolution;
            this.frameRate = frameRate;
        }

        @Nullable
        public CameraMode getCameraMode() {
            return this.cameraMode;
        }

        @Nullable
        public PhotoFileFormat getPhotoFileFormat() {
            return this.photoFileFormat;
        }

        @Nullable
        public VideoResolution getResolution() {
            return this.resolution;
        }

        @Nullable
        public VideoFrameRate getFrameRate() {
            return this.frameRate;
        }
    }

    public static class CameraStorageState {
        private final CameraMode cameraMode;
        private final int availableCapacity;
        private final CameraStorageLocation storageLocation;
        private final SDCardLoadState storageOperationState;
        private final long availableCaptureCount;
        private final int availableRecordingTime;

        @VisibleForTesting
        protected CameraStorageState(@NonNull CameraMode cameraMode, @NonNull CameraStorageLocation storageLocation, @NonNull SDCardLoadState storageOperationState, int availableCapacity, long availableCaptureCount, int availableRecordingTime) {
            this.cameraMode = cameraMode;
            this.storageLocation = storageLocation;
            this.storageOperationState = storageOperationState;
            this.availableCapacity = availableCapacity;
            this.availableCaptureCount = availableCaptureCount;
            this.availableRecordingTime = availableRecordingTime;
        }

        @NonNull
        public CameraMode getCameraMode() {
            return this.cameraMode;
        }

        @NonNull
        public CameraStorageLocation getStorageLocation() {
            return this.storageLocation;
        }

        @NonNull
        public SDCardLoadState getStorageOperationState() {
            return this.storageOperationState;
        }

        public int getAvailableCapacity() {
            return this.availableCapacity;
        }

        public int getAvailableRecordingTime() {
            return this.availableRecordingTime;
        }

        public long getAvailableCaptureCount() {
            return this.availableCaptureCount;
        }
    }
}

