/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.training.util;

import android.content.SharedPreferences;
import dji.v5.utils.common.ContextUtil;
import dji.v5.ux.training.simulatorcontrol.preset.SimulatorPresetData;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020\u001fJ\u0006\u0010+\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Ldji/v5/ux/training/util/SimulatorPresetUtils;", "", "<init>", "()V", "SIMULATOR_SHARED_PREFERENCES", "", "SIMULATOR_FREQUENCY", "SIMULATOR_LAT", "SIMULATOR_LNG", "sharedPreferences", "Landroid/content/SharedPreferences;", "presetList", "", "getPresetList", "()Ljava/util/Map;", "value", "currentSimulatorStartLat", "getCurrentSimulatorStartLat", "()Ljava/lang/String;", "setCurrentSimulatorStartLat", "(Ljava/lang/String;)V", "currentSimulatorStartLng", "getCurrentSimulatorStartLng", "setCurrentSimulatorStartLng", "", "currentSimulatorFrequency", "getCurrentSimulatorFrequency", "()I", "setCurrentSimulatorFrequency", "(I)V", "savePreset", "", "key", "lat", "", "lng", "satelliteCount", "frequency", "simulatorPresetData", "Ldji/v5/ux/training/simulatorcontrol/preset/SimulatorPresetData;", "deletePreset", "clearSimulatorFrequency", "clearSimulatorStartLat", "clearSimulatorStartLng", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nSimulatorPresetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimulatorPresetUtils.kt\ndji/v5/ux/training/util/SimulatorPresetUtils\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,145:1\n39#2,12:146\n39#2,12:158\n39#2,12:170\n39#2,12:182\n39#2,12:194\n*S KotlinDebug\n*F\n+ 1 SimulatorPresetUtils.kt\ndji/v5/ux/training/util/SimulatorPresetUtils\n*L\n68#1:146,12\n77#1:158,12\n86#1:170,12\n99#1:182,12\n121#1:194,12\n*E\n"})
public final class SimulatorPresetUtils {
    @NotNull
    public static final SimulatorPresetUtils INSTANCE = new SimulatorPresetUtils();
    @NotNull
    private static final String SIMULATOR_SHARED_PREFERENCES = "simulatorsharedpreferences";
    @NotNull
    private static final String SIMULATOR_FREQUENCY = "simulatorfrequency";
    @NotNull
    private static final String SIMULATOR_LAT = "simulatorLatitude";
    @NotNull
    private static final String SIMULATOR_LNG = "simulatorLongitude";
    @NotNull
    private static final SharedPreferences sharedPreferences;

    private SimulatorPresetUtils() {
    }

    @NotNull
    public final Map<String, ?> getPresetList() {
        Map resultList = sharedPreferences.getAll();
        resultList.remove(SIMULATOR_FREQUENCY);
        resultList.remove(SIMULATOR_LAT);
        resultList.remove(SIMULATOR_LNG);
        Intrinsics.checkNotNull((Object)resultList);
        return resultList;
    }

    @NotNull
    public final String getCurrentSimulatorStartLat() {
        String string2 = sharedPreferences.getString(SIMULATOR_LAT, "");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final void setCurrentSimulatorStartLat(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences $this$edit_u24default$iv = sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_currentSimulatorStartLat__u24lambda_u240 = editor$iv;
        boolean bl = false;
        $this$_set_currentSimulatorStartLat__u24lambda_u240.putString(SIMULATOR_LAT, value);
        editor$iv.apply();
    }

    @NotNull
    public final String getCurrentSimulatorStartLng() {
        String string2 = sharedPreferences.getString(SIMULATOR_LNG, "");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final void setCurrentSimulatorStartLng(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences $this$edit_u24default$iv = sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_currentSimulatorStartLng__u24lambda_u241 = editor$iv;
        boolean bl = false;
        $this$_set_currentSimulatorStartLng__u24lambda_u241.putString(SIMULATOR_LNG, value);
        editor$iv.apply();
    }

    public final int getCurrentSimulatorFrequency() {
        return sharedPreferences.getInt(SIMULATOR_FREQUENCY, -1);
    }

    public final void setCurrentSimulatorFrequency(int value) {
        SharedPreferences $this$edit_u24default$iv = sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_currentSimulatorFrequency__u24lambda_u242 = editor$iv;
        boolean bl = false;
        $this$_set_currentSimulatorFrequency__u24lambda_u242.putInt(SIMULATOR_FREQUENCY, value);
        editor$iv.apply();
    }

    public final void savePreset(@NotNull String key, double lat, double lng, int satelliteCount, int frequency) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$savePreset_u24lambda_u243 = editor$iv;
        boolean bl = false;
        $this$savePreset_u24lambda_u243.putString(key, lat + " " + lng + " " + satelliteCount + " " + frequency);
        editor$iv.apply();
    }

    public final void savePreset(@NotNull String key, @NotNull SimulatorPresetData simulatorPresetData) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)simulatorPresetData, (String)"simulatorPresetData");
        this.savePreset(key, simulatorPresetData.getLatitude(), simulatorPresetData.getLongitude(), simulatorPresetData.getSatelliteCount(), simulatorPresetData.getUpdateFrequency());
    }

    public final void deletePreset(@Nullable String key) {
        SharedPreferences $this$edit_u24default$iv = sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$deletePreset_u24lambda_u244 = editor$iv;
        boolean bl = false;
        $this$deletePreset_u24lambda_u244.remove(key);
        editor$iv.apply();
    }

    public final void clearSimulatorFrequency() {
        this.deletePreset(SIMULATOR_FREQUENCY);
    }

    public final void clearSimulatorStartLat() {
        this.deletePreset(SIMULATOR_LAT);
    }

    public final void clearSimulatorStartLng() {
        this.deletePreset(SIMULATOR_LNG);
    }

    static {
        SharedPreferences sharedPreferences = ContextUtil.getContext().getSharedPreferences(SIMULATOR_SHARED_PREFERENCES, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        SimulatorPresetUtils.sharedPreferences = sharedPreferences;
    }
}

