/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.sample.showcase.defaultlayout;

import android.app.Activity;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.drawerlayout.widget.DrawerLayout;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.manager.datacenter.MediaDataCenter;
import dji.v5.manager.interfaces.ICameraStreamManager;
import dji.v5.network.DJINetworkManager;
import dji.v5.network.IDJINetworkStatusListener;
import dji.v5.utils.common.JsonUtil;
import dji.v5.utils.common.LogPath;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.accessory.RTKStartServiceHelper;
import dji.v5.ux.cameracore.widget.autoexposurelock.AutoExposureLockWidget;
import dji.v5.ux.cameracore.widget.cameracontrols.CameraControlsWidget;
import dji.v5.ux.cameracore.widget.cameracontrols.lenscontrol.LensControlWidget;
import dji.v5.ux.cameracore.widget.focusexposureswitch.FocusExposureSwitchWidget;
import dji.v5.ux.cameracore.widget.focusmode.FocusModeWidget;
import dji.v5.ux.cameracore.widget.fpvinteraction.FPVInteractionWidget;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.communication.BroadcastValues;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.panel.systemstatus.SystemStatusListPanelWidget;
import dji.v5.ux.core.panel.topbar.TopBarPanelWidget;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.core.widget.fpv.FPVWidget;
import dji.v5.ux.core.widget.hsi.HorizontalSituationIndicatorWidget;
import dji.v5.ux.core.widget.hsi.PrimaryFlightDisplayWidget;
import dji.v5.ux.core.widget.setting.SettingWidget;
import dji.v5.ux.core.widget.simulator.SimulatorIndicatorWidget;
import dji.v5.ux.core.widget.systemstatus.SystemStatusWidget;
import dji.v5.ux.gimbal.GimbalFineTuneWidget;
import dji.v5.ux.map.MapWidget;
import dji.v5.ux.mapkit.core.maps.DJIUiSettings;
import dji.v5.ux.training.simulatorcontrol.SimulatorControlWidget;
import dji.v5.ux.visualcamera.CameraNDVIPanelWidget;
import dji.v5.ux.visualcamera.CameraVisiblePanelWidget;
import dji.v5.ux.visualcamera.zoom.FocalZoomWidget;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultLayoutActivity
extends AppCompatActivity {
    private final String TAG = LogUtils.getTag((Object)((Object)this));
    protected FPVWidget primaryFpvWidget;
    protected FPVInteractionWidget fpvInteractionWidget;
    protected FPVWidget secondaryFPVWidget;
    protected SystemStatusListPanelWidget systemStatusListPanelWidget;
    protected SimulatorControlWidget simulatorControlWidget;
    protected LensControlWidget lensControlWidget;
    protected AutoExposureLockWidget autoExposureLockWidget;
    protected FocusModeWidget focusModeWidget;
    protected FocusExposureSwitchWidget focusExposureSwitchWidget;
    protected CameraControlsWidget cameraControlsWidget;
    protected HorizontalSituationIndicatorWidget horizontalSituationIndicatorWidget;
    protected PrimaryFlightDisplayWidget pfvFlightDisplayWidget;
    protected CameraNDVIPanelWidget ndviCameraPanel;
    protected CameraVisiblePanelWidget visualCameraPanel;
    protected FocalZoomWidget focalZoomWidget;
    protected SettingWidget settingWidget;
    protected MapWidget mapWidget;
    protected TopBarPanelWidget topBarPanel;
    protected ConstraintLayout fpvParentView;
    private DrawerLayout mDrawerLayout;
    private TextView gimbalAdjustDone;
    private GimbalFineTuneWidget gimbalFineTuneWidget;
    private ComponentIndexType lastDevicePosition = ComponentIndexType.UNKNOWN;
    private CameraLensType lastLensType = CameraLensType.UNKNOWN;
    private CompositeDisposable compositeDisposable;
    private final DataProcessor<CameraSource> cameraSourceProcessor = DataProcessor.create(new CameraSource(ComponentIndexType.UNKNOWN, CameraLensType.UNKNOWN));
    private final IDJINetworkStatusListener networkStatusListener = isNetworkAvailable -> {
        if (isNetworkAvailable) {
            LogUtils.d((String)this.TAG, (Object[])new Object[]{"isNetworkAvailable=true"});
            RTKStartServiceHelper.INSTANCE.startRtkService(false);
        }
    };
    private final ICameraStreamManager.AvailableCameraUpdatedListener availableCameraUpdatedListener = new ICameraStreamManager.AvailableCameraUpdatedListener(){

        public void onAvailableCameraUpdated(@NonNull List<ComponentIndexType> availableCameraList) {
            DefaultLayoutActivity.this.runOnUiThread(() -> DefaultLayoutActivity.this.updateFPVWidgetSource(availableCameraList));
        }

        public void onCameraStreamEnableUpdate(@NonNull Map<ComponentIndexType, Boolean> cameraStreamEnableMap) {
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.uxsdk_activity_default_layout);
        this.fpvParentView = (ConstraintLayout)this.findViewById(R.id.fpv_holder);
        this.mDrawerLayout = (DrawerLayout)this.findViewById(R.id.root_view);
        this.topBarPanel = (TopBarPanelWidget)this.findViewById(R.id.panel_top_bar);
        this.settingWidget = this.topBarPanel.getSettingWidget();
        this.primaryFpvWidget = (FPVWidget)this.findViewById(R.id.widget_primary_fpv);
        this.fpvInteractionWidget = (FPVInteractionWidget)this.findViewById(R.id.widget_fpv_interaction);
        this.secondaryFPVWidget = (FPVWidget)this.findViewById(R.id.widget_secondary_fpv);
        this.systemStatusListPanelWidget = (SystemStatusListPanelWidget)this.findViewById(R.id.widget_panel_system_status_list);
        this.simulatorControlWidget = (SimulatorControlWidget)this.findViewById(R.id.widget_simulator_control);
        this.lensControlWidget = (LensControlWidget)this.findViewById(R.id.widget_lens_control);
        this.ndviCameraPanel = (CameraNDVIPanelWidget)this.findViewById(R.id.panel_ndvi_camera);
        this.visualCameraPanel = (CameraVisiblePanelWidget)this.findViewById(R.id.panel_visual_camera);
        this.autoExposureLockWidget = (AutoExposureLockWidget)this.findViewById(R.id.widget_auto_exposure_lock);
        this.focusModeWidget = (FocusModeWidget)this.findViewById(R.id.widget_focus_mode);
        this.focusExposureSwitchWidget = (FocusExposureSwitchWidget)this.findViewById(R.id.widget_focus_exposure_switch);
        this.pfvFlightDisplayWidget = (PrimaryFlightDisplayWidget)this.findViewById(R.id.widget_fpv_flight_display_widget);
        this.focalZoomWidget = (FocalZoomWidget)this.findViewById(R.id.widget_focal_zoom);
        this.cameraControlsWidget = (CameraControlsWidget)this.findViewById(R.id.widget_camera_controls);
        this.horizontalSituationIndicatorWidget = (HorizontalSituationIndicatorWidget)this.findViewById(R.id.widget_horizontal_situation_indicator);
        this.gimbalAdjustDone = (TextView)this.findViewById(R.id.fpv_gimbal_ok_btn);
        this.gimbalFineTuneWidget = (GimbalFineTuneWidget)this.findViewById(R.id.setting_menu_gimbal_fine_tune);
        this.mapWidget = (MapWidget)this.findViewById(R.id.widget_map);
        this.initClickListener();
        MediaDataCenter.getInstance().getCameraStreamManager().addAvailableCameraUpdatedListener(this.availableCameraUpdatedListener);
        this.primaryFpvWidget.setOnFPVStreamSourceListener((devicePosition, lensType) -> this.cameraSourceProcessor.onNext(new CameraSource(devicePosition, lensType)));
        this.secondaryFPVWidget.setSurfaceViewZOrderOnTop(true);
        this.secondaryFPVWidget.setSurfaceViewZOrderMediaOverlay(true);
        this.mapWidget.initMapLibreMap(this.getApplicationContext(), map -> {
            DJIUiSettings uiSetting = map.getUiSettings();
            if (uiSetting != null) {
                uiSetting.setZoomControlsEnabled(false);
            }
        });
        this.mapWidget.onCreate(savedInstanceState);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-16777216));
        DJINetworkManager.getInstance().addNetworkStatusListener(this.networkStatusListener);
    }

    private void isGimableAdjustClicked(BroadcastValues broadcastValues) {
        if (this.mDrawerLayout.isDrawerOpen(0x800005)) {
            this.mDrawerLayout.closeDrawers();
        }
        this.horizontalSituationIndicatorWidget.setVisibility(8);
        if (this.gimbalFineTuneWidget != null) {
            this.gimbalFineTuneWidget.setVisibility(0);
        }
    }

    private void initClickListener() {
        SimulatorIndicatorWidget simulatorIndicatorWidget;
        SystemStatusWidget systemStatusWidget;
        this.secondaryFPVWidget.setOnClickListener(v -> this.swapVideoSource());
        if (this.settingWidget != null) {
            this.settingWidget.setOnClickListener(v -> this.toggleRightDrawer());
        }
        if ((systemStatusWidget = this.topBarPanel.getSystemStatusWidget()) != null) {
            systemStatusWidget.setOnClickListener(v -> ViewExtensions.toggleVisibility((View)this.systemStatusListPanelWidget));
        }
        if ((simulatorIndicatorWidget = this.topBarPanel.getSimulatorIndicatorWidget()) != null) {
            simulatorIndicatorWidget.setOnClickListener(v -> ViewExtensions.toggleVisibility((View)this.simulatorControlWidget));
        }
        this.gimbalAdjustDone.setOnClickListener(view -> {
            this.horizontalSituationIndicatorWidget.setVisibility(0);
            if (this.gimbalFineTuneWidget != null) {
                this.gimbalFineTuneWidget.setVisibility(8);
            }
        });
    }

    private void toggleRightDrawer() {
        this.mDrawerLayout.openDrawer(0x800005);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mapWidget.onDestroy();
        MediaDataCenter.getInstance().getCameraStreamManager().removeAvailableCameraUpdatedListener(this.availableCameraUpdatedListener);
        DJINetworkManager.getInstance().removeNetworkStatusListener(this.networkStatusListener);
    }

    protected void onResume() {
        super.onResume();
        this.mapWidget.onResume();
        this.compositeDisposable = new CompositeDisposable();
        this.compositeDisposable.add(this.systemStatusListPanelWidget.closeButtonPressed().observeOn(AndroidSchedulers.mainThread()).subscribe(pressed -> {
            if (pressed.booleanValue()) {
                ViewExtensions.hide((View)this.systemStatusListPanelWidget);
            }
        }));
        this.compositeDisposable.add(this.simulatorControlWidget.getUIStateUpdates().observeOn(AndroidSchedulers.mainThread()).subscribe(simulatorControlWidgetState -> {
            if (simulatorControlWidgetState instanceof SimulatorControlWidget.UIState.VisibilityUpdated && ((SimulatorControlWidget.UIState.VisibilityUpdated)simulatorControlWidgetState).isVisible()) {
                this.hideOtherPanels((View)this.simulatorControlWidget);
            }
        }));
        this.compositeDisposable.add(this.cameraSourceProcessor.toFlowable().observeOn(SchedulerProvider.io()).throttleLast(500L, TimeUnit.MILLISECONDS).subscribeOn(SchedulerProvider.io()).subscribe(result -> this.runOnUiThread(() -> this.onCameraSourceUpdated(result.devicePosition, result.lensType))));
        this.compositeDisposable.add(ObservableInMemoryKeyedStore.getInstance().addObserver(UXKeys.create("gimbalAdujustClicled")).observeOn(SchedulerProvider.ui()).subscribe(this::isGimableAdjustClicked));
        ViewUtil.setKeepScreen((Activity)this, true);
    }

    protected void onPause() {
        if (this.compositeDisposable != null) {
            this.compositeDisposable.dispose();
            this.compositeDisposable = null;
        }
        this.mapWidget.onPause();
        super.onPause();
        ViewUtil.setKeepScreen((Activity)this, false);
    }

    private void hideOtherPanels(@Nullable View widget) {
        View[] panels;
        for (View panel : panels = new View[]{this.simulatorControlWidget}) {
            if (widget == panel) continue;
            panel.setVisibility(8);
        }
    }

    private void updateFPVWidgetSource(List<ComponentIndexType> availableCameraList) {
        LogUtils.i((String)this.TAG, (Object[])new Object[]{JsonUtil.toJson(availableCameraList)});
        if (availableCameraList == null) {
            return;
        }
        ArrayList<ComponentIndexType> cameraList = new ArrayList<ComponentIndexType>(availableCameraList);
        if (cameraList.isEmpty()) {
            this.secondaryFPVWidget.setVisibility(8);
            return;
        }
        if (cameraList.size() == 1) {
            this.primaryFpvWidget.updateVideoSource(availableCameraList.get(0));
            this.secondaryFPVWidget.setVisibility(8);
            return;
        }
        ComponentIndexType primarySource = this.getSuitableSource(cameraList, ComponentIndexType.LEFT_OR_MAIN);
        this.primaryFpvWidget.updateVideoSource(primarySource);
        cameraList.remove(primarySource);
        ComponentIndexType secondarySource = this.getSuitableSource(cameraList, ComponentIndexType.FPV);
        this.secondaryFPVWidget.updateVideoSource(secondarySource);
        this.secondaryFPVWidget.setVisibility(0);
    }

    private ComponentIndexType getSuitableSource(List<ComponentIndexType> cameraList, ComponentIndexType defaultSource) {
        if (cameraList.contains(ComponentIndexType.LEFT_OR_MAIN)) {
            return ComponentIndexType.LEFT_OR_MAIN;
        }
        if (cameraList.contains(ComponentIndexType.RIGHT)) {
            return ComponentIndexType.RIGHT;
        }
        if (cameraList.contains(ComponentIndexType.UP)) {
            return ComponentIndexType.UP;
        }
        if (cameraList.contains(ComponentIndexType.PORT_1)) {
            return ComponentIndexType.PORT_1;
        }
        if (cameraList.contains(ComponentIndexType.PORT_2)) {
            return ComponentIndexType.PORT_2;
        }
        if (cameraList.contains(ComponentIndexType.PORT_3)) {
            return ComponentIndexType.PORT_4;
        }
        if (cameraList.contains(ComponentIndexType.PORT_4)) {
            return ComponentIndexType.PORT_4;
        }
        if (cameraList.contains(ComponentIndexType.VISION_ASSIST)) {
            return ComponentIndexType.VISION_ASSIST;
        }
        return defaultSource;
    }

    private void onCameraSourceUpdated(ComponentIndexType devicePosition, CameraLensType lensType) {
        LogUtils.i((LogPath)LogPath.SAMPLE, (Object[])new Object[]{"onCameraSourceUpdated", devicePosition, lensType});
        if (devicePosition == this.lastDevicePosition && lensType == this.lastLensType) {
            return;
        }
        this.lastDevicePosition = devicePosition;
        this.lastLensType = lensType;
        this.updateViewVisibility(devicePosition, lensType);
        this.updateInteractionEnabled();
        if (this.fpvInteractionWidget.isInteractionEnabled()) {
            this.fpvInteractionWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.lensControlWidget.getVisibility() == 0) {
            this.lensControlWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.ndviCameraPanel.getVisibility() == 0) {
            this.ndviCameraPanel.updateCameraSource(devicePosition, lensType);
        }
        if (this.visualCameraPanel.getVisibility() == 0) {
            this.visualCameraPanel.updateCameraSource(devicePosition, lensType);
        }
        if (this.autoExposureLockWidget.getVisibility() == 0) {
            this.autoExposureLockWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.focusModeWidget.getVisibility() == 0) {
            this.focusModeWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.focusExposureSwitchWidget.getVisibility() == 0) {
            this.focusExposureSwitchWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.cameraControlsWidget.getVisibility() == 0) {
            this.cameraControlsWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.focalZoomWidget.getVisibility() == 0) {
            this.focalZoomWidget.updateCameraSource(devicePosition, lensType);
        }
        if (this.horizontalSituationIndicatorWidget.getVisibility() == 0) {
            this.horizontalSituationIndicatorWidget.updateCameraSource(devicePosition, lensType);
        }
    }

    private void updateViewVisibility(ComponentIndexType devicePosition, CameraLensType lensType) {
        this.pfvFlightDisplayWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 0 : 4);
        this.lensControlWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.ndviCameraPanel.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.visualCameraPanel.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.autoExposureLockWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.focusModeWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.focusExposureSwitchWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.cameraControlsWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.focalZoomWidget.setVisibility(CameraUtil.isFPVTypeView(devicePosition) ? 4 : 0);
        this.horizontalSituationIndicatorWidget.setSimpleModeEnable(CameraUtil.isFPVTypeView(devicePosition));
        this.ndviCameraPanel.setVisibility(CameraUtil.isSupportForNDVI(lensType) ? 0 : 4);
    }

    private void swapVideoSource() {
        ComponentIndexType primarySource = this.primaryFpvWidget.getWidgetModel().getCameraIndex();
        ComponentIndexType secondarySource = this.secondaryFPVWidget.getWidgetModel().getCameraIndex();
        if (primarySource != ComponentIndexType.UNKNOWN && secondarySource != ComponentIndexType.UNKNOWN) {
            this.primaryFpvWidget.updateVideoSource(secondarySource);
            this.secondaryFPVWidget.updateVideoSource(primarySource);
        }
    }

    private void updateInteractionEnabled() {
        this.fpvInteractionWidget.setInteractionEnabled(!CameraUtil.isFPVTypeView(this.primaryFpvWidget.getWidgetModel().getCameraIndex()));
    }

    public void onBackPressed() {
        if (this.mDrawerLayout.isDrawerOpen(0x800005)) {
            this.mDrawerLayout.closeDrawers();
        } else {
            super.onBackPressed();
        }
    }

    private static class CameraSource {
        ComponentIndexType devicePosition;
        CameraLensType lensType;

        public CameraSource(ComponentIndexType devicePosition, CameraLensType lensType) {
            this.devicePosition = devicePosition;
            this.lensType = lensType;
        }
    }
}

