/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.utils;

import dji.v5.ux.mapkit.core.Mapkit;
import dji.v5.ux.mapkit.core.models.DJILatLng;

public class DJIGpsUtils {
    private static final double ZERO_DEBOUNCE_THRESHOLD = 1.0E-8;
    private static final double M_PI = Math.PI;
    private static final DeltaLatLngCache sDeltaLatLngCache = new DeltaLatLngCache();

    private DJIGpsUtils() {
    }

    private static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private static DJILatLng delta(DJILatLng source) {
        double a = 6378245.0;
        double ee = 0.006693421622965943;
        double dLat = DJIGpsUtils.transformLat(source.longitude - 105.0, source.latitude - 35.0);
        double dLng = DJIGpsUtils.transformLon(source.longitude - 105.0, source.latitude - 35.0);
        double radLat = source.latitude / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * Math.PI);
        dLng = dLng * 180.0 / (a / sqrtMagic * Math.cos(radLat) * Math.PI);
        return new DJILatLng(dLat, dLng);
    }

    private static DeltaLatLngCache delta(double latitude, double longitude) {
        double a = 6378245.0;
        double ee = 0.006693421622965943;
        double dLat = DJIGpsUtils.transformLat(longitude - 105.0, latitude - 35.0);
        double dLng = DJIGpsUtils.transformLon(longitude - 105.0, latitude - 35.0);
        double radLat = latitude / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * Math.PI);
        dLng = dLng * 180.0 / (a / sqrtMagic * Math.cos(radLat) * Math.PI);
        DJIGpsUtils.sDeltaLatLngCache.latitude = dLat;
        DJIGpsUtils.sDeltaLatLngCache.longitude = dLng;
        return sDeltaLatLngCache;
    }

    public static DJILatLng wgs2gcjInChina(DJILatLng source) {
        if (!(Mapkit.isInMainlandChina() || Mapkit.isInHongKong() || Mapkit.isInMacau())) {
            return source;
        }
        DeltaLatLngCache cache = DJIGpsUtils.delta(source.getLatitude(), source.getLongitude());
        double latitude = source.getLatitude() + cache.latitude;
        double longitude = source.getLongitude() + cache.longitude;
        return new DJILatLng(latitude, longitude, source.getAltitude(), source.getAccuracy(), source.getTime());
    }

    public static DJILatLng wgs2gcjJustInMainlandChina(DJILatLng source) {
        if (!Mapkit.isInMainlandChina()) {
            return source;
        }
        DeltaLatLngCache cache = DJIGpsUtils.delta(source.getLatitude(), source.getLongitude());
        double latitude = source.getLatitude() + cache.latitude;
        double longitude = source.getLongitude() + cache.longitude;
        return new DJILatLng(latitude, longitude, source.getAltitude(), source.getAccuracy(), source.getTime());
    }

    public static DJILatLng gcj2wgsInChina(DJILatLng source) {
        if (!(Mapkit.isInMainlandChina() || Mapkit.isInHongKong() || Mapkit.isInMacau())) {
            return source;
        }
        DJILatLng latLng = DJIGpsUtils.delta(source);
        double latitude = source.latitude - latLng.latitude;
        double longitude = source.longitude - latLng.longitude;
        return new DJILatLng(latitude, longitude, source.getAltitude(), source.getAccuracy(), source.getTime());
    }

    public static DJILatLng gcj2wgsJustInMainlandChina(DJILatLng source) {
        if (!Mapkit.isInMainlandChina()) {
            return source;
        }
        DJILatLng latLng = DJIGpsUtils.delta(source);
        double latitude = source.latitude - latLng.latitude;
        double longitude = source.longitude - latLng.longitude;
        return new DJILatLng(latitude, longitude, source.getAltitude(), source.getAccuracy(), source.getTime());
    }

    public static double distance(double latA, double lngA, double latB, double lngB) {
        double y;
        double earthR = 6371000.0;
        double x = Math.cos(latA * Math.PI / 180.0) * Math.cos(latB * Math.PI / 180.0) * Math.cos((lngA - lngB) * Math.PI / 180.0);
        double s = x + (y = Math.sin(latA * Math.PI / 180.0) * Math.sin(latB * Math.PI / 180.0));
        if (s > 1.0) {
            s = 1.0;
        }
        if (s < -1.0) {
            s = -1.0;
        }
        double alpha = Math.acos(s);
        double distance = alpha * earthR;
        return distance;
    }

    public static double distance(DJILatLng latLngA, DJILatLng latLngB) {
        return DJIGpsUtils.distance(latLngA.latitude, latLngA.longitude, latLngB.latitude, latLngB.longitude);
    }

    public static boolean isAvailable(double latitude, double longitude) {
        boolean result = Math.abs(latitude) <= 90.0 && Math.abs(longitude) <= 180.0 && (!DJIGpsUtils.isZero(latitude) || !DJIGpsUtils.isZero(longitude));
        return result;
    }

    private static boolean isZero(double value) {
        return -1.0E-8 <= value && value <= 1.0E-8;
    }

    private static class DeltaLatLngCache {
        private double latitude;
        private double longitude;

        private DeltaLatLngCache() {
        }
    }
}

