/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.map;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.common.LocationCoordinate3D;
import dji.v5.common.utils.GpsUtils;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneInformation;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneLicenseInfo;
import dji.v5.manager.areacode.AreaCode;
import dji.v5.manager.areacode.AreaCodeManager;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.MathUtil;
import dji.v5.ux.core.util.SettingDefinitions;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.map.FlyZoneActionListener;
import dji.v5.ux.map.FlyZoneMapHelper;
import dji.v5.ux.map.MapWidgetModel;
import dji.v5.ux.mapkit.amap.provider.AMapProvider;
import dji.v5.ux.mapkit.core.Mapkit;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdateFactory;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.maps.DJIMapViewInternal;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptorFactory;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.DJILatLngBounds;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.gmap.provider.GoogleProvider;
import dji.v5.ux.mapkit.maplibre.provider.MaplibreProvider;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MapWidget
extends ConstraintLayoutWidget<Object>
implements View.OnTouchListener,
FlyZoneActionListener {
    private static final int COUNTER_REFRESH_THRESHOLD = 200;
    private static final int MAX_FLY_ZONE_SHOW_ON_MAP = 100;
    private static final int FLIGHT_ANIM_DURATION = 130;
    private static final int ROTATION_ANIM_DURATION = 100;
    private static final int AIRCRAFT_MARKER_ELEVATION = 7;
    private static final int GIMBAL_MARKER_ELEVATION = 6;
    private static final int HOME_MARKER_ELEVATION = 5;
    private static final int DEFAULT_ZOOM = 16;
    private static final int DO_NOT_UPDATE_ZOOM = -1;
    private static final String TAG = "MapWidget";
    private static final String HOME_MARKER = "homemarker";
    private static final String AIRCRAFT_MARKER = "aircraftmarker";
    private static final String GIMBAL_YAW_MARKER = "gimbalyawmarker";
    private boolean isTouching = false;
    private int centerRefreshCounter = 201;
    private MapWidgetModel widgetModel;
    private DJIMap map;
    private DJIMapViewInternal mapView;
    private MapCenterLock mapCenterLockMode = MapCenterLock.AIRCRAFT;
    private boolean isAutoFrameMapBounds = false;
    private DJIMap.MapType mapType;
    private FlyZoneMapHelper flyZoneHelper;
    private DJIMap.OnMarkerClickListener onMarkerClickListener;
    private DJIMarker homeMarker;
    private Drawable homeIcon;
    private boolean homeMarkerEnabled;
    private float homeIconAnchorX = 0.5f;
    private float homeIconAnchorY = 0.5f;
    private DJIMarker gimbalYawMarker;
    private Drawable gimbalYawIcon;
    private boolean gimbalYawMarkerEnabled;
    private float gimbalYawAnchorX = 0.5f;
    private float gimbalYawAnchorY = 0.5f;
    private float aircraftMarkerHeading;
    private DJIMarker aircraftMarker;
    private Drawable aircraftIcon;
    private boolean aircraftMarkerEnabled;
    private float aircraftIconAnchorX = 0.5f;
    private float aircraftIconAnchorY = 0.5f;
    private DJIPolyline homeLine;
    private List<FlyZoneInformation> flyZoneInformationList;
    private boolean homeDirectionEnabled = true;
    @ColorInt
    private int homeDirectionColor = -16711936;
    private float homeDirectionWidth = 5.0f;
    private DJIPolyline flightPathLine;
    private List<DJILatLng> flightPathPoints = new ArrayList<DJILatLng>();
    @ColorInt
    private int flightPathColor = -1;
    private float flightPathWidth = 5.0f;
    private boolean flightPathEnabled = true;

    public MapWidget(@NonNull Context context) {
        super(context);
    }

    public MapWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public MapWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        MapWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_map, (ViewGroup)this);
        if (!this.isInEditMode()) {
            this.widgetModel = new MapWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.flyZoneHelper = new FlyZoneMapHelper(context, this);
        }
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.reactToHeadingChanges());
        this.addReaction(this.widgetModel.getHomeLocation().observeOn(SchedulerProvider.ui()).subscribe(this::updateHomeLocation));
        this.addReaction(this.widgetModel.getAircraftLocation().observeOn(SchedulerProvider.ui()).subscribe(this::updateAircraftLocation));
        this.addReaction(Flowable.combineLatest(this.widgetModel.flyZoneInformationDataProcessor.toFlowable(), this.widgetModel.getHomeLocation(), Pair::new).map(pair -> {
            List infos = new ArrayList((Collection)pair.first);
            if (((LocationCoordinate2D)pair.second).getLatitude() == 181.0) {
                return new ArrayList();
            }
            Collections.sort(infos, (o1, o2) -> {
                double d1 = GpsUtils.distance((double)o1.getCircleCenter().getLatitude(), (double)o1.getCircleCenter().getLongitude(), (double)((LocationCoordinate2D)pair.second).getLatitude(), (double)((LocationCoordinate2D)pair.second).getLongitude());
                double d2 = GpsUtils.distance((double)o2.getCircleCenter().getLatitude(), (double)o2.getCircleCenter().getLongitude(), (double)((LocationCoordinate2D)pair.second).getLatitude(), (double)((LocationCoordinate2D)pair.second).getLongitude());
                return (int)(d1 - d2);
            });
            if (infos.size() > 100) {
                infos = infos.subList(0, 100);
            }
            return infos;
        }).subscribeOn(SchedulerProvider.io()).observeOn(SchedulerProvider.ui()).subscribe(this::onFlyZoneListUpdate));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_map_ratio);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.isTouching = true;
                break;
            }
            case 1: {
                this.isTouching = false;
                break;
            }
        }
        return true;
    }

    public void onCreate(@Nullable Bundle saveInstanceState) {
        if (this.mapView != null) {
            this.mapView.onCreate(saveInstanceState);
        }
    }

    public void onResume() {
        if (this.mapView != null) {
            this.mapView.onResume();
        }
    }

    public void onPause() {
        if (this.mapView != null) {
            this.mapView.onPause();
        }
    }

    public void onDestroy() {
        if (this.mapView != null) {
            try {
                this.mapView.onDestroy();
            }
            catch (NullPointerException e) {
                LogUtils.e((String)TAG, (Object[])new Object[]{"Error while attempting MapView.onDestroy(), ignoring exception" + e});
            }
        }
    }

    public void onSaveInstanceState(@Nullable Bundle bundle) {
        if (this.mapView != null) {
            this.mapView.onSaveInstanceState(bundle);
        }
    }

    public void onLowMemory() {
        if (this.mapView != null) {
            this.mapView.onLowMemory();
        }
    }

    private void initMap(String mapBoxAccessToken, TypedArray typedArray) {
        int mapProviderInt = typedArray.getInt(R.styleable.MapWidget_uxsdk_mapProvider, -1);
        if (mapProviderInt >= 0 && (mapProviderInt != 3 || mapBoxAccessToken != null)) {
            this.setMapProvider(SettingDefinitions.MapProvider.find(mapProviderInt), mapBoxAccessToken);
        }
        this.setMapType(DJIMap.MapType.find(typedArray.getInt(R.styleable.MapWidget_uxsdk_djiMap_mapType, DJIMap.MapType.NORMAL.getValue())));
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MapWidget);
        String mapBoxAccessToken = typedArray.getString(R.styleable.MapWidget_uxsdk_mapBoxToken);
        if (!this.isInEditMode()) {
            float dimension;
            this.initMap(mapBoxAccessToken, typedArray);
            int color2 = typedArray.getColor(R.styleable.MapWidget_uxsdk_homeDirectionColor, 0);
            if (color2 != 0) {
                this.setDirectionToHomeColor(color2);
            }
            if ((dimension = typedArray.getDimension(R.styleable.MapWidget_uxsdk_homeDirectionWidth, 0.0f)) != 0.0f) {
                this.setDirectionToHomeWidth(dimension);
            }
            this.setDirectionToHomeEnabled(typedArray.getBoolean(R.styleable.MapWidget_uxsdk_homeDirectionEnabled, true));
            color2 = typedArray.getColor(R.styleable.MapWidget_uxsdk_flightPathColor, 0);
            if (color2 != 0) {
                this.setFlightPathColor(color2);
            }
            if ((dimension = typedArray.getDimension(R.styleable.MapWidget_uxsdk_flightPathWidth, 0.0f)) != 0.0f) {
                this.setFlightPathWidth(dimension);
            }
            this.setFlightPathEnabled(typedArray.getBoolean(R.styleable.MapWidget_uxsdk_flightPathEnabled, true));
            Drawable drawable2 = typedArray.getDrawable(R.styleable.MapWidget_uxsdk_aircraftMarkerIcon);
            if (drawable2 != null) {
                this.setAircraftMarkerIcon(drawable2);
            }
            this.setAircraftMarkerEnabled(typedArray.getBoolean(R.styleable.MapWidget_uxsdk_aircraftMarkerEnabled, true));
            drawable2 = typedArray.getDrawable(R.styleable.MapWidget_uxsdk_homeMarkerIcon);
            if (drawable2 != null) {
                this.setHomeMarkerIcon(drawable2);
            }
            this.setHomeMarkerEnabled(typedArray.getBoolean(R.styleable.MapWidget_uxsdk_homeMarkerEnabled, true));
            drawable2 = typedArray.getDrawable(R.styleable.MapWidget_uxsdk_gimbalMarkerIcon);
            if (drawable2 != null) {
                this.setGimbalMarkerIcon(drawable2);
            }
            this.setGimbalAttitudeEnabled(typedArray.getBoolean(R.styleable.MapWidget_uxsdk_gimbalAttitudeEnabled, true));
        }
        this.mapCenterLockMode = MapCenterLock.find(typedArray.getInt(R.styleable.MapWidget_uxsdk_mapCenterLock, MapCenterLock.AIRCRAFT.getIndex()));
        this.isAutoFrameMapBounds = typedArray.getBoolean(R.styleable.MapWidget_uxsdk_autoFrameMap, false);
        typedArray.recycle();
    }

    private void setMapProvider(SettingDefinitions.MapProvider provider, String accessToken) {
        switch (provider) {
            case HERE: {
                break;
            }
            case MAPLIBRE: {
                this.initMapLibreMap(this.getContext(), null);
                break;
            }
            case GOOGLE: {
                this.initGoogleMap(null);
                break;
            }
        }
    }

    private void setMapType(DJIMap.MapType mapType) {
        this.mapType = mapType;
        if (this.map != null) {
            this.map.setMapType(mapType);
        }
    }

    private Disposable reactToHeadingChanges() {
        return Flowable.combineLatest(this.widgetModel.getAircraftHeading(), this.widgetModel.getGimbalHeading(), Pair::create).observeOn(SchedulerProvider.ui()).subscribe(values -> {
            this.updateAircraftHeading(((Double)values.first).floatValue());
            this.setGimbalHeading(((Double)values.first).floatValue(), ((Double)values.second).floatValue());
        }, UxErrorHandle.logErrorConsumer(TAG, "react to Heading Update "));
    }

    private void updateHomeCountry() {
        Mapkit.inMacau(AreaCodeManager.getInstance().getAreaCode().getAreaCodeEnum() == AreaCode.MACAU);
        Mapkit.inHongKong(AreaCodeManager.getInstance().getAreaCode().getAreaCodeEnum() == AreaCode.HONG_KONG);
        Mapkit.inMainlandChina(AreaCodeManager.getInstance().getAreaCode().getAreaCodeEnum() == AreaCode.CHINA);
    }

    private void initDefaults() {
        this.aircraftIcon = this.getResources().getDrawable(R.drawable.uxsdk_ic_compass_aircraft);
        this.homeIcon = this.getResources().getDrawable(R.drawable.uxsdk_ic_home);
        this.gimbalYawIcon = this.getResources().getDrawable(R.drawable.uxsdk_ic_map_gimbal_yaw);
    }

    private void initHomeOnMap(DJILatLng homePosition) {
        if (this.map == null || !homePosition.isAvailable()) {
            return;
        }
        DJIMarkerOptions homeMarkerOptions = new DJIMarkerOptions().position(homePosition).icon(DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.homeIcon))).title(HOME_MARKER).anchor(this.homeIconAnchorX, this.homeIconAnchorY).zIndex(5).visible(this.homeMarkerEnabled);
        this.homeMarker = this.map.addMarker(homeMarkerOptions);
        LogUtils.d((String)TAG, (Object[])new Object[]{"added home marker to map at (" + homePosition.getLatitude() + "," + homePosition.getLongitude() + ")"});
        this.setMapCenter(this.mapCenterLockMode, 16.0f, false);
    }

    private void updateHomeLocation(LocationCoordinate2D homeLocation) {
        if (homeLocation.getLatitude() == 181.0 || homeLocation.getLongitude() == 181.0) {
            return;
        }
        DJILatLng homePosition = new DJILatLng(homeLocation.getLatitude(), homeLocation.getLongitude());
        if (this.map == null || !homePosition.isAvailable()) {
            return;
        }
        if (this.homeMarker != null) {
            this.homeMarker.setPosition(homePosition);
            this.updateCameraPosition();
        } else {
            this.initHomeOnMap(homePosition);
        }
    }

    private void initAircraftOnMap(DJILatLng aircraftPosition) {
        if (this.map == null || !aircraftPosition.isAvailable()) {
            return;
        }
        DJIMarkerOptions aircraftMarkerOptions = new DJIMarkerOptions().position(aircraftPosition).icon(DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.aircraftIcon))).title(AIRCRAFT_MARKER).anchor(this.aircraftIconAnchorX, this.aircraftIconAnchorY).zIndex(7).visible(this.aircraftMarkerEnabled);
        this.aircraftMarker = this.map.addMarker(aircraftMarkerOptions);
        DJIMarkerOptions gimbalMarkerOptions = new DJIMarkerOptions().position(aircraftPosition).icon(DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.gimbalYawIcon))).anchor(this.gimbalYawAnchorX, this.gimbalYawAnchorY).zIndex(6).title(GIMBAL_YAW_MARKER).visible(this.gimbalYawMarkerEnabled);
        this.gimbalYawMarker = this.map.addMarker(gimbalMarkerOptions);
        LogUtils.d((String)TAG, (Object[])new Object[]{"added aircraft marker to map at (" + aircraftPosition.getLatitude() + "," + aircraftPosition.getLongitude() + ")"});
        this.setMapCenter(this.mapCenterLockMode, 16.0f, false);
    }

    private void onFlyZoneListUpdate(List<FlyZoneInformation> flyZoneInformationList) {
        this.flyZoneInformationList = flyZoneInformationList;
        this.flyZoneHelper.onFlyZoneListUpdate(flyZoneInformationList);
    }

    @Override
    public void requestSelfUnlock(@NonNull ArrayList<Integer> arrayList) {
    }

    @Override
    public void requestFlyZoneList() {
    }

    @Override
    public void requestEnableFlyZone(@NonNull FlyZoneLicenseInfo customUnlockZone) {
    }

    @Override
    public void requestDisableFlyZone() {
    }

    private void updateAircraftHeading(float aircraftHeading) {
        if ((aircraftHeading >= 0.0f && this.aircraftMarkerHeading >= 0.0f || aircraftHeading <= 0.0f && this.aircraftMarkerHeading <= 0.0f) && this.map != null) {
            this.animateAircraftHeading(this.aircraftMarkerHeading, aircraftHeading - this.map.getCameraPosition().bearing, aircraftHeading);
        } else {
            this.setAircraftHeading(aircraftHeading);
        }
    }

    private void setAircraftHeading(float aircraftHeading) {
        if (this.map == null) {
            return;
        }
        if (this.aircraftMarker != null) {
            this.rotateAircraftMarker(aircraftHeading - this.map.getCameraPosition().bearing);
        }
        this.aircraftMarkerHeading = aircraftHeading - this.map.getCameraPosition().bearing;
    }

    private void setGimbalHeading(float aircraftHeading, float gimbalHeading) {
        if (this.map == null) {
            return;
        }
        if (this.gimbalYawMarker != null) {
            this.rotateGimbalMarker(gimbalHeading + aircraftHeading - this.map.getCameraPosition().bearing);
        }
    }

    private void animateAircraftHeading(float fromPosition, float toPosition, float aircraftHeading) {
        if (this.map == null || this.aircraftMarker == null) {
            return;
        }
        ValueAnimator rotateAnimation = ValueAnimator.ofFloat((float[])new float[]{this.aircraftMarkerHeading, aircraftHeading - this.map.getCameraPosition().bearing});
        rotateAnimation.setDuration(100L);
        rotateAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimation.addUpdateListener(valueAnimator -> {
            float progress = valueAnimator.getAnimatedFraction();
            float rotation = (toPosition - fromPosition) * progress + fromPosition;
            this.rotateAircraftMarker(rotation);
        });
        rotateAnimation.start();
        this.aircraftMarkerHeading = aircraftHeading - this.map.getCameraPosition().bearing;
    }

    private void rotateAircraftMarker(float rotation) {
        if (this.aircraftMarker != null) {
            this.aircraftMarker.setRotation(rotation);
        }
    }

    private void rotateGimbalMarker(float rotation) {
        if (this.gimbalYawMarker != null) {
            this.gimbalYawMarker.setRotation(rotation);
        }
    }

    private void animateAircraftMarker(DJILatLng toPosition, DJILatLng fromPosition) {
        ValueAnimator flightAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        flightAnimation.setDuration(130L);
        flightAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        flightAnimation.addUpdateListener(valueAnimator -> {
            double longitude;
            float progress = valueAnimator.getAnimatedFraction();
            double latitude = (toPosition.getLatitude() - fromPosition.getLatitude()) * (double)progress + fromPosition.getLatitude();
            DJILatLng aircraftLatLng = new DJILatLng(latitude, longitude = (toPosition.getLongitude() - fromPosition.getLongitude()) * (double)progress + fromPosition.getLongitude());
            if (aircraftLatLng.isAvailable()) {
                if (this.aircraftMarker != null) {
                    this.aircraftMarker.setPosition(aircraftLatLng);
                }
                if (this.gimbalYawMarker != null) {
                    this.gimbalYawMarker.setPosition(aircraftLatLng);
                }
            }
            this.updateCameraPosition();
        });
        flightAnimation.start();
    }

    private void updateCameraPosition() {
        ++this.centerRefreshCounter;
        if (this.centerRefreshCounter > 200) {
            this.centerRefreshCounter = 0;
            this.setMapCenter(this.mapCenterLockMode, -1.0f, true);
        }
    }

    private void updateAircraftLocation(LocationCoordinate3D locationCoordinate3D) {
        if (this.map == null) {
            return;
        }
        if (locationCoordinate3D.getLatitude() == 181.0 || locationCoordinate3D.getLongitude() == 181.0) {
            return;
        }
        DJILatLng aircraftPosition = new DJILatLng(locationCoordinate3D.getLatitude(), locationCoordinate3D.getLongitude());
        if (this.aircraftMarker != null) {
            DJILatLng markerPosition = this.aircraftMarker.getPosition();
            this.animateAircraftMarker(aircraftPosition, markerPosition);
        } else if (aircraftPosition.isAvailable()) {
            this.initAircraftOnMap(aircraftPosition);
        }
        this.updateFlightPath();
        this.updateHomeDirection();
    }

    private void updateHomeDirection() {
        if (this.homeMarker == null || this.aircraftMarker == null || this.map == null) {
            return;
        }
        DJILatLng homeCoordinate = this.homeMarker.getPosition();
        if (this.homeDirectionEnabled) {
            if (this.homeLine != null) {
                ArrayList<DJILatLng> points = new ArrayList<DJILatLng>();
                points.add(this.aircraftMarker.getPosition());
                points.add(homeCoordinate);
                this.homeLine.setPoints(points);
            } else {
                DJIPolylineOptions homeLineOptions = new DJIPolylineOptions().add(this.aircraftMarker.getPosition()).add(homeCoordinate).color(this.homeDirectionColor).width(this.homeDirectionWidth);
                this.homeLine = this.map.addPolyline(homeLineOptions);
            }
        } else if (this.homeLine != null) {
            this.homeLine.remove();
            this.homeLine = null;
        }
    }

    private void setMapCenter(MapCenterLock mapCenterLock, float zoomLevel, boolean animate) {
        if (this.map == null) {
            return;
        }
        if (!this.isTouching) {
            if (zoomLevel == -1.0f) {
                zoomLevel = this.map.getCameraPosition().zoom;
            }
            DJICameraUpdate cameraUpdate = null;
            float rotation = this.map.getCameraPosition().getBearing();
            DJICameraPosition cameraPosition = this.getCameraPosition(mapCenterLock, rotation, zoomLevel);
            if (cameraPosition != null) {
                cameraUpdate = DJICameraUpdateFactory.newCameraPosition(cameraPosition);
            }
            if (cameraUpdate != null) {
                if (animate) {
                    this.map.animateCamera(cameraUpdate);
                } else {
                    this.map.moveCamera(cameraUpdate);
                }
            }
            this.autoFrameMapBounds();
        }
    }

    private DJICameraPosition getCameraPosition(MapCenterLock mapCenterLock, float rotation, float zoomLevel) {
        DJICameraPosition cameraPosition = null;
        switch (mapCenterLock.ordinal()) {
            case 1: {
                if (this.aircraftMarker == null) break;
                cameraPosition = new DJICameraPosition.Builder().bearing(rotation).target(this.aircraftMarker.getPosition()).zoom(zoomLevel).build();
                break;
            }
            case 2: {
                if (this.homeMarker == null) break;
                cameraPosition = new DJICameraPosition.Builder().bearing(rotation).target(this.homeMarker.getPosition()).zoom(zoomLevel).build();
                break;
            }
        }
        return cameraPosition;
    }

    private void autoFrameMapBounds() {
        if (!this.isAutoFrameMapBounds) {
            return;
        }
        ArrayList<DJILatLng> latLngList = new ArrayList<DJILatLng>();
        if (this.homeMarker == null || this.aircraftMarker == null) {
            if (this.homeMarker != null) {
                latLngList.add(new DJILatLng(this.homeMarker.getPosition().getLatitude(), this.homeMarker.getPosition().getLongitude()));
            }
            if (this.aircraftMarker != null) {
                latLngList.add(new DJILatLng(this.aircraftMarker.getPosition().getLatitude(), this.aircraftMarker.getPosition().getLongitude()));
            }
        } else {
            this.doAutoBounds(latLngList);
        }
        if (!latLngList.isEmpty()) {
            DJILatLngBounds latLngBounds = DJILatLngBounds.fromLatLngs(latLngList);
            this.map.animateCamera(DJICameraUpdateFactory.newLatLngBounds(latLngBounds, 0, 100));
        }
    }

    private void doAutoBounds(List<DJILatLng> latLngList) {
        double aircraftLat = this.aircraftMarker.getPosition().getLatitude();
        double aircraftLng = this.aircraftMarker.getPosition().getLongitude();
        double homeLat = this.homeMarker.getPosition().getLatitude();
        double homeLng = this.homeMarker.getPosition().getLongitude();
        double delta = 2.0E-4;
        if (this.mapCenterLockMode == MapCenterLock.AIRCRAFT) {
            DJILatLng aircraftPosition = new DJILatLng(aircraftLat, aircraftLng);
            latLngList.add(aircraftPosition);
            double adjustedLat = homeLat > aircraftLat ? homeLat + delta : homeLat - delta;
            double adjustedLng = homeLng > aircraftLng ? homeLng + delta : homeLng - delta;
            DJILatLng homePosition = new DJILatLng(adjustedLat, adjustedLng);
            latLngList.add(homePosition);
            DJILatLng dummyLocation = new DJILatLng(aircraftLat - (adjustedLat - aircraftLat), aircraftLng - (adjustedLng - aircraftLng));
            latLngList.add(dummyLocation);
        } else if (this.mapCenterLockMode == MapCenterLock.HOME) {
            DJILatLng homePosition = new DJILatLng(homeLat, homeLng);
            latLngList.add(homePosition);
            double adjustedLat = aircraftLat > homeLat ? aircraftLat + delta : aircraftLat - delta;
            double adjustedLng = aircraftLng > homeLng ? aircraftLng + delta : aircraftLng - delta;
            DJILatLng aircraftPosition = new DJILatLng(adjustedLat, adjustedLng);
            latLngList.add(aircraftPosition);
            DJILatLng dummyLocation = new DJILatLng(homeLat - (adjustedLat - homeLat), homeLng - (adjustedLng - homeLng));
            latLngList.add(dummyLocation);
        } else if (this.mapCenterLockMode == MapCenterLock.NONE) {
            latLngList.add(this.getAdjustPostion(aircraftLat, aircraftLng, homeLat, homeLng, delta, true));
            latLngList.add(this.getAdjustPostion(aircraftLat, aircraftLng, homeLat, homeLng, delta, false));
        }
    }

    private DJILatLng getAdjustPostion(double aircraftLat, double aircraftLng, double homeLat, double homeLng, double delta, boolean isAircraft) {
        double adjustedHomeLng;
        double adjustedAircraftLng;
        double adjustedHomeLat;
        double adjustedAircraftLat;
        if (aircraftLat > homeLat) {
            adjustedAircraftLat = aircraftLat + delta;
            adjustedHomeLat = homeLat - delta;
        } else {
            adjustedAircraftLat = aircraftLat - delta;
            adjustedHomeLat = homeLat + delta;
        }
        if (aircraftLng > homeLng) {
            adjustedAircraftLng = aircraftLng + delta;
            adjustedHomeLng = homeLng - delta;
        } else {
            adjustedAircraftLng = aircraftLng - delta;
            adjustedHomeLng = homeLng + delta;
        }
        if (isAircraft) {
            return new DJILatLng(adjustedAircraftLat, adjustedAircraftLng);
        }
        return new DJILatLng(adjustedHomeLat, adjustedHomeLng);
    }

    public void initGoogleMap(@Nullable OnMapReadyListener listener2) {
        this.mapView = new GoogleProvider().dispatchMapViewRequest(this.getContext(), null);
        this.addView((View)((ViewGroup)this.mapView), 0);
        this.mapView.getDJIMapAsync(map -> {
            this.map = map;
            this.postInit(listener2);
            this.flyZoneHelper.initializeMap(map);
        });
    }

    public void initAMap(@Nullable OnMapReadyListener listener2) {
        this.mapView = new AMapProvider().dispatchMapViewRequest(this.getContext(), null);
        this.addView((View)((ViewGroup)this.mapView), 0);
        this.mapView.getDJIMapAsync(map -> {
            this.map = map;
            this.postInit(listener2);
            this.flyZoneHelper.initializeMap(map);
        });
    }

    public void initMapLibreMap(@NonNull Context context, @Nullable OnMapReadyListener listener2) {
        Mapkit.init(context);
        this.mapView = new MaplibreProvider().dispatchMapViewRequest(this.getContext(), null);
        this.addView((View)((ViewGroup)this.mapView), 0);
        this.mapView.getDJIMapAsync(map -> {
            this.flyZoneHelper.initializeMap(map);
            this.map = map;
            this.postInit(mapLib -> {
                if (this.flyZoneInformationList != null) {
                    this.onFlyZoneListUpdate(this.flyZoneInformationList);
                }
                if (listener2 != null) {
                    listener2.onMapReady(mapLib);
                }
            });
        });
    }

    private void postInit(OnMapReadyListener listener2) {
        this.updateHomeCountry();
        this.map.setMapType(this.mapType, () -> {
            Single aircraftLocation = this.widgetModel.getAircraftLocation().firstOrError();
            Single homeLocation = this.widgetModel.getHomeLocation().firstOrError();
            this.addDisposable(Single.zip((SingleSource)aircraftLocation, (SingleSource)homeLocation, Pair::new).observeOn(SchedulerProvider.ui()).subscribe(pair -> {
                this.updateAircraftLocation((LocationCoordinate3D)pair.first);
                this.updateHomeLocation((LocationCoordinate2D)pair.second);
                if (listener2 != null) {
                    listener2.onMapReady(this.map);
                }
            }, UxErrorHandle.logErrorConsumer(TAG, "updateAircraftAndHomeLocation")));
        });
        this.map.setOnMarkerClickListener(marker -> {
            String title = marker.getTitle();
            if (title == null || title.length() <= 0 || GIMBAL_YAW_MARKER.equals(title) || AIRCRAFT_MARKER.equals(title) || HOME_MARKER.equals(title) || !MathUtil.isInteger(title)) {
                this.emitMarkerClickEvent(marker);
            }
            return true;
        });
        this.addDisposable(this.widgetModel.getAircraftLocation().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateAircraftLocation, UxErrorHandle.logErrorConsumer(TAG, "updateAircraftLocation")));
        this.addDisposable(this.widgetModel.getHomeLocation().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateHomeLocation, UxErrorHandle.logErrorConsumer(TAG, "updateHomeLocation")));
    }

    private void emitMarkerClickEvent(DJIMarker marker) {
        if (this.onMarkerClickListener != null) {
            this.onMarkerClickListener.onMarkerClick(marker);
        }
    }

    private void updateFlightPath() {
        if (this.aircraftMarker == null) {
            return;
        }
        DJILatLng aircraftPosition = this.aircraftMarker.getPosition();
        if (this.flightPathPoints.size() >= 2) {
            DJILatLng lastPosition = this.flightPathPoints.get(this.flightPathPoints.size() - 1);
            if (Math.abs(lastPosition.getLatitude() - aircraftPosition.getLatitude()) > 5.0E-6 || Math.abs(lastPosition.getLongitude() - aircraftPosition.getLongitude()) > 5.0E-6) {
                this.flightPathPoints.add(aircraftPosition);
            }
        } else {
            this.flightPathPoints.add(aircraftPosition);
            this.flightPathPoints.add(aircraftPosition);
        }
        this.refreshFlightPath();
    }

    private void refreshFlightPath() {
        if (this.aircraftMarker == null || this.map == null) {
            return;
        }
        if (this.flightPathEnabled) {
            if (this.flightPathLine == null) {
                DJIPolylineOptions polylineOptions = new DJIPolylineOptions().addAll(this.flightPathPoints).color(this.flightPathColor).width(this.flightPathWidth);
                this.flightPathLine = this.map.addPolyline(polylineOptions);
            } else {
                this.flightPathLine.setPoints(this.flightPathPoints);
            }
        } else if (this.flightPathLine != null) {
            this.flightPathLine.remove();
            this.flightPathLine = null;
        }
    }

    public void clearFlightPath() {
        if (this.flightPathLine == null) {
            return;
        }
        this.flightPathPoints.clear();
        this.flightPathLine.remove();
        this.flightPathLine = null;
        this.updateFlightPath();
    }

    public boolean isFlightPathEnabled() {
        return this.flightPathEnabled;
    }

    public void setFlightPathEnabled(boolean isEnabled) {
        this.flightPathEnabled = isEnabled;
        this.refreshFlightPath();
    }

    @ColorInt
    public int getFlightPathColor() {
        return this.flightPathColor;
    }

    public void setFlightPathColor(@ColorInt int color2) {
        this.flightPathColor = color2;
        if (this.flightPathEnabled && this.flightPathLine != null) {
            this.flightPathLine.setColor(this.flightPathColor);
        }
    }

    public float getFlightPathWidth() {
        return this.flightPathWidth;
    }

    public void setFlightPathWidth(float width) {
        this.flightPathWidth = width;
        if (this.flightPathEnabled && this.flightPathLine != null) {
            this.flightPathLine.setWidth(this.flightPathWidth);
        }
    }

    public boolean isDirectionToHomeEnabled() {
        return this.homeDirectionEnabled;
    }

    public void setDirectionToHomeEnabled(boolean isEnabled) {
        this.homeDirectionEnabled = isEnabled;
        this.updateHomeDirection();
    }

    @ColorInt
    public int getDirectionToHomeColor() {
        return this.homeDirectionColor;
    }

    public void setDirectionToHomeColor(@ColorInt int color2) {
        this.homeDirectionColor = color2;
        if (this.homeDirectionEnabled && this.homeLine != null) {
            this.homeLine.setColor(color2);
        }
    }

    public float getDirectionToHomeWidth() {
        return this.homeDirectionWidth;
    }

    public void setDirectionToHomeWidth(float width) {
        this.homeDirectionWidth = width;
        if (this.homeDirectionEnabled && this.homeLine != null) {
            this.homeLine.setWidth(width);
        }
    }

    @Nullable
    public DJIMap getMap() {
        return this.map;
    }

    public void setAircraftMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.aircraftIconAnchorX = x;
        this.aircraftIconAnchorY = y;
        this.setAircraftMarkerIcon(drawable2);
        if (this.aircraftMarker != null) {
            this.aircraftMarker.setAnchor(x, y);
        }
    }

    @NonNull
    public Drawable getAircraftMarkerIcon() {
        return this.aircraftIcon;
    }

    public void setAircraftMarkerIcon(@NonNull Drawable drawable2) {
        this.aircraftIcon = drawable2;
        if (this.aircraftMarker != null) {
            this.aircraftMarker.setIcon(DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.aircraftIcon)));
        }
    }

    public void setHomeMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.homeIconAnchorX = x;
        this.homeIconAnchorY = y;
        this.setHomeMarkerIcon(drawable2);
        if (this.homeMarker != null) {
            this.homeMarker.setAnchor(x, y);
        }
    }

    @NonNull
    public Drawable getHomeMarkerIcon() {
        return this.homeIcon;
    }

    public void setHomeMarkerIcon(@NonNull Drawable drawable2) {
        this.homeIcon = drawable2;
        if (this.homeMarker != null) {
            this.homeMarker.setIcon(DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.homeIcon)));
        }
    }

    public void setGimbalMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.gimbalYawAnchorX = x;
        this.gimbalYawAnchorY = y;
        this.setGimbalMarkerIcon(drawable2);
        if (this.gimbalYawMarker != null) {
            this.gimbalYawMarker.setAnchor(x, y);
        }
    }

    @NonNull
    public Drawable getGimbalMarkerIcon() {
        return this.gimbalYawIcon;
    }

    public void setGimbalMarkerIcon(@NonNull Drawable drawable2) {
        this.gimbalYawIcon = drawable2;
        if (this.gimbalYawMarker != null) {
            this.gimbalYawMarker.setIcon(DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.gimbalYawIcon)));
        }
    }

    public boolean isGimbalAttitudeEnabled() {
        return this.gimbalYawMarkerEnabled;
    }

    public void setGimbalAttitudeEnabled(boolean isVisible) {
        this.gimbalYawMarkerEnabled = isVisible;
        if (this.gimbalYawMarker != null) {
            this.gimbalYawMarker.setVisible(isVisible);
        }
    }

    public boolean isAircraftMarkerEnabled() {
        return this.aircraftMarkerEnabled;
    }

    public void setAircraftMarkerEnabled(boolean isVisible) {
        this.aircraftMarkerEnabled = isVisible;
        if (this.aircraftMarker != null) {
            this.aircraftMarker.setVisible(isVisible);
        }
    }

    public boolean isHomeMarkerEnabled() {
        return this.homeMarkerEnabled;
    }

    public void setHomeMarkerEnabled(boolean isEnabled) {
        this.homeMarkerEnabled = isEnabled;
        if (this.homeMarker != null) {
            this.homeMarker.setVisible(isEnabled);
        }
    }

    public void setOnMarkerClickListener(DJIMap.OnMarkerClickListener onMarkerClickListener) {
        this.onMarkerClickListener = onMarkerClickListener;
    }

    public void setMapCenterLock(@NonNull MapCenterLock mapCenterLock) {
        this.mapCenterLockMode = mapCenterLock;
        this.setMapCenter(mapCenterLock, -1.0f, true);
    }

    public boolean isAutoFrameMapEnabled() {
        return this.isAutoFrameMapBounds;
    }

    public void setAutoFrameMapEnabled(boolean isEnabled) {
        this.isAutoFrameMapBounds = isEnabled;
        this.autoFrameMapBounds();
    }

    public static enum MapCenterLock {
        NONE(0),
        AIRCRAFT(1),
        HOME(2);

        private int index;
        private static MapCenterLock[] values;

        private MapCenterLock(int index) {
            this.index = index;
        }

        public static MapCenterLock[] getValues() {
            if (values == null) {
                values = MapCenterLock.values();
            }
            return values;
        }

        @NonNull
        public static MapCenterLock find(@IntRange(from=-1L, to=2L) int index) {
            for (MapCenterLock mapCenterLock : MapCenterLock.getValues()) {
                if (mapCenterLock.getIndex() != index) continue;
                return mapCenterLock;
            }
            return NONE;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static interface OnMapReadyListener {
        public void onMapReady(@NonNull DJIMap var1);
    }
}

