/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.battery.BatteryGroupInfoWidgetModel;
import dji.v5.ux.core.widget.battery.BatteryGroupWidget;
import java.util.Locale;

public class BatteryGroupInfoWidget
extends ConstraintLayoutWidget<Object> {
    protected BatteryGroupInfoWidgetModel widgetModel = new BatteryGroupInfoWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    protected BatteryGroupWidget batteryGroupWidget;
    protected TextView batteryChargeRemaining;
    protected TextView flightTime;
    protected Button batteryDetail;
    protected boolean isConnected;

    public BatteryGroupInfoWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BatteryGroupInfoWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BatteryGroupInfoWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        BatteryGroupInfoWidget.inflate((Context)context, (int)R.layout.uxsdk_view_group_battery_info, (ViewGroup)this);
        this.batteryChargeRemaining = (TextView)this.findViewById(R.id.setting_menu_battery_charge_remain);
        this.flightTime = (TextView)this.findViewById(R.id.setting_menu_battery_fly_time);
        this.batteryDetail = (Button)this.findViewById(R.id.setting_menu_battery_info_detail_view);
        this.batteryGroupWidget = (BatteryGroupWidget)this.findViewById(R.id.setting_menu_battery_group_view);
        this.setBackgroundResource(R.drawable.uxsdk_background_fpv_setting_battery_group);
        this.batteryGroupWidget.setEnableBatteryCells(false);
        this.batteryGroupWidget.setEnableSerialNumber(false);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getBatteryChargeRemaining().subscribe(this::updateBatteryChargeRemaining));
        this.addReaction(this.widgetModel.getFlightTimeInSeconds().subscribe(this::updateFlightTime));
        this.addReaction(this.widgetModel.getConnection().subscribe(connection -> {
            if (Boolean.compare(this.isConnected, connection) == 0) {
                return;
            }
            this.isConnected = connection;
            if (!this.isConnected) {
                this.widgetModel.reset();
            }
        }));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private void updateFlightTime(int time) {
        int seconds = (time /= 10) % 60;
        int minute = time / 60;
        String data = String.format(Locale.getDefault(), "%1$02d:%2$02d", minute, seconds);
        this.flightTime.setText((CharSequence)data);
    }

    private void updateBatteryChargeRemaining(int percent) {
        this.batteryChargeRemaining.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_percent, new Object[]{percent}));
    }

    public void setOnDetailOnClickListener(@Nullable View.OnClickListener listener2) {
        this.batteryDetail.setVisibility(listener2 == null ? 8 : 0);
        this.batteryDetail.setOnClickListener(listener2);
    }
}

