/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.panel.listitem.ssdstatus;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.v5.utils.common.JsonUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.UXSDKError;
import dji.v5.ux.core.base.WidgetSizeDescription;
import dji.v5.ux.core.base.panel.listitem.ListItemLabelButtonWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.panel.listitem.ssdstatus.SSDStatusListItemWidgetModel;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002=>B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020#H\u0014J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0014J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020,2\u0006\u0010-\u001a\u00020\bH\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010(\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020,H\u0002J\u0010\u00101\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0002J\b\u00102\u001a\u00020#H\u0002J\u001a\u00103\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\n\u00108\u001a\u0004\u0018\u00010+H\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020:H\u0016R\u001e\u0010\u000b\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006?"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget;", "Ldji/v5/ux/core/base/panel/listitem/ListItemLabelButtonWidget;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dialogTheme", "getDialogTheme", "()I", "setDialogTheme", "(I)V", "formatConfirmationDialogIcon", "Landroid/graphics/drawable/Drawable;", "getFormatConfirmationDialogIcon", "()Landroid/graphics/drawable/Drawable;", "setFormatConfirmationDialogIcon", "(Landroid/graphics/drawable/Drawable;)V", "formatSuccessDialogIcon", "getFormatSuccessDialogIcon", "setFormatSuccessDialogIcon", "formatErrorDialogIcon", "getFormatErrorDialogIcon", "setFormatErrorDialogIcon", "widgetModel", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "onAttachedToWindow", "", "onDetachedFromWindow", "onButtonClick", "reactToModelChanges", "updateUI", "ssdState", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidgetModel$SSDState;", "getSSDMessage", "", "Ldji/sdk/keyvalue/value/camera/SSDOperationState;", "remainingSpace", "getSSDMessageColor", "getFormatButtonVisibility", "", "updateDisabledState", "formatSSD", "initAttributes", "widgetSizeDescription", "Ldji/v5/ux/core/base/WidgetSizeDescription;", "getWidgetSizeDescription", "()Ldji/v5/ux/core/base/WidgetSizeDescription;", "getIdealDimensionRatioString", "getUIStateUpdates", "Lio/reactivex/rxjava3/core/Flowable;", "Ldji/v5/ux/core/base/panel/listitem/ListItemLabelButtonWidget$UIState;", "getWidgetStateUpdate", "DialogType", "ModelState", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nSSDStatusListItemWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSDStatusListItemWidget.kt\ndji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget\n+ 2 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 3 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,341:1\n233#2:342\n234#2,2:360\n101#3,2:343\n103#3:346\n101#3,2:347\n103#3:350\n101#3,2:351\n103#3:354\n125#3,5:355\n1#4:345\n1#4:349\n1#4:353\n*S KotlinDebug\n*F\n+ 1 SSDStatusListItemWidget.kt\ndji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget\n*L\n259#1:342\n259#1:360,2\n260#1:343,2\n260#1:346\n263#1:347,2\n263#1:350\n266#1:351,2\n266#1:354\n269#1:355,5\n260#1:345\n263#1:349\n266#1:353\n*E\n"})
public class SSDStatusListItemWidget
extends ListItemLabelButtonWidget<ModelState> {
    @StyleRes
    private int dialogTheme;
    @Nullable
    private Drawable formatConfirmationDialogIcon;
    @Nullable
    private Drawable formatSuccessDialogIcon;
    @Nullable
    private Drawable formatErrorDialogIcon;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private final WidgetSizeDescription widgetSizeDescription;

    @JvmOverloads
    public SSDStatusListItemWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, ListItemLabelButtonWidget.WidgetType.LABEL_BUTTON, R.style.UXSDKSSDStatusListItem);
        this.dialogTheme = R.style.UXSDKDialogTheme;
        this.formatConfirmationDialogIcon = ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_alert_yellow);
        this.formatSuccessDialogIcon = ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_alert_good);
        this.formatErrorDialogIcon = ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_alert_error);
        this.widgetModel$delegate = LazyKt.lazy(SSDStatusListItemWidget::widgetModel_delegate$lambda$0);
        this.initAttributes(context, attrs);
        this.widgetSizeDescription = new WidgetSizeDescription(WidgetSizeDescription.SizeType.OTHER, WidgetSizeDescription.Dimension.EXPAND, WidgetSizeDescription.Dimension.WRAP);
    }

    public /* synthetic */ SSDStatusListItemWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getDialogTheme() {
        return this.dialogTheme;
    }

    public final void setDialogTheme(int n) {
        this.dialogTheme = n;
    }

    @Nullable
    public final Drawable getFormatConfirmationDialogIcon() {
        return this.formatConfirmationDialogIcon;
    }

    public final void setFormatConfirmationDialogIcon(@Nullable Drawable drawable2) {
        this.formatConfirmationDialogIcon = drawable2;
    }

    @Nullable
    public final Drawable getFormatSuccessDialogIcon() {
        return this.formatSuccessDialogIcon;
    }

    public final void setFormatSuccessDialogIcon(@Nullable Drawable drawable2) {
        this.formatSuccessDialogIcon = drawable2;
    }

    @Nullable
    public final Drawable getFormatErrorDialogIcon() {
        return this.formatErrorDialogIcon;
    }

    public final void setFormatErrorDialogIcon(@Nullable Drawable drawable2) {
        this.formatErrorDialogIcon = drawable2;
    }

    private final SSDStatusListItemWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (SSDStatusListItemWidgetModel)lazy.getValue();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void onButtonClick() {
        DialogInterface.OnClickListener dialogListener = (arg_0, arg_1) -> SSDStatusListItemWidget.onButtonClick$lambda$1(this, arg_0, arg_1);
        DialogInterface.OnDismissListener dialogDismissListener = arg_0 -> SSDStatusListItemWidget.onButtonClick$lambda$2(this, arg_0);
        String string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_dialog_title, new Object[0]);
        Drawable drawable2 = this.formatConfirmationDialogIcon;
        int n = this.dialogTheme;
        String string3 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_format_confirmation, new Object[0]);
        ViewExtensions.showConfirmationDialog((View)this, n, string2, drawable2, string3, dialogListener, dialogDismissListener);
        this.getUiUpdateStateProcessor().onNext((Object)new ListItemLabelButtonWidget.UIState.DialogDisplayed(DialogType.FormatConfirmation.INSTANCE));
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ SSDStatusListItemWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SSDStatusListItemWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.ProductConnected(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getSsdState().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ SSDStatusListItemWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(SSDStatusListItemWidgetModel.SSDState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SSDStatusListItemWidget.access$updateUI(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
    }

    private final void updateUI(SSDStatusListItemWidgetModel.SSDState ssdState) {
        Object object = new Object[]{JsonUtil.toJson((Object)ssdState)};
        LogUtils.i((String)this.getLogTag(), (Object[])object);
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.SSDStateUpdated(ssdState));
        object = ssdState;
        if (Intrinsics.areEqual((Object)object, (Object)SSDStatusListItemWidgetModel.SSDState.ProductDisconnected.INSTANCE) || Intrinsics.areEqual((Object)object, (Object)SSDStatusListItemWidgetModel.SSDState.NotSupported.INSTANCE)) {
            this.updateDisabledState(ssdState);
        } else if (object instanceof SSDStatusListItemWidgetModel.SSDState.CurrentSSDState) {
            this.setEnabled(true);
            this.setListItemLabel(this.getSSDMessage(((SSDStatusListItemWidgetModel.SSDState.CurrentSSDState)ssdState).getSsdOperationState(), ((SSDStatusListItemWidgetModel.SSDState.CurrentSSDState)ssdState).getRemainingSpace()));
            this.setListItemLabelTextColor(this.getSSDMessageColor(((SSDStatusListItemWidgetModel.SSDState.CurrentSSDState)ssdState).getSsdOperationState()));
            this.setListItemButtonEnabled(this.getFormatButtonVisibility(((SSDStatusListItemWidgetModel.SSDState.CurrentSSDState)ssdState).getSsdOperationState()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final String getSSDMessage(SSDOperationState ssdState, int remainingSpace) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[ssdState.ordinal()]) {
            case 1: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_not_found, new Object[0]);
                break;
            }
            case 2: {
                String string3 = UnitConversionUtil.getSpaceWithUnit(this.getContext(), remainingSpace);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSpaceWithUnit(...)");
                break;
            }
            case 3: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_saving, new Object[0]);
                break;
            }
            case 4: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_formatting, new Object[0]);
                break;
            }
            case 5: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_initializing, new Object[0]);
                break;
            }
            case 6: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_error, new Object[0]);
                break;
            }
            case 7: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_full, new Object[0]);
                break;
            }
            case 8: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_poor_connection, new Object[0]);
                break;
            }
            case 9: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_switching_license, new Object[0]);
                break;
            }
            case 10: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_formatting_required, new Object[0]);
                break;
            }
            case 11: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_not_initialized, new Object[0]);
                break;
            }
            case 12: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_ssd_formatting_required, new Object[0]);
                break;
            }
            case 13: {
                string2 = ViewExtensions.getString((View)this, R.string.uxsdk_string_default_value, new Object[0]);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final int getSSDMessageColor(SSDOperationState ssdState) {
        return switch (WhenMappings.$EnumSwitchMapping$0[ssdState.ordinal()]) {
            case 2 -> this.getNormalValueColor();
            case 6 -> this.getErrorValueColor();
            default -> this.getWarningValueColor();
        };
    }

    private final boolean getFormatButtonVisibility(SSDOperationState ssdState) {
        return switch (WhenMappings.$EnumSwitchMapping$0[ssdState.ordinal()]) {
            case 2, 7, 10, 12 -> true;
            default -> false;
        };
    }

    private final void updateDisabledState(SSDStatusListItemWidgetModel.SSDState ssdState) {
        this.setListItemLabel(ssdState instanceof SSDStatusListItemWidgetModel.SSDState.ProductDisconnected ? ViewExtensions.getString((View)this, R.string.uxsdk_string_default_value, new Object[0]) : ViewExtensions.getString((View)this, R.string.uxsdk_storage_status_not_supported, new Object[0]));
        this.setListItemLabelTextColor(ssdState instanceof SSDStatusListItemWidgetModel.SSDState.ProductDisconnected ? this.getDisconnectedValueColor() : this.getErrorValueColor());
        this.setEnabled(false);
    }

    private final void formatSSD() {
        Ref.ObjectRef dialogType = new Ref.ObjectRef();
        DialogInterface.OnDismissListener dialogDismissListener = arg_0 -> SSDStatusListItemWidget.formatSSD$lambda$3(this, dialogType, arg_0);
        Disposable disposable = this.getWidgetModel().formatSSD().observeOn(SchedulerProvider.ui()).subscribe(() -> SSDStatusListItemWidget.formatSSD$lambda$4(dialogType, this, dialogDismissListener), new Consumer((Ref.ObjectRef<DialogType>)dialogType, this, dialogDismissListener){
            final /* synthetic */ Ref.ObjectRef<DialogType> $dialogType;
            final /* synthetic */ SSDStatusListItemWidget this$0;
            final /* synthetic */ DialogInterface.OnDismissListener $dialogDismissListener;
            {
                this.$dialogType = $dialogType;
                this.this$0 = $receiver;
                this.$dialogDismissListener = $dialogDismissListener;
            }

            public final void accept(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (error instanceof UXSDKError) {
                    this.$dialogType.element = DialogType.FormatError.INSTANCE;
                    String string2 = ViewExtensions.getString((View)this.this$0, R.string.uxsdk_ssd_dialog_title, new Object[0]);
                    Drawable drawable2 = this.this$0.getFormatErrorDialogIcon();
                    int n = this.this$0.getDialogTheme();
                    Object[] objectArray = new Object[]{((UXSDKError)error).getDJIError().description()};
                    String string3 = ViewExtensions.getString((View)this.this$0, R.string.uxsdk_ssd_format_error, objectArray);
                    ViewExtensions.showAlertDialog$default((View)this.this$0, n, string2, drawable2, string3, null, null, this.$dialogDismissListener, 48, null);
                    SSDStatusListItemWidget.access$getUiUpdateStateProcessor(this.this$0).onNext((Object)new ListItemLabelButtonWidget.UIState.DialogDisplayed(this.$dialogType.element));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        void $this$getResourceIdAndUse$iv;
        Drawable it;
        boolean bl;
        Drawable it$iv;
        TypedArray $this$getDrawableAndUse$iv;
        Drawable drawable$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SSDStatusListItemWidget, 0, this.getDefaultStyle());
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl2 = false;
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.SSDStatusListItemWidget_uxsdk_list_item_confirmation_dialog_icon;
        boolean $i$f$getDrawableAndUse = false;
        Drawable drawable2 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable2 != null) {
            it$iv = drawable2;
            bl = false;
            it = drawable$iv;
            boolean bl3 = false;
            this.formatConfirmationDialogIcon = it;
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SSDStatusListItemWidget_uxsdk_list_item_success_dialog_icon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable3 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable3 != null) {
            it$iv = drawable3;
            bl = false;
            it = drawable$iv;
            boolean bl4 = false;
            this.formatSuccessDialogIcon = it;
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SSDStatusListItemWidget_uxsdk_list_item_error_dialog_icon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable4 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable4 != null) {
            it$iv = drawable4;
            bl = false;
            it = drawable$iv;
            boolean bl5 = false;
            this.formatErrorDialogIcon = it;
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SSDStatusListItemWidget_uxsdk_list_item_dialog_theme;
        boolean $i$f$getResourceIdAndUse = false;
        int resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it2 = resourceId$iv;
            boolean bl6 = false;
            this.dialogTheme = it2;
        }
        Unit it$iv2 = unit = Unit.INSTANCE;
        boolean bl7 = false;
        $this$use$iv.recycle();
    }

    @Override
    @NotNull
    public WidgetSizeDescription getWidgetSizeDescription() {
        return this.widgetSizeDescription;
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @Override
    @NotNull
    public Flowable<ListItemLabelButtonWidget.UIState> getUIStateUpdates() {
        Flowable flowable = this.getUiUpdateStateProcessor().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"onBackpressureBuffer(...)");
        return flowable;
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @JvmOverloads
    public SSDStatusListItemWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SSDStatusListItemWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final SSDStatusListItemWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new SSDStatusListItemWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final void onButtonClick$lambda$1(SSDStatusListItemWidget this$0, DialogInterface dialogInterface, int buttonId) {
        if (buttonId == -1) {
            this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemLabelButtonWidget.UIState.DialogActionConfirmed(DialogType.FormatConfirmation.INSTANCE));
            this$0.formatSSD();
        } else {
            this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemLabelButtonWidget.UIState.DialogActionCanceled(DialogType.FormatConfirmation.INSTANCE));
        }
        dialogInterface.dismiss();
    }

    private static final void onButtonClick$lambda$2(SSDStatusListItemWidget this$0, DialogInterface it) {
        this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemLabelButtonWidget.UIState.DialogDismissed(DialogType.FormatConfirmation.INSTANCE));
    }

    private static final void formatSSD$lambda$3(SSDStatusListItemWidget this$0, Ref.ObjectRef $dialogType, DialogInterface it) {
        this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemLabelButtonWidget.UIState.DialogDismissed($dialogType.element));
    }

    private static final void formatSSD$lambda$4(Ref.ObjectRef $dialogType, SSDStatusListItemWidget this$0, DialogInterface.OnDismissListener $dialogDismissListener) {
        $dialogType.element = DialogType.FormatSuccess.INSTANCE;
        String string2 = ViewExtensions.getString((View)this$0, R.string.uxsdk_ssd_dialog_title, new Object[0]);
        Drawable drawable2 = this$0.formatSuccessDialogIcon;
        int n = this$0.dialogTheme;
        String string3 = ViewExtensions.getString((View)this$0, R.string.uxsdk_ssd_format_complete, new Object[0]);
        ViewExtensions.showAlertDialog$default((View)this$0, n, string2, drawable2, string3, null, null, $dialogDismissListener, 48, null);
        this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemLabelButtonWidget.UIState.DialogDisplayed($dialogType.element));
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(SSDStatusListItemWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    public static final /* synthetic */ void access$updateUI(SSDStatusListItemWidget $this, SSDStatusListItemWidgetModel.SSDState ssdState) {
        $this.updateUI(ssdState);
    }

    public static final /* synthetic */ PublishProcessor access$getUiUpdateStateProcessor(SSDStatusListItemWidget $this) {
        return $this.getUiUpdateStateProcessor();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType;", "", "<init>", "()V", "FormatConfirmation", "FormatSuccess", "FormatError", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType$FormatConfirmation;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType$FormatError;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType$FormatSuccess;", "android-sdk-v5-uxsdk_release"})
    public static abstract class DialogType {
        private DialogType() {
        }

        public /* synthetic */ DialogType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType$FormatConfirmation;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class FormatConfirmation
        extends DialogType {
            @NotNull
            public static final FormatConfirmation INSTANCE = new FormatConfirmation();

            private FormatConfirmation() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType$FormatError;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class FormatError
        extends DialogType {
            @NotNull
            public static final FormatError INSTANCE = new FormatError();

            private FormatError() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType$FormatSuccess;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$DialogType;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class FormatSuccess
        extends DialogType {
            @NotNull
            public static final FormatSuccess INSTANCE = new FormatSuccess();

            private FormatSuccess() {
                super(null);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "SSDStateUpdated", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState$SSDStateUpdated;", "android-sdk-v5-uxsdk_release"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState$SSDStateUpdated;", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidget$ModelState;", "ssdState", "Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidgetModel$SSDState;", "<init>", "(Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidgetModel$SSDState;)V", "getSsdState", "()Ldji/v5/ux/core/panel/listitem/ssdstatus/SSDStatusListItemWidgetModel$SSDState;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class SSDStateUpdated
        extends ModelState {
            @NotNull
            private final SSDStatusListItemWidgetModel.SSDState ssdState;

            public SSDStateUpdated(@NotNull SSDStatusListItemWidgetModel.SSDState ssdState) {
                Intrinsics.checkNotNullParameter((Object)ssdState, (String)"ssdState");
                super(null);
                this.ssdState = ssdState;
            }

            @NotNull
            public final SSDStatusListItemWidgetModel.SSDState getSsdState() {
                return this.ssdState;
            }

            @NotNull
            public final SSDStatusListItemWidgetModel.SSDState component1() {
                return this.ssdState;
            }

            @NotNull
            public final SSDStateUpdated copy(@NotNull SSDStatusListItemWidgetModel.SSDState ssdState) {
                Intrinsics.checkNotNullParameter((Object)ssdState, (String)"ssdState");
                return new SSDStateUpdated(ssdState);
            }

            public static /* synthetic */ SSDStateUpdated copy$default(SSDStateUpdated sSDStateUpdated, SSDStatusListItemWidgetModel.SSDState sSDState, int n, Object object) {
                if ((n & 1) != 0) {
                    sSDState = sSDStateUpdated.ssdState;
                }
                return sSDStateUpdated.copy(sSDState);
            }

            @NotNull
            public String toString() {
                return "SSDStateUpdated(ssdState=" + this.ssdState + ")";
            }

            public int hashCode() {
                return this.ssdState.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SSDStateUpdated)) {
                    return false;
                }
                SSDStateUpdated sSDStateUpdated = (SSDStateUpdated)other;
                return Intrinsics.areEqual((Object)this.ssdState, (Object)sSDStateUpdated.ssdState);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SSDOperationState.values().length];
            try {
                nArray[SSDOperationState.NOT_FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.IDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.SAVING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.FORMATTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.INITIALIZING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.STATE_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.FULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.POOR_CONNECTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.SWITCHING_LICENSE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.FORMATTING_REQUIRED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.NOT_INITIALIZED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.INVALID_FILE_SYSTEM.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSDOperationState.UNKNOWN.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

