/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.focusexposureswitch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraFocusMode;
import dji.sdk.keyvalue.value.camera.CameraMeteringMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.SettingDefinitions;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class FocusExposureSwitchWidgetModel
extends WidgetModel
implements ICameraIndex {
    private final DataProcessor<Boolean> isFocusModeSupportedDataProcessor;
    private final DataProcessor<CameraFocusMode> focusModeDataProcessor;
    private final DataProcessor<CameraMeteringMode> meteringModeDataProcessor;
    private final DataProcessor<SettingDefinitions.ControlMode> controlModeDataProcessor;
    private final GlobalPreferencesInterface preferencesManager;
    private UXKey controlModeKey;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public FocusExposureSwitchWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        super(djiSdkModel, keyedStore);
        this.focusModeDataProcessor = DataProcessor.create(CameraFocusMode.UNKNOWN);
        this.meteringModeDataProcessor = DataProcessor.create(CameraMeteringMode.UNKNOWN);
        this.controlModeDataProcessor = DataProcessor.create(SettingDefinitions.ControlMode.SPOT_METER);
        this.isFocusModeSupportedDataProcessor = DataProcessor.create(false);
        if (preferencesManager != null) {
            this.controlModeDataProcessor.onNext(preferencesManager.getControlMode());
        }
        this.preferencesManager = preferencesManager;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraFocusMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.focusModeDataProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraMeteringMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.meteringModeDataProcessor);
        this.controlModeKey = UXKeys.create("ControlMode");
        this.bindDataProcessor(this.controlModeKey, this.controlModeDataProcessor);
        if (this.preferencesManager != null) {
            this.preferencesManager.setUpListener();
        }
    }

    @Override
    protected void inCleanup() {
        if (this.preferencesManager != null) {
            this.preferencesManager.cleanup();
        }
    }

    @Override
    protected void updateStates() {
        this.updateFocusMode();
    }

    @Override
    protected void onProductConnectionChanged(boolean isConnected) {
    }

    public Flowable<Boolean> isFocusModeChangeSupported() {
        return this.isFocusModeSupportedDataProcessor.toFlowable();
    }

    public Flowable<SettingDefinitions.ControlMode> getControlMode() {
        return this.controlModeDataProcessor.toFlowable();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Completable switchControlMode() {
        SettingDefinitions.ControlMode currentControlMode = this.controlModeDataProcessor.getValue();
        if (currentControlMode == SettingDefinitions.ControlMode.SPOT_METER || currentControlMode == SettingDefinitions.ControlMode.CENTER_METER) {
            return this.setFocusMode();
        }
        return this.setMeteringMode();
    }

    private void updateFocusMode() {
        SettingDefinitions.ControlMode currentControlMode = this.controlModeDataProcessor.getValue();
        if (currentControlMode != SettingDefinitions.ControlMode.SPOT_METER && currentControlMode != SettingDefinitions.ControlMode.CENTER_METER) {
            this.setFocusMode();
        }
    }

    private Completable setMeteringMode() {
        if (this.djiSdkModel.getCacheValue(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraMeteringMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType)) == CameraMeteringMode.REGION) {
            return Completable.fromAction(() -> {
                this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.SPOT_METER);
                this.addDisposable(this.uxKeyManager.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.SPOT_METER).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(this.tag, "setMeteringMode: ")));
            });
        }
        return this.djiSdkModel.setValue(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraMeteringMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), CameraMeteringMode.REGION).doOnComplete(() -> {
            this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.SPOT_METER);
            this.addDisposable(this.uxKeyManager.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.SPOT_METER).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(this.tag, "setMeteringMode: ")));
        }).doOnError(error -> this.setFocusMode());
    }

    private Completable setFocusMode() {
        if (this.controlModeKey == null || this.preferencesManager == null) {
            return Completable.complete();
        }
        LogUtils.d((String)this.tag, (Object[])new Object[]{"In setFocusMode ControlModeKey Value Type " + this.controlModeKey.getValueType()});
        if (this.focusModeDataProcessor.getValue() == CameraFocusMode.MANUAL) {
            this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.MANUAL_FOCUS);
            return this.uxKeyManager.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.MANUAL_FOCUS);
        }
        if (this.focusModeDataProcessor.getValue() == CameraFocusMode.AFC) {
            this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE);
            return this.uxKeyManager.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE);
        }
        this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.AUTO_FOCUS);
        return this.uxKeyManager.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.AUTO_FOCUS);
    }
}

