/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.gmap.annotations;

import com.google.android.gms.maps.model.Marker;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.gmap.map.GMapDelegate;
import dji.v5.ux.mapkit.gmap.utils.GoogleUtils;

public class GMarker
extends DJIMarker {
    private Marker mMarker;
    private GMapDelegate gMap;

    public GMarker(Marker marker, GMapDelegate map) {
        this.mMarker = marker;
        this.gMap = map;
    }

    @Override
    public void setPosition(DJILatLng latLng) {
        this.setPositionCache(latLng);
        this.mMarker.setPosition(GoogleUtils.fromDJILatLng(latLng));
    }

    @Override
    public void setRotation(float rotate) {
        this.mMarker.setRotation(rotate);
    }

    @Override
    public void setIcon(DJIBitmapDescriptor icon) {
        this.mMarker.setIcon(GoogleUtils.fromDJIBitmapDescriptor(icon));
    }

    @Override
    public void setAnchor(float u, float v) {
        this.mMarker.setAnchor(u, v);
    }

    @Override
    public void setTitle(String title) {
        this.mMarker.setTitle(title);
    }

    @Override
    public void setVisible(boolean visible) {
        this.mMarker.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.mMarker.isVisible();
    }

    @Override
    public void showInfoWindow() {
        this.mMarker.showInfoWindow();
    }

    @Override
    public void hideInfoWindow() {
        this.mMarker.hideInfoWindow();
    }

    @Override
    public boolean isInfoWindowShown() {
        return this.mMarker.isInfoWindowShown();
    }

    @Override
    public void remove() {
        this.mMarker.remove();
        this.gMap.onMarkerRemove(this.mMarker);
    }

    @Override
    public String getTitle() {
        return this.mMarker.getTitle();
    }

    @Override
    public void setDraggable(boolean b) {
        this.mMarker.setDraggable(b);
    }

    @Override
    public boolean isDraggable() {
        return this.mMarker.isDraggable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GMarker gMarker = (GMarker)o;
        return this.mMarker != null ? this.mMarker.equals((Object)gMarker.mMarker) : gMarker.mMarker == null;
    }

    public int hashCode() {
        return this.mMarker != null ? this.mMarker.hashCode() : 0;
    }
}

