/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.gimbal;

import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.GimbalKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.gimbal.FineTunePostureMsg;
import dji.sdk.keyvalue.value.gimbal.PostureFineTuneAxis;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.IGimbalIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ\b\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldji/v5/ux/gimbal/GimbalFineTuneWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "Ldji/v5/ux/core/base/IGimbalIndex;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "uxKeyManager", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;)V", "gimbalIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "rollAdjustDegreeProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "kotlin.jvm.PlatformType", "yawAdjustDegreeProcessor", "pitchAdjustDegreeProcessor", "inSetup", "", "inCleanup", "fineTunePosture", "Lio/reactivex/rxjava3/core/Completable;", "axis", "Ldji/sdk/keyvalue/value/gimbal/PostureFineTuneAxis;", "value", "rollAdjustDegree", "Lio/reactivex/rxjava3/core/Flowable;", "yawAdjustDegree", "pitchAdjustDegree", "getGimbalIndex", "updateGimbalIndex", "android-sdk-v5-uxsdk_release"})
public class GimbalFineTuneWidgetModel
extends WidgetModel
implements IGimbalIndex {
    @NotNull
    private ComponentIndexType gimbalIndex;
    @NotNull
    private final DataProcessor<Double> rollAdjustDegreeProcessor;
    @NotNull
    private final DataProcessor<Double> yawAdjustDegreeProcessor;
    @NotNull
    private final DataProcessor<Double> pitchAdjustDegreeProcessor;

    public GimbalFineTuneWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore uxKeyManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)uxKeyManager, (String)"uxKeyManager");
        super(djiSdkModel, uxKeyManager);
        this.gimbalIndex = ComponentIndexType.LEFT_OR_MAIN;
        DataProcessor<Double> dataProcessor = DataProcessor.create(0.0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.rollAdjustDegreeProcessor = dataProcessor;
        DataProcessor<Double> dataProcessor2 = DataProcessor.create(0.0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.yawAdjustDegreeProcessor = dataProcessor2;
        DataProcessor<Double> dataProcessor3 = DataProcessor.create(0.0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.pitchAdjustDegreeProcessor = dataProcessor3;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyFineTuneRollTotalDegree, (ComponentIndexType)this.gimbalIndex), this.rollAdjustDegreeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyFineTuneYawTotalDegree, (ComponentIndexType)this.gimbalIndex), this.yawAdjustDegreeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyFineTunePitchTotalDegree, (ComponentIndexType)this.gimbalIndex), this.pitchAdjustDegreeProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @NotNull
    public final Completable fineTunePosture(@NotNull PostureFineTuneAxis axis, double value) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)GimbalKey.KeyFineTunePosture, (ComponentIndexType)this.gimbalIndex), new FineTunePostureMsg(axis, Double.valueOf(value)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"performActionWithOutResult(...)");
        return completable;
    }

    @NotNull
    public final Flowable<Double> rollAdjustDegree() {
        Flowable<Double> flowable = this.rollAdjustDegreeProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<Double> yawAdjustDegree() {
        Flowable<Double> flowable = this.yawAdjustDegreeProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<Double> pitchAdjustDegree() {
        Flowable<Double> flowable = this.pitchAdjustDegreeProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    @NotNull
    public ComponentIndexType getGimbalIndex() {
        return this.gimbalIndex;
    }

    @Override
    public void updateGimbalIndex(@NotNull ComponentIndexType gimbalIndex) {
        Intrinsics.checkNotNullParameter((Object)gimbalIndex, (String)"gimbalIndex");
        if (this.gimbalIndex != gimbalIndex) {
            this.gimbalIndex = gimbalIndex;
            this.restart();
        }
    }
}

