/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.TabSelectCell;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.ChannelContract;
import dji.v5.ux.core.widget.hd.ChannelSelectWidgetModel;
import java.util.List;

public class ChannelSelectWidget
extends ConstraintLayoutWidget<Object>
implements ChannelContract.View,
TabSelectCell.OnTabChangeListener {
    private static final String TAG = "ChannelSelectWidget";
    TabSelectCell mChannelModeTabCell;
    private boolean mIsChangingChannelMode;
    ChannelSelectWidgetModel widgetModel = new ChannelSelectWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());

    public ChannelSelectWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ChannelSelectWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ChannelSelectWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    public void onTabChanged(TabSelectCell cell, int oldIndex, int newIndex) {
        this.addDisposable(this.widgetModel.setChannelSelectionMode(newIndex == 0 ? ChannelSelectionMode.AUTO : ChannelSelectionMode.MANUAL).subscribe(() -> {}, throwable -> {
            LogUtils.e((String)TAG, (Object[])new Object[]{"setChannelSelectionMode fail: " + throwable});
            this.onChannelSelectionModeFailed(oldIndex);
            this.onDidSetChannelSelectionMode();
        }));
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ChannelSelectWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_sdr_channel_select_layout, (ViewGroup)this);
        this.mChannelModeTabCell = (TabSelectCell)this.findViewById(R.id.tsc_setting_menu_channel_select_tab_cell);
        this.mChannelModeTabCell.setOnTabChangeListener(this);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getChannelSelectionMode().subscribe(value -> this.updateChannelMode(ChannelSelectionMode.AUTO == value)));
    }

    @Override
    public void updateSupportDataRates(List<String> bands) {
    }

    @Override
    public void initSlaveViews() {
    }

    @Override
    public void updateVideoCameras(boolean enable) {
    }

    @Override
    public void updateChannelMode(boolean auto) {
        if (this.mChannelModeTabCell != null) {
            this.mChannelModeTabCell.setOnTabChangeListener(null);
            this.mChannelModeTabCell.setCurrentTab(auto ? 0 : 1);
            this.mChannelModeTabCell.setOnTabChangeListener(this);
        }
    }

    private void onDidSetChannelSelectionMode() {
        this.mIsChangingChannelMode = false;
        this.updateChannelModeTabEnable();
    }

    private void updateChannelModeTabEnable() {
        if (this.mChannelModeTabCell != null) {
            this.mChannelModeTabCell.setEnabled(!this.mIsChangingChannelMode);
        }
    }

    private void onChannelSelectionModeFailed(int oldIndex) {
        if (this.mChannelModeTabCell != null) {
            this.mChannelModeTabCell.setOnTabChangeListener(null);
            this.mChannelModeTabCell.setCurrentTab(oldIndex);
            this.mChannelModeTabCell.setOnTabChangeListener(this);
        }
    }
}

