/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.gpssignal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.v5.manager.aircraft.rtk.RTKCenter;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.accessory.RTKEnabledWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.popover.Popover;
import dji.v5.ux.core.popover.PopoverHelper;
import dji.v5.ux.core.widget.gpssignal.GpsSignalPopoverView;
import dji.v5.ux.core.widget.gpssignal.GpsSignalWidgetModel;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010$\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010&\u001a\u00020%H\u0014J\b\u0010'\u001a\u00020%H\u0014J\b\u0010(\u001a\u00020%H\u0014J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0011H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b!\u0010\"\u00a8\u0006."}, d2={"Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "ivRtkIcon", "Landroid/widget/ImageView;", "ivSatelliteIcon", "tvSatelliteCount", "Landroid/widget/TextView;", "rtkOverView", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkOverview;", "rootView", "Landroidx/constraintlayout/widget/ConstraintLayout;", "rtkEnabledWidgetModel", "Ldji/v5/ux/accessory/RTKEnabledWidgetModel;", "getRtkEnabledWidgetModel", "()Ldji/v5/ux/accessory/RTKEnabledWidgetModel;", "rtkEnabledWidgetModel$delegate", "Lkotlin/Lazy;", "popover", "Ldji/v5/ux/core/popover/Popover;", "getPopover", "()Ldji/v5/ux/core/popover/Popover;", "popover$delegate", "gpsSignalWidgetModel", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel;", "getGpsSignalWidgetModel", "()Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel;", "gpsSignalWidgetModel$delegate", "initView", "", "onAttachedToWindow", "onDetachedFromWindow", "reactToModelChanges", "updateRtkIcon", "overview", "getTintColor", "level", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$SignalLevel;", "android-sdk-v5-uxsdk_release"})
public final class GpsSignalWidget
extends ConstraintLayoutWidget<Boolean> {
    @NotNull
    private final ImageView ivRtkIcon;
    @NotNull
    private final ImageView ivSatelliteIcon;
    @NotNull
    private final TextView tvSatelliteCount;
    @NotNull
    private GpsSignalWidgetModel.RtkOverview rtkOverView;
    @NotNull
    private final ConstraintLayout rootView;
    @NotNull
    private final Lazy rtkEnabledWidgetModel$delegate;
    @NotNull
    private final Lazy popover$delegate;
    @NotNull
    private final Lazy gpsSignalWidgetModel$delegate;

    @JvmOverloads
    public GpsSignalWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View view = this.findViewById(R.id.iv_rtk_icon);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.ivRtkIcon = (ImageView)view;
        View view2 = this.findViewById(R.id.iv_satellite_icon);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.ivSatelliteIcon = (ImageView)view2;
        View view3 = this.findViewById(R.id.tv_satellite_count);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.tvSatelliteCount = (TextView)view3;
        this.rtkOverView = new GpsSignalWidgetModel.RtkOverview(false, false, false, null, null, false, 63, null);
        View view4 = this.findViewById(R.id.root_view);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.rootView = (ConstraintLayout)view4;
        this.rtkEnabledWidgetModel$delegate = LazyKt.lazy(GpsSignalWidget::rtkEnabledWidgetModel_delegate$lambda$0);
        this.popover$delegate = LazyKt.lazy(() -> GpsSignalWidget.popover_delegate$lambda$1(this, context));
        this.gpsSignalWidgetModel$delegate = LazyKt.lazy(GpsSignalWidget::gpsSignalWidgetModel_delegate$lambda$2);
        this.setOnClickListener(arg_0 -> GpsSignalWidget._init_$lambda$3(this, arg_0));
    }

    public /* synthetic */ GpsSignalWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final RTKEnabledWidgetModel getRtkEnabledWidgetModel() {
        Lazy lazy = this.rtkEnabledWidgetModel$delegate;
        return (RTKEnabledWidgetModel)lazy.getValue();
    }

    private final Popover getPopover() {
        Lazy lazy = this.popover$delegate;
        return (Popover)lazy.getValue();
    }

    private final GpsSignalWidgetModel getGpsSignalWidgetModel() {
        Lazy lazy = this.gpsSignalWidgetModel$delegate;
        return (GpsSignalWidgetModel)lazy.getValue();
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_fpv_top_bar_widget_gps_signal, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getGpsSignalWidgetModel().setup();
            this.getRtkEnabledWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getGpsSignalWidgetModel().cleanup();
            this.getRtkEnabledWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getGpsSignalWidgetModel().getRtkOverview().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(GpsSignalWidgetModel.RtkOverview it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GpsSignalWidget.access$setRtkOverView$p(this.this$0, it);
                GpsSignalWidget.access$updateRtkIcon(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getGpsSignalWidgetModel().getGpsSatelliteCount().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!GpsSignalWidget.access$getRtkOverView$p(this.this$0).getRtkHealthy()) {
                    Object[] objectArray = new Object[]{"rtk is  not healthy,use gpsSatelliteCount"};
                    LogUtils.d((String)GpsSignalWidget.access$getLogTag(this.this$0), (Object[])objectArray);
                    GpsSignalWidget.access$getTvSatelliteCount$p(this.this$0).setText((CharSequence)String.valueOf(it));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getGpsSignalWidgetModel().getRtkSatelliteCount().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (GpsSignalWidget.access$getRtkOverView$p(this.this$0).getRtkHealthy()) {
                    Object[] objectArray = new Object[]{"rtk is healthy,use rtkSatelliteCount"};
                    LogUtils.d((String)GpsSignalWidget.access$getLogTag(this.this$0), (Object[])objectArray);
                    GpsSignalWidget.access$getTvSatelliteCount$p(this.this$0).setText((CharSequence)String.valueOf(it));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
        Disposable disposable4 = this.getGpsSignalWidgetModel().getGpsSignalLevel().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(GpsSignalWidgetModel.SignalLevel it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                GpsSignalWidget.access$getIvSatelliteIcon$p(this.this$0).setColorFilter(GpsSignalWidget.access$getTintColor(this.this$0, it));
                GpsSignalWidget.access$getTvSatelliteCount$p(this.this$0).setTextColor(GpsSignalWidget.access$getTintColor(this.this$0, it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"subscribe(...)");
        this.addReaction(disposable4);
    }

    private final void updateRtkIcon(GpsSignalWidgetModel.RtkOverview overview) {
        this.ivRtkIcon.setVisibility(overview.getConnected() ? 0 : 8);
        if (overview.getEnabled()) {
            if (overview.getRtkKeepingStatus()) {
                this.ivRtkIcon.setImageResource(R.drawable.uxsdk_ic_fpv_topbar_rtk_caution);
            } else if (overview.getRtkHealthy()) {
                this.ivRtkIcon.setImageResource(R.drawable.uxsdk_ic_fpv_topbar_rtk_normal);
            } else {
                this.ivRtkIcon.setImageResource(R.drawable.uxsdk_ic_fpv_topbar_rtk_danger);
            }
        } else {
            this.ivRtkIcon.setImageResource(R.drawable.uxsdk_ic_fpv_topbar_rtk_no_open);
        }
    }

    private final int getTintColor(GpsSignalWidgetModel.SignalLevel level) {
        return switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1 -> this.getResources().getColor(R.color.uxsdk_tips_danger_in_dark);
            case 2 -> this.getResources().getColor(R.color.uxsdk_tips_caution_in_dark);
            case 3 -> this.getResources().getColor(R.color.uxsdk_tips_normal_in_dark);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmOverloads
    public GpsSignalWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GpsSignalWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final RTKEnabledWidgetModel rtkEnabledWidgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new RTKEnabledWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final Popover popover_delegate$lambda$1(GpsSignalWidget this$0, Context $context) {
        return PopoverHelper.showPopover$default(PopoverHelper.INSTANCE, (View)this$0.rootView, (View)new GpsSignalPopoverView($context, null, 0, 6, null), 0, 0, 12, null);
    }

    private static final GpsSignalWidgetModel gpsSignalWidgetModel_delegate$lambda$2() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        IRTKCenter iRTKCenter = RTKCenter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)iRTKCenter, (String)"getInstance(...)");
        return new GpsSignalWidgetModel(dJISDKModel, observableInMemoryKeyedStore, iRTKCenter);
    }

    private static final void _init_$lambda$3(GpsSignalWidget this$0, View it) {
        if (!this$0.getPopover().isShowing()) {
            this$0.getPopover().show();
        }
    }

    public static final /* synthetic */ void access$setRtkOverView$p(GpsSignalWidget $this, GpsSignalWidgetModel.RtkOverview rtkOverview) {
        $this.rtkOverView = rtkOverview;
    }

    public static final /* synthetic */ void access$updateRtkIcon(GpsSignalWidget $this, GpsSignalWidgetModel.RtkOverview overview) {
        $this.updateRtkIcon(overview);
    }

    public static final /* synthetic */ GpsSignalWidgetModel.RtkOverview access$getRtkOverView$p(GpsSignalWidget $this) {
        return $this.rtkOverView;
    }

    public static final /* synthetic */ String access$getLogTag(GpsSignalWidget $this) {
        return $this.getLogTag();
    }

    public static final /* synthetic */ TextView access$getTvSatelliteCount$p(GpsSignalWidget $this) {
        return $this.tvSatelliteCount;
    }

    public static final /* synthetic */ ImageView access$getIvSatelliteIcon$p(GpsSignalWidget $this) {
        return $this.ivSatelliteIcon;
    }

    public static final /* synthetic */ int access$getTintColor(GpsSignalWidget $this, GpsSignalWidgetModel.SignalLevel level) {
        return $this.getTintColor(level);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GpsSignalWidgetModel.SignalLevel.values().length];
            try {
                nArray[GpsSignalWidgetModel.SignalLevel.LEVEL_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.SignalLevel.LEVEL_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.SignalLevel.LEVEL_3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

