/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.ImageViewCompat;

public final class ViewUtil {
    private static final Handler UI_Handler = new Handler(Looper.getMainLooper());

    private ViewUtil() {
    }

    public static void tintImage(@NonNull ImageView imageView, @ColorInt int color2) {
        if (imageView.getDrawable() == null) {
            return;
        }
        Drawable wrapDrawable = DrawableCompat.wrap((Drawable)imageView.getDrawable().mutate());
        DrawableCompat.setTint((Drawable)wrapDrawable, (int)color2);
        if (Build.VERSION.SDK_INT == 21) {
            imageView.invalidate();
        }
    }

    public static void tintImage(@NonNull ImageView imageView, @NonNull ColorStateList colorStateList) {
        ImageViewCompat.setImageTintList((ImageView)imageView, (ColorStateList)colorStateList);
    }

    @NonNull
    public static Bitmap getBitmapFromVectorDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 21) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2).mutate();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static void showToast(Context context, int resId, int duration) {
        ViewUtil.showToast(context, context.getString(resId), duration);
    }

    public static void showToast(Context context, String message, int duration) {
        if (context == null) {
            return;
        }
        Runnable runnable = () -> Toast.makeText((Context)context, (CharSequence)message, (int)duration).show();
        if (UI_Handler.getLooper().isCurrentThread()) {
            runnable.run();
        } else {
            UI_Handler.post(runnable);
        }
    }

    public static void showToast(Context context, String message) {
        ViewUtil.showToast(context, message, 0);
    }

    public static boolean dispatchKeyEvent(Context context, KeyEvent keyEvent) {
        Activity activity = ViewUtil.contextToActivity(context);
        if (activity != null) {
            activity.dispatchKeyEvent(keyEvent);
            return true;
        }
        return false;
    }

    public static Activity contextToActivity(Context context) {
        Context context2;
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper && (context2 = ((ContextWrapper)context).getBaseContext()) instanceof Activity) {
            return (Activity)context2;
        }
        return null;
    }

    public static void setKeepScreen(Activity activity, boolean isKeep) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        if (isKeep) {
            window.addFlags(128);
        } else {
            window.clearFlags(128);
        }
    }
}

