/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.LogUtils;
import io.reactivex.rxjava3.functions.Consumer;

public final class UxErrorHandle {
    private UxErrorHandle() {
    }

    public static Consumer<Throwable> logErrorConsumer(@NonNull String tag, @NonNull String message) {
        return UxErrorHandle.errorConsumer(null, tag, message);
    }

    public static Consumer<Throwable> errorConsumer(@Nullable errorHandler handler, @NonNull String tag, @NonNull String message) {
        return throwable -> {
            if (handler != null) {
                handler.onErrorHandler();
            }
            LogUtils.e((String)tag, (Object[])new Object[]{message + throwable.getLocalizedMessage()});
        };
    }

    public static interface errorHandler {
        public void onErrorHandler();
    }
}

