/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import androidx.annotation.IntRange;
import dji.sdk.keyvalue.key.BatteryKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.battery.BatteryException;
import dji.sdk.keyvalue.value.battery.BatteryOverviewValue;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.flightcontroller.FCBatteryThresholdBehavior;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.MathExtensions;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u000289B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020'H\u0014J\b\u0010)\u001a\u00020'H\u0014J\b\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020-2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eH\u0002J8\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020-H\u0002J\f\u00107\u001a\u00020\u0017*\u00020\u0011H\u0002R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00170\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00170\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00170\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00170\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00170\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u001f0\u001f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006:"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;)V", "batteryPercentageProcessor1", "Ldji/v5/ux/core/util/DataProcessor;", "", "kotlin.jvm.PlatformType", "batteryPercentageProcessor2", "batteryVoltageProcessor1", "", "batteryVoltageProcessor2", "batteryWarningRecordProcessor1", "Ldji/sdk/keyvalue/value/battery/BatteryException;", "batteryWarningRecordProcessor2", "batteryOverviewsProcessor", "Ldji/sdk/keyvalue/value/battery/BatteryOverviewValue;", "batteryConnectedProcessor", "isAnyBatteryDisconnectedProcessor", "", "isCellDamagedDisconnectedProcessor", "isFirmwareDifferenceDetectedProcessor", "isVoltageDifferenceDetectedProcessor", "isLowCellVoltageDetectedProcessor", "batteryStateProcessor", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "batteryThresholdBehaviorProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/FCBatteryThresholdBehavior;", "batteryNeededToGoHomeProcessor", "isAircraftFlyingDataProcessor", "batteryState", "Lio/reactivex/rxjava3/core/Flowable;", "getBatteryState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "updateStates", "inCleanup", "findConnectedBattery", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "calculateAverageVoltage", "", "cellVoltages", "calculateBatteryStatus", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "batteryException", "batteryThresholdBehavior", "percentage", "goHomeBattery", "isFlying", "voltage", "isError", "BatteryState", "BatteryStatus", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nBatteryWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatteryWidgetModel.kt\ndji/v5/ux/core/widget/battery/BatteryWidgetModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,400:1\n766#2:401\n857#2,2:402\n*S KotlinDebug\n*F\n+ 1 BatteryWidgetModel.kt\ndji/v5/ux/core/widget/battery/BatteryWidgetModel\n*L\n253#1:401\n253#1:402,2\n*E\n"})
public final class BatteryWidgetModel
extends WidgetModel {
    @NotNull
    private final DataProcessor<Integer> batteryPercentageProcessor1;
    @NotNull
    private final DataProcessor<Integer> batteryPercentageProcessor2;
    @NotNull
    private final DataProcessor<List<Integer>> batteryVoltageProcessor1;
    @NotNull
    private final DataProcessor<List<Integer>> batteryVoltageProcessor2;
    @NotNull
    private final DataProcessor<BatteryException> batteryWarningRecordProcessor1;
    @NotNull
    private final DataProcessor<BatteryException> batteryWarningRecordProcessor2;
    @NotNull
    private final DataProcessor<List<BatteryOverviewValue>> batteryOverviewsProcessor;
    @NotNull
    private final DataProcessor<Integer> batteryConnectedProcessor;
    @NotNull
    private final DataProcessor<Boolean> isAnyBatteryDisconnectedProcessor;
    @NotNull
    private final DataProcessor<Boolean> isCellDamagedDisconnectedProcessor;
    @NotNull
    private final DataProcessor<Boolean> isFirmwareDifferenceDetectedProcessor;
    @NotNull
    private final DataProcessor<Boolean> isVoltageDifferenceDetectedProcessor;
    @NotNull
    private final DataProcessor<Boolean> isLowCellVoltageDetectedProcessor;
    @NotNull
    private final DataProcessor<BatteryState> batteryStateProcessor;
    @NotNull
    private final DataProcessor<FCBatteryThresholdBehavior> batteryThresholdBehaviorProcessor;
    @NotNull
    private final DataProcessor<Integer> batteryNeededToGoHomeProcessor;
    @NotNull
    private final DataProcessor<Boolean> isAircraftFlyingDataProcessor;

    public BatteryWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        DataProcessor<Integer> dataProcessor = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.batteryPercentageProcessor1 = dataProcessor;
        DataProcessor<Integer> dataProcessor2 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.batteryPercentageProcessor2 = dataProcessor2;
        DataProcessor dataProcessor3 = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.batteryVoltageProcessor1 = dataProcessor3;
        DataProcessor dataProcessor4 = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.batteryVoltageProcessor2 = dataProcessor4;
        DataProcessor<BatteryException> dataProcessor5 = DataProcessor.create(new BatteryException());
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.batteryWarningRecordProcessor1 = dataProcessor5;
        DataProcessor<BatteryException> dataProcessor6 = DataProcessor.create(new BatteryException());
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.batteryWarningRecordProcessor2 = dataProcessor6;
        DataProcessor dataProcessor7 = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor7, (String)"create(...)");
        this.batteryOverviewsProcessor = dataProcessor7;
        DataProcessor<Integer> dataProcessor8 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor8, (String)"create(...)");
        this.batteryConnectedProcessor = dataProcessor8;
        DataProcessor<Boolean> dataProcessor9 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor9, (String)"create(...)");
        this.isAnyBatteryDisconnectedProcessor = dataProcessor9;
        DataProcessor<Boolean> dataProcessor10 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor10, (String)"create(...)");
        this.isCellDamagedDisconnectedProcessor = dataProcessor10;
        DataProcessor<Boolean> dataProcessor11 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor11, (String)"create(...)");
        this.isFirmwareDifferenceDetectedProcessor = dataProcessor11;
        DataProcessor<Boolean> dataProcessor12 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor12, (String)"create(...)");
        this.isVoltageDifferenceDetectedProcessor = dataProcessor12;
        DataProcessor<Boolean> dataProcessor13 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor13, (String)"create(...)");
        this.isLowCellVoltageDetectedProcessor = dataProcessor13;
        DataProcessor<BatteryState.DisconnectedState> dataProcessor14 = DataProcessor.create(BatteryState.DisconnectedState.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(dataProcessor14, (String)"create(...)");
        this.batteryStateProcessor = dataProcessor14;
        DataProcessor<FCBatteryThresholdBehavior> dataProcessor15 = DataProcessor.create(FCBatteryThresholdBehavior.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor15, (String)"create(...)");
        this.batteryThresholdBehaviorProcessor = dataProcessor15;
        DataProcessor<Integer> dataProcessor16 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor16, (String)"create(...)");
        this.batteryNeededToGoHomeProcessor = dataProcessor16;
        DataProcessor<Boolean> dataProcessor17 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor17, (String)"create(...)");
        this.isAircraftFlyingDataProcessor = dataProcessor17;
    }

    @NotNull
    public final Flowable<BatteryState> getBatteryState() {
        Flowable<BatteryState> flowable = this.batteryStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyChargeRemainingInPercent, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.batteryPercentageProcessor1);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyCellVoltages, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.batteryVoltageProcessor1);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyBatteryException, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.batteryWarningRecordProcessor1);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyChargeRemainingInPercent, (ComponentIndexType)ComponentIndexType.RIGHT), this.batteryPercentageProcessor2);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyCellVoltages, (ComponentIndexType)ComponentIndexType.RIGHT), this.batteryVoltageProcessor2);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyBatteryException, (ComponentIndexType)ComponentIndexType.RIGHT), this.batteryWarningRecordProcessor2);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyNumberOfConnectedBatteries, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.batteryConnectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyIsAnyBatteryDisconnected, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.isAnyBatteryDisconnectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyIsCellDamaged, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.isCellDamagedDisconnectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyIsFirmwareDifferenceDetected, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.isFirmwareDifferenceDetectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyIsVoltageDifferenceDetected, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.isVoltageDifferenceDetectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyIsLowCellVoltageDetected, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.isLowCellVoltageDetectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyBatteryOverviews, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.batteryOverviewsProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyBatteryThresholdBehavior), this.batteryThresholdBehaviorProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyBatteryPercentNeededToGoHome), this.batteryNeededToGoHomeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsFlying), this.isAircraftFlyingDataProcessor);
    }

    @Override
    protected void updateStates() {
        if (((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            Integer n = this.batteryConnectedProcessor.getValue();
            int n2 = 2;
            if (n != null && n == n2) {
                float battery1Voltage = this.calculateAverageVoltage(this.batteryVoltageProcessor1.getValue());
                float battery2Voltage = this.calculateAverageVoltage(this.batteryVoltageProcessor2.getValue());
                Integer n3 = this.batteryPercentageProcessor1.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getValue(...)");
                int n4 = ((Number)n3).intValue();
                BatteryException batteryException = this.batteryWarningRecordProcessor1.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)batteryException, (String)"getValue(...)");
                FCBatteryThresholdBehavior fCBatteryThresholdBehavior = this.batteryThresholdBehaviorProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)fCBatteryThresholdBehavior, (String)"getValue(...)");
                Integer n5 = this.batteryPercentageProcessor1.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"getValue(...)");
                int n6 = ((Number)n5).intValue();
                Integer n7 = this.batteryNeededToGoHomeProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"getValue(...)");
                int n8 = ((Number)n7).intValue();
                Boolean bl = this.isAircraftFlyingDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getValue(...)");
                BatteryStatus batteryStatus = this.calculateBatteryStatus(batteryException, fCBatteryThresholdBehavior, n6, n8, bl, battery1Voltage);
                Integer n9 = this.batteryPercentageProcessor2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n9, (String)"getValue(...)");
                int n10 = ((Number)n9).intValue();
                BatteryException batteryException2 = this.batteryWarningRecordProcessor2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)batteryException2, (String)"getValue(...)");
                FCBatteryThresholdBehavior fCBatteryThresholdBehavior2 = this.batteryThresholdBehaviorProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)fCBatteryThresholdBehavior2, (String)"getValue(...)");
                Integer n11 = this.batteryPercentageProcessor2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n11, (String)"getValue(...)");
                int n12 = ((Number)n11).intValue();
                Integer n13 = this.batteryNeededToGoHomeProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n13, (String)"getValue(...)");
                int n14 = ((Number)n13).intValue();
                Boolean bl2 = this.isAircraftFlyingDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getValue(...)");
                this.batteryStateProcessor.onNext(new BatteryState.DualBatteryState(n4, battery1Voltage, batteryStatus, n10, battery2Voltage, this.calculateBatteryStatus(batteryException2, fCBatteryThresholdBehavior2, n12, n14, bl2, battery2Voltage)));
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[this.findConnectedBattery().ordinal()]) {
                    case 1: {
                        float voltage = this.calculateAverageVoltage(this.batteryVoltageProcessor1.getValue());
                        Integer n15 = this.batteryPercentageProcessor1.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)n15, (String)"getValue(...)");
                        int n16 = ((Number)n15).intValue();
                        BatteryException batteryException = this.batteryWarningRecordProcessor1.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)batteryException, (String)"getValue(...)");
                        FCBatteryThresholdBehavior fCBatteryThresholdBehavior = this.batteryThresholdBehaviorProcessor.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)fCBatteryThresholdBehavior, (String)"getValue(...)");
                        Integer n17 = this.batteryPercentageProcessor1.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)n17, (String)"getValue(...)");
                        int n18 = ((Number)n17).intValue();
                        Integer n19 = this.batteryNeededToGoHomeProcessor.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)n19, (String)"getValue(...)");
                        int n20 = ((Number)n19).intValue();
                        Boolean bl = this.isAircraftFlyingDataProcessor.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getValue(...)");
                        this.batteryStateProcessor.onNext(new BatteryState.SingleBatteryState(n16, voltage, this.calculateBatteryStatus(batteryException, fCBatteryThresholdBehavior, n18, n20, bl, voltage)));
                        break;
                    }
                    case 2: {
                        float voltage = this.calculateAverageVoltage(this.batteryVoltageProcessor2.getValue());
                        Integer n21 = this.batteryPercentageProcessor2.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)n21, (String)"getValue(...)");
                        int n22 = ((Number)n21).intValue();
                        BatteryException batteryException = this.batteryWarningRecordProcessor2.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)batteryException, (String)"getValue(...)");
                        FCBatteryThresholdBehavior fCBatteryThresholdBehavior = this.batteryThresholdBehaviorProcessor.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)fCBatteryThresholdBehavior, (String)"getValue(...)");
                        Integer n23 = this.batteryPercentageProcessor2.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)n23, (String)"getValue(...)");
                        int n24 = ((Number)n23).intValue();
                        Integer n25 = this.batteryNeededToGoHomeProcessor.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)n25, (String)"getValue(...)");
                        int n26 = ((Number)n25).intValue();
                        Boolean bl = this.isAircraftFlyingDataProcessor.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getValue(...)");
                        this.batteryStateProcessor.onNext(new BatteryState.SingleBatteryState(n22, voltage, this.calculateBatteryStatus(batteryException, fCBatteryThresholdBehavior, n24, n26, bl, voltage)));
                    }
                }
            }
        } else {
            this.batteryStateProcessor.onNext(BatteryState.DisconnectedState.INSTANCE);
        }
    }

    @Override
    protected void inCleanup() {
    }

    /*
     * WARNING - void declaration
     */
    private final ComponentIndexType findConnectedBattery() {
        Integer n;
        void $this$filterTo$iv$iv;
        List<BatteryOverviewValue> list = this.batteryOverviewsProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValue(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BatteryOverviewValue it = (BatteryOverviewValue)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = it.getIsConnected();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getIsConnected(...)");
            if (!bl2.booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        BatteryOverviewValue batteryOverviewValue = (BatteryOverviewValue)CollectionsKt.getOrNull((List)((List)destination$iv$iv), (int)0);
        int batteryIndex = batteryOverviewValue != null && (n = batteryOverviewValue.getIndex()) != null ? n : 0;
        ComponentIndexType componentIndexType = ComponentIndexType.find((int)batteryIndex);
        Intrinsics.checkNotNullExpressionValue((Object)componentIndexType, (String)"find(...)");
        return componentIndexType;
    }

    private final float calculateAverageVoltage(List<Integer> cellVoltages) {
        return cellVoltages != null && !((Collection)cellVoltages).isEmpty() ? MathExtensions.milliVoltsToVolts((float)CollectionsKt.averageOfInt((Iterable)cellVoltages)) : 0.0f;
    }

    private final BatteryStatus calculateBatteryStatus(BatteryException batteryException, FCBatteryThresholdBehavior batteryThresholdBehavior, int percentage, int goHomeBattery, boolean isFlying, float voltage) {
        if (percentage < 0 || voltage < 0.0f) {
            return BatteryStatus.UNKNOWN;
        }
        if (batteryException.getFirstLevelOverHeating().booleanValue() || batteryException.getSecondLevelOverHeating().booleanValue()) {
            return BatteryStatus.OVERHEATING;
        }
        if (this.isError(batteryException)) {
            return BatteryStatus.ERROR;
        }
        if (FCBatteryThresholdBehavior.LAND_IMMEDIATELY == batteryThresholdBehavior) {
            return BatteryStatus.WARNING_LEVEL_2;
        }
        if (FCBatteryThresholdBehavior.GO_HOME == batteryThresholdBehavior || percentage <= goHomeBattery && isFlying) {
            return BatteryStatus.WARNING_LEVEL_1;
        }
        return BatteryStatus.NORMAL;
    }

    private final boolean isError(BatteryException $this$isError) {
        return $this$isError.getFirstLevelOverHeating() != false || $this$isError.getSecondLevelOverHeating() != false || $this$isError.getCommunicationException() != false || $this$isError.getHasBrokenCell() != false || $this$isError.getHasLowVoltageCell() != false || $this$isError.getShortCircuited() != false || $this$isError.getFirstLevelLowTemperature() != false || $this$isError.getSecondLevelLowTemperature() != false;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "", "<init>", "()V", "DisconnectedState", "SingleBatteryState", "DualBatteryState", "AggregateBatteryState", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$AggregateBatteryState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$DisconnectedState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$DualBatteryState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$SingleBatteryState;", "android-sdk-v5-uxsdk_release"})
    public static abstract class BatteryState {
        private BatteryState() {
        }

        public /* synthetic */ BatteryState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$AggregateBatteryState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "aggregatePercentage", "", "aggregateVoltage", "", "aggregateBatteryStatus", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "<init>", "(IFLdji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;)V", "getAggregatePercentage", "()I", "getAggregateVoltage", "()F", "getAggregateBatteryStatus", "()Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class AggregateBatteryState
        extends BatteryState {
            private final int aggregatePercentage;
            private final float aggregateVoltage;
            @NotNull
            private final BatteryStatus aggregateBatteryStatus;

            public AggregateBatteryState(int aggregatePercentage, float aggregateVoltage, @NotNull BatteryStatus aggregateBatteryStatus) {
                Intrinsics.checkNotNullParameter((Object)((Object)aggregateBatteryStatus), (String)"aggregateBatteryStatus");
                super(null);
                this.aggregatePercentage = aggregatePercentage;
                this.aggregateVoltage = aggregateVoltage;
                this.aggregateBatteryStatus = aggregateBatteryStatus;
            }

            public final int getAggregatePercentage() {
                return this.aggregatePercentage;
            }

            public final float getAggregateVoltage() {
                return this.aggregateVoltage;
            }

            @NotNull
            public final BatteryStatus getAggregateBatteryStatus() {
                return this.aggregateBatteryStatus;
            }

            public final int component1() {
                return this.aggregatePercentage;
            }

            public final float component2() {
                return this.aggregateVoltage;
            }

            @NotNull
            public final BatteryStatus component3() {
                return this.aggregateBatteryStatus;
            }

            @NotNull
            public final AggregateBatteryState copy(int aggregatePercentage, float aggregateVoltage, @NotNull BatteryStatus aggregateBatteryStatus) {
                Intrinsics.checkNotNullParameter((Object)((Object)aggregateBatteryStatus), (String)"aggregateBatteryStatus");
                return new AggregateBatteryState(aggregatePercentage, aggregateVoltage, aggregateBatteryStatus);
            }

            public static /* synthetic */ AggregateBatteryState copy$default(AggregateBatteryState aggregateBatteryState, int n, float f, BatteryStatus batteryStatus, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = aggregateBatteryState.aggregatePercentage;
                }
                if ((n2 & 2) != 0) {
                    f = aggregateBatteryState.aggregateVoltage;
                }
                if ((n2 & 4) != 0) {
                    batteryStatus = aggregateBatteryState.aggregateBatteryStatus;
                }
                return aggregateBatteryState.copy(n, f, batteryStatus);
            }

            @NotNull
            public String toString() {
                return "AggregateBatteryState(aggregatePercentage=" + this.aggregatePercentage + ", aggregateVoltage=" + this.aggregateVoltage + ", aggregateBatteryStatus=" + this.aggregateBatteryStatus + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.aggregatePercentage);
                result = result * 31 + Float.hashCode(this.aggregateVoltage);
                result = result * 31 + this.aggregateBatteryStatus.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AggregateBatteryState)) {
                    return false;
                }
                AggregateBatteryState aggregateBatteryState = (AggregateBatteryState)other;
                if (this.aggregatePercentage != aggregateBatteryState.aggregatePercentage) {
                    return false;
                }
                if (Float.compare(this.aggregateVoltage, aggregateBatteryState.aggregateVoltage) != 0) {
                    return false;
                }
                return this.aggregateBatteryStatus == aggregateBatteryState.aggregateBatteryStatus;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$DisconnectedState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class DisconnectedState
        extends BatteryState {
            @NotNull
            public static final DisconnectedState INSTANCE = new DisconnectedState();

            private DisconnectedState() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003JE\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006$"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$DualBatteryState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "percentageRemaining1", "", "voltageLevel1", "", "batteryStatus1", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "percentageRemaining2", "voltageLevel2", "batteryStatus2", "<init>", "(IFLdji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;IFLdji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;)V", "getPercentageRemaining1", "()I", "getVoltageLevel1", "()F", "getBatteryStatus1", "()Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "getPercentageRemaining2", "getVoltageLevel2", "getBatteryStatus2", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class DualBatteryState
        extends BatteryState {
            private final int percentageRemaining1;
            private final float voltageLevel1;
            @NotNull
            private final BatteryStatus batteryStatus1;
            private final int percentageRemaining2;
            private final float voltageLevel2;
            @NotNull
            private final BatteryStatus batteryStatus2;

            public DualBatteryState(int percentageRemaining1, float voltageLevel1, @NotNull BatteryStatus batteryStatus1, int percentageRemaining2, float voltageLevel2, @NotNull BatteryStatus batteryStatus2) {
                Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus1), (String)"batteryStatus1");
                Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus2), (String)"batteryStatus2");
                super(null);
                this.percentageRemaining1 = percentageRemaining1;
                this.voltageLevel1 = voltageLevel1;
                this.batteryStatus1 = batteryStatus1;
                this.percentageRemaining2 = percentageRemaining2;
                this.voltageLevel2 = voltageLevel2;
                this.batteryStatus2 = batteryStatus2;
            }

            public final int getPercentageRemaining1() {
                return this.percentageRemaining1;
            }

            public final float getVoltageLevel1() {
                return this.voltageLevel1;
            }

            @NotNull
            public final BatteryStatus getBatteryStatus1() {
                return this.batteryStatus1;
            }

            public final int getPercentageRemaining2() {
                return this.percentageRemaining2;
            }

            public final float getVoltageLevel2() {
                return this.voltageLevel2;
            }

            @NotNull
            public final BatteryStatus getBatteryStatus2() {
                return this.batteryStatus2;
            }

            public final int component1() {
                return this.percentageRemaining1;
            }

            public final float component2() {
                return this.voltageLevel1;
            }

            @NotNull
            public final BatteryStatus component3() {
                return this.batteryStatus1;
            }

            public final int component4() {
                return this.percentageRemaining2;
            }

            public final float component5() {
                return this.voltageLevel2;
            }

            @NotNull
            public final BatteryStatus component6() {
                return this.batteryStatus2;
            }

            @NotNull
            public final DualBatteryState copy(int percentageRemaining1, float voltageLevel1, @NotNull BatteryStatus batteryStatus1, int percentageRemaining2, float voltageLevel2, @NotNull BatteryStatus batteryStatus2) {
                Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus1), (String)"batteryStatus1");
                Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus2), (String)"batteryStatus2");
                return new DualBatteryState(percentageRemaining1, voltageLevel1, batteryStatus1, percentageRemaining2, voltageLevel2, batteryStatus2);
            }

            public static /* synthetic */ DualBatteryState copy$default(DualBatteryState dualBatteryState, int n, float f, BatteryStatus batteryStatus, int n2, float f2, BatteryStatus batteryStatus2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = dualBatteryState.percentageRemaining1;
                }
                if ((n3 & 2) != 0) {
                    f = dualBatteryState.voltageLevel1;
                }
                if ((n3 & 4) != 0) {
                    batteryStatus = dualBatteryState.batteryStatus1;
                }
                if ((n3 & 8) != 0) {
                    n2 = dualBatteryState.percentageRemaining2;
                }
                if ((n3 & 0x10) != 0) {
                    f2 = dualBatteryState.voltageLevel2;
                }
                if ((n3 & 0x20) != 0) {
                    batteryStatus2 = dualBatteryState.batteryStatus2;
                }
                return dualBatteryState.copy(n, f, batteryStatus, n2, f2, batteryStatus2);
            }

            @NotNull
            public String toString() {
                return "DualBatteryState(percentageRemaining1=" + this.percentageRemaining1 + ", voltageLevel1=" + this.voltageLevel1 + ", batteryStatus1=" + this.batteryStatus1 + ", percentageRemaining2=" + this.percentageRemaining2 + ", voltageLevel2=" + this.voltageLevel2 + ", batteryStatus2=" + this.batteryStatus2 + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.percentageRemaining1);
                result = result * 31 + Float.hashCode(this.voltageLevel1);
                result = result * 31 + this.batteryStatus1.hashCode();
                result = result * 31 + Integer.hashCode(this.percentageRemaining2);
                result = result * 31 + Float.hashCode(this.voltageLevel2);
                result = result * 31 + this.batteryStatus2.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DualBatteryState)) {
                    return false;
                }
                DualBatteryState dualBatteryState = (DualBatteryState)other;
                if (this.percentageRemaining1 != dualBatteryState.percentageRemaining1) {
                    return false;
                }
                if (Float.compare(this.voltageLevel1, dualBatteryState.voltageLevel1) != 0) {
                    return false;
                }
                if (this.batteryStatus1 != dualBatteryState.batteryStatus1) {
                    return false;
                }
                if (this.percentageRemaining2 != dualBatteryState.percentageRemaining2) {
                    return false;
                }
                if (Float.compare(this.voltageLevel2, dualBatteryState.voltageLevel2) != 0) {
                    return false;
                }
                return this.batteryStatus2 == dualBatteryState.batteryStatus2;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$SingleBatteryState;", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "percentageRemaining", "", "voltageLevel", "", "batteryStatus", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "<init>", "(IFLdji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;)V", "getPercentageRemaining", "()I", "getVoltageLevel", "()F", "getBatteryStatus", "()Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class SingleBatteryState
        extends BatteryState {
            private final int percentageRemaining;
            private final float voltageLevel;
            @NotNull
            private final BatteryStatus batteryStatus;

            public SingleBatteryState(int percentageRemaining, float voltageLevel, @NotNull BatteryStatus batteryStatus) {
                Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
                super(null);
                this.percentageRemaining = percentageRemaining;
                this.voltageLevel = voltageLevel;
                this.batteryStatus = batteryStatus;
            }

            public final int getPercentageRemaining() {
                return this.percentageRemaining;
            }

            public final float getVoltageLevel() {
                return this.voltageLevel;
            }

            @NotNull
            public final BatteryStatus getBatteryStatus() {
                return this.batteryStatus;
            }

            public final int component1() {
                return this.percentageRemaining;
            }

            public final float component2() {
                return this.voltageLevel;
            }

            @NotNull
            public final BatteryStatus component3() {
                return this.batteryStatus;
            }

            @NotNull
            public final SingleBatteryState copy(int percentageRemaining, float voltageLevel, @NotNull BatteryStatus batteryStatus) {
                Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
                return new SingleBatteryState(percentageRemaining, voltageLevel, batteryStatus);
            }

            public static /* synthetic */ SingleBatteryState copy$default(SingleBatteryState singleBatteryState, int n, float f, BatteryStatus batteryStatus, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = singleBatteryState.percentageRemaining;
                }
                if ((n2 & 2) != 0) {
                    f = singleBatteryState.voltageLevel;
                }
                if ((n2 & 4) != 0) {
                    batteryStatus = singleBatteryState.batteryStatus;
                }
                return singleBatteryState.copy(n, f, batteryStatus);
            }

            @NotNull
            public String toString() {
                return "SingleBatteryState(percentageRemaining=" + this.percentageRemaining + ", voltageLevel=" + this.voltageLevel + ", batteryStatus=" + this.batteryStatus + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.percentageRemaining);
                result = result * 31 + Float.hashCode(this.voltageLevel);
                result = result * 31 + this.batteryStatus.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SingleBatteryState)) {
                    return false;
                }
                SingleBatteryState singleBatteryState = (SingleBatteryState)other;
                if (this.percentageRemaining != singleBatteryState.percentageRemaining) {
                    return false;
                }
                if (Float.compare(this.voltageLevel, singleBatteryState.voltageLevel) != 0) {
                    return false;
                }
                return this.batteryStatus == singleBatteryState.batteryStatus;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "", "index", "", "<init>", "(Ljava/lang/String;II)V", "getIndex", "()I", "NORMAL", "WARNING_LEVEL_1", "WARNING_LEVEL_2", "ERROR", "OVERHEATING", "UNKNOWN", "Companion", "android-sdk-v5-uxsdk_release"})
    public static final class BatteryStatus
    extends Enum<BatteryStatus> {
        @NotNull
        public static final Companion Companion;
        private final int index;
        @NotNull
        private static final BatteryStatus[] values;
        public static final /* enum */ BatteryStatus NORMAL;
        public static final /* enum */ BatteryStatus WARNING_LEVEL_1;
        public static final /* enum */ BatteryStatus WARNING_LEVEL_2;
        public static final /* enum */ BatteryStatus ERROR;
        public static final /* enum */ BatteryStatus OVERHEATING;
        public static final /* enum */ BatteryStatus UNKNOWN;
        private static final /* synthetic */ BatteryStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BatteryStatus(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static BatteryStatus[] values() {
            return (BatteryStatus[])$VALUES.clone();
        }

        public static BatteryStatus valueOf(String value) {
            return Enum.valueOf(BatteryStatus.class, value);
        }

        @NotNull
        public static EnumEntries<BatteryStatus> getEntries() {
            return $ENTRIES;
        }

        @NotNull
        public static final BatteryStatus[] getValues() {
            return Companion.getValues();
        }

        @JvmStatic
        @NotNull
        public static final BatteryStatus find(@IntRange(from=0L, to=5L) int index) {
            return Companion.find(index);
        }

        static {
            NORMAL = new BatteryStatus(0);
            WARNING_LEVEL_1 = new BatteryStatus(1);
            WARNING_LEVEL_2 = new BatteryStatus(2);
            ERROR = new BatteryStatus(3);
            OVERHEATING = new BatteryStatus(4);
            UNKNOWN = new BatteryStatus(5);
            $VALUES = batteryStatusArray = new BatteryStatus[]{BatteryStatus.NORMAL, BatteryStatus.WARNING_LEVEL_1, BatteryStatus.WARNING_LEVEL_2, BatteryStatus.ERROR, BatteryStatus.OVERHEATING, BatteryStatus.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            values = BatteryStatus.values();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\rH\u0007R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\n\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus$Companion;", "", "<init>", "()V", "values", "", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "getValues$annotations", "getValues", "()[Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "[Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "find", "index", "", "android-sdk-v5-uxsdk_release"})
        @SourceDebugExtension(value={"SMAP\nBatteryWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatteryWidgetModel.kt\ndji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BatteryStatus[] getValues() {
                return values;
            }

            @JvmStatic
            public static /* synthetic */ void getValues$annotations() {
            }

            @JvmStatic
            @NotNull
            public final BatteryStatus find(@IntRange(from=0L, to=5L) int index) {
                BatteryStatus batteryStatus;
                BatteryStatus batteryStatus2;
                block2: {
                    BatteryStatus[] batteryStatusArray = this.getValues();
                    int n = batteryStatusArray.length;
                    for (int i = 0; i < n; ++i) {
                        BatteryStatus batteryStatus3;
                        BatteryStatus it = batteryStatus3 = batteryStatusArray[i];
                        boolean bl = false;
                        if (!(it.getIndex() == index)) continue;
                        batteryStatus2 = batteryStatus3;
                        break block2;
                    }
                    batteryStatus2 = batteryStatus = null;
                }
                if (batteryStatus2 == null) {
                    batteryStatus = UNKNOWN;
                }
                return batteryStatus;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentIndexType.values().length];
            try {
                nArray[ComponentIndexType.LEFT_OR_MAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentIndexType.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

