/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.extension;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.SparseLongArray;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.R;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.RecyclerView;
import dji.v5.ux.R;
import dji.v5.ux.core.util.UnitConversionUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\u0004\u001a\u0016\u0010\f\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\r\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\u0004H\u0007\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00022\b\b\u0001\u0010\u0016\u001a\u00020\u0004\u001a\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00022\b\b\u0001\u0010\u0016\u001a\u00020\u0004\u001a\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001\u001a\\\u0010+\u001a\u00020\u0012*\u00020\u00022\b\b\u0003\u0010,\u001a\u00020\u00042\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u00102\u001a\u0004\u0018\u000103\u001aP\u00104\u001a\u00020\u0012*\u00020\u00022\b\b\u0003\u0010,\u001a\u00020\u00042\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u00102\u001a\u0004\u0018\u000103\u001a\u0012\u00105\u001a\u00020\u0001*\u00020\u00022\u0006\u00106\u001a\u000207\u001a\u0012\u00108\u001a\u00020\u0001*\u00020\u00022\u0006\u00106\u001a\u000207\u001aF\u00109\u001a\u00020\u0012*\u00020\u00022\b\b\u0003\u0010:\u001a\u00020\u00042\b\b\u0003\u0010;\u001a\u00020\u00042\b\b\u0002\u0010<\u001a\u00020\u00042\b\b\u0002\u0010=\u001a\u00020\u00042\b\b\u0002\u0010>\u001a\u00020\u00042\b\b\u0002\u0010?\u001a\u00020\u0004\u001a<\u0010@\u001a\u0002HA\"\b\b\u0000\u0010A*\u00020B*\u0002HA2!\u0010C\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020\u00120D\u00a2\u0006\u0002\u0010H\u001a\u0012\u0010M\u001a\u00020N*\u00020O2\u0006\u0010P\u001a\u00020\u0004\u001a\n\u0010M\u001a\u00020N*\u00020O\"*\u0010\u0019\u001a\u00020\u0004*\u00020\u001a2\b\b\u0001\u0010\u0005\u001a\u00020\u00048G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\",\u0010 \u001a\u0004\u0018\u00010\u001f*\u00020\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\",\u0010%\u001a\u0004\u0018\u00010\n*\u00020&2\b\u0010\u0005\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\"\u000e\u0010I\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010J\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"getString", "", "Landroid/view/View;", "stringRes", "", "value", "", "", "(Landroid/view/View;I[Ljava/lang/Object;)Ljava/lang/String;", "getDrawable", "Landroid/graphics/drawable/Drawable;", "drawableRes", "getColor", "colorRes", "getDimension", "", "dimenRes", "show", "", "hide", "toggleVisibility", "showShortToast", "messageResId", "showLongToast", "message", "textColor", "Landroid/widget/TextView;", "getTextColor", "(Landroid/widget/TextView;)I", "setTextColor", "(Landroid/widget/TextView;I)V", "Landroid/content/res/ColorStateList;", "textColorStateList", "getTextColorStateList", "(Landroid/widget/TextView;)Landroid/content/res/ColorStateList;", "setTextColorStateList", "(Landroid/widget/TextView;Landroid/content/res/ColorStateList;)V", "imageDrawable", "Landroid/widget/ImageView;", "getImageDrawable", "(Landroid/widget/ImageView;)Landroid/graphics/drawable/Drawable;", "setImageDrawable", "(Landroid/widget/ImageView;Landroid/graphics/drawable/Drawable;)V", "showAlertDialog", "dialogTheme", "title", "icon", "dismissButton", "dialogClickListener", "Landroid/content/DialogInterface$OnClickListener;", "dialogDismissListener", "Landroid/content/DialogInterface$OnDismissListener;", "showConfirmationDialog", "getVelocityString", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "getDistanceString", "setBorder", "backgroundColor", "borderColor", "leftBorder", "topBorder", "rightBorder", "bottomBorder", "listen", "T", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "event", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "position", "(Landroidx/recyclerview/widget/RecyclerView$ViewHolder;Lkotlin/jvm/functions/Function1;)Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "TRANSITION_OFFSET", "FAST_CLICK_DURATION", "sClickTimes", "Landroid/util/SparseLongArray;", "isFastClick", "", "Landroid/widget/Button;", "duration", "android-sdk-v5-uxsdk_release"})
@JvmName(name="ViewExtensions")
public final class ViewExtensions {
    public static final int TRANSITION_OFFSET = 80;
    private static final int FAST_CLICK_DURATION = 300;
    @NotNull
    private static final SparseLongArray sClickTimes = new SparseLongArray();

    @NotNull
    public static final String getString(@NotNull View $this$getString, @StringRes int stringRes, Object ... value) {
        Intrinsics.checkNotNullParameter((Object)$this$getString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string2 = $this$getString.getContext().getResources().getString(stringRes, Arrays.copyOf(value, value.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    @NotNull
    public static final Drawable getDrawable(@NotNull View $this$getDrawable, @DrawableRes int drawableRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawable, (String)"<this>");
        Drawable drawable2 = $this$getDrawable.getContext().getResources().getDrawable(drawableRes);
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    @ColorInt
    public static final int getColor(@NotNull View $this$getColor, @ColorRes int colorRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getColor, (String)"<this>");
        return $this$getColor.getContext().getResources().getColor(colorRes);
    }

    @Px
    public static final float getDimension(@NotNull View $this$getDimension, @DimenRes int dimenRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimension, (String)"<this>");
        return $this$getDimension.getContext().getResources().getDimension(dimenRes);
    }

    public static final void show(@NotNull View $this$show) {
        Intrinsics.checkNotNullParameter((Object)$this$show, (String)"<this>");
        $this$show.setVisibility(0);
    }

    public static final void hide(@NotNull View $this$hide) {
        Intrinsics.checkNotNullParameter((Object)$this$hide, (String)"<this>");
        $this$hide.setVisibility(8);
    }

    public static final void toggleVisibility(@NotNull View $this$toggleVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleVisibility, (String)"<this>");
        if ($this$toggleVisibility.getVisibility() == 0) {
            ViewExtensions.hide($this$toggleVisibility);
        } else {
            ViewExtensions.show($this$toggleVisibility);
        }
    }

    public static final void showShortToast(@NotNull View $this$showShortToast, @StringRes int messageResId) {
        Intrinsics.checkNotNullParameter((Object)$this$showShortToast, (String)"<this>");
        Toast.makeText((Context)$this$showShortToast.getContext(), (int)messageResId, (int)0).show();
    }

    public static final void showLongToast(@NotNull View $this$showLongToast, @StringRes int messageResId) {
        Intrinsics.checkNotNullParameter((Object)$this$showLongToast, (String)"<this>");
        Toast.makeText((Context)$this$showLongToast.getContext(), (int)messageResId, (int)1).show();
    }

    public static final void showShortToast(@NotNull View $this$showShortToast, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)$this$showShortToast, (String)"<this>");
        Toast.makeText((Context)$this$showShortToast.getContext(), (CharSequence)message, (int)0).show();
    }

    public static final void showLongToast(@NotNull View $this$showLongToast, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)$this$showLongToast, (String)"<this>");
        Toast.makeText((Context)$this$showLongToast.getContext(), (CharSequence)message, (int)1).show();
    }

    @ColorInt
    public static final int getTextColor(@NotNull TextView $this$textColor) {
        Intrinsics.checkNotNullParameter((Object)$this$textColor, (String)"<this>");
        return $this$textColor.getCurrentTextColor();
    }

    public static final void setTextColor(@NotNull TextView $this$textColor, @ColorInt int value) {
        Intrinsics.checkNotNullParameter((Object)$this$textColor, (String)"<this>");
        $this$textColor.setTextColor(value);
    }

    @Nullable
    public static final ColorStateList getTextColorStateList(@NotNull TextView $this$textColorStateList) {
        Intrinsics.checkNotNullParameter((Object)$this$textColorStateList, (String)"<this>");
        return $this$textColorStateList.getTextColors();
    }

    public static final void setTextColorStateList(@NotNull TextView $this$textColorStateList, @Nullable ColorStateList value) {
        Intrinsics.checkNotNullParameter((Object)$this$textColorStateList, (String)"<this>");
        $this$textColorStateList.setTextColor(value);
    }

    @Nullable
    public static final Drawable getImageDrawable(@NotNull ImageView $this$imageDrawable) {
        Intrinsics.checkNotNullParameter((Object)$this$imageDrawable, (String)"<this>");
        return $this$imageDrawable.getDrawable();
    }

    public static final void setImageDrawable(@NotNull ImageView $this$imageDrawable, @Nullable Drawable value) {
        Intrinsics.checkNotNullParameter((Object)$this$imageDrawable, (String)"<this>");
        $this$imageDrawable.setImageDrawable(value);
    }

    public static final void showAlertDialog(@NotNull View $this$showAlertDialog, @StyleRes int dialogTheme, @Nullable String title, @Nullable Drawable icon, @Nullable String message, @Nullable String dismissButton, @Nullable DialogInterface.OnClickListener dialogClickListener, @Nullable DialogInterface.OnDismissListener dialogDismissListener) {
        Intrinsics.checkNotNullParameter((Object)$this$showAlertDialog, (String)"<this>");
        AlertDialog.Builder builder = new AlertDialog.Builder($this$showAlertDialog.getContext(), dialogTheme);
        builder.setTitle((CharSequence)title);
        builder.setIcon(icon);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)dismissButton, dialogClickListener);
        builder.setOnDismissListener(dialogDismissListener);
        AlertDialog alertDialog = builder.create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        dialog.show();
    }

    public static /* synthetic */ void showAlertDialog$default(View view, int n, String string2, Drawable drawable2, String string3, String string4, DialogInterface.OnClickListener onClickListener, DialogInterface.OnDismissListener onDismissListener, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = R.style.Theme_AppCompat_Dialog;
        }
        if ((n2 & 2) != 0) {
            string2 = ViewExtensions.getString(view, R.string.uxsdk_alert, new Object[0]);
        }
        if ((n2 & 4) != 0) {
            drawable2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            string4 = ViewExtensions.getString(view, R.string.uxsdk_app_ok, new Object[0]);
        }
        if ((n2 & 0x20) != 0) {
            onClickListener = null;
        }
        if ((n2 & 0x40) != 0) {
            onDismissListener = null;
        }
        ViewExtensions.showAlertDialog(view, n, string2, drawable2, string3, string4, onClickListener, onDismissListener);
    }

    public static final void showConfirmationDialog(@NotNull View $this$showConfirmationDialog, @StyleRes int dialogTheme, @Nullable String title, @Nullable Drawable icon, @Nullable String message, @Nullable DialogInterface.OnClickListener dialogClickListener, @Nullable DialogInterface.OnDismissListener dialogDismissListener) {
        Intrinsics.checkNotNullParameter((Object)$this$showConfirmationDialog, (String)"<this>");
        AlertDialog.Builder builder = new AlertDialog.Builder($this$showConfirmationDialog.getContext(), dialogTheme);
        builder.setIcon(icon);
        builder.setTitle((CharSequence)title);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)ViewExtensions.getString($this$showConfirmationDialog, R.string.uxsdk_app_ok, new Object[0]), dialogClickListener);
        builder.setNegativeButton((CharSequence)ViewExtensions.getString($this$showConfirmationDialog, R.string.uxsdk_app_cancel, new Object[0]), dialogClickListener);
        builder.setOnDismissListener(dialogDismissListener);
        AlertDialog alertDialog = builder.create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        dialog.show();
    }

    public static /* synthetic */ void showConfirmationDialog$default(View view, int n, String string2, Drawable drawable2, String string3, DialogInterface.OnClickListener onClickListener, DialogInterface.OnDismissListener onDismissListener, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = R.style.Theme_AppCompat_Dialog;
        }
        if ((n2 & 2) != 0) {
            string2 = ViewExtensions.getString(view, R.string.uxsdk_alert, new Object[0]);
        }
        if ((n2 & 4) != 0) {
            drawable2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            onClickListener = null;
        }
        if ((n2 & 0x20) != 0) {
            onDismissListener = null;
        }
        ViewExtensions.showConfirmationDialog(view, n, string2, drawable2, string3, onClickListener, onDismissListener);
    }

    @NotNull
    public static final String getVelocityString(@NotNull View $this$getVelocityString, @NotNull UnitConversionUtil.UnitType unitType) {
        Intrinsics.checkNotNullParameter((Object)$this$getVelocityString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
        return unitType == UnitConversionUtil.UnitType.IMPERIAL ? ViewExtensions.getString($this$getVelocityString, R.string.uxsdk_unit_mile_per_hr, new Object[0]) : ViewExtensions.getString($this$getVelocityString, R.string.uxsdk_unit_meter_per_second, new Object[0]);
    }

    @NotNull
    public static final String getDistanceString(@NotNull View $this$getDistanceString, @NotNull UnitConversionUtil.UnitType unitType) {
        Intrinsics.checkNotNullParameter((Object)$this$getDistanceString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
        return unitType == UnitConversionUtil.UnitType.IMPERIAL ? ViewExtensions.getString($this$getDistanceString, R.string.uxsdk_unit_feet, new Object[0]) : ViewExtensions.getString($this$getDistanceString, R.string.uxsdk_unit_meters, new Object[0]);
    }

    public static final void setBorder(@NotNull View $this$setBorder, @ColorInt int backgroundColor, @ColorInt int borderColor, int leftBorder, int topBorder, int rightBorder, int bottomBorder) {
        Intrinsics.checkNotNullParameter((Object)$this$setBorder, (String)"<this>");
        ColorDrawable borderColorDrawable = new ColorDrawable(borderColor);
        ColorDrawable backgroundColorDrawable = new ColorDrawable(backgroundColor);
        Drawable[] drawableArray = new Drawable[]{borderColorDrawable, backgroundColorDrawable};
        Drawable[] drawables = drawableArray;
        LayerDrawable layerDrawable = new LayerDrawable(drawables);
        layerDrawable.setLayerInset(1, leftBorder, topBorder, rightBorder, bottomBorder);
        $this$setBorder.setBackground((Drawable)layerDrawable);
    }

    public static /* synthetic */ void setBorder$default(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = ViewExtensions.getColor(view, R.color.uxsdk_transparent);
        }
        if ((n7 & 2) != 0) {
            n2 = ViewExtensions.getColor(view, R.color.uxsdk_transparent);
        }
        if ((n7 & 4) != 0) {
            n3 = 0;
        }
        if ((n7 & 8) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 0;
        }
        ViewExtensions.setBorder(view, n, n2, n3, n4, n5, n6);
    }

    @NotNull
    public static final <T extends RecyclerView.ViewHolder> T listen(@NotNull T $this$listen, @NotNull Function1<? super Integer, Unit> event) {
        Intrinsics.checkNotNullParameter($this$listen, (String)"<this>");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        $this$listen.itemView.setOnClickListener(arg_0 -> ViewExtensions.listen$lambda$0(event, $this$listen, arg_0));
        return $this$listen;
    }

    public static final boolean isFastClick(@NotNull Button $this$isFastClick, int duration) {
        boolean isFast;
        Intrinsics.checkNotNullParameter((Object)$this$isFastClick, (String)"<this>");
        long prevTime = sClickTimes.get($this$isFastClick.getId());
        long now = System.currentTimeMillis();
        boolean bl = isFast = now - prevTime < (long)duration;
        if (!isFast) {
            sClickTimes.put($this$isFastClick.getId(), now);
        }
        return isFast;
    }

    public static final boolean isFastClick(@NotNull Button $this$isFastClick) {
        Intrinsics.checkNotNullParameter((Object)$this$isFastClick, (String)"<this>");
        return ViewExtensions.isFastClick($this$isFastClick, 300);
    }

    private static final void listen$lambda$0(Function1 $event, RecyclerView.ViewHolder $this_listen, View it) {
        $event.invoke((Object)$this_listen.getAdapterPosition());
    }
}

