/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller.calibration.stick;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.BaseView;
import java.util.Arrays;

public class RcCalibrationRollView
extends BaseView {
    private static final float PROGRESS_DRAW_THRESHOLD = 1.0f;
    private int mStickBitmapSidePx;
    private int mStickMaxProgressPx;
    private int mTopProgressBarStartX;
    private int mTopProgressBarStartY;
    private int mTopProgressBarEndX;
    private int mTopProgressBarEndY;
    private int mRightProgressBarStartX;
    private int mRightProgressBarStartY;
    private int mRightProgressBarEndX;
    private int mRightProgressBarEndY;
    private int mBottomProgressBarStartX;
    private int mBottomProgressBarStartY;
    private int mBottomProgressBarEndX;
    private int mBottomProgressBarEndY;
    private int mLeftProgressBarStartX;
    private int mLeftProgressBarStartY;
    private int mLeftProgressBarEndX;
    private int mLeftProgressBarEndY;
    private float mHorizontalProgress;
    private float mVerticalProgress;
    private float mProgressTopEndY;
    private float mProgressBottomEndY;
    private float mProgressLeftEndX;
    private float mProgressRightEndX;
    private int mFontWidth;
    private Rect mLeftTextRect;
    private Rect mTopTextRect;
    private Rect mBottomTextRect;
    private Rect mRightTextRect;
    private Bitmap mStickBitmap;
    private Rect mStickRect;
    private Paint mStickBitmapPaint;
    private Paint mProgressBackgroundPaint;
    private Paint mHorizontalProgressPaint;
    private Paint mVerticalProgressPaint;
    private Paint mFontPaint;
    private Boolean[] mLimitStatus = new Boolean[]{false, false, false, false};

    public RcCalibrationRollView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        float progressBarWidth = this.getResources().getDimension(R.dimen.uxsdk_2_dp);
        final int progressBarAndRollGap = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_2_dp);
        this.mFontWidth = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_32_dp);
        this.mStickBitmapSidePx = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_24_dp);
        this.mStickMaxProgressPx = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_40_dp);
        this.mStickBitmap = this.getBitmapFromVectorDrawable(context, R.drawable.uxsdk_img_fpv_rc_calibration_shell_stick);
        this.mStickBitmapPaint = new Paint();
        this.mProgressBackgroundPaint = new Paint();
        this.mProgressBackgroundPaint.setAntiAlias(true);
        this.mProgressBackgroundPaint.setColor(-7829368);
        this.mProgressBackgroundPaint.setStrokeWidth(progressBarWidth);
        this.mProgressBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mProgressBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mHorizontalProgressPaint = new Paint(1);
        this.mHorizontalProgressPaint.setColor(-1);
        this.mHorizontalProgressPaint.setStrokeWidth(progressBarWidth);
        this.mHorizontalProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mHorizontalProgressPaint.setStyle(Paint.Style.STROKE);
        this.mVerticalProgressPaint = new Paint(1);
        this.mVerticalProgressPaint.setColor(-1);
        this.mVerticalProgressPaint.setStrokeWidth(progressBarWidth);
        this.mVerticalProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mVerticalProgressPaint.setStyle(Paint.Style.STROKE);
        int fontSize = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_12_dp);
        this.mFontPaint = new Paint(1);
        this.mFontPaint.setStrokeWidth(0.0f);
        this.mFontPaint.setTextSize((float)fontSize);
        this.mFontPaint.setColor(-1);
        this.mFontPaint.setTextAlign(Paint.Align.CENTER);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                RcCalibrationRollView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int width = RcCalibrationRollView.this.getWidth();
                int height = RcCalibrationRollView.this.getHeight();
                int centerX = width / 2;
                int centerY = height / 2;
                int stickRectLeft = centerX - RcCalibrationRollView.this.mStickBitmapSidePx / 2;
                int stickRectTop = centerY - RcCalibrationRollView.this.mStickBitmapSidePx / 2;
                int stickRectRight = centerX + RcCalibrationRollView.this.mStickBitmapSidePx / 2;
                int stickRectBottom = centerY + RcCalibrationRollView.this.mStickBitmapSidePx / 2;
                RcCalibrationRollView.this.mStickRect = new Rect(stickRectLeft, stickRectTop, stickRectRight, stickRectBottom);
                RcCalibrationRollView.this.mTopProgressBarStartX = centerX;
                RcCalibrationRollView.this.mTopProgressBarStartY = centerY - RcCalibrationRollView.this.mStickBitmapSidePx / 2 - progressBarAndRollGap;
                RcCalibrationRollView.this.mTopProgressBarEndX = centerX;
                RcCalibrationRollView.this.mTopProgressBarEndY = RcCalibrationRollView.this.mTopProgressBarStartY - RcCalibrationRollView.this.mStickMaxProgressPx;
                RcCalibrationRollView.this.mRightProgressBarStartX = centerX + RcCalibrationRollView.this.mStickBitmapSidePx / 2 + progressBarAndRollGap;
                RcCalibrationRollView.this.mRightProgressBarStartY = centerY;
                RcCalibrationRollView.this.mRightProgressBarEndX = RcCalibrationRollView.this.mRightProgressBarStartX + RcCalibrationRollView.this.mStickMaxProgressPx;
                RcCalibrationRollView.this.mRightProgressBarEndY = centerY;
                RcCalibrationRollView.this.mBottomProgressBarStartX = centerX;
                RcCalibrationRollView.this.mBottomProgressBarStartY = centerY + RcCalibrationRollView.this.mStickBitmapSidePx / 2 + progressBarAndRollGap;
                RcCalibrationRollView.this.mBottomProgressBarEndX = centerX;
                RcCalibrationRollView.this.mBottomProgressBarEndY = RcCalibrationRollView.this.mBottomProgressBarStartY + RcCalibrationRollView.this.mStickMaxProgressPx;
                RcCalibrationRollView.this.mLeftProgressBarStartX = centerX - RcCalibrationRollView.this.mStickBitmapSidePx / 2 - progressBarAndRollGap;
                RcCalibrationRollView.this.mLeftProgressBarStartY = centerY;
                RcCalibrationRollView.this.mLeftProgressBarEndX = RcCalibrationRollView.this.mLeftProgressBarStartX - RcCalibrationRollView.this.mStickMaxProgressPx;
                RcCalibrationRollView.this.mLeftProgressBarEndY = centerY;
                RcCalibrationRollView.this.mLeftTextRect = new Rect(0, 0, RcCalibrationRollView.this.mFontWidth, height);
                RcCalibrationRollView.this.mTopTextRect = new Rect(0, 0, width, RcCalibrationRollView.this.mFontWidth);
                RcCalibrationRollView.this.mRightTextRect = new Rect(width - RcCalibrationRollView.this.mFontWidth, 0, width, height);
                RcCalibrationRollView.this.mBottomTextRect = new Rect(0, height - RcCalibrationRollView.this.mFontWidth, width, height);
                RcCalibrationRollView.this.mProgressLeftEndX = RcCalibrationRollView.this.mLeftProgressBarStartX;
                RcCalibrationRollView.this.mProgressRightEndX = RcCalibrationRollView.this.mRightProgressBarStartX;
                RcCalibrationRollView.this.mProgressBottomEndY = RcCalibrationRollView.this.mBottomProgressBarStartY;
                RcCalibrationRollView.this.mProgressTopEndY = RcCalibrationRollView.this.mTopProgressBarStartY;
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_184_dp);
        int height = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_184_dp);
        this.setMeasuredDimension(width, height);
    }

    public boolean isGetLimit() {
        boolean result = true;
        for (Boolean status : this.mLimitStatus) {
            result &= status.booleanValue();
        }
        return result;
    }

    public void resetLimit() {
        Arrays.fill((Object[])this.mLimitStatus, (Object)false);
    }

    private void handlerLimitStatus(int horizontal, int vertical) {
        if (horizontal == 100) {
            this.mLimitStatus[0] = true;
        } else if (horizontal == -100) {
            this.mLimitStatus[1] = true;
        }
        if (vertical == 100) {
            this.mLimitStatus[2] = true;
        } else if (vertical == -100) {
            this.mLimitStatus[3] = true;
        }
    }

    public void setProgress(int horizontal, int vertical) {
        this.handlerLimitStatus(horizontal, vertical);
        if (Math.abs(horizontal) == 100) {
            this.mHorizontalProgressPaint.setColor(-16711936);
        } else {
            this.mHorizontalProgressPaint.setColor(-1);
        }
        if (Math.abs(vertical) == 100) {
            this.mVerticalProgressPaint.setColor(-16711936);
        } else {
            this.mVerticalProgressPaint.setColor(-1);
        }
        float horizontalProgressPx = (float)(this.mStickMaxProgressPx * horizontal) / 100.0f;
        if (horizontalProgressPx < 0.0f) {
            this.mProgressLeftEndX = (float)this.mLeftProgressBarStartX + horizontalProgressPx;
            this.mProgressRightEndX = this.mRightProgressBarStartX;
        } else {
            this.mProgressRightEndX = (float)this.mRightProgressBarStartX + horizontalProgressPx;
            this.mProgressLeftEndX = this.mLeftProgressBarStartX;
        }
        float verticalProgressPx = (float)(this.mStickMaxProgressPx * vertical) / 100.0f;
        if (verticalProgressPx < 0.0f) {
            this.mProgressBottomEndY = (float)this.mBottomProgressBarStartY - verticalProgressPx;
            this.mProgressTopEndY = this.mTopProgressBarStartY;
        } else {
            this.mProgressTopEndY = (float)this.mTopProgressBarStartY - verticalProgressPx;
            this.mProgressBottomEndY = this.mBottomProgressBarStartY;
        }
        this.mHorizontalProgress = horizontal;
        this.mVerticalProgress = vertical;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.mStickBitmap, null, this.mStickRect, this.mStickBitmapPaint);
        this.drawProgressBackground(canvas);
        this.drawProgress(canvas);
        this.drawText(canvas);
    }

    private void drawText(Canvas canvas) {
        int absHorizontalProgress = (int)Math.abs(this.mHorizontalProgress);
        if (this.mHorizontalProgress > 0.0f) {
            this.drawCenterText(canvas, absHorizontalProgress + "%", this.mRightTextRect);
            this.drawCenterText(canvas, "0%", this.mLeftTextRect);
        } else {
            this.drawCenterText(canvas, absHorizontalProgress + "%", this.mLeftTextRect);
            this.drawCenterText(canvas, "0%", this.mRightTextRect);
        }
        int absVerticalProgress = (int)Math.abs(this.mVerticalProgress);
        if (this.mVerticalProgress > 0.0f) {
            this.drawCenterText(canvas, absVerticalProgress + "%", this.mTopTextRect);
            this.drawCenterText(canvas, "0%", this.mBottomTextRect);
        } else {
            this.drawCenterText(canvas, absVerticalProgress + "%", this.mBottomTextRect);
            this.drawCenterText(canvas, "0%", this.mTopTextRect);
        }
    }

    private void drawProgress(Canvas canvas) {
        if (Math.abs((float)this.mTopProgressBarStartY - this.mProgressTopEndY) > 1.0f) {
            canvas.drawLine((float)this.mTopProgressBarStartX, (float)this.mTopProgressBarStartY, (float)this.mTopProgressBarEndX, this.mProgressTopEndY, this.mVerticalProgressPaint);
        }
        if (Math.abs((float)this.mRightProgressBarStartX - this.mProgressRightEndX) > 1.0f) {
            canvas.drawLine((float)this.mRightProgressBarStartX, (float)this.mRightProgressBarStartY, this.mProgressRightEndX, (float)this.mRightProgressBarEndY, this.mHorizontalProgressPaint);
        }
        if (Math.abs((float)this.mBottomProgressBarStartY - this.mProgressBottomEndY) > 1.0f) {
            canvas.drawLine((float)this.mBottomProgressBarStartX, (float)this.mBottomProgressBarStartY, (float)this.mBottomProgressBarEndX, this.mProgressBottomEndY, this.mVerticalProgressPaint);
        }
        if (Math.abs((float)this.mLeftProgressBarStartX - this.mProgressLeftEndX) > 1.0f) {
            canvas.drawLine((float)this.mLeftProgressBarStartX, (float)this.mLeftProgressBarStartY, this.mProgressLeftEndX, (float)this.mLeftProgressBarEndY, this.mHorizontalProgressPaint);
        }
    }

    private void drawProgressBackground(Canvas canvas) {
        canvas.drawLine((float)this.mTopProgressBarStartX, (float)this.mTopProgressBarStartY, (float)this.mTopProgressBarEndX, (float)this.mTopProgressBarEndY, this.mProgressBackgroundPaint);
        canvas.drawLine((float)this.mRightProgressBarStartX, (float)this.mRightProgressBarStartY, (float)this.mRightProgressBarEndX, (float)this.mRightProgressBarEndY, this.mProgressBackgroundPaint);
        canvas.drawLine((float)this.mBottomProgressBarStartX, (float)this.mBottomProgressBarStartY, (float)this.mBottomProgressBarEndX, (float)this.mBottomProgressBarEndY, this.mProgressBackgroundPaint);
        canvas.drawLine((float)this.mLeftProgressBarStartX, (float)this.mLeftProgressBarStartY, (float)this.mLeftProgressBarEndX, (float)this.mLeftProgressBarEndY, this.mProgressBackgroundPaint);
    }

    private Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableId);
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private void drawCenterText(Canvas canvas, String text, Rect rect) {
        Paint.FontMetricsInt fontMetrics = this.mFontPaint.getFontMetricsInt();
        int baseline = (rect.bottom + rect.top - fontMetrics.bottom - fontMetrics.top) / 2;
        canvas.drawText(text, (float)rect.centerX(), (float)baseline, this.mFontPaint);
    }
}

