/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import android.location.Location;
import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.sdk.keyvalue.value.remotecontroller.RCMode;
import dji.sdk.keyvalue.value.remotecontroller.RcGPSInfo;
import dji.v5.common.utils.GpsUtils;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.LocationUtil;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;

public class HomeSetWidgetModel
extends WidgetModel {
    private final DataProcessor<ProductType> productTypeProcessor = DataProcessor.create(ProductType.UNKNOWN);
    private final DataProcessor<RCMode> rcModeDataProcessor = DataProcessor.create(RCMode.UNKNOWN);
    private final DataProcessor<RcGPSInfo> rcGPSInfoDataProcessor = DataProcessor.create(new RcGPSInfo());
    public final DataProcessor<LocationCoordinate2D> homeLocationDataProcessor = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(181.0), Double.valueOf(181.0)));

    protected HomeSetWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcMachineMode), this.rcModeDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), this.productTypeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcGPSInfo), this.rcGPSInfoDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHomeLocation), this.homeLocationDataProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public RcGPSInfo getRcGPSInfo() {
        return this.rcGPSInfoDataProcessor.getValue();
    }

    boolean isSupportMultiRc() {
        ProductType curType = this.productTypeProcessor.getValue();
        return curType == ProductType.M30_SERIES || curType == ProductType.M350_RTK || curType == ProductType.M300_RTK || curType == ProductType.DJI_MATRICE_400;
    }

    boolean isCurrentRc(RCMode mode) {
        return this.rcModeDataProcessor.getValue() == mode;
    }

    public Completable setHomeLocationUseingAircraftLoc() {
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyHomeLocationUsingCurrentAircraftLocation));
    }

    public int checkRcGpsValid(double latitude, double longitude, double accuracy) {
        if (!(GpsUtils.checkLatitude((double)latitude) && GpsUtils.checkLongitude((double)longitude) && this.isFineAccuracy((float)accuracy, 60.0f))) {
            return -1;
        }
        LocationCoordinate2D homeLocation = this.homeLocationDataProcessor.getValue();
        if (GpsUtils.isValid((double)homeLocation.getLatitude(), (double)homeLocation.getLongitude())) {
            return (int)GpsUtils.distance((double)latitude, (double)longitude, (double)homeLocation.getLatitude(), (double)homeLocation.getLongitude());
        }
        return -1;
    }

    public Completable setHomeLocation(LocationCoordinate2D locationCoordinate2D) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHomeLocation), locationCoordinate2D);
    }

    private boolean isFineAccuracy(float accuracy, float meter) {
        return 0.0f < accuracy && accuracy <= meter;
    }

    public boolean isChannelB() {
        return RCMode.CHANNEL_B == KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcMachineMode), (Object)RCMode.UNKNOWN);
    }

    public boolean isChannelA() {
        return RCMode.CHANNEL_A == KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcMachineMode), (Object)RCMode.UNKNOWN);
    }

    public Location getOtherRcLocation() {
        return LocationUtil.getLastLocation();
    }
}

