/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.compass;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.view.WindowManager;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.GimbalKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.common.Attitude;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.remotecontroller.RcGPSInfo;
import dji.v5.utils.common.LocationUtil;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DJIDeviceUtil;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.MathUtil;
import dji.v5.ux.core.util.MobileGPSLocationUtil;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0005QRSTUB+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u00101\u001a\u000202H\u0014J\b\u00103\u001a\u000202H\u0014J\b\u00104\u001a\u000202H\u0014J\b\u00105\u001a\u000202H\u0002J\b\u00106\u001a\u000202H\u0002J\u0010\u00107\u001a\u0002022\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020@H\u0016J \u0010A\u001a\u0002022\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020=2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u0002022\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010H\u001a\u0002022\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010I\u001a\u0002022\u0006\u0010J\u001a\u00020\u0014H\u0002J\b\u0010K\u001a\u000202H\u0002J\b\u0010L\u001a\u000202H\u0002J\b\u0010M\u001a\u000202H\u0002J\b\u0010N\u001a\u00020=H\u0002J\u0006\u0010O\u001a\u00020)J\u0010\u0010P\u001a\u0002022\b\u0010(\u001a\u0004\u0018\u00010)R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006V"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "Landroid/hardware/SensorEventListener;", "Landroid/location/LocationListener;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "sensorManager", "Landroid/hardware/SensorManager;", "windowManager", "Landroid/view/WindowManager;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Landroid/hardware/SensorManager;Landroid/view/WindowManager;)V", "homeLocationProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/common/LocationCoordinate2D;", "kotlin.jvm.PlatformType", "aircraftLocationProcessor", "rcGPSDataProcessor", "Ldji/sdk/keyvalue/value/remotecontroller/RcGPSInfo;", "gimbalYawProcessor", "", "centerTypeProcessor", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;", "mobileDeviceAzimuthProcessor", "", "aircraftAttitudeProcessor", "Ldji/sdk/keyvalue/value/common/Attitude;", "aircraftStateProcessor", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;", "currentLocationStateProcessor", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;", "compassWidgetStateProcessor", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CompassWidgetState;", "rotationVector", "Landroid/hardware/Sensor;", "rcOrMobileLatitude", "rcOrMobileLongitude", "latestSensorValue", "gimbalIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "values", "", "rotations", "compassWidgetState", "Lio/reactivex/rxjava3/core/Flowable;", "getCompassWidgetState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "inCleanup", "updateStates", "registerMobileDeviceSensorListener", "unregisterMobileDeviceSensorListener", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "onAccuracyChanged", "sensor", "accuracy", "", "onLocationChanged", "location", "Landroid/location/Location;", "onStatusChanged", "provider", "", "status", "extras", "Landroid/os/Bundle;", "onProviderEnabled", "onProviderDisabled", "updateGPSData", "data", "updateCalculations", "calculateAircraftAngleAndDistanceFromCenterLocation", "calculateAngleAndDistanceBetweenRCAndHome", "getDisplayRotation", "getGimbalIndex", "setGimbalIndex", "CenterType", "AircraftAttitude", "AircraftState", "CurrentLocationState", "CompassWidgetState", "android-sdk-v5-uxsdk_debug"})
public final class CompassWidgetModel
extends WidgetModel
implements SensorEventListener,
LocationListener {
    @Nullable
    private final SensorManager sensorManager;
    @Nullable
    private final WindowManager windowManager;
    @NotNull
    private final DataProcessor<LocationCoordinate2D> homeLocationProcessor;
    @NotNull
    private final DataProcessor<LocationCoordinate2D> aircraftLocationProcessor;
    @NotNull
    private final DataProcessor<RcGPSInfo> rcGPSDataProcessor;
    @NotNull
    private final DataProcessor<Double> gimbalYawProcessor;
    @NotNull
    private final DataProcessor<CenterType> centerTypeProcessor;
    @NotNull
    private final DataProcessor<Float> mobileDeviceAzimuthProcessor;
    @NotNull
    private final DataProcessor<Attitude> aircraftAttitudeProcessor;
    @NotNull
    private final DataProcessor<AircraftState> aircraftStateProcessor;
    @NotNull
    private final DataProcessor<CurrentLocationState> currentLocationStateProcessor;
    @NotNull
    private final DataProcessor<CompassWidgetState> compassWidgetStateProcessor;
    @Nullable
    private Sensor rotationVector;
    private double rcOrMobileLatitude;
    private double rcOrMobileLongitude;
    private float latestSensorValue;
    @NotNull
    private ComponentIndexType gimbalIndex;
    @NotNull
    private final float[] values;
    @NotNull
    private final float[] rotations;

    public CompassWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable SensorManager sensorManager, @Nullable WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.sensorManager = sensorManager;
        this.windowManager = windowManager;
        DataProcessor<LocationCoordinate2D> dataProcessor = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.homeLocationProcessor = dataProcessor;
        DataProcessor<LocationCoordinate2D> dataProcessor2 = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.aircraftLocationProcessor = dataProcessor2;
        DataProcessor<RcGPSInfo> dataProcessor3 = DataProcessor.create(new RcGPSInfo());
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.rcGPSDataProcessor = dataProcessor3;
        DataProcessor<Double> dataProcessor4 = DataProcessor.create(0.0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.gimbalYawProcessor = dataProcessor4;
        DataProcessor<CenterType> dataProcessor5 = DataProcessor.create(CenterType.HOME_GPS);
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.centerTypeProcessor = dataProcessor5;
        DataProcessor<Float> dataProcessor6 = DataProcessor.create(Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.mobileDeviceAzimuthProcessor = dataProcessor6;
        DataProcessor<Attitude> dataProcessor7 = DataProcessor.create(new Attitude());
        Intrinsics.checkNotNullExpressionValue(dataProcessor7, (String)"create(...)");
        this.aircraftAttitudeProcessor = dataProcessor7;
        DataProcessor<AircraftState> dataProcessor8 = DataProcessor.create(new AircraftState(0.0f, 0.0f));
        Intrinsics.checkNotNullExpressionValue(dataProcessor8, (String)"create(...)");
        this.aircraftStateProcessor = dataProcessor8;
        DataProcessor<CurrentLocationState> dataProcessor9 = DataProcessor.create(new CurrentLocationState(0.0f, 0.0f));
        Intrinsics.checkNotNullExpressionValue(dataProcessor9, (String)"create(...)");
        this.currentLocationStateProcessor = dataProcessor9;
        DataProcessor<CompassWidgetState> dataProcessor10 = DataProcessor.create(new CompassWidgetState(0.0f, new Attitude(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)), new AircraftState(0.0f, 0.0f), new CurrentLocationState(0.0f, 0.0f), 0.0f, CenterType.HOME_GPS));
        Intrinsics.checkNotNullExpressionValue(dataProcessor10, (String)"create(...)");
        this.compassWidgetStateProcessor = dataProcessor10;
        this.gimbalIndex = ComponentIndexType.LEFT_OR_MAIN;
        this.values = new float[3];
        this.rotations = new float[9];
    }

    @NotNull
    public final Flowable<CompassWidgetState> getCompassWidgetState() {
        Flowable<CompassWidgetState> flowable = this.compassWidgetStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftAttitude), this.aircraftAttitudeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHomeLocation), this.homeLocationProcessor, arg_0 -> CompassWidgetModel.inSetup$lambda$0(this, arg_0));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation), this.aircraftLocationProcessor, arg_0 -> CompassWidgetModel.inSetup$lambda$1(this, arg_0));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcGPSInfo), this.rcGPSDataProcessor, arg_0 -> CompassWidgetModel.inSetup$lambda$2(this, arg_0));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyYawRelativeToAircraftHeading, (ComponentIndexType)this.gimbalIndex), this.gimbalYawProcessor);
        this.registerMobileDeviceSensorListener();
        MobileGPSLocationUtil.getInstance().addLocationListener(this);
        MobileGPSLocationUtil.getInstance().startUpdateLocation();
    }

    @Override
    protected void inCleanup() {
        block0: {
            this.unregisterMobileDeviceSensorListener();
            MobileGPSLocationUtil mobileGPSLocationUtil = MobileGPSLocationUtil.getInstance();
            if (mobileGPSLocationUtil == null) break block0;
            mobileGPSLocationUtil.removeLocationListener(this);
        }
    }

    @Override
    protected void updateStates() {
        Float f = this.mobileDeviceAzimuthProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"getValue(...)");
        float f2 = ((Number)f).floatValue();
        Attitude attitude = this.aircraftAttitudeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)attitude, (String)"getValue(...)");
        AircraftState aircraftState = this.aircraftStateProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)aircraftState, (String)"getValue(...)");
        CurrentLocationState currentLocationState = this.currentLocationStateProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)currentLocationState, (String)"getValue(...)");
        float f3 = (float)((Number)this.gimbalYawProcessor.getValue()).doubleValue();
        CenterType centerType = this.centerTypeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)centerType), (String)"getValue(...)");
        this.compassWidgetStateProcessor.onNext(new CompassWidgetState(f2, attitude, aircraftState, currentLocationState, f3, centerType));
    }

    private final void registerMobileDeviceSensorListener() {
        if (this.sensorManager != null) {
            Sensor sensor = this.rotationVector = DJIDeviceUtil.isDJIDevice() ? this.sensorManager.getDefaultSensor(3) : this.sensorManager.getDefaultSensor(11);
            if (this.rotationVector != null) {
                this.sensorManager.registerListener((SensorEventListener)this, this.rotationVector, 2);
            }
        }
    }

    private final void unregisterMobileDeviceSensorListener() {
        block0: {
            SensorManager sensorManager = this.sensorManager;
            if (sensorManager == null) break block0;
            sensorManager.unregisterListener((SensorEventListener)this, this.rotationVector);
        }
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        float sensorValue = this.latestSensorValue;
        if (event.sensor.getType() == 3) {
            sensorValue = event.values[0];
        } else if (event.sensor.getType() == 11) {
            MathUtil.getRotationMatrixFromVector(this.rotations, event.values);
            SensorManager.getOrientation((float[])this.rotations, (float[])this.values);
            sensorValue = (float)Math.toDegrees(this.values[0]);
        }
        if (Math.abs(sensorValue - this.latestSensorValue) > 2.0f) {
            this.latestSensorValue = sensorValue;
            int rotation = this.getDisplayRotation();
            if (rotation == 3) {
                sensorValue += 180.0f;
            }
            if (DJIDeviceUtil.isSmartController()) {
                sensorValue += 90.0f;
            }
            float mobileDeviceAzimuth = sensorValue + (float)90;
            this.mobileDeviceAzimuthProcessor.onNext(Float.valueOf(mobileDeviceAzimuth));
        }
        this.updateStates();
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    public void onLocationChanged(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.centerTypeProcessor.onNext(CenterType.RC_MOBILE_GPS);
        this.rcOrMobileLatitude = location.getLatitude();
        this.rcOrMobileLongitude = location.getLongitude();
        this.updateCalculations();
        this.updateStates();
    }

    public void onStatusChanged(@NotNull String provider, int status, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
    }

    public void onProviderEnabled(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
    }

    public void onProviderDisabled(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
    }

    private final void updateGPSData(RcGPSInfo data) {
        if (data.getIsValid().booleanValue()) {
            this.centerTypeProcessor.onNext(CenterType.RC_MOBILE_GPS);
            this.rcOrMobileLatitude = data.getLocation().getLatitude();
            this.rcOrMobileLongitude = data.getLocation().getLongitude();
            MobileGPSLocationUtil mobileGPSLocationUtil = MobileGPSLocationUtil.getInstance();
            if (mobileGPSLocationUtil != null) {
                mobileGPSLocationUtil.removeLocationListener(this);
            }
            this.updateCalculations();
        }
    }

    private final void updateCalculations() {
        this.calculateAircraftAngleAndDistanceFromCenterLocation();
        this.calculateAngleAndDistanceBetweenRCAndHome();
    }

    private final void calculateAircraftAngleAndDistanceFromCenterLocation() {
        float[] tempCalculatedLocation = null;
        AircraftState latestAircraftState = new AircraftState(0.0f, 0.0f);
        if (this.centerTypeProcessor.getValue() == CenterType.HOME_GPS) {
            Double d = this.homeLocationProcessor.getValue().getLatitude();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getLatitude(...)");
            if (LocationUtil.checkLatitude((double)((Number)d).doubleValue())) {
                Double d2 = this.homeLocationProcessor.getValue().getLongitude();
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"getLongitude(...)");
                if (LocationUtil.checkLongitude((double)((Number)d2).doubleValue())) {
                    Double d3 = this.homeLocationProcessor.getValue().getLatitude();
                    Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"getLatitude(...)");
                    double d4 = ((Number)d3).doubleValue();
                    Double d5 = this.homeLocationProcessor.getValue().getLongitude();
                    Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"getLongitude(...)");
                    double d6 = ((Number)d5).doubleValue();
                    Double d7 = this.aircraftLocationProcessor.getValue().getLatitude();
                    Intrinsics.checkNotNullExpressionValue((Object)d7, (String)"getLatitude(...)");
                    double d8 = ((Number)d7).doubleValue();
                    Double d9 = this.aircraftLocationProcessor.getValue().getLongitude();
                    Intrinsics.checkNotNullExpressionValue((Object)d9, (String)"getLongitude(...)");
                    tempCalculatedLocation = LocationUtil.calculateAngleAndDistance((double)d4, (double)d6, (double)d8, (double)((Number)d9).doubleValue());
                    latestAircraftState.setAngle(tempCalculatedLocation[0]);
                    latestAircraftState.setDistance(tempCalculatedLocation[1]);
                    this.aircraftStateProcessor.onNext(latestAircraftState);
                }
            }
        } else if (this.centerTypeProcessor.getValue() == CenterType.RC_MOBILE_GPS && LocationUtil.checkLatitude((double)this.rcOrMobileLatitude) && LocationUtil.checkLongitude((double)this.rcOrMobileLongitude)) {
            Double d = this.aircraftLocationProcessor.getValue().getLatitude();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getLatitude(...)");
            double d10 = ((Number)d).doubleValue();
            Double d11 = this.aircraftLocationProcessor.getValue().getLongitude();
            Intrinsics.checkNotNullExpressionValue((Object)d11, (String)"getLongitude(...)");
            tempCalculatedLocation = LocationUtil.calculateAngleAndDistance((double)this.rcOrMobileLatitude, (double)this.rcOrMobileLongitude, (double)d10, (double)((Number)d11).doubleValue());
            latestAircraftState.setAngle(tempCalculatedLocation[0]);
            latestAircraftState.setDistance(tempCalculatedLocation[1]);
            this.aircraftStateProcessor.onNext(latestAircraftState);
        }
    }

    private final void calculateAngleAndDistanceBetweenRCAndHome() {
        if (this.centerTypeProcessor.getValue() != CenterType.HOME_GPS) {
            Double d = this.homeLocationProcessor.getValue().getLatitude();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getLatitude(...)");
            double d2 = ((Number)d).doubleValue();
            Double d3 = this.homeLocationProcessor.getValue().getLongitude();
            Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"getLongitude(...)");
            float[] tempCalculatedLocation = LocationUtil.calculateAngleAndDistance((double)this.rcOrMobileLatitude, (double)this.rcOrMobileLongitude, (double)d2, (double)((Number)d3).doubleValue());
            CurrentLocationState latestCurrentLocationState = new CurrentLocationState(0.0f, 0.0f);
            latestCurrentLocationState.setAngle(tempCalculatedLocation[0]);
            latestCurrentLocationState.setDistance(tempCalculatedLocation[1]);
            this.currentLocationStateProcessor.onNext(latestCurrentLocationState);
        }
    }

    private final int getDisplayRotation() {
        int rotation = 0;
        if (this.windowManager != null) {
            rotation = this.windowManager.getDefaultDisplay().getRotation();
        }
        if (DJIDeviceUtil.isDJIDevice()) {
            rotation = (rotation + 1) % 4;
        }
        return rotation;
    }

    @NotNull
    public final ComponentIndexType getGimbalIndex() {
        return this.gimbalIndex;
    }

    public final void setGimbalIndex(@Nullable ComponentIndexType gimbalIndex) {
        if (gimbalIndex != null) {
            this.gimbalIndex = gimbalIndex;
        }
        this.restart();
    }

    private static final void inSetup$lambda$0(CompassWidgetModel this$0, LocationCoordinate2D it) {
        this$0.updateCalculations();
    }

    private static final void inSetup$lambda$1(CompassWidgetModel this$0, LocationCoordinate2D it) {
        this$0.calculateAircraftAngleAndDistanceFromCenterLocation();
    }

    private static final void inSetup$lambda$2(CompassWidgetModel this$0, RcGPSInfo it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.updateGPSData(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftAttitude;", "", "roll", "", "pitch", "yaw", "<init>", "(DDD)V", "getRoll", "()D", "setRoll", "(D)V", "getPitch", "setPitch", "getYaw", "setYaw", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class AircraftAttitude {
        private double roll;
        private double pitch;
        private double yaw;

        public AircraftAttitude(double roll, double pitch, double yaw) {
            this.roll = roll;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public final double getRoll() {
            return this.roll;
        }

        public final void setRoll(double d) {
            this.roll = d;
        }

        public final double getPitch() {
            return this.pitch;
        }

        public final void setPitch(double d) {
            this.pitch = d;
        }

        public final double getYaw() {
            return this.yaw;
        }

        public final void setYaw(double d) {
            this.yaw = d;
        }

        public final double component1() {
            return this.roll;
        }

        public final double component2() {
            return this.pitch;
        }

        public final double component3() {
            return this.yaw;
        }

        @NotNull
        public final AircraftAttitude copy(double roll, double pitch, double yaw) {
            return new AircraftAttitude(roll, pitch, yaw);
        }

        public static /* synthetic */ AircraftAttitude copy$default(AircraftAttitude aircraftAttitude, double d, double d2, double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = aircraftAttitude.roll;
            }
            if ((n & 2) != 0) {
                d2 = aircraftAttitude.pitch;
            }
            if ((n & 4) != 0) {
                d3 = aircraftAttitude.yaw;
            }
            return aircraftAttitude.copy(d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "AircraftAttitude(roll=" + this.roll + ", pitch=" + this.pitch + ", yaw=" + this.yaw + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.roll);
            result = result * 31 + Double.hashCode(this.pitch);
            result = result * 31 + Double.hashCode(this.yaw);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AircraftAttitude)) {
                return false;
            }
            AircraftAttitude aircraftAttitude = (AircraftAttitude)other;
            if (Double.compare(this.roll, aircraftAttitude.roll) != 0) {
                return false;
            }
            if (Double.compare(this.pitch, aircraftAttitude.pitch) != 0) {
                return false;
            }
            return Double.compare(this.yaw, aircraftAttitude.yaw) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;", "", "angle", "", "distance", "<init>", "(FF)V", "getAngle", "()F", "setAngle", "(F)V", "getDistance", "setDistance", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class AircraftState {
        private float angle;
        private float distance;

        public AircraftState(float angle, float distance) {
            this.angle = angle;
            this.distance = distance;
        }

        public final float getAngle() {
            return this.angle;
        }

        public final void setAngle(float f) {
            this.angle = f;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final void setDistance(float f) {
            this.distance = f;
        }

        public final float component1() {
            return this.angle;
        }

        public final float component2() {
            return this.distance;
        }

        @NotNull
        public final AircraftState copy(float angle, float distance) {
            return new AircraftState(angle, distance);
        }

        public static /* synthetic */ AircraftState copy$default(AircraftState aircraftState, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = aircraftState.angle;
            }
            if ((n & 2) != 0) {
                f2 = aircraftState.distance;
            }
            return aircraftState.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "AircraftState(angle=" + this.angle + ", distance=" + this.distance + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.angle);
            result = result * 31 + Float.hashCode(this.distance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AircraftState)) {
                return false;
            }
            AircraftState aircraftState = (AircraftState)other;
            if (Float.compare(this.angle, aircraftState.angle) != 0) {
                return false;
            }
            return Float.compare(this.distance, aircraftState.distance) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;", "", "<init>", "(Ljava/lang/String;I)V", "RC_MOBILE_GPS", "HOME_GPS", "android-sdk-v5-uxsdk_debug"})
    public static final class CenterType
    extends Enum<CenterType> {
        public static final /* enum */ CenterType RC_MOBILE_GPS = new CenterType();
        public static final /* enum */ CenterType HOME_GPS = new CenterType();
        private static final /* synthetic */ CenterType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CenterType[] values() {
            return (CenterType[])$VALUES.clone();
        }

        public static CenterType valueOf(String value) {
            return Enum.valueOf(CenterType.class, value);
        }

        @NotNull
        public static EnumEntries<CenterType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = centerTypeArray = new CenterType[]{CenterType.RC_MOBILE_GPS, CenterType.HOME_GPS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003JE\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00063"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CompassWidgetState;", "", "phoneAzimuth", "", "aircraftAttitude", "Ldji/sdk/keyvalue/value/common/Attitude;", "aircraftState", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;", "currentLocationState", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;", "gimbalHeading", "centerType", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;", "<init>", "(FLdji/sdk/keyvalue/value/common/Attitude;Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;FLdji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;)V", "getPhoneAzimuth", "()F", "setPhoneAzimuth", "(F)V", "getAircraftAttitude", "()Ldji/sdk/keyvalue/value/common/Attitude;", "setAircraftAttitude", "(Ldji/sdk/keyvalue/value/common/Attitude;)V", "getAircraftState", "()Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;", "setAircraftState", "(Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;)V", "getCurrentLocationState", "()Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;", "setCurrentLocationState", "(Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;)V", "getGimbalHeading", "setGimbalHeading", "getCenterType", "()Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;", "setCenterType", "(Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class CompassWidgetState {
        private float phoneAzimuth;
        @NotNull
        private Attitude aircraftAttitude;
        @NotNull
        private AircraftState aircraftState;
        @NotNull
        private CurrentLocationState currentLocationState;
        private float gimbalHeading;
        @NotNull
        private CenterType centerType;

        public CompassWidgetState(float phoneAzimuth, @NotNull Attitude aircraftAttitude, @NotNull AircraftState aircraftState, @NotNull CurrentLocationState currentLocationState, float gimbalHeading, @NotNull CenterType centerType) {
            Intrinsics.checkNotNullParameter((Object)aircraftAttitude, (String)"aircraftAttitude");
            Intrinsics.checkNotNullParameter((Object)aircraftState, (String)"aircraftState");
            Intrinsics.checkNotNullParameter((Object)currentLocationState, (String)"currentLocationState");
            Intrinsics.checkNotNullParameter((Object)((Object)centerType), (String)"centerType");
            this.phoneAzimuth = phoneAzimuth;
            this.aircraftAttitude = aircraftAttitude;
            this.aircraftState = aircraftState;
            this.currentLocationState = currentLocationState;
            this.gimbalHeading = gimbalHeading;
            this.centerType = centerType;
        }

        public final float getPhoneAzimuth() {
            return this.phoneAzimuth;
        }

        public final void setPhoneAzimuth(float f) {
            this.phoneAzimuth = f;
        }

        @NotNull
        public final Attitude getAircraftAttitude() {
            return this.aircraftAttitude;
        }

        public final void setAircraftAttitude(@NotNull Attitude attitude) {
            Intrinsics.checkNotNullParameter((Object)attitude, (String)"<set-?>");
            this.aircraftAttitude = attitude;
        }

        @NotNull
        public final AircraftState getAircraftState() {
            return this.aircraftState;
        }

        public final void setAircraftState(@NotNull AircraftState aircraftState) {
            Intrinsics.checkNotNullParameter((Object)aircraftState, (String)"<set-?>");
            this.aircraftState = aircraftState;
        }

        @NotNull
        public final CurrentLocationState getCurrentLocationState() {
            return this.currentLocationState;
        }

        public final void setCurrentLocationState(@NotNull CurrentLocationState currentLocationState) {
            Intrinsics.checkNotNullParameter((Object)currentLocationState, (String)"<set-?>");
            this.currentLocationState = currentLocationState;
        }

        public final float getGimbalHeading() {
            return this.gimbalHeading;
        }

        public final void setGimbalHeading(float f) {
            this.gimbalHeading = f;
        }

        @NotNull
        public final CenterType getCenterType() {
            return this.centerType;
        }

        public final void setCenterType(@NotNull CenterType centerType) {
            Intrinsics.checkNotNullParameter((Object)((Object)centerType), (String)"<set-?>");
            this.centerType = centerType;
        }

        public final float component1() {
            return this.phoneAzimuth;
        }

        @NotNull
        public final Attitude component2() {
            return this.aircraftAttitude;
        }

        @NotNull
        public final AircraftState component3() {
            return this.aircraftState;
        }

        @NotNull
        public final CurrentLocationState component4() {
            return this.currentLocationState;
        }

        public final float component5() {
            return this.gimbalHeading;
        }

        @NotNull
        public final CenterType component6() {
            return this.centerType;
        }

        @NotNull
        public final CompassWidgetState copy(float phoneAzimuth, @NotNull Attitude aircraftAttitude, @NotNull AircraftState aircraftState, @NotNull CurrentLocationState currentLocationState, float gimbalHeading, @NotNull CenterType centerType) {
            Intrinsics.checkNotNullParameter((Object)aircraftAttitude, (String)"aircraftAttitude");
            Intrinsics.checkNotNullParameter((Object)aircraftState, (String)"aircraftState");
            Intrinsics.checkNotNullParameter((Object)currentLocationState, (String)"currentLocationState");
            Intrinsics.checkNotNullParameter((Object)((Object)centerType), (String)"centerType");
            return new CompassWidgetState(phoneAzimuth, aircraftAttitude, aircraftState, currentLocationState, gimbalHeading, centerType);
        }

        public static /* synthetic */ CompassWidgetState copy$default(CompassWidgetState compassWidgetState, float f, Attitude attitude, AircraftState aircraftState, CurrentLocationState currentLocationState, float f2, CenterType centerType, int n, Object object) {
            if ((n & 1) != 0) {
                f = compassWidgetState.phoneAzimuth;
            }
            if ((n & 2) != 0) {
                attitude = compassWidgetState.aircraftAttitude;
            }
            if ((n & 4) != 0) {
                aircraftState = compassWidgetState.aircraftState;
            }
            if ((n & 8) != 0) {
                currentLocationState = compassWidgetState.currentLocationState;
            }
            if ((n & 0x10) != 0) {
                f2 = compassWidgetState.gimbalHeading;
            }
            if ((n & 0x20) != 0) {
                centerType = compassWidgetState.centerType;
            }
            return compassWidgetState.copy(f, attitude, aircraftState, currentLocationState, f2, centerType);
        }

        @NotNull
        public String toString() {
            return "CompassWidgetState(phoneAzimuth=" + this.phoneAzimuth + ", aircraftAttitude=" + this.aircraftAttitude + ", aircraftState=" + this.aircraftState + ", currentLocationState=" + this.currentLocationState + ", gimbalHeading=" + this.gimbalHeading + ", centerType=" + this.centerType + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.phoneAzimuth);
            result = result * 31 + this.aircraftAttitude.hashCode();
            result = result * 31 + this.aircraftState.hashCode();
            result = result * 31 + this.currentLocationState.hashCode();
            result = result * 31 + Float.hashCode(this.gimbalHeading);
            result = result * 31 + this.centerType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompassWidgetState)) {
                return false;
            }
            CompassWidgetState compassWidgetState = (CompassWidgetState)other;
            if (Float.compare(this.phoneAzimuth, compassWidgetState.phoneAzimuth) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.aircraftAttitude, (Object)compassWidgetState.aircraftAttitude)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.aircraftState, (Object)compassWidgetState.aircraftState)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentLocationState, (Object)compassWidgetState.currentLocationState)) {
                return false;
            }
            if (Float.compare(this.gimbalHeading, compassWidgetState.gimbalHeading) != 0) {
                return false;
            }
            return this.centerType == compassWidgetState.centerType;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;", "", "angle", "", "distance", "<init>", "(FF)V", "getAngle", "()F", "setAngle", "(F)V", "getDistance", "setDistance", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class CurrentLocationState {
        private float angle;
        private float distance;

        public CurrentLocationState(float angle, float distance) {
            this.angle = angle;
            this.distance = distance;
        }

        public final float getAngle() {
            return this.angle;
        }

        public final void setAngle(float f) {
            this.angle = f;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final void setDistance(float f) {
            this.distance = f;
        }

        public final float component1() {
            return this.angle;
        }

        public final float component2() {
            return this.distance;
        }

        @NotNull
        public final CurrentLocationState copy(float angle, float distance) {
            return new CurrentLocationState(angle, distance);
        }

        public static /* synthetic */ CurrentLocationState copy$default(CurrentLocationState currentLocationState, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = currentLocationState.angle;
            }
            if ((n & 2) != 0) {
                f2 = currentLocationState.distance;
            }
            return currentLocationState.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "CurrentLocationState(angle=" + this.angle + ", distance=" + this.distance + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.angle);
            result = result * 31 + Float.hashCode(this.distance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentLocationState)) {
                return false;
            }
            CurrentLocationState currentLocationState = (CurrentLocationState)other;
            if (Float.compare(this.angle, currentLocationState.angle) != 0) {
                return false;
            }
            return Float.compare(this.distance, currentLocationState.distance) == 0;
        }
    }
}

