/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import dji.v5.ux.R;
import java.util.Locale;

public class BatteryCellView
extends RelativeLayout {
    private static final float[] SECTION_PART_VOLTAGE = new float[]{3.0f, 4.35f};
    ProgressBar batteryPartPgb;
    TextView batteryVoltageTv;
    private float mCurrentVoltage;

    public BatteryCellView(Context context) {
        this(context, null);
    }

    public BatteryCellView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BatteryCellView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BatteryCellView.inflate((Context)context, (int)R.layout.uxsdk_view_battery_detail_cell, (ViewGroup)this);
        this.batteryPartPgb = (ProgressBar)this.findViewById(R.id.battery_part_pgb);
        this.batteryVoltageTv = (TextView)this.findViewById(R.id.battery_part_tv);
    }

    public void setVoltage(float voltage) {
        if (this.mCurrentVoltage == voltage) {
            return;
        }
        int progress = this.calculatePartVoltageProgress(voltage);
        if (this.batteryPartPgb.getProgress() != progress) {
            this.batteryPartPgb.setProgress(progress);
        }
        this.batteryVoltageTv.setText((CharSequence)String.format(Locale.getDefault(), "%.2fV", Float.valueOf(voltage)));
        this.mCurrentVoltage = voltage;
    }

    private int calculatePartVoltageProgress(float voltage) {
        int progress = voltage >= SECTION_PART_VOLTAGE[1] ? 100 : (voltage <= SECTION_PART_VOLTAGE[0] ? 0 : (int)((voltage - SECTION_PART_VOLTAGE[0]) * 100.0f / (SECTION_PART_VOLTAGE[1] - SECTION_PART_VOLTAGE[0])));
        return progress;
    }
}

