/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.altitude;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferenceKeys;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.MathExtensions;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u0017H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "altitudeProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "takeOffLocationAltitudeProcessor", "unitTypeDataProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "altitudeStateProcessor", "Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState;", "altitudeState", "Lio/reactivex/rxjava3/core/Flowable;", "getAltitudeState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "updateStates", "inCleanup", "AltitudeState", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nAltitudeWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltitudeWidgetModel.kt\ndji/v5/ux/core/widget/altitude/AltitudeWidgetModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class AltitudeWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<Double> altitudeProcessor;
    @NotNull
    private final DataProcessor<Double> takeOffLocationAltitudeProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeDataProcessor;
    @NotNull
    private final DataProcessor<AltitudeState> altitudeStateProcessor;

    @JvmOverloads
    public AltitudeWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.preferencesManager = preferencesManager;
        DataProcessor<Double> dataProcessor = DataProcessor.create(0.0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.altitudeProcessor = dataProcessor;
        DataProcessor<Double> dataProcessor2 = DataProcessor.create(0.0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.takeOffLocationAltitudeProcessor = dataProcessor2;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor3 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.unitTypeDataProcessor = dataProcessor3;
        DataProcessor<AltitudeState.ProductDisconnected> dataProcessor4 = DataProcessor.create(AltitudeState.ProductDisconnected.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.altitudeStateProcessor = dataProcessor4;
    }

    @NotNull
    public final Flowable<AltitudeState> getAltitudeState() {
        Flowable<AltitudeState> flowable = this.altitudeStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        block1: {
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAltitude), this.altitudeProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyTakeoffLocationAltitude), this.takeOffLocationAltitudeProcessor);
            this.bindDataProcessor(GlobalPreferenceKeys.create("UnitType"), this.unitTypeDataProcessor);
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface != null) {
                globalPreferencesInterface.setUpListener();
            }
            GlobalPreferencesInterface globalPreferencesInterface2 = this.preferencesManager;
            if (globalPreferencesInterface2 == null) break block1;
            GlobalPreferencesInterface it = globalPreferencesInterface2;
            boolean bl = false;
            this.unitTypeDataProcessor.onNext(it.getUnitType());
        }
    }

    @Override
    protected void updateStates() {
        if (((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            Double d = this.altitudeProcessor.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getValue(...)");
            double d2 = ((Number)d).doubleValue();
            UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
            double d3 = MathExtensions.toDistance(d2, unitType);
            double d4 = ((Number)this.altitudeProcessor.getValue()).doubleValue();
            Double d5 = this.takeOffLocationAltitudeProcessor.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"getValue(...)");
            double d6 = d4 + ((Number)d5).doubleValue();
            UnitConversionUtil.UnitType unitType2 = this.unitTypeDataProcessor.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType2), (String)"getValue(...)");
            double d7 = MathExtensions.toDistance(d6, unitType2);
            UnitConversionUtil.UnitType unitType3 = this.unitTypeDataProcessor.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType3), (String)"getValue(...)");
            this.altitudeStateProcessor.onNext(new AltitudeState.CurrentAltitude(d3, d7, unitType3));
        } else {
            this.altitudeStateProcessor.onNext(AltitudeState.ProductDisconnected.INSTANCE);
        }
    }

    @Override
    protected void inCleanup() {
        block0: {
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.cleanup();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState;", "", "<init>", "()V", "ProductDisconnected", "CurrentAltitude", "Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState$CurrentAltitude;", "Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState$ProductDisconnected;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class AltitudeState {
        private AltitudeState() {
        }

        public /* synthetic */ AltitudeState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState$CurrentAltitude;", "Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState;", "altitudeAGL", "", "altitudeAMSL", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(DDLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getAltitudeAGL", "()D", "getAltitudeAMSL", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class CurrentAltitude
        extends AltitudeState {
            private final double altitudeAGL;
            private final double altitudeAMSL;
            @NotNull
            private final UnitConversionUtil.UnitType unitType;

            public CurrentAltitude(double altitudeAGL, double altitudeAMSL, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                super(null);
                this.altitudeAGL = altitudeAGL;
                this.altitudeAMSL = altitudeAMSL;
                this.unitType = unitType;
            }

            public final double getAltitudeAGL() {
                return this.altitudeAGL;
            }

            public final double getAltitudeAMSL() {
                return this.altitudeAMSL;
            }

            @NotNull
            public final UnitConversionUtil.UnitType getUnitType() {
                return this.unitType;
            }

            public final double component1() {
                return this.altitudeAGL;
            }

            public final double component2() {
                return this.altitudeAMSL;
            }

            @NotNull
            public final UnitConversionUtil.UnitType component3() {
                return this.unitType;
            }

            @NotNull
            public final CurrentAltitude copy(double altitudeAGL, double altitudeAMSL, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                return new CurrentAltitude(altitudeAGL, altitudeAMSL, unitType);
            }

            public static /* synthetic */ CurrentAltitude copy$default(CurrentAltitude currentAltitude, double d, double d2, UnitConversionUtil.UnitType unitType, int n, Object object) {
                if ((n & 1) != 0) {
                    d = currentAltitude.altitudeAGL;
                }
                if ((n & 2) != 0) {
                    d2 = currentAltitude.altitudeAMSL;
                }
                if ((n & 4) != 0) {
                    unitType = currentAltitude.unitType;
                }
                return currentAltitude.copy(d, d2, unitType);
            }

            @NotNull
            public String toString() {
                return "CurrentAltitude(altitudeAGL=" + this.altitudeAGL + ", altitudeAMSL=" + this.altitudeAMSL + ", unitType=" + this.unitType + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.altitudeAGL);
                result = result * 31 + Double.hashCode(this.altitudeAMSL);
                result = result * 31 + this.unitType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CurrentAltitude)) {
                    return false;
                }
                CurrentAltitude currentAltitude = (CurrentAltitude)other;
                if (Double.compare(this.altitudeAGL, currentAltitude.altitudeAGL) != 0) {
                    return false;
                }
                if (Double.compare(this.altitudeAMSL, currentAltitude.altitudeAMSL) != 0) {
                    return false;
                }
                return this.unitType == currentAltitude.unitType;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState$ProductDisconnected;", "Ldji/v5/ux/core/widget/altitude/AltitudeWidgetModel$AltitudeState;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class ProductDisconnected
        extends AltitudeState {
            @NotNull
            public static final ProductDisconnected INSTANCE = new ProductDisconnected();

            private ProductDisconnected() {
                super(null);
            }
        }
    }
}

